/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.handlers;

import com.github.gunirs.anchors.Registry;
import com.github.gunirs.anchors.tileentity.TileAdminAnchor;
import com.github.gunirs.anchors.tileentity.TileWorldAnchor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadingHandler
implements ForgeChunkManager.OrderedLoadingCallback {
    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList<ForgeChunkManager.Ticket> validTickets = new ArrayList<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            Block blockChunkLoader;
            int coreX = ticket.getModData().func_74762_e("coreX");
            int coreY = ticket.getModData().func_74762_e("coreY");
            int coreZ = ticket.getModData().func_74762_e("coreZ");
            if (coreY <= 0 || (blockChunkLoader = world.func_147439_a(coreX, coreY, coreZ)) != Registry.Blocks.blockWorldAnchor && blockChunkLoader != Registry.Blocks.blockAdminAnchor) continue;
            validTickets.add(ticket);
        }
        return validTickets;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket.isPlayerTicket()) continue;
            int coreX = ticket.getModData().func_74762_e("coreX");
            int coreY = ticket.getModData().func_74762_e("coreY");
            int coreZ = ticket.getModData().func_74762_e("coreZ");
            TileEntity te = world.func_147438_o(coreX, coreY, coreZ);
            if (coreY <= 0) continue;
            if (te instanceof TileWorldAnchor) {
                TileWorldAnchor tileWorldAnchor = (TileWorldAnchor)te;
                tileWorldAnchor.forceChunkLoadingCallback(ticket);
            }
            if (!(te instanceof TileAdminAnchor)) continue;
            TileAdminAnchor tileAdminAnchor = (TileAdminAnchor)te;
            tileAdminAnchor.forceChunkLoadingCallback(ticket);
        }
    }
}

