/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.packets;

import com.github.gunirs.anchors.Config;
import com.github.gunirs.anchors.tileentity.TileWorldAnchor;
import com.github.gunirs.anchors.utils.enums.LoadingMode;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketClickButton
implements IMessage {
    private int buttonId;
    private int posX;
    private int posY;
    private int posZ;
    private int dimensionId;

    public PacketClickButton() {
    }

    public PacketClickButton(int buttonId, int posX, int posY, int posZ, int dimensionId) {
        this.buttonId = buttonId;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.dimensionId = dimensionId;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.buttonId);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buf) {
        this.buttonId = buf.readInt();
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.dimensionId = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketClickButton, IMessage> {
        public IMessage onMessage(PacketClickButton message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity te = player.field_70170_p.func_147438_o(message.posX, message.posY, message.posZ);
            if (te instanceof TileWorldAnchor) {
                TileWorldAnchor tileWorldAnchor = (TileWorldAnchor)te;
                switch (message.buttonId) {
                    case 1: {
                        if (tileWorldAnchor.isAdminModeAnchor()) break;
                        LoadingMode mode = tileWorldAnchor.getMode();
                        int time = tileWorldAnchor.getChunkLoadingTime();
                        switch (mode) {
                            case SMALL: {
                                tileWorldAnchor.setMode(LoadingMode.NORMAL);
                                tileWorldAnchor.setChunkLoadingTime(time / Config.multiplier);
                                break;
                            }
                            case NORMAL: {
                                tileWorldAnchor.setMode(LoadingMode.LARGE);
                                tileWorldAnchor.setChunkLoadingTime(time / Config.multiplier);
                                break;
                            }
                            case LARGE: {
                                tileWorldAnchor.setMode(LoadingMode.NORMAL);
                                tileWorldAnchor.setChunkLoadingTime(time * Config.multiplier);
                            }
                        }
                        tileWorldAnchor.func_145831_w().func_147471_g(message.posX, message.posY, message.posZ);
                        break;
                    }
                    case 2: {
                        boolean paused = tileWorldAnchor.isPaused();
                        if (paused && (tileWorldAnchor.getChunkLoadingTime() > 0 || tileWorldAnchor.isAdminModeAnchor())) {
                            tileWorldAnchor.forceChunkLoading();
                            tileWorldAnchor.setPaused(false);
                        } else {
                            tileWorldAnchor.releaseTicket();
                            tileWorldAnchor.setPaused(true);
                        }
                        tileWorldAnchor.func_145831_w().func_147471_g(message.posX, message.posY, message.posZ);
                    }
                }
            }
            return null;
        }
    }
}

