/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.tileentity;

import com.github.gunirs.anchors.Anchors;
import com.github.gunirs.anchors.Config;
import com.github.gunirs.anchors.utils.AnchorsChunkManager;
import com.github.gunirs.anchors.utils.BlockPos;
import com.github.gunirs.anchors.utils.PlayerUtils;
import com.github.gunirs.anchors.utils.enums.LoadingMode;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileAdminAnchor
extends TileEntity {
    private int chunkLoadingTime;
    private boolean paused;
    private LoadingMode mode = LoadingMode.NORMAL;
    private ForgeChunkManager.Ticket ticket = null;
    private boolean adminAnchor = true;
    private GameProfile owner = new GameProfile(null, "[Anchors]");

    public void forceChunkLoadingCallback(ForgeChunkManager.Ticket ticket) {
        if (!Config.enableKeepChunks) {
            return;
        }
        if (this.ticket == null) {
            this.ticket = ticket;
        }
        for (ChunkCoordIntPair chunk : AnchorsChunkManager.getLoadArea(this.mode, this.field_145851_c, this.field_145849_e)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
        }
    }

    public void forceChunkLoading() {
        if (!Config.enableKeepChunks) {
            return;
        }
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestTicket((Object)Anchors.INSTANCE, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.ticket == null) {
            System.out.println("[Anchors] Ticket could not be reserved [" + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + "]");
        } else {
            this.ticket.getModData().func_74768_a("coreX", this.field_145851_c);
            this.ticket.getModData().func_74768_a("coreY", this.field_145848_d);
            this.ticket.getModData().func_74768_a("coreZ", this.field_145849_e);
            this.forceChunkLoadingCallback(this.ticket);
        }
    }

    public void releaseTicket() {
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.owner.getName() != null) {
            compound.func_74778_a("owner", this.owner.getName());
        }
        if (this.owner.getId() != null) {
            compound.func_74778_a("ownerId", this.owner.getId().toString());
        }
        this.owner = PlayerUtils.readOwnerFromNBT(compound);
        compound.func_74757_a("isPaused", this.paused);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.paused = compound.func_74767_n("isPaused");
    }

    public void func_145845_h() {
        super.func_145845_h();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            AnchorsChunkManager.anchorsList.removeIf(obj -> obj.getX() == this.field_145851_c && obj.getY() == this.field_145848_d && obj.getZ() == this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.releaseTicket();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            AnchorsChunkManager.anchorsList.add(new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
        if (placer instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)placer).func_146103_bH();
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        TileEntity tile = this.field_145850_b.func_147438_o(packet.func_148856_c(), packet.func_148855_d(), packet.func_148854_e());
        if (tile instanceof TileAdminAnchor) {
            this.func_145839_a(packet.func_148857_g());
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int getChunkLoadingTime() {
        return this.chunkLoadingTime;
    }

    public void setChunkLoadingTime(int chunkLoadingTime) {
        this.chunkLoadingTime = chunkLoadingTime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public LoadingMode getMode() {
        return this.mode;
    }

    public void setMode(LoadingMode mode) {
        this.mode = mode;
    }

    public boolean isAdminAnchor() {
        return this.adminAnchor;
    }
}

