/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.tileentity;

import com.github.gunirs.anchors.Anchors;
import com.github.gunirs.anchors.Config;
import com.github.gunirs.anchors.items.IAnchorFuel;
import com.github.gunirs.anchors.items.ItemTritiumCell;
import com.github.gunirs.anchors.items.ItemUnobtaniumCell;
import com.github.gunirs.anchors.utils.AnchorsChunkManager;
import com.github.gunirs.anchors.utils.BlockPos;
import com.github.gunirs.anchors.utils.PlayerUtils;
import com.github.gunirs.anchors.utils.enums.LoadingMode;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileWorldAnchor
extends TileEntity
implements IInventory,
ISidedInventory {
    private ItemStack fuelSlotItem;
    private int chunkLoadingTime;
    private boolean paused = false;
    private LoadingMode mode = LoadingMode.NORMAL;
    private ForgeChunkManager.Ticket ticket;
    private GameProfile owner = new GameProfile(null, "[Anchors]");

    public boolean isAdminModeAnchor() {
        return this.chunkLoadingTime > 20 * Config.fuelTime * Config.multiplier * Config.multiplier * Config.multiplier;
    }

    public void forceChunkLoadingCallback(ForgeChunkManager.Ticket ticket) {
        if (!Config.enableKeepChunks) {
            return;
        }
        if (this.ticket == null) {
            this.ticket = ticket;
        }
        for (ChunkCoordIntPair chunk : AnchorsChunkManager.getLoadArea(this.mode, this.field_145851_c, this.field_145849_e)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
        }
    }

    public void forceChunkLoading() {
        if (!Config.enableKeepChunks) {
            return;
        }
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestTicket((Object)Anchors.INSTANCE, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.ticket == null) {
            System.out.println("[Anchors] Ticket could not be reserved [" + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + "]");
        } else {
            this.ticket.getModData().func_74768_a("coreX", this.field_145851_c);
            this.ticket.getModData().func_74768_a("coreY", this.field_145848_d);
            this.ticket.getModData().func_74768_a("coreZ", this.field_145849_e);
            this.forceChunkLoadingCallback(this.ticket);
        }
    }

    public void releaseTicket() {
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
        if (placer instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)placer).func_146103_bH();
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList items = new NBTTagList();
        if (this.owner.getName() != null) {
            compound.func_74778_a("owner", this.owner.getName());
        }
        if (this.owner.getId() != null) {
            compound.func_74778_a("ownerId", this.owner.getId().toString());
        }
        if (this.fuelSlotItem != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)0);
            this.fuelSlotItem.func_77955_b(tagCompound);
            items.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74768_a("chunkLoadingTime", this.chunkLoadingTime);
        compound.func_74777_a("mode", (short)this.mode.ordinal());
        compound.func_74757_a("isPaused", this.paused);
        compound.func_74782_a("Items", (NBTBase)items);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.owner = PlayerUtils.readOwnerFromNBT(compound);
        this.chunkLoadingTime = compound.func_74762_e("chunkLoadingTime");
        this.mode = LoadingMode.fromInteger(compound.func_74765_d("mode"));
        this.paused = compound.func_74767_n("isPaused");
        NBTTagList items = compound.func_150295_c("Items", 10);
        NBTTagCompound nbtTagCompound = items.func_150305_b(0);
        this.fuelSlotItem = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
    }

    public void func_145845_h() {
        if (this.chunkLoadingTime > 0 && !this.paused) {
            --this.chunkLoadingTime;
        }
        if (this.fuelSlotItem != null && this.chunkLoadingTime == 0) {
            Item fuelItem = this.fuelSlotItem.func_77973_b();
            if (fuelItem instanceof ItemTritiumCell) {
                if (this.fuelSlotItem.field_77994_a > 1) {
                    --this.fuelSlotItem.field_77994_a;
                } else {
                    this.fuelSlotItem = null;
                }
                if (this.mode == LoadingMode.SMALL) {
                    this.mode = LoadingMode.NORMAL;
                }
                switch (this.mode) {
                    case NORMAL: {
                        this.chunkLoadingTime = 20 * Config.fuelTime;
                        break;
                    }
                    case LARGE: {
                        this.chunkLoadingTime = 20 * Config.fuelTime / Config.multiplier;
                    }
                }
            } else if (fuelItem instanceof ItemUnobtaniumCell && this.chunkLoadingTime == 0) {
                if (this.fuelSlotItem.field_77994_a > 1) {
                    --this.fuelSlotItem.field_77994_a;
                } else {
                    this.fuelSlotItem = null;
                }
                this.chunkLoadingTime = Integer.MAX_VALUE;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!this.paused) {
                    this.forceChunkLoading();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.chunkLoadingTime == 0) {
            this.releaseTicket();
        }
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            AnchorsChunkManager.anchorsList.removeIf(obj -> obj.getX() == this.field_145851_c && obj.getY() == this.field_145848_d && obj.getZ() == this.field_145849_e);
        } else {
            this.releaseTicket();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            AnchorsChunkManager.anchorsList.add(new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        TileEntity tile = this.field_145850_b.func_147438_o(packet.func_148856_c(), packet.func_148855_d(), packet.func_148854_e());
        if (tile instanceof TileWorldAnchor) {
            this.func_145839_a(packet.func_148857_g());
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.fuelSlotItem;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.fuelSlotItem != null) {
            ItemStack itemStack;
            if (this.fuelSlotItem.field_77994_a == count) {
                itemStack = this.fuelSlotItem;
                this.fuelSlotItem = null;
            } else {
                itemStack = this.fuelSlotItem.func_77979_a(count);
                if (this.fuelSlotItem.field_77994_a == 0) {
                    this.fuelSlotItem = null;
                }
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.fuelSlotItem != null) {
            ItemStack itemStack = this.fuelSlotItem;
            this.fuelSlotItem = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.fuelSlotItem = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "inventory.worldAnchor.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IAnchorFuel;
    }

    public int[] func_94128_d(int slot) {
        return new int[slot];
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return false;
    }

    public ItemStack getFuelSlotItem() {
        return this.fuelSlotItem;
    }

    public void setFuelSlotItem(ItemStack fuelSlotItem) {
        this.fuelSlotItem = fuelSlotItem;
    }

    public int getChunkLoadingTime() {
        return this.chunkLoadingTime;
    }

    public void setChunkLoadingTime(int chunkLoadingTime) {
        this.chunkLoadingTime = chunkLoadingTime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public LoadingMode getMode() {
        return this.mode;
    }

    public void setMode(LoadingMode mode) {
        this.mode = mode;
    }
}

