/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.utils;

import com.github.gunirs.anchors.tileentity.TileAdminAnchor;
import com.github.gunirs.anchors.tileentity.TileWorldAnchor;
import com.github.gunirs.anchors.utils.BlockPos;
import com.github.gunirs.anchors.utils.Utils;
import com.github.gunirs.anchors.utils.enums.LoadingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class AnchorsChunkManager {
    public static List<BlockPos> anchorsList = new ArrayList<BlockPos>();
    public static boolean rendered = false;
    public static String teMode;
    public static boolean anchorEnabled;
    public static int chunkLoadingTime;
    private static boolean isAdminAnchor;

    public static Set<ChunkCoordIntPair> getLoadedChunksInRadius(World world, double x, double z) {
        return AnchorsChunkManager.getLoadedChunksInRadius(world, x, z, 1024);
    }

    public static Set<ChunkCoordIntPair> getLoadedChunksInRadius(World world, double x, double z, int radius) {
        HashSet<ChunkCoordIntPair> chunks = new HashSet<ChunkCoordIntPair>();
        for (BlockPos blockPos : anchorsList) {
            if (!(Utils.getDistance(x, blockPos.getY(), z, blockPos.getX(), blockPos.getY(), blockPos.getZ()) < (double)radius)) continue;
            TileEntity te = world.func_147438_o(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (te instanceof TileWorldAnchor) {
                TileWorldAnchor tileWorldAnchor = (TileWorldAnchor)te;
                LoadingMode mode = tileWorldAnchor.getMode();
                teMode = Utils.getMode(mode.ordinal());
                anchorEnabled = tileWorldAnchor.isPaused();
                chunkLoadingTime = tileWorldAnchor.getChunkLoadingTime();
                for (int i = -mode.ordinal(); i < mode.ordinal() + 1; ++i) {
                    for (int j = -mode.ordinal(); j < mode.ordinal() + 1; ++j) {
                        chunks.add(new ChunkCoordIntPair((blockPos.getX() >> 4) + i, (blockPos.getZ() >> 4) + j));
                    }
                }
            }
            if (!(te instanceof TileAdminAnchor)) continue;
            TileAdminAnchor tileAdminAnchor = (TileAdminAnchor)te;
            anchorEnabled = tileAdminAnchor.isPaused();
            isAdminAnchor = tileAdminAnchor.isAdminAnchor();
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    chunks.add(new ChunkCoordIntPair((blockPos.getX() >> 4) + i, (blockPos.getZ() >> 4) + j));
                }
            }
        }
        return chunks;
    }

    public static Set<ChunkCoordIntPair> getLoadArea(LoadingMode mode, int x, int z) {
        HashSet<ChunkCoordIntPair> targetArea = new HashSet<ChunkCoordIntPair>();
        for (int xx = -mode.ordinal(); xx < mode.ordinal() + 1; ++xx) {
            for (int zz = -mode.ordinal(); zz < mode.ordinal() + 1; ++zz) {
                targetArea.add(new ChunkCoordIntPair((x >> 4) + xx, (z >> 4) + zz));
            }
        }
        return targetArea;
    }

    public static String getTeMode() {
        return teMode;
    }

    public static boolean isAnchorEnabled() {
        return anchorEnabled;
    }

    public static int getChunkLoadingTime() {
        return chunkLoadingTime;
    }

    public static boolean isAdminAnchor() {
        return isAdminAnchor;
    }

    static {
        anchorEnabled = false;
        isAdminAnchor = false;
    }
}

