/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.utils;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PlayerUtils {
    public static GameProfile readOwnerFromNBT(NBTTagCompound nbt) {
        String ownerName = "[Unknown]";
        if (nbt.func_74764_b("owner")) {
            ownerName = nbt.func_74779_i("owner");
        }
        UUID ownerUUID = null;
        if (nbt.func_74764_b("ownerId")) {
            ownerUUID = UUID.fromString(nbt.func_74779_i("ownerId"));
        }
        return new GameProfile(ownerUUID, ownerName);
    }

    public static String getUsername(World world, GameProfile gameProfile) {
        EntityPlayer player;
        UUID playerId = gameProfile.getId();
        if (playerId != null && (player = world.func_152378_a(playerId)) != null) {
            return player.getDisplayName();
        }
        String username = gameProfile.getName();
        return username != null && !username.isEmpty() ? username : "[Unknown]";
    }

    public static boolean isPlayerConnected(GameProfile player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(player.getName()) != null;
    }
}

