/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.storage.IItemDisplayRegistry;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class AppEngRenderItem
extends RenderItem {
    private static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEItemStack aeStack = null;
    public static List<IItemDisplayRegistry.ItemRenderHook> POST_HOOKS = new ArrayList<IItemDisplayRegistry.ItemRenderHook>();

    public void func_94148_a(FontRenderer fontRenderer, TextureManager textureManager, ItemStack is, int par4, int par5, String par6Str) {
        if (is != null) {
            long amount;
            boolean skip = false;
            boolean showDurabilitybar = true;
            boolean showStackSize = true;
            boolean showCraftLabelText = true;
            for (IItemDisplayRegistry.ItemRenderHook hook : POST_HOOKS) {
                skip |= hook.renderOverlay(fontRenderer, textureManager, is, par4, par5);
                showDurabilitybar &= hook.showDurability(is);
                showStackSize &= hook.showStackSize(is);
                showCraftLabelText &= hook.showCraftLabelText(is);
            }
            if (skip) {
                return;
            }
            float scaleFactor = AEConfig.instance.useTerminalUseLargeFont() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            int offset = AEConfig.instance.useTerminalUseLargeFont() ? 0 : -1;
            boolean unicodeFlag = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(false);
            if (showDurabilitybar && is.func_77973_b().showDurabilityBar(is)) {
                double health = is.func_77973_b().getDurabilityForDisplay(is);
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                Tessellator tessellator = Tessellator.field_78398_a;
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                this.func_77017_a(tessellator, par4 + 2, par5 + 13, 13, 2, 0);
                this.func_77017_a(tessellator, par4 + 2, par5 + 13, 12, 1, i1);
                this.func_77017_a(tessellator, par4 + 2, par5 + 13, j1, 1, l);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (is.field_77994_a == 0 && showCraftLabelText) {
                String craftLabelText = AEConfig.instance.useTerminalUseLargeFont() ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                GL11.glDisable((int)2896);
                GL11.glPushMatrix();
                GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
                int X = (int)(((float)par4 + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(craftLabelText) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)par5 + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_78261_a(craftLabelText, X, Y, 0xFFFFFF);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
            }
            long l = amount = this.aeStack != null ? this.aeStack.getStackSize() : (long)is.field_77994_a;
            if (amount != 0L && showStackSize) {
                String stackSize = this.getToBeRenderedStackSize(amount);
                GL11.glDisable((int)2896);
                GL11.glPushMatrix();
                GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
                int X = (int)(((float)par4 + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)par5 + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_78261_a(stackSize, X, Y, 0xFFFFFF);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
            }
            fontRenderer.func_78264_a(unicodeFlag);
        }
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance.useTerminalUseLargeFont()) {
            return SLIM_CONVERTER.toSlimReadableForm(originalSize);
        }
        return WIDE_CONVERTER.toWideReadableForm(originalSize);
    }

    public IAEItemStack getAeStack() {
        return this.aeStack;
    }

    public void setAeStack(@Nonnull IAEItemStack aeStack) {
        this.aeStack = aeStack;
    }
}

