/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;

public final class PacketConfigButton
extends AppEngPacket {
    private final Settings option;
    private final boolean rotationDirection;

    public PacketConfigButton(ByteBuf stream) {
        this.option = Settings.values()[stream.readInt()];
        this.rotationDirection = stream.readBoolean();
    }

    public PacketConfigButton(Settings option, boolean rotationDirection) {
        this.option = option;
        this.rotationDirection = rotationDirection;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(option.ordinal());
        data.writeBoolean(rotationDirection);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        AEBaseContainer baseContainer;
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container container = sender.field_71070_bA;
        if (container instanceof AEBaseContainer && (baseContainer = (AEBaseContainer)container).getTarget() instanceof IConfigurableObject) {
            IConfigManager cm = ((IConfigurableObject)baseContainer.getTarget()).getConfigManager();
            Enum<?> newState = Platform.rotateEnum(cm.getSetting(this.option), this.rotationDirection, this.option.getPossibleValues());
            cm.putSetting(this.option, newState);
        }
    }
}

