/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.gui.widgets.ICraftingCPUTableHolder;
import appeng.container.implementations.CraftingCPUStatus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class PacketCraftingCPUsUpdate
extends AppEngPacket {
    private final CraftingCPUStatus[] cpus;

    public PacketCraftingCPUsUpdate(ByteBuf stream) {
        int count = stream.readInt();
        this.cpus = new CraftingCPUStatus[count];
        for (int i = 0; i < count; ++i) {
            try {
                this.cpus[i] = new CraftingCPUStatus(stream);
                continue;
            }
            catch (IOException e) {
                this.cpus[i] = new CraftingCPUStatus();
            }
        }
    }

    public PacketCraftingCPUsUpdate(Collection<CraftingCPUStatus> cpus) throws IOException {
        this.cpus = cpus.toArray(new CraftingCPUStatus[0]);
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(this.cpus.length);
        for (CraftingCPUStatus cpu : this.cpus) {
            cpu.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof ICraftingCPUTableHolder) {
            ICraftingCPUTableHolder gui = (ICraftingCPUTableHolder)gs;
            gui.getCPUTable().getContainer().handleCPUUpdate(this.cpus);
        }
    }
}

