/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.AEApi;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.ISimplifiedBundle;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.RenderBlocksWorkaround;
import appeng.core.AELog;
import appeng.facade.IFacadeItem;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBuildCraftTransport;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class FacadePart
implements IFacadePart,
IBoxProvider {
    private final ItemStack facade;
    private final ForgeDirection side;
    private int thickness = 2;
    @SideOnly(value=Side.CLIENT)
    private ISimplifiedBundle prevLight;

    public FacadePart(ItemStack facade, ForgeDirection side) {
        if (facade == null) {
            throw new IllegalArgumentException("Facade Part constructed on null item.");
        }
        this.facade = facade.func_77946_l();
        this.facade.field_77994_a = 1;
        this.side = side;
    }

    public static boolean isFacade(ItemStack is) {
        return is.func_77973_b() instanceof IFacadeItem;
    }

    @Override
    public ItemStack getItemStack() {
        return this.facade;
    }

    @Override
    public void getBoxes(IPartCollisionHelper ch, Entity e) {
        if (e instanceof EntityLivingBase) {
            ch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);
        } else {
            ch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.9);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper instance2, RenderBlocks renderer, IFacadeContainer fc, AxisAlignedBB busBounds, boolean renderStilt) {
        block43: {
            if (this.facade != null) {
                BusRenderHelper instance = (BusRenderHelper)instance2;
                try {
                    Object bc;
                    ItemStack randomItem = this.getTexture();
                    RenderBlocksWorkaround rbw = null;
                    if (renderer instanceof RenderBlocksWorkaround) {
                        rbw = (RenderBlocksWorkaround)renderer;
                    }
                    if (renderStilt && busBounds == null) {
                        if (rbw != null) {
                            rbw.setFacade(false);
                            rbw.setCalculations(true);
                        }
                        IIcon myIcon = null;
                        if (this.notAEFacade() && IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.BuildCraftTransport)) {
                            bc = (IBuildCraftTransport)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.BuildCraftTransport);
                            myIcon = bc.getCobbleStructurePipeTexture();
                        }
                        if (myIcon == null) {
                            myIcon = this.facade.func_77954_c();
                        }
                        instance.setTexture(myIcon);
                        if (this.notAEFacade()) {
                            instance.setBounds(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 15.0f);
                        } else {
                            instance.setBounds(7.0f, 7.0f, 10.0f, 9.0f, 9.0f, 15.0f);
                        }
                        instance.renderBlock(x, y, z, renderer);
                        instance.setTexture(null);
                    }
                    if (randomItem == null || !((bc = randomItem.func_77973_b()) instanceof ItemBlock)) break block43;
                    ItemBlock ib = (ItemBlock)bc;
                    Block blk = Block.func_149634_a((Item)ib);
                    if (AEApi.instance().partHelper().getCableRenderMode().transparentFacades) {
                        if (rbw != null) {
                            rbw.setOpacity(0.3f);
                        }
                        instance.renderForPass(1);
                    } else if (blk.canRenderInPass(1)) {
                        instance.renderForPass(1);
                    }
                    int color = 0xFFFFFF;
                    try {
                        color = ib.func_82790_a(randomItem, 0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    renderer.field_147873_r = 0;
                    renderer.field_147867_u = 0;
                    renderer.field_147871_s = 0;
                    renderer.field_147869_t = 0;
                    renderer.field_147875_q = 0;
                    renderer.field_147865_v = 0;
                    instance.setBounds(0.0f, 0.0f, 16 - this.thickness, 16.0f, 16.0f, 16.0f);
                    instance.prepareBounds(renderer);
                    if (rbw != null) {
                        rbw.setFacade(true);
                        rbw.setCalculations(true);
                        rbw.setFaces(EnumSet.noneOf(ForgeDirection.class));
                        if (this.prevLight != null && rbw.similarLighting(blk, rbw.field_147845_a, x, y, z, this.prevLight)) {
                            rbw.populate(this.prevLight);
                        } else {
                            instance.setRenderColor(color);
                            rbw.func_147784_q(instance.getBlock(), x, y, z);
                            instance.setRenderColor(0xFFFFFF);
                            this.prevLight = rbw.getLightingCache();
                        }
                        rbw.setCalculations(false);
                        rbw.setFaces(this.calculateFaceOpenFaces(rbw.field_147845_a, fc, x, y, z, this.side));
                        ((RenderBlocksWorkaround)renderer).setTexture(blk.func_149691_a(ForgeDirection.DOWN.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.UP.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.NORTH.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.SOUTH.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.WEST.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.EAST.ordinal(), ib.func_77647_b(randomItem.func_77960_j())));
                    } else {
                        instance.setTexture(blk.func_149691_a(ForgeDirection.DOWN.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.UP.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.NORTH.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.SOUTH.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.WEST.ordinal(), ib.func_77647_b(randomItem.func_77960_j())), blk.func_149691_a(ForgeDirection.EAST.ordinal(), ib.func_77647_b(randomItem.func_77960_j())));
                    }
                    if (busBounds == null) {
                        if (this.side == ForgeDirection.UP || this.side == ForgeDirection.DOWN) {
                            instance.renderBlockCurrentBounds(x, y, z, renderer);
                        } else if (this.side == ForgeDirection.NORTH || this.side == ForgeDirection.SOUTH) {
                            if (fc.getFacade(ForgeDirection.UP) != null) {
                                renderer.field_147857_k -= (double)this.thickness / 16.0;
                            }
                            if (fc.getFacade(ForgeDirection.DOWN) != null) {
                                renderer.field_147855_j += (double)this.thickness / 16.0;
                            }
                            instance.renderBlockCurrentBounds(x, y, z, renderer);
                        } else {
                            if (fc.getFacade(ForgeDirection.UP) != null) {
                                renderer.field_147857_k -= (double)this.thickness / 16.0;
                            }
                            if (fc.getFacade(ForgeDirection.DOWN) != null) {
                                renderer.field_147855_j += (double)this.thickness / 16.0;
                            }
                            if (fc.getFacade(ForgeDirection.SOUTH) != null) {
                                renderer.field_147853_m -= (double)this.thickness / 16.0;
                            }
                            if (fc.getFacade(ForgeDirection.NORTH) != null) {
                                renderer.field_147851_l += (double)this.thickness / 16.0;
                            }
                            instance.renderBlockCurrentBounds(x, y, z, renderer);
                        }
                    } else if (this.side == ForgeDirection.UP || this.side == ForgeDirection.DOWN) {
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, busBounds.field_72334_f, 1.0, 1.0, 1.0);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, 0.0, 1.0, 1.0, busBounds.field_72339_c);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, busBounds.field_72339_c, busBounds.field_72340_a, 1.0, busBounds.field_72334_f);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, busBounds.field_72336_d, 0.0, busBounds.field_72339_c, 1.0, 1.0, busBounds.field_72334_f);
                    } else if (this.side == ForgeDirection.NORTH || this.side == ForgeDirection.SOUTH) {
                        if (fc.getFacade(ForgeDirection.UP) != null) {
                            renderer.field_147857_k -= (double)this.thickness / 16.0;
                        }
                        if (fc.getFacade(ForgeDirection.DOWN) != null) {
                            renderer.field_147855_j += (double)this.thickness / 16.0;
                        }
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, busBounds.field_72336_d, 0.0, 0.0, 1.0, 1.0, 1.0);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, 0.0, busBounds.field_72340_a, 1.0, 1.0);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, busBounds.field_72340_a, 0.0, 0.0, busBounds.field_72336_d, busBounds.field_72338_b, 1.0);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, busBounds.field_72340_a, busBounds.field_72337_e, 0.0, busBounds.field_72336_d, 1.0, 1.0);
                    } else {
                        if (fc.getFacade(ForgeDirection.UP) != null) {
                            renderer.field_147857_k -= (double)this.thickness / 16.0;
                        }
                        if (fc.getFacade(ForgeDirection.DOWN) != null) {
                            renderer.field_147855_j += (double)this.thickness / 16.0;
                        }
                        if (fc.getFacade(ForgeDirection.SOUTH) != null) {
                            renderer.field_147853_m -= (double)this.thickness / 16.0;
                        }
                        if (fc.getFacade(ForgeDirection.NORTH) != null) {
                            renderer.field_147851_l += (double)this.thickness / 16.0;
                        }
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, busBounds.field_72334_f, 1.0, 1.0, 1.0);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, 0.0, 1.0, 1.0, busBounds.field_72339_c);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, 0.0, busBounds.field_72339_c, 1.0, busBounds.field_72338_b, busBounds.field_72334_f);
                        this.renderSegmentBlockCurrentBounds(instance, x, y, z, renderer, 0.0, busBounds.field_72337_e, busBounds.field_72339_c, 1.0, 1.0, busBounds.field_72334_f);
                    }
                    if (rbw != null) {
                        rbw.setOpacity(1.0f);
                        rbw.setFaces(EnumSet.allOf(ForgeDirection.class));
                    }
                    instance.renderForPass(0);
                    instance.setTexture(null);
                    Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                }
                catch (Throwable t) {
                    AELog.debug(t);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper instance, RenderBlocks renderer) {
        block5: {
            if (this.facade != null) {
                IFacadeItem fi = (IFacadeItem)this.facade.func_77973_b();
                try {
                    Item item;
                    if (fi == null) break block5;
                    ItemStack randomItem = fi.getTextureItem(this.facade);
                    instance.setTexture(this.facade.func_77954_c());
                    instance.setBounds(7.0f, 7.0f, 4.0f, 9.0f, 9.0f, 14.0f);
                    instance.renderInventoryBox(renderer);
                    instance.setTexture(null);
                    if (randomItem == null || !((item = randomItem.func_77973_b()) instanceof ItemBlock)) break block5;
                    ItemBlock ib = (ItemBlock)item;
                    Block blk = Block.func_149634_a((Item)ib);
                    try {
                        int color = ib.func_82790_a(randomItem, 0);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        instance.setInvColor(color);
                    }
                    catch (Throwable error) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        instance.setInvColor(0xFFFFFF);
                    }
                    Tessellator.field_78398_a.func_78380_c(0xF000F0);
                    Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                    instance.setTexture(blk.func_149691_a(this.side.ordinal(), ib.func_77647_b(randomItem.func_77960_j())));
                    instance.setBounds(0.0f, 0.0f, 14.0f, 16.0f, 16.0f, 16.0f);
                    instance.renderInventoryBox(renderer);
                    instance.setTexture(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public ForgeDirection getSide() {
        return this.side;
    }

    @Override
    public AxisAlignedBB getPrimaryBox() {
        return Platform.getPrimaryBox(this.side, this.thickness);
    }

    @Override
    public Item getItem() {
        ItemStack is = this.getTexture();
        if (is == null) {
            return null;
        }
        return is.func_77973_b();
    }

    @Override
    public int getItemDamage() {
        ItemStack is = this.getTexture();
        if (is == null) {
            return 0;
        }
        return is.func_77960_j();
    }

    @Override
    public boolean notAEFacade() {
        return !(this.facade.func_77973_b() instanceof IFacadeItem);
    }

    @Override
    public void setThinFacades(boolean useThinFacades) {
        this.thickness = useThinFacades ? 1 : 2;
    }

    @Override
    public boolean isTransparent() {
        if (AEApi.instance().partHelper().getCableRenderMode().transparentFacades) {
            return true;
        }
        ItemStack is = this.getTexture();
        Block blk = Block.func_149634_a((Item)is.func_77973_b());
        return !blk.func_149662_c();
    }

    @Nullable
    private ItemStack getTexture() {
        Item maybeFacade = this.facade.func_77973_b();
        if (maybeFacade instanceof IFacadeItem) {
            IFacadeItem facade = (IFacadeItem)maybeFacade;
            return facade.getTextureItem(this.facade);
        }
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.BuildCraftTransport)) {
            IBuildCraftTransport bc = (IBuildCraftTransport)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.BuildCraftTransport);
            return bc.getTextureForFacade(this.facade);
        }
        return null;
    }

    private EnumSet<ForgeDirection> calculateFaceOpenFaces(IBlockAccess blockAccess, IFacadeContainer fc, int x, int y, int z, ForgeDirection side) {
        IFacadePart fp;
        EnumSet<ForgeDirection> out = EnumSet.of(side, side.getOpposite());
        IFacadePart facade = fc.getFacade(side);
        for (ForgeDirection it : ForgeDirection.VALID_DIRECTIONS) {
            if (out.contains(it) || !this.hasAlphaDiff(blockAccess.func_147438_o(x + it.offsetX, y + it.offsetY, z + it.offsetZ), side, facade)) continue;
            out.add(it);
        }
        if (out.contains(ForgeDirection.UP) && (side.offsetX != 0 || side.offsetZ != 0) && (fp = fc.getFacade(ForgeDirection.UP)) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(ForgeDirection.UP);
        }
        if (out.contains(ForgeDirection.DOWN) && (side.offsetX != 0 || side.offsetZ != 0) && (fp = fc.getFacade(ForgeDirection.DOWN)) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(ForgeDirection.DOWN);
        }
        if (out.contains(ForgeDirection.SOUTH) && side.offsetX != 0 && (fp = fc.getFacade(ForgeDirection.SOUTH)) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(ForgeDirection.SOUTH);
        }
        if (out.contains(ForgeDirection.NORTH) && side.offsetX != 0 && (fp = fc.getFacade(ForgeDirection.NORTH)) != null && fp.isTransparent() == facade.isTransparent()) {
            out.remove(ForgeDirection.NORTH);
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderSegmentBlockCurrentBounds(IPartRenderHelper instance, int x, int y, int z, RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double oldMinX = renderer.field_147859_h;
        double oldMinY = renderer.field_147855_j;
        double oldMinZ = renderer.field_147851_l;
        double oldMaxX = renderer.field_147861_i;
        double oldMaxY = renderer.field_147857_k;
        double oldMaxZ = renderer.field_147853_m;
        renderer.field_147859_h = Math.max(renderer.field_147859_h, minX);
        renderer.field_147855_j = Math.max(renderer.field_147855_j, minY);
        renderer.field_147851_l = Math.max(renderer.field_147851_l, minZ);
        renderer.field_147861_i = Math.min(renderer.field_147861_i, maxX);
        renderer.field_147857_k = Math.min(renderer.field_147857_k, maxY);
        renderer.field_147853_m = Math.min(renderer.field_147853_m, maxZ);
        if (renderer.field_147861_i - renderer.field_147859_h >= 0.0625 && renderer.field_147857_k - renderer.field_147855_j >= 0.0625 && renderer.field_147853_m - renderer.field_147851_l >= 0.0625) {
            instance.renderBlockCurrentBounds(x, y, z, renderer);
        }
        renderer.field_147859_h = oldMinX;
        renderer.field_147855_j = oldMinY;
        renderer.field_147851_l = oldMinZ;
        renderer.field_147861_i = oldMaxX;
        renderer.field_147857_k = oldMaxY;
        renderer.field_147853_m = oldMaxZ;
    }

    private boolean hasAlphaDiff(TileEntity tileEntity, ForgeDirection side, IFacadePart facade) {
        if (tileEntity instanceof IPartHost) {
            IPartHost ph = (IPartHost)tileEntity;
            IFacadePart fp = ph.getFacadeContainer().getFacade(side);
            return fp == null || fp.isTransparent() != facade.isTransparent();
        }
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.getBoxes(bch, null);
    }
}

