/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila;

import appeng.api.parts.IPart;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.integration.modules.waila.part.ChannelWailaDataProvider;
import appeng.integration.modules.waila.part.IPartWailaDataProvider;
import appeng.integration.modules.waila.part.P2PStateWailaDataProvider;
import appeng.integration.modules.waila.part.PartAccessor;
import appeng.integration.modules.waila.part.PartInterfaceDataProvider;
import appeng.integration.modules.waila.part.PowerStateWailaDataProvider;
import appeng.integration.modules.waila.part.StorageMonitorWailaDataProvider;
import appeng.integration.modules.waila.part.Tracer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class PartWailaDataProvider
implements IWailaDataProvider {
    private final List<IPartWailaDataProvider> providers;
    private final PartAccessor accessor = new PartAccessor();
    private final Tracer tracer = new Tracer();

    public PartWailaDataProvider() {
        ChannelWailaDataProvider channel = new ChannelWailaDataProvider();
        StorageMonitorWailaDataProvider storageMonitor = new StorageMonitorWailaDataProvider();
        PowerStateWailaDataProvider powerState = new PowerStateWailaDataProvider();
        P2PStateWailaDataProvider p2pState = new P2PStateWailaDataProvider();
        BasePartWailaDataProvider partStack = new BasePartWailaDataProvider();
        PartInterfaceDataProvider partInterface = new PartInterfaceDataProvider();
        this.providers = Lists.newArrayList((Object[])new IPartWailaDataProvider[]{channel, storageMonitor, powerState, p2pState, partStack, partInterface});
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPartWailaDataProvider provider;
            IPart part = (IPart)maybePart.get();
            ItemStack wailaStack = null;
            Iterator<IPartWailaDataProvider> iterator = this.providers.iterator();
            while (iterator.hasNext() && (wailaStack = (provider = iterator.next()).getWailaStack(part, config, wailaStack)) == null) {
            }
            return wailaStack;
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaHead(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaBody(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaTail(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        Optional<IPart> maybePart;
        MovingObjectPosition mop = this.tracer.retraceBlock(world, player, x, y, z);
        if (mop != null && (maybePart = this.accessor.getMaybePart(te, mop)).isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getNBTData(player, part, te, tag, world, x, y, z);
            }
        }
        return tag;
    }
}

