/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.parts.networking.PartCableSmart;
import appeng.parts.networking.PartDenseCable;
import appeng.parts.networking.PartUltraDenseCableSmart;
import gnu.trove.map.TObjectShortMap;
import gnu.trove.map.hash.TObjectShortHashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class ChannelWailaDataProvider
extends BasePartWailaDataProvider {
    private static final String ID_USED_CHANNELS = "usedChannels";
    private final TObjectShortMap<IPart> cache = new TObjectShortHashMap();

    @Override
    public List<String> getWailaBody(IPart part, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (part instanceof PartCableSmart || part instanceof PartDenseCable) {
            short usedChannels = this.getUsedChannels(part, accessor.getNBTData());
            int maxChannels = part instanceof PartUltraDenseCableSmart ? 128 : (part instanceof PartDenseCable ? 32 : 8);
            String formattedToolTip = String.format(WailaText.Channels.getLocal(), usedChannels, maxChannels);
            currentToolTip.add(formattedToolTip);
        }
        return currentToolTip;
    }

    private short getUsedChannels(IPart part, NBTTagCompound tag) {
        short usedChannels;
        if (tag.func_74764_b(ID_USED_CHANNELS)) {
            usedChannels = tag.func_74765_d(ID_USED_CHANNELS);
            this.cache.put((Object)part, usedChannels);
        } else {
            usedChannels = this.cache.containsKey((Object)part) ? this.cache.get((Object)part) : (short)0;
        }
        return usedChannels;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, IPart part, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (part instanceof PartCableSmart || part instanceof PartDenseCable) {
            NBTTagCompound tempTag = new NBTTagCompound();
            part.writeToNBT(tempTag);
            if (tempTag.func_74764_b(ID_USED_CHANNELS)) {
                short usedChannels = tempTag.func_74765_d(ID_USED_CHANNELS);
                tag.func_74777_a(ID_USED_CHANNELS, usedChannels);
            }
        }
        return tag;
    }
}

