/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.energy;

import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.me.cache.EnergyGridCache;
import appeng.me.energy.EnergyThreshold;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class EnergyWatcher
implements IEnergyWatcher {
    private final EnergyGridCache gsc;
    private final IEnergyWatcherHost myObject;
    private final HashSet<EnergyThreshold> myInterests = new HashSet();

    public EnergyWatcher(EnergyGridCache cache, IEnergyWatcherHost host) {
        this.gsc = cache;
        this.myObject = host;
    }

    public void post(EnergyGridCache energyGridCache) {
        this.myObject.onThresholdPass(energyGridCache);
    }

    public IEnergyWatcherHost getHost() {
        return this.myObject;
    }

    @Override
    public int size() {
        return this.myInterests.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myInterests.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myInterests.contains(o);
    }

    @Override
    public Iterator<Double> iterator() {
        return new EnergyWatcherIterator(this, this.myInterests.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.myInterests.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.myInterests.toArray(a);
    }

    @Override
    public boolean add(Double e) {
        if (this.myInterests.contains(e)) {
            return false;
        }
        EnergyThreshold eh = new EnergyThreshold(e, this);
        return this.gsc.getInterests().add(eh) && this.myInterests.add(eh);
    }

    @Override
    public boolean remove(Object o) {
        EnergyThreshold eh = new EnergyThreshold((Double)o, this);
        return this.myInterests.remove(eh) && this.gsc.getInterests().remove(eh);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myInterests.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        boolean didChange = false;
        for (Double d : c) {
            didChange = this.add(d) || didChange;
        }
        return didChange;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean didSomething = false;
        for (Object o : c) {
            didSomething = this.remove(o) || didSomething;
        }
        return didSomething;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<Double> i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<EnergyThreshold> i = this.myInterests.iterator();
        while (i.hasNext()) {
            this.gsc.getInterests().remove(i.next());
            i.remove();
        }
    }

    private class EnergyWatcherIterator
    implements Iterator<Double> {
        private final EnergyWatcher watcher;
        private final Iterator<EnergyThreshold> interestIterator;
        private EnergyThreshold myLast;

        public EnergyWatcherIterator(EnergyWatcher parent, Iterator<EnergyThreshold> i) {
            this.watcher = parent;
            this.interestIterator = i;
        }

        @Override
        public boolean hasNext() {
            return this.interestIterator.hasNext();
        }

        @Override
        public Double next() {
            this.myLast = this.interestIterator.next();
            return this.myLast.getLimit();
        }

        @Override
        public void remove() {
            EnergyWatcher.this.gsc.getInterests().remove(this.myLast);
            this.interestIterator.remove();
        }
    }
}

