/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.sync.GuiBridge;
import appeng.helpers.PatternHelper;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.BiggerAppEngInventory;
import appeng.tile.inventory.InvOperation;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartPatternTerminal
extends AbstractPartTerminal {
    private static final CableBusTextures FRONT_BRIGHT_ICON = CableBusTextures.PartPatternTerm_Bright;
    private static final CableBusTextures FRONT_DARK_ICON = CableBusTextures.PartPatternTerm_Dark;
    private static final CableBusTextures FRONT_COLORED_ICON = CableBusTextures.PartPatternTerm_Colored;
    private final AppEngInternalInventory crafting = new BiggerAppEngInventory(this, 9){};
    private final AppEngInternalInventory output = new BiggerAppEngInventory(this, 3){};
    private final AppEngInternalInventory pattern = new AppEngInternalInventory(this, 2);
    private boolean craftingMode = true;
    private boolean substitute = false;
    private boolean beSubstitute = false;

    public PartPatternTerminal(ItemStack is) {
        super(is);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.pattern) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setCraftingRecipe(data.func_74767_n("craftingMode"));
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setCanBeSubstitution(data.func_74767_n("beSubstitute"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("craftingMode", this.craftingMode);
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("beSubstitute", this.beSubstitute);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.getTile().field_145851_c;
            y = this.getTile().field_145848_d;
            z = this.getTile().field_145849_e;
        }
        if (GuiBridge.GUI_PATTERN_TERMINAL.hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), p)) {
            return GuiBridge.GUI_PATTERN_TERMINAL;
        }
        return GuiBridge.GUI_ME;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.pattern && slot == 1) {
            Item item;
            ItemStack stack = this.pattern.func_70301_a(1);
            if (stack != null && (item = stack.func_77973_b()) instanceof ICraftingPatternItem) {
                ICraftingPatternItem pattern = (ICraftingPatternItem)item;
                NBTTagCompound encodedValue = stack.func_77978_p();
                if (encodedValue != null) {
                    int x;
                    IAEItemStack[] outItems;
                    IAEItemStack[] inItems;
                    ICraftingPatternDetails details = pattern.getPatternForItem(stack, this.getHost().getTile().func_145831_w());
                    boolean substitute = encodedValue.func_74767_n("substitute");
                    boolean beSubstitute = encodedValue.func_74767_n("beSubstitute");
                    boolean isCrafting = encodedValue.func_74767_n("crafting");
                    if (details == null) {
                        inItems = PatternHelper.loadIAEItemStackFromNBT(encodedValue.func_150295_c("in", 10), true, null);
                        outItems = PatternHelper.loadIAEItemStackFromNBT(encodedValue.func_150295_c("out", 10), true, null);
                    } else {
                        inItems = details.getInputs();
                        outItems = details.getOutputs();
                    }
                    this.setCraftingRecipe(isCrafting);
                    this.setSubstitution(substitute);
                    this.setCanBeSubstitution(beSubstitute);
                    for (x = 0; x < this.crafting.func_70302_i_(); ++x) {
                        this.crafting.func_70299_a(x, null);
                    }
                    for (x = 0; x < this.output.func_70302_i_(); ++x) {
                        this.output.func_70299_a(x, null);
                    }
                    for (x = 0; x < this.crafting.func_70302_i_() && x < inItems.length; ++x) {
                        if (inItems[x] == null) continue;
                        this.crafting.func_70299_a(x, inItems[x].getItemStack());
                    }
                    for (x = 0; x < this.output.func_70302_i_() && x < outItems.length; ++x) {
                        if (outItems[x] == null) continue;
                        this.output.func_70299_a(x, outItems[x].getItemStack());
                    }
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.getHost().markForSave();
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
                ItemStack is = this.crafting.func_70301_a(x);
                if (is == null) continue;
                is.field_77994_a = 1;
            }
        }
    }

    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public boolean canBeSubstitution() {
        return this.beSubstitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    public void setCanBeSubstitution(boolean beSubstitute) {
        this.beSubstitute = beSubstitute;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public CableBusTextures getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public CableBusTextures getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public CableBusTextures getFrontDark() {
        return FRONT_DARK_ICON;
    }
}

