/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.SettingsFrom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyCell
extends AENetworkTile
implements IAEPowerStorage {
    private double internalCurrentPower = 0.0;
    private double internalMaxPower = 200000.0;
    private byte currentMeta = (byte)-1;

    public TileEnergyCell() {
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.currentMeta = (byte)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.changePowerLevel();
    }

    private void changePowerLevel() {
        if (this.notLoaded()) {
            return;
        }
        byte boundMetadata = (byte)(8.0 * (this.internalCurrentPower / this.getInternalMaxPower()));
        if (boundMetadata > 7) {
            boundMetadata = 7;
        }
        if (boundMetadata < 0) {
            boundMetadata = 0;
        }
        if (this.currentMeta != boundMetadata) {
            this.currentMeta = boundMetadata;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.currentMeta, 2);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileEnergyCell(NBTTagCompound data) {
        if (!this.field_145850_b.field_72995_K) {
            data.func_74780_a("internalCurrentPower", this.internalCurrentPower);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileEnergyCell(NBTTagCompound data) {
        this.internalCurrentPower = data.func_74769_h("internalCurrentPower");
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentPower = compound.func_74769_h("internalCurrentPower");
        }
    }

    @Override
    public NBTTagCompound downloadSettings(SettingsFrom from) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("internalCurrentPower", this.internalCurrentPower);
            tag.func_74780_a("internalMaxPower", this.getInternalMaxPower());
            return tag;
        }
        return null;
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.internalCurrentPower + amt;
            if (fakeBattery > this.getInternalMaxPower()) {
                return fakeBattery - this.getInternalMaxPower();
            }
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.01) {
            this.getProxy().getNode().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > this.getInternalMaxPower()) {
            amt = this.internalCurrentPower - this.getInternalMaxPower();
            this.internalCurrentPower = this.getInternalMaxPower();
            this.changePowerLevel();
            return amt;
        }
        this.changePowerLevel();
        return 0.0;
    }

    @Override
    public double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.internalCurrentPower > amt) {
                return amt;
            }
            return this.internalCurrentPower;
        }
        boolean bl = wasFull = this.internalCurrentPower >= this.getInternalMaxPower() - 0.001;
        if (wasFull && amt > 0.001) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            this.changePowerLevel();
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        this.changePowerLevel();
        return amt;
    }

    private double getInternalMaxPower() {
        return this.internalMaxPower * PowerMultiplier.CONFIG.multiplier;
    }

    void setInternalMaxPower(double internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }
}

