/*
 * Decompiled with CFR 0.152.
 */
package appeng.transformer.asm;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.net.URL;
import java.net.URLConnection;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

public class ApiRepairer
implements IClassTransformer {
    private LaunchClassLoader launchClassLoader = (LaunchClassLoader)this.getClass().getClassLoader();

    public ApiRepairer() {
        FMLRelaunchLog.log((String)"AE2-ApiRepairer", (Level)Level.INFO, (String)"AE2 ApiFixer Installed", (Object[])new Object[0]);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.startsWith("appeng.api")) {
            try {
                String clazzurl = this.getClass().getResource("").toString();
                clazzurl = clazzurl.substring(0, clazzurl.length() - 23) + transformedName.replace('.', '/') + ".class";
                URL url = new URL(clazzurl);
                URLConnection connection = url.openConnection();
                byte[] bytes = new byte[connection.getContentLength()];
                if (connection.getInputStream().read(bytes) == -1) {
                    FMLRelaunchLog.log((String)"AE2-ApiRepairer", (Level)Level.ERROR, (String)"Failed to fix api class [%s] because the new class couldn't be read", (Object[])new Object[]{transformedName});
                    return basicClass;
                }
                for (IClassTransformer ct : this.launchClassLoader.getTransformers()) {
                    if (ct == this) continue;
                    bytes = ct.transform(name, transformedName, bytes);
                }
                return bytes;
            }
            catch (Exception e) {
                FMLRelaunchLog.log((String)"AE2-ApiRepairer", (Level)Level.ERROR, (String)"Failed to fix api class [%s] because of [%s]", (Object[])new Object[]{transformedName, e.getClass().getName()});
                return basicClass;
            }
        }
        return basicClass;
    }
}

