/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IMaterials;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.worlddata.WorldData;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.worldgen.meteorite.Fallout;
import appeng.worldgen.meteorite.FalloutCopy;
import appeng.worldgen.meteorite.FalloutSand;
import appeng.worldgen.meteorite.FalloutSnow;
import appeng.worldgen.meteorite.IMeteoriteWorld;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public final class MeteoritePlacer {
    private static final int SKYSTONE_SPAWN_LIMIT = 12;
    private static final long SEED_OFFSET_CHEST_LOOT = 1L;
    private static final long SEED_OFFSET_DECAY = 2L;
    private static final Collection<Block> validSpawn = new HashSet<Block>();
    private static final Collection<Block> invalidSpawn = new HashSet<Block>();
    private static IBlockDefinition skyChestDefinition;
    private static IBlockDefinition skyStoneDefinition;
    private final IMeteoriteWorld world;
    private final long seed;
    private final int x;
    private final int y;
    private final int z;
    private final int skyMode;
    private final double meteoriteSize;
    private final double craterSize;
    private final double squaredMeteoriteSize;
    private final double squaredCraterSize;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private final NBTTagCompound settings;
    private Fallout type;

    private static void initializeSpawnLists() {
        if (validSpawn.isEmpty()) {
            IBlocks blocks = AEApi.instance().definitions().blocks();
            skyChestDefinition = blocks.skyChest();
            skyStoneDefinition = blocks.skyStone();
            validSpawn.clear();
            validSpawn.add(Blocks.field_150348_b);
            validSpawn.add(Blocks.field_150347_e);
            validSpawn.add((Block)Blocks.field_150349_c);
            validSpawn.add((Block)Blocks.field_150354_m);
            validSpawn.add(Blocks.field_150346_d);
            validSpawn.add(Blocks.field_150351_n);
            validSpawn.add(Blocks.field_150424_aL);
            validSpawn.add(Blocks.field_150366_p);
            validSpawn.add(Blocks.field_150352_o);
            validSpawn.add(Blocks.field_150482_ag);
            validSpawn.add(Blocks.field_150450_ax);
            validSpawn.add(Blocks.field_150405_ch);
            validSpawn.add(Blocks.field_150432_aD);
            validSpawn.add(Blocks.field_150433_aE);
            validSpawn.add(Blocks.field_150406_ce);
            invalidSpawn.clear();
            invalidSpawn.addAll(skyStoneDefinition.maybeBlock().asSet());
            invalidSpawn.add(Blocks.field_150344_f);
            invalidSpawn.add(Blocks.field_150454_av);
            invalidSpawn.add(Blocks.field_150411_aY);
            invalidSpawn.add(Blocks.field_150466_ao);
            invalidSpawn.add(Blocks.field_150336_V);
            invalidSpawn.add(Blocks.field_150435_aG);
            invalidSpawn.add(Blocks.field_150355_j);
            invalidSpawn.add(Blocks.field_150364_r);
            invalidSpawn.add(Blocks.field_150363_s);
        }
    }

    public MeteoritePlacer(IMeteoriteWorld world, long seed, int x, int y, int z) {
        int j;
        MeteoritePlacer.initializeSpawnLists();
        this.seed = seed;
        Random rng = new Random(seed);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.meteoriteSize = rng.nextDouble() * 6.0 + 2.0;
        this.craterSize = this.meteoriteSize * 2.0 + 5.0;
        this.squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
        this.squaredCraterSize = this.craterSize * this.craterSize;
        this.type = new Fallout(this.putter, skyStoneDefinition);
        int skyMode = 0;
        for (int i = x - 15; i < x + 15; ++i) {
            for (j = y - 15; j < y + 11; ++j) {
                for (int k = z - 15; k < z + 15; ++k) {
                    if (!world.canBlockSeeTheSky(i, j, k)) continue;
                    ++skyMode;
                }
            }
        }
        boolean solid = true;
        for (j = y - 15; j < y - 1; ++j) {
            if (world.getBlock(x, j, z) != Platform.AIR_BLOCK) continue;
            solid = false;
        }
        if (!solid) {
            skyMode = 0;
        }
        this.skyMode = skyMode;
        Block blk = world.getBlock(x, y, z);
        this.settings = new NBTTagCompound();
        this.settings.func_74772_a("seed", seed);
        this.settings.func_74768_a("x", x);
        this.settings.func_74768_a("y", y);
        this.settings.func_74768_a("z", z);
        this.settings.func_74768_a("blk", Block.func_149682_b((Block)blk));
        this.settings.func_74768_a("skyMode", skyMode);
        this.settings.func_74780_a("real_sizeOfMeteorite", this.meteoriteSize);
        this.settings.func_74780_a("realCrater", this.craterSize);
        this.settings.func_74780_a("sizeOfMeteorite", this.squaredMeteoriteSize);
        this.settings.func_74780_a("crater", this.squaredCraterSize);
        this.settings.func_74757_a("lava", rng.nextFloat() > 0.9f);
    }

    public MeteoritePlacer(IMeteoriteWorld world, NBTTagCompound meteoriteBlob) {
        Random rng = new Random();
        this.settings = meteoriteBlob;
        long dataSeed = meteoriteBlob.func_74763_f("seed");
        if (dataSeed == 0L) {
            Platform.seedFromGrid(rng, world.getWorld().func_72905_C(), meteoriteBlob.func_74762_e("x"), meteoriteBlob.func_74762_e("z"));
            while (dataSeed == 0L) {
                dataSeed = rng.nextLong();
            }
        }
        this.seed = dataSeed;
        rng.setSeed(dataSeed);
        this.world = world;
        this.x = this.settings.func_74762_e("x");
        this.y = this.settings.func_74762_e("y");
        this.z = this.settings.func_74762_e("z");
        this.type = new Fallout(this.putter, skyStoneDefinition);
        this.meteoriteSize = this.settings.func_74769_h("real_sizeOfMeteorite");
        this.craterSize = this.settings.func_74769_h("realCrater");
        this.squaredMeteoriteSize = this.settings.func_74769_h("sizeOfMeteorite");
        this.squaredCraterSize = this.settings.func_74769_h("crater");
        this.skyMode = this.settings.func_74762_e("skyMode");
    }

    void spawnMeteorite() {
        Block blk = Block.func_149729_e((int)this.settings.func_74762_e("blk"));
        if (blk == Blocks.field_150354_m) {
            this.type = new FalloutSand(this.world, this.x, this.y, this.z, this.putter, skyStoneDefinition);
        } else if (blk == Blocks.field_150405_ch) {
            this.type = new FalloutCopy(this.world, this.x, this.y, this.z, this.putter, skyStoneDefinition);
        } else if (blk == Blocks.field_150432_aD || blk == Blocks.field_150433_aE) {
            this.type = new FalloutSnow(this.world, this.x, this.y, this.z, this.putter, skyStoneDefinition);
        }
        if (this.skyMode > 10) {
            this.placeCrater(this.world, this.x, this.y, this.z);
        }
        this.placeMeteorite(this.world, this.x, this.y, this.z);
        if (this.skyMode > 3) {
            this.decay(this.world, this.x, this.y, this.z);
        }
        this.world.done();
    }

    private void placeCrater(IMeteoriteWorld w, int x, int y, int z) {
        boolean lava = this.settings.func_74767_n("lava");
        int maxY = 255;
        int minX = w.minX(x - 200);
        int maxX = w.maxX(x + 200);
        int minZ = w.minZ(z - 200);
        int maxZ = w.maxZ(z + 200);
        for (int j = y - 5; j < 255; ++j) {
            boolean changed = false;
            for (int i = minX; i < maxX; ++i) {
                for (int k = minZ; k < maxZ; ++k) {
                    double distanceFrom;
                    double dx = i - x;
                    double dz = k - z;
                    double h = (double)y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    if (!((double)j > h + (distanceFrom = dx * dx + dz * dz) * 0.02)) continue;
                    if (lava && j < y && w.getBlock(x, y - 1, z).func_149747_d((IBlockAccess)w.getWorld(), i, j, k, 0)) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(w, i, j, k, Blocks.field_150353_l);
                        continue;
                    }
                    changed = this.putter.put(w, i, j, k, Platform.AIR_BLOCK) || changed;
                }
            }
        }
        for (Object o : w.getWorld().func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)w.minX(x - 30), (double)(y - 5), (double)w.minZ(z - 30), (double)w.maxX(x + 30), (double)(y + 30), (double)w.maxZ(z + 30)))) {
            Entity e = (Entity)o;
            e.func_70106_y();
        }
    }

    private void placeMeteorite(IMeteoriteWorld w, int x, int y, int z) {
        int meteorXLength = w.minX(x - 8);
        int meteorXHeight = w.maxX(x + 8);
        int meteorZLength = w.minZ(z - 8);
        int meteorZHeight = w.maxZ(z + 8);
        for (int i = meteorXLength; i < meteorXHeight; ++i) {
            for (int j = y - 8; j < y + 8; ++j) {
                for (int k = meteorZLength; k < meteorZHeight; ++k) {
                    double dx = i - x;
                    double dy = j - y;
                    double dz = k - z;
                    double d = j > y ? 1.4 : 0.8;
                    if (!(dx * dx * 0.7 + dy * dy * d + dz * dz * 0.7 < this.squaredMeteoriteSize)) continue;
                    for (Block skyStoneBlock : skyStoneDefinition.maybeBlock().asSet()) {
                        this.putter.put(w, i, j, k, skyStoneBlock);
                    }
                }
            }
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.SpawnPressesInMeteorites)) {
            for (Block skyChestBlock : skyChestDefinition.maybeBlock().asSet()) {
                this.putter.put(w, x, y, z, skyChestBlock);
            }
            TileEntity te = w.getTileEntity(x, y, z);
            if (te instanceof IInventory) {
                Random lootRng = new Random(this.seed + 1L);
                InventoryAdaptor ap = InventoryAdaptor.getAdaptor(te, ForgeDirection.UP);
                ArrayList pressTypes = new ArrayList(4);
                IMaterials materials = AEApi.instance().definitions().materials();
                pressTypes.addAll(materials.calcProcessorPress().maybeStack(1).asSet());
                pressTypes.addAll(materials.engProcessorPress().maybeStack(1).asSet());
                pressTypes.addAll(materials.logicProcessorPress().maybeStack(1).asSet());
                pressTypes.addAll(materials.siliconPress().maybeStack(1).asSet());
                int pressCount = 1 + lootRng.nextInt(3);
                int removeCount = Math.max(0, pressTypes.size() - pressCount);
                for (int zz = 0; zz < removeCount; ++zz) {
                    pressTypes.remove(lootRng.nextInt(pressTypes.size()));
                }
                for (ItemStack toAdd : pressTypes) {
                    ap.addItems(toAdd);
                }
                ArrayList<ItemStack> nuggetLoot = new ArrayList<ItemStack>();
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetIron"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetCopper"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetTin"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetSilver"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetLead"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetPlatinum"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetNickel"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetAluminium"));
                nuggetLoot.addAll(OreDictionary.getOres((String)"nuggetElectrum"));
                nuggetLoot.add(new ItemStack(Items.field_151074_bl));
                int secondaryCount = 1 + lootRng.nextInt(3);
                block11: for (int zz = 0; zz < secondaryCount; ++zz) {
                    switch (lootRng.nextInt(3)) {
                        case 0: {
                            int amount = 1 + lootRng.nextInt(12);
                            for (ItemStack skyStoneStack : skyStoneDefinition.maybeStack(amount).asSet()) {
                                ap.addItems(skyStoneStack);
                            }
                            continue block11;
                        }
                        case 1: {
                            ItemStack nugget = (ItemStack)nuggetLoot.get(lootRng.nextInt(nuggetLoot.size()));
                            if (nugget == null) continue block11;
                            nugget = nugget.func_77946_l();
                            nugget.field_77994_a = 1 + lootRng.nextInt(12);
                            ap.addItems(nugget);
                            continue block11;
                        }
                    }
                }
            }
        }
    }

    private void decay(IMeteoriteWorld w, int x, int y, int z) {
        Random decayRng = new Random(this.seed + 2L);
        double randomShit = 0.0;
        int meteorXLength = w.minX(x - 30);
        int meteorXHeight = w.maxX(x + 30);
        int meteorZLength = w.minZ(z - 30);
        int meteorZHeight = w.maxZ(z + 30);
        for (int i = meteorXLength; i < meteorXHeight; ++i) {
            for (int k = meteorZLength; k < meteorZHeight; ++k) {
                for (int j = y - 9; j < y + 30; ++j) {
                    double dx;
                    double dz;
                    double dy;
                    Block blk_b;
                    Block blk = w.getBlock(i, j, k);
                    if (blk == Blocks.field_150353_l) continue;
                    if (blk.isReplaceable((IBlockAccess)w.getWorld(), i, j, k)) {
                        blk = Platform.AIR_BLOCK;
                        blk_b = w.getBlock(i, j + 1, k);
                        if (blk_b != blk) {
                            int meta_b = w.getBlockMetadata(i, j + 1, k);
                            w.setBlock(i, j, k, blk_b, meta_b, 3);
                            w.setBlock(i, j + 1, k, blk);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.squaredCraterSize)) continue;
                        double dx2 = i - x;
                        dy = j - y;
                        dz = k - z;
                        double dist = dx2 * dx2 + dy * dy + dz * dz;
                        Block xf = w.getBlock(i, j - 1, k);
                        if (xf.isReplaceable((IBlockAccess)w.getWorld(), i, j - 1, k)) continue;
                        double extraRange = decayRng.nextDouble() * 0.6;
                        double height = this.squaredCraterSize * (extraRange + 0.2) - Math.abs(dist - this.squaredCraterSize * 1.7);
                        if (xf == blk || !(height > 0.0) || !(decayRng.nextFloat() > 0.6f)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(decayRng.nextDouble(), w, i, j, k);
                        continue;
                    }
                    blk_b = w.getBlock(i, j + 1, k);
                    if (blk_b != Platform.AIR_BLOCK || !(decayRng.nextFloat() > 0.4f) || !((dx = (double)(i - x)) * dx + (dy = (double)(j - y)) * dy + (dz = (double)(k - z)) * dz < this.squaredCraterSize * 1.6)) continue;
                    this.type.getRandomInset(decayRng.nextDouble(), w, i, j, k);
                }
            }
        }
    }

    public boolean spawnMeteoriteCenter() {
        if (!this.world.hasNoSky()) {
            return false;
        }
        Block blk = this.world.getBlock(this.x, this.y, this.z);
        if (!validSpawn.contains(blk)) {
            return false;
        }
        if (blk == Blocks.field_150354_m) {
            this.type = new FalloutSand(this.world, this.x, this.y, this.z, this.putter, skyStoneDefinition);
        } else if (blk == Blocks.field_150405_ch) {
            this.type = new FalloutCopy(this.world, this.x, this.y, this.z, this.putter, skyStoneDefinition);
        } else if (blk == Blocks.field_150432_aD || blk == Blocks.field_150433_aE) {
            this.type = new FalloutSnow(this.world, this.x, this.y, this.z, this.putter, skyStoneDefinition);
        }
        int realValidBlocks = 0;
        for (int i = this.x - 6; i < this.x + 6; ++i) {
            for (int j = this.y - 6; j < this.y + 6; ++j) {
                for (int k = this.z - 6; k < this.z + 6; ++k) {
                    blk = this.world.getBlock(i, j, k);
                    if (!validSpawn.contains(blk)) continue;
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = this.x - 15; i < this.x + 15; ++i) {
            for (int j = this.y - 15; j < this.y + 15; ++j) {
                for (int k = this.z - 15; k < this.z + 15; ++k) {
                    blk = this.world.getBlock(i, j, k);
                    if (invalidSpawn.contains(blk)) {
                        return false;
                    }
                    if (!validSpawn.contains(blk)) continue;
                    ++validBlocks;
                }
            }
        }
        int minBlocks = 200;
        if (validBlocks > 200 && realValidBlocks > 80) {
            if (this.skyMode > 10) {
                this.placeCrater(this.world, this.x, this.y, this.z);
            }
            this.placeMeteorite(this.world, this.x, this.y, this.z);
            if (this.skyMode > 3) {
                this.decay(this.world, this.x, this.y, this.z);
            }
            this.world.done();
            WorldData.instance().spawnData().addNearByMeteorites(this.world.getWorld().field_73011_w.field_76574_g, this.x >> 4, this.z >> 4, this.settings);
            return true;
        }
        return false;
    }

    NBTTagCompound getSettings() {
        return this.settings;
    }
}

