/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.parts.p2p.PartP2PGT5Power;
import appeng.parts.p2p.PartP2PIC2Power;
import appeng.parts.p2p.PartP2PInterface;
import appeng.parts.p2p.PartP2PItems;
import appeng.parts.p2p.PartP2PLight;
import appeng.parts.p2p.PartP2PLiquids;
import appeng.parts.p2p.PartP2POpenComputers;
import appeng.parts.p2p.PartP2PPressure;
import appeng.parts.p2p.PartP2PRFPower;
import appeng.parts.p2p.PartP2PRedstone;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelME;
import com.projecturanus.betterp2p.item.ItemAdvancedMemoryCard;
import com.projecturanus.betterp2p.network.ServerPlayerDisconnectHandler;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0005J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J,\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0012\u0010\u0019\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001a0\nH\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/projecturanus/betterp2p/CommonProxy;", "", "()V", "tunnelIndices", "", "", "Lcom/projecturanus/betterp2p/util/p2p/TunnelInfo;", "getTunnelIndices", "()Ljava/util/Map;", "tunnelTypes", "Ljava/lang/Class;", "getTunnelTypes", "getP2PFromClass", "clazz", "getP2PFromIndex", "index", "getP2PTypeList", "", "initTunnels", "", "postInit", "registerTunnel", "def", "Lappeng/api/definitions/IItemDefinition;", "type", "classType", "Lappeng/parts/p2p/PartP2PTunnel;", "betterp2p"})
public class CommonProxy {
    @NotNull
    private final Map<Class<?>, TunnelInfo> tunnelTypes = new LinkedHashMap();
    @NotNull
    private final Map<Integer, TunnelInfo> tunnelIndices = new LinkedHashMap();

    @NotNull
    protected final Map<Class<?>, TunnelInfo> getTunnelTypes() {
        return this.tunnelTypes;
    }

    @NotNull
    protected final Map<Integer, TunnelInfo> getTunnelIndices() {
        return this.tunnelIndices;
    }

    public void postInit() {
        ServerPlayerDisconnectHandler.INSTANCE.register();
        Object[] objectArray = new ItemStack[]{(ItemStack)AEApi.instance().definitions().items().networkTool().maybeStack(1).get(), (ItemStack)AEApi.instance().definitions().items().memoryCard().maybeStack(1).get()};
        GameRegistry.addRecipe((IRecipe)((IRecipe)new ShapelessRecipes(new ItemStack((Item)ItemAdvancedMemoryCard.INSTANCE), CollectionsKt.listOf((Object[])objectArray))));
        this.initTunnels();
    }

    public void initTunnels() {
        IParts partDefs = AEApi.instance().definitions().parts();
        int typeId = 0;
        IItemDefinition iItemDefinition = partDefs.p2PTunnelME();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition, (String)"partDefs.p2PTunnelME()");
        this.registerTunnel(iItemDefinition, typeId++, PartP2PTunnelME.class);
        IItemDefinition iItemDefinition2 = partDefs.p2PTunnelEU();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition2, (String)"partDefs.p2PTunnelEU()");
        this.registerTunnel(iItemDefinition2, typeId++, PartP2PIC2Power.class);
        IItemDefinition iItemDefinition3 = partDefs.p2PTunnelRF();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition3, (String)"partDefs.p2PTunnelRF()");
        this.registerTunnel(iItemDefinition3, typeId++, PartP2PRFPower.class);
        IItemDefinition iItemDefinition4 = partDefs.p2PTunnelRedstone();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition4, (String)"partDefs.p2PTunnelRedstone()");
        this.registerTunnel(iItemDefinition4, typeId++, PartP2PRedstone.class);
        IItemDefinition iItemDefinition5 = partDefs.p2PTunnelLiquids();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition5, (String)"partDefs.p2PTunnelLiquids()");
        this.registerTunnel(iItemDefinition5, typeId++, PartP2PLiquids.class);
        IItemDefinition iItemDefinition6 = partDefs.p2PTunnelItems();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition6, (String)"partDefs.p2PTunnelItems()");
        this.registerTunnel(iItemDefinition6, typeId++, PartP2PItems.class);
        IItemDefinition iItemDefinition7 = partDefs.p2PTunnelLight();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition7, (String)"partDefs.p2PTunnelLight()");
        this.registerTunnel(iItemDefinition7, typeId++, PartP2PLight.class);
        IItemDefinition iItemDefinition8 = partDefs.p2PTunnelOpenComputers();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition8, (String)"partDefs.p2PTunnelOpenComputers()");
        this.registerTunnel(iItemDefinition8, typeId++, PartP2POpenComputers.class);
        IItemDefinition iItemDefinition9 = partDefs.p2PTunnelPneumaticCraft();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition9, (String)"partDefs.p2PTunnelPneumaticCraft()");
        this.registerTunnel(iItemDefinition9, typeId++, PartP2PPressure.class);
        IItemDefinition iItemDefinition10 = partDefs.p2PTunnelGregtech();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition10, (String)"partDefs.p2PTunnelGregtech()");
        this.registerTunnel(iItemDefinition10, typeId++, PartP2PGT5Power.class);
        IItemDefinition iItemDefinition11 = partDefs.p2PTunnelMEInterface();
        Intrinsics.checkNotNullExpressionValue((Object)iItemDefinition11, (String)"partDefs.p2PTunnelMEInterface()");
        this.registerTunnel(iItemDefinition11, typeId++, PartP2PInterface.class);
    }

    private final void registerTunnel(IItemDefinition def, int type, Class<? extends PartP2PTunnel<?>> classType) {
        if (def.isEnabled()) {
            ItemStack stack = (ItemStack)def.maybeStack(1).get();
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            TunnelInfo info2 = new TunnelInfo(type, stack, classType);
            this.tunnelTypes.put(classType, info2);
            Integer n = type;
            this.tunnelIndices.put(n, info2);
        }
    }

    @Nullable
    public final TunnelInfo getP2PFromIndex(int index) {
        return this.tunnelIndices.get(index);
    }

    @Nullable
    public final TunnelInfo getP2PFromClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.tunnelTypes.get(clazz);
    }

    @NotNull
    public final List<TunnelInfo> getP2PTypeList() {
        return CollectionsKt.toList((Iterable)this.tunnelIndices.values());
    }
}

