/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerObjectHandler;
import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.IHideable;
import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.ToolTipManager;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.gui.widget.VScrollbar;
import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Timer;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Optional.InterfaceList(value={@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems"), @Optional.Interface(iface="codechicken.nei.api.guihook.IContainerObjectHandler", modid="NotEnoughItems")})
public abstract class GuiContainerBase
extends GuiContainer
implements ToolTipManager.ToolTipRenderer,
IGuiScreen,
INEIGuiHandler,
IContainerObjectHandler {
    protected ToolTipManager ttMan = new ToolTipManager();
    protected List<IGuiOverlay> overlays = Lists.newArrayList();
    protected List<TextFieldEnder> textFields = Lists.newArrayList();
    protected List<VScrollbar> scrollbars = Lists.newArrayList();
    protected List<IDrawingElement> drawingElements = Lists.newArrayList();
    protected GhostSlotHandler ghostSlotHandler = new GhostSlotHandler();
    @Deprecated
    protected List<GhostSlot> ghostSlots = this.ghostSlotHandler.getGhostSlots();
    @Deprecated
    protected GhostSlot hoverGhostSlot;
    protected VScrollbar draggingScrollbar;
    protected static boolean registeredNEIHandler;
    protected final boolean isNEILoaded = Loader.isModLoaded((String)"NotEnoughItems");
    private int realMx;
    private int realMy;

    protected GuiContainerBase(Container par1Container) {
        super(par1Container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.fixupGuiPosition();
        for (IGuiOverlay overlay : this.overlays) {
            overlay.init(this);
        }
        for (TextFieldEnder f : this.textFields) {
            f.init(this);
        }
        if (this.isNEILoaded && !registeredNEIHandler) {
            GuiContainerManager.addObjectHandler((IContainerObjectHandler)this);
            registeredNEIHandler = true;
        }
    }

    protected void fixupGuiPosition() {
    }

    protected void func_73869_a(char c, int key) {
        TextFieldEnder focused = null;
        for (TextFieldEnder f : this.textFields) {
            if (!f.func_146206_l()) continue;
            focused = f;
        }
        if (key == 1) {
            if (focused != null && key == 1) {
                focused.func_146195_b(false);
                focused = null;
                return;
            }
            if (!this.hideOverlays()) {
                this.field_146297_k.field_71439_g.func_71053_j();
                return;
            }
        }
        if (c == '\t') {
            for (int i = 0; i < this.textFields.size(); ++i) {
                TextFieldEnder f;
                f = this.textFields.get(i);
                if (!f.func_146206_l()) continue;
                this.textFields.get((i + 1) % this.textFields.size()).func_146195_b(true);
                f.func_146195_b(false);
                return;
            }
        }
        if (focused != null) {
            String old = focused.func_146179_b();
            if (focused.func_146201_a(c, key)) {
                this.onTextFieldChanged(focused, old);
                return;
            }
        }
        if (c == 'f' && focused == null && !this.textFields.isEmpty()) {
            focused = this.textFields.get(0);
            focused.func_146195_b(true);
        }
        if (key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            if (!this.hideOverlays()) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            return;
        }
        super.func_73869_a(c, key);
    }

    protected final void setText(TextFieldEnder tf, String newText) {
        String old = tf.func_146179_b();
        tf.func_146180_a(newText);
        this.onTextFieldChanged(tf, old);
    }

    protected void onTextFieldChanged(TextFieldEnder tf, String old) {
    }

    public boolean hideOverlays() {
        for (IGuiOverlay overlay : this.overlays) {
            if (!overlay.isVisible()) continue;
            overlay.setVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public void addToolTip(GuiToolTip toolTip) {
        this.ttMan.addToolTip(toolTip);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!ForgeHooks.canInteractWith((EntityPlayer)this.field_146297_k.field_71439_g, (Container)this.field_147002_h)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.func_146178_a();
        }
    }

    public void func_146274_d() {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int b = Mouse.getEventButton();
        for (IGuiOverlay overlay : this.overlays) {
            if (overlay == null || !overlay.isVisible() || !overlay.handleMouseInput(x, y, b)) continue;
            return;
        }
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            this.mouseWheel(x, y, delta);
        }
        super.func_146274_d();
    }

    protected boolean func_146978_c(int p_146978_1_, int p_146978_2_, int p_146978_3_, int p_146978_4_, int p_146978_5_, int p_146978_6_) {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        for (IGuiOverlay overlay : this.overlays) {
            if (overlay == null || !overlay.isVisible() || !overlay.isMouseInBounds(x, y)) continue;
            return false;
        }
        return super.func_146978_c(p_146978_1_, p_146978_2_, p_146978_3_, p_146978_4_, p_146978_5_, p_146978_6_);
    }

    @Override
    public List<GhostSlot> getGhostSlots() {
        return this.ghostSlotHandler.getGhostSlots();
    }

    @Deprecated
    protected void ghostSlotClicked(GhostSlot slot, int x, int y, int button) {
        this.ghostSlotHandler.ghostSlotClicked(this, slot, x, y, button);
    }

    protected void func_73864_a(int x, int y, int button) {
        GhostSlot slot;
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.func_146192_a(x, y, button);
        }
        if (!this.scrollbars.isEmpty()) {
            if (this.draggingScrollbar != null) {
                this.draggingScrollbar.mouseClicked(x, y, button);
                return;
            }
            for (VScrollbar vScrollbar : this.scrollbars) {
                if (!vScrollbar.mouseClicked(x, y, button)) continue;
                this.draggingScrollbar = vScrollbar;
                return;
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty() && (slot = this.getGhostSlot(x, y)) != null) {
            this.ghostSlotClicked(slot, x, y, button);
            super.func_73864_a(x, y, button);
            return;
        }
        if (button == 1) {
            for (TextFieldEnder textFieldEnder : this.textFields) {
                if (!textFieldEnder.contains(x, y)) continue;
                this.setText(textFieldEnder, "");
            }
        }
        if (button >= 1) {
            for (IHideable iHideable : this.field_146292_n) {
                IconButton btn;
                if (!(iHideable instanceof IconButton) || !(btn = (IconButton)iHideable).mousePressedButton(this.field_146297_k, x, y, button)) continue;
                btn.func_146113_a(this.field_146297_k.func_147118_V());
                this.actionPerformedButton(btn, button);
            }
        }
        super.func_73864_a(x, y, button);
    }

    protected void func_146286_b(int x, int y, int button) {
        if (this.draggingScrollbar != null) {
            this.draggingScrollbar.mouseMovedOrUp(x, y, button);
            this.draggingScrollbar = null;
        }
        super.func_146286_b(x, y, button);
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (this.draggingScrollbar != null) {
            this.draggingScrollbar.mouseClickMove(x, y, button, time);
            return;
        }
        super.func_146273_a(x, y, button, time);
    }

    protected void mouseWheel(int x, int y, int delta) {
        GhostSlot slot;
        if (!this.scrollbars.isEmpty()) {
            for (VScrollbar vs : this.scrollbars) {
                vs.mouseWheel(x, y, delta);
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty() && (slot = this.getGhostSlot(x, y)) != null) {
            this.ghostSlotClicked(slot, x, y, delta < 0 ? -1 : -2);
        }
    }

    protected void actionPerformedButton(IconButton btn, int mouseButton) {
        this.func_146284_a(btn);
    }

    public void addOverlay(IGuiOverlay overlay) {
        this.overlays.add(overlay);
    }

    public void removeOverlay(IGuiOverlay overlay) {
        this.overlays.remove(overlay);
    }

    public void addScrollbar(VScrollbar vs) {
        this.scrollbars.add(vs);
        vs.adjustPosition();
    }

    public void removeScrollbar(VScrollbar vs) {
        this.scrollbars.remove(vs);
        if (this.draggingScrollbar == vs) {
            this.draggingScrollbar = null;
        }
    }

    public void addDrawingElement(IDrawingElement element) {
        this.drawingElements.add(element);
        GuiToolTip tooltip = element.getTooltip();
        if (tooltip != null) {
            this.addToolTip(tooltip);
        }
    }

    public void removeDrawingElement(IDrawingElement element) {
        this.drawingElements.remove(element);
        GuiToolTip tooltip = element.getTooltip();
        if (tooltip != null) {
            this.removeToolTip(tooltip);
        }
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        this.drawForegroundImpl(mouseX, mouseY);
        Timer t = RenderUtil.getTimer();
        if (t != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            for (IGuiOverlay overlay : this.overlays) {
                if (overlay == null || !overlay.isVisible()) continue;
                overlay.draw(this.realMx, this.realMy, t.field_74281_c);
            }
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    protected void func_146976_a(float par1, int mouseX, int mouseY) {
        for (IDrawingElement iDrawingElement : this.drawingElements) {
            iDrawingElement.drawGuiContainerBackgroundLayer(par1, mouseX, mouseY);
        }
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.func_146194_f();
        }
        if (!this.scrollbars.isEmpty()) {
            for (VScrollbar vScrollbar : this.scrollbars) {
                vScrollbar.drawScrollbar(mouseX, mouseY);
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty()) {
            this.drawGhostSlots(mouseX, mouseY);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int mx = this.realMx = par1;
        int my = this.realMy = par2;
        super.func_73863_a(mx, my, par3);
        if (this.draggingScrollbar == null) {
            this.ghostSlotHandler.drawGhostSlotToolTip(this, par1, par2);
            this.ttMan.drawTooltips(this, par1, par2);
        }
    }

    protected void func_146982_a(ItemStack stack, int mouseX, int mouseY, String str) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiContainerBase.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, mouseX, mouseY);
        field_146296_j.func_94148_a(font, this.field_146297_k.func_110434_K(), stack, mouseX, mouseY, str);
        this.field_73735_i = 0.0f;
        GuiContainerBase.field_146296_j.field_77023_b = 0.0f;
    }

    protected void drawFakeItemsStart() {
        this.field_73735_i = 0.0f;
        GuiContainerBase.field_146296_j.field_77023_b = -25.0f;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
    }

    protected void drawFakeItemStack(int x, int y, ItemStack stack) {
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, stack, x, y);
    }

    protected void drawFakeItemStackStdOverlay(int x, int y, ItemStack stack) {
        field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.field_71446_o, stack, x, y, null);
    }

    protected void drawFakeItemHover(int x, int y) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    protected void drawFakeItemsEnd() {
        GL11.glPopAttrib();
        GuiContainerBase.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    public void func_146285_a(ItemStack p_146285_1_, int p_146285_2_, int p_146285_3_) {
        if (!this.isNEILoaded) {
            super.func_146285_a(p_146285_1_, p_146285_2_, p_146285_3_);
        }
    }

    @Deprecated
    protected void drawGhostSlotTooltip(GhostSlot slot, int mouseX, int mouseY) {
        this.ghostSlotHandler.drawGhostSlotTooltip(this, slot, mouseX, mouseY);
    }

    protected String getGuiTexture() {
        return null;
    }

    @Deprecated
    protected void drawGhostSlots(int mouseX, int mouseY) {
        this.ghostSlotHandler.drawGhostSlots(this, mouseX, mouseY);
    }

    @Deprecated
    protected GhostSlot getGhostSlot(int mouseX, int mouseY) {
        return this.ghostSlotHandler.getGhostSlot(this, mouseX, mouseY);
    }

    @Override
    public boolean removeToolTip(GuiToolTip toolTip) {
        return this.ttMan.removeToolTip(toolTip);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        this.copyOfdrawHoveringText(par1List, par2, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    protected void copyOfdrawHoveringText(List<String> par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = par1List.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public float getZlevel() {
        return this.field_73735_i;
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public int getXSize() {
        return this.field_146999_f;
    }

    @Override
    public int getYSize() {
        return this.field_147000_g;
    }

    public void setGuiLeft(int i) {
        this.field_147003_i = i;
    }

    public void setGuiTop(int i) {
        this.field_147009_r = i;
    }

    public void setXSize(int i) {
        this.field_146999_f = i;
    }

    public void setYSize(int i) {
        this.field_147000_g = i;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public void addButton(GuiButton button) {
        if (!this.field_146292_n.contains(button)) {
            this.field_146292_n.add(button);
        }
    }

    @Override
    public void removeButton(GuiButton button) {
        this.field_146292_n.remove(button);
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }

    @Override
    public void doActionPerformed(GuiButton guiButton) {
        this.func_146284_a(guiButton);
    }

    public ItemStack getHoveredStack(int mouseX, int mouseY) {
        GhostSlot slot = this.getGhostSlot(mouseX, mouseY);
        if (slot != null) {
            return slot.getStack();
        }
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gc, VisiblityData vd) {
        return vd;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gc, ItemStack is) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gc) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gc, int x, int y, ItemStack is, int button) {
        GhostSlot slot;
        if (gc instanceof GuiContainerBase && button == 0 && (slot = this.getGhostSlot(x, y)) != null) {
            this.ghostSlotHandler.ghostSlotClickedPrimaryMouseButton(slot, is, slot.getStack());
            is.field_77994_a = 0;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gc, int x, int y, int w, int h) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public void guiTick(GuiContainer guiContainer) {
    }

    @Optional.Method(modid="NotEnoughItems")
    public void refresh(GuiContainer guiContainer) {
    }

    @Optional.Method(modid="NotEnoughItems")
    public void load(GuiContainer guiContainer) {
    }

    @Optional.Method(modid="NotEnoughItems")
    public ItemStack getStackUnderMouse(GuiContainer guiContainer, int mouseX, int mouseY) {
        if (guiContainer instanceof GuiContainerBase) {
            return ((GuiContainerBase)guiContainer).getHoveredStack(mouseX, mouseY);
        }
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean objectUnderMouse(GuiContainer guiContainer, int mouseX, int mouseY) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean shouldShowTooltip(GuiContainer guiContainer) {
        return true;
    }
}

