/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.TechneUtil;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;

public class TechneModelRenderer
implements ISimpleBlockRenderingHandler {
    protected Map<String, GroupObject> model;
    protected VertexTransform vt;
    private final int renderId;

    public TechneModelRenderer(String modid, String modelPath, int renderId) {
        this(modid, modelPath, renderId, null);
    }

    public TechneModelRenderer(String modid, String modelPath, int renderId, VertexTransform vt) {
        this(TechneUtil.getModel(modid, modelPath), renderId, vt);
    }

    public TechneModelRenderer(Map<String, GroupObject> model, int renderId) {
        this(model, renderId, null);
    }

    public TechneModelRenderer(Map<String, GroupObject> model, int renderId, VertexTransform vt) {
        this.model = model;
        this.renderId = renderId;
        this.vt = vt;
    }

    protected Collection<GroupObject> getModel(Block block, int metadata) {
        return this.model.values();
    }

    protected Collection<GroupObject> getModel(IBlockAccess world, int x, int y, int z) {
        return this.model.values();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        TechneUtil.vt = this.vt;
        TechneUtil.renderInventoryBlock(this.getModel(block, metadata), this.getModelIcon(block, metadata), block, metadata, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TechneUtil.vt = this.vt;
        return TechneUtil.renderWorldBlock(this.getModel(world, x, y, z), this.getModelIcon(world, x, y, z, block), world, x, y, z, block, renderer);
    }

    protected IIcon getModelIcon(Block block, int metadata) {
        return block.func_149691_a(0, metadata);
    }

    protected IIcon getModelIcon(IBlockAccess world, int x, int y, int z, Block block) {
        return block.func_149673_e(world, x, y, z, 0);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderId;
    }
}

