/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.compat;

import com.enderio.core.EnderCore;
import com.enderio.core.common.util.RegisterTime;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public enum CompatRegistry {
    INSTANCE;

    private final Map<Registration, String> compatMap = new HashMap<Registration, String>();
    private RegisterTime state = null;

    public RegisterTime getState() {
        return this.state;
    }

    public void registerCompat(RegisterTime time, String clazz, String ... modids) {
        this.compatMap.put(new Registration(time, modids), clazz);
    }

    public void registerCompat(RegisterTime[] times, String clazz, String ... modids) {
        this.compatMap.put(new Registration(times, modids), clazz);
    }

    public void handle(FMLStateEvent event) {
        RegisterTime time;
        this.state = time = RegisterTime.timeFor(event);
        for (Registration r : this.compatMap.keySet()) {
            if (!ArrayUtils.contains((Object[])r.times, (Object)((Object)time)) || !this.allModsLoaded(r.modids)) continue;
            this.doLoad(this.compatMap.get(r));
        }
    }

    private boolean allModsLoaded(String[] modids) {
        for (String s : modids) {
            if (Loader.isModLoaded((String)s)) continue;
            return false;
        }
        return true;
    }

    public void forceLoad(String clazz) {
        for (Registration r : this.compatMap.keySet()) {
            String s = this.compatMap.get(r);
            if (!s.equals(clazz)) continue;
            this.doLoad(s);
        }
    }

    private void doLoad(String clazz) {
        try {
            EnderCore.logger.info("[Compat] Loading compatability class " + clazz);
            Class<?> compat = Class.forName(clazz);
            compat.getDeclaredMethod("load", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            EnderCore.logger.error("[Compat] ICompatability class {} did not contain static method {}!", new Object[]{clazz, "load"});
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error in compatability class " + clazz, e.getTargetException());
        }
        catch (Throwable e) {
            EnderCore.logger.error("[Compat] An unknown error was thrown loading class {}.", new Object[]{clazz});
            e.printStackTrace();
        }
    }

    private static class Registration {
        private final String[] modids;
        private final RegisterTime[] times;

        private Registration(RegisterTime time, String ... modids) {
            this.modids = modids;
            this.times = new RegisterTime[]{time};
        }

        private Registration(RegisterTime[] times, String ... modids) {
            this.modids = modids;
            this.times = times;
        }

        public String[] getModids() {
            return this.modids;
        }

        public RegisterTime[] getTimes() {
            return this.times;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Registration)) {
                return false;
            }
            Registration other = (Registration)o;
            if (!Arrays.deepEquals(this.getModids(), other.getModids())) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.getTimes(), (Object[])other.getTimes());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getModids());
            result = result * 59 + Arrays.deepHashCode((Object[])this.getTimes());
            return result;
        }

        public String toString() {
            return "CompatRegistry.Registration(modids=" + Arrays.deepToString(this.getModids()) + ", times=" + Arrays.deepToString((Object[])this.getTimes()) + ")";
        }
    }
}

