/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.EnderCore;
import com.enderio.core.common.config.AbstractConfigHandler;
import com.enderio.core.common.config.ConfigProcessor;
import com.enderio.core.common.config.ITweakConfigHandler;
import com.enderio.core.common.config.JsonConfigReader;
import com.enderio.core.common.config.annot.Comment;
import com.enderio.core.common.config.annot.Config;
import com.enderio.core.common.config.annot.NoSync;
import com.enderio.core.common.config.annot.Range;
import com.enderio.core.common.config.annot.RestartReq;
import com.enderio.core.common.handlers.RightClickCropHandler;
import com.enderio.core.common.tweaks.Tweak;
import com.enderio.core.common.tweaks.Tweaks;
import java.io.File;
import java.util.Locale;

public class ConfigHandler
extends AbstractConfigHandler
implements ITweakConfigHandler,
ConfigProcessor.IReloadCallback {
    private static final String sectionGeneral = "general";
    private static final String sectionEnchants = "enchants";
    @Config
    @Comment(value={"Show oredictionary names of every item in its tooltip.", "0 - Off", "1 - Always on", "2 - Only with shift", "3 - Only in debug mode"})
    @Range(min=0.0, max=3.0)
    @NoSync
    public static int showOredictTooltips = 2;
    @Config
    @Comment(value={"Show item registry names in tooltips.", "0 - Off", "1 - Always on", "2 - Only with shift", "3 - Only in debug mode"})
    @Range(min=0.0, max=3.0)
    @NoSync
    public static int showRegistryNameTooltips = 3;
    @Config
    @Comment(value={"Show durability on item tooltips.", "0 - Off", "1 - Always on", "2 - Only with shift", "3 - Only in debug mode"})
    @Range(min=0.0, max=3.0)
    @NoSync
    public static int showDurabilityTooltips = 1;
    @Config
    @Comment(value={"Removes all void fog.", "0 = off", "1 = DEFAULT worldtype only", "2 = all world types"})
    @NoSync
    @Range(min=0.0, max=2.0)
    public static int disableVoidFog = 1;
    @Config
    @Comment(value={"The max amount of XP levels an anvil recipe can use."})
    public static int anvilMaxLevel = 40;
    @Config
    @Comment(value={"The way the game should have been made (Yes this is the fireworks thing)."})
    public static boolean betterAchievements = true;
    @Config
    @Comment(value={"Disabling this option will prevent any crops added to the config json from being right clickable."})
    public static boolean allowCropRC = true;
    @Config
    @Comment(value={"Prevent tick speedup (i.e. torcherino) on any TE that uses the base TE class from EnderCore"})
    public static boolean allowExternalTickSpeedup = false;
    @Config
    @Comment(value={"0 - Do nothing", "1 - Remove stacktraces, leave 1-line missing texture errors", "2 - Remove all missing texture errors completely."})
    @NoSync
    @Range(min=0.0, max=2.0)
    public static int textureErrorRemover = 1;
    @Config
    @Comment(value={"Controls the default sorting on the mod list GUI.", "0 - Default sort (load order)", "1 - A to Z sort", "2 - Z to A sort"})
    @NoSync
    @Range(min=0.0, max=2.0)
    public static int defaultModSort = 1;
    @Config(value="enchants")
    @Comment(value={"Enchant ID for the XP boost enchant."})
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    @Range(min=0.0, max=255.0)
    public static int enchantIDXPBoost = 45;
    @Config(value="enchants")
    @Comment(value={"Allow the XP Boost enchant to be registered."})
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    public static boolean allowXPBoost = true;
    @Config(value="enchants")
    @Comment(value={"Enchant ID for the Auto Smelt enchant."})
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    @Range(min=0.0, max=255.0)
    public static int enchantIDAutoSmelt = 46;
    @Config(value="enchants")
    @Comment(value={"Allow the Auto Smelt enchant to be registered."})
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    public static boolean allowAutoSmelt = true;
    @Config(value="enchants")
    @Comment(value={"Allow the Auto Smelt enchant to work with Fortune."})
    public static boolean allowAutoSmeltWithFortune = true;
    public static File configFolder;
    public static File enderConfigFolder;
    public static File configFile;
    public static ConfigProcessor processor;
    private static ConfigHandler INSTANCE;

    protected ConfigHandler() {
        super("endercore");
    }

    public static ConfigHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigHandler();
        }
        return INSTANCE;
    }

    @Override
    public void init() {
        this.addSection(sectionGeneral);
        this.addSection(sectionEnchants);
        this.addSection("tweaks");
        processor = new ConfigProcessor(this.getClass(), this, this);
        processor.process(true);
    }

    @Override
    protected void reloadIngameConfigs() {
        Tweaks.loadIngameTweaks();
    }

    @Override
    protected void reloadNonIngameConfigs() {
        Tweaks.loadNonIngameTweaks();
    }

    @Override
    public void callback(ConfigProcessor inst) {
        Tweaks.loadIngameTweaks();
    }

    @Override
    public boolean addBooleanFor(Tweak tweak) {
        this.activateSection("tweaks");
        return this.getValue(tweak.getName(), tweak.getComment(), true);
    }

    public void loadRightClickCrops() {
        JsonConfigReader<RightClickCropHandler.PlantInfo> reader = new JsonConfigReader<RightClickCropHandler.PlantInfo>(new JsonConfigReader.ModToken(EnderCore.class, "endercore".toLowerCase(Locale.US) + "/config"), enderConfigFolder.getAbsolutePath() + "/cropConfig.json", RightClickCropHandler.PlantInfo.class);
        for (RightClickCropHandler.PlantInfo i : reader) {
            i.init();
            RightClickCropHandler.INSTANCE.addCrop(i);
        }
    }
}

