/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.common.config.ConfigProcessor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class PacketConfigSync
implements IMessage {
    private Map<String, Object> configValues;
    private String modid;

    public PacketConfigSync() {
    }

    public PacketConfigSync(ConfigProcessor toSync) {
        this.configValues = toSync.configValues;
        this.modid = toSync.modid;
    }

    private static void writeValue(ByteBuf buf, Object value) {
        if (value == null) {
            buf.writeByte(0);
        } else if (value instanceof Integer) {
            buf.writeByte(1);
            buf.writeInt(((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            buf.writeByte(2);
            buf.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Float) {
            buf.writeByte(3);
            buf.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            buf.writeByte(4);
            buf.writeDouble(((Double)value).doubleValue());
        } else if (value instanceof String) {
            buf.writeByte(5);
            PacketConfigSync.writeString(buf, (String)value);
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + value.getClass());
        }
    }

    private static Object readValue(ByteBuf buf) {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return buf.readInt();
            }
            case 2: {
                return buf.readBoolean();
            }
            case 3: {
                return Float.valueOf(buf.readFloat());
            }
            case 4: {
                return buf.readDouble();
            }
            case 5: {
                return PacketConfigSync.readString(buf);
            }
        }
        throw new IllegalArgumentException("Unknown value type: " + type);
    }

    public static void writeString(ByteBuf buf, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.US_ASCII);
        buf.writeShort(bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readString(ByteBuf buf) {
        return new String(buf.readBytes((int)buf.readShort()).array(), StandardCharsets.US_ASCII);
    }

    public void toBytes(ByteBuf buf) {
        PacketConfigSync.writeString(buf, this.modid);
        buf.writeShort(this.configValues.size());
        for (Map.Entry<String, Object> entry : this.configValues.entrySet()) {
            PacketConfigSync.writeString(buf, entry.getKey());
            PacketConfigSync.writeValue(buf, entry.getValue());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.modid = PacketConfigSync.readString(buf);
        int size = buf.readShort();
        this.configValues = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            this.configValues.put(PacketConfigSync.readString(buf), PacketConfigSync.readValue(buf));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, PacketConfigSync> {
        public PacketConfigSync onMessage(PacketConfigSync message, MessageContext ctx) {
            ConfigProcessor processor = ConfigProcessor.processorMap.get(message.modid);
            if (processor != null) {
                processor.syncTo(message.configValues);
            }
            return null;
        }
    }
}

