/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

@Handlers.Handler
public class RightClickCropHandler {
    public static final RightClickCropHandler INSTANCE = new RightClickCropHandler();
    private final List<PlantInfo> plants = Lists.newArrayList();
    private PlantInfo currentPlant = null;

    private RightClickCropHandler() {
    }

    public void addCrop(PlantInfo info) {
        this.plants.add(info);
    }

    @SubscribeEvent
    public void handleCropRightClick(PlayerInteractEvent event) {
        int x = event.x;
        int y = event.y;
        int z = event.z;
        Block block = event.world.func_147439_a(x, y, z);
        int meta = event.world.func_72805_g(x, y, z);
        if (ConfigHandler.allowCropRC && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (event.entityPlayer.func_70694_bm() == null || !event.entityPlayer.func_70093_af())) {
            for (PlantInfo info : this.plants) {
                if (info.blockInst != block || meta != info.meta) continue;
                if (event.world.field_72995_K) {
                    event.entityPlayer.func_71038_i();
                    break;
                }
                this.currentPlant = info;
                block.func_149697_b(event.world, x, y, z, meta, 0);
                this.currentPlant = null;
                event.world.func_72921_c(x, y, z, info.resetMeta, 3);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDrop(BlockEvent.HarvestDropsEvent event) {
        if (this.currentPlant != null) {
            for (int i = 0; i < event.drops.size(); ++i) {
                ItemStack stack = (ItemStack)event.drops.get(i);
                if (stack.func_77973_b() != this.currentPlant.seedStack.func_77973_b() || this.currentPlant.seedStack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != this.currentPlant.seedStack.func_77960_j()) continue;
                event.drops.remove(i);
                break;
            }
        }
    }

    public static class PlantInfo {
        public String seed;
        public String block;
        public int meta = 7;
        public int resetMeta = 0;
        private transient ItemStack seedStack;
        private transient Block blockInst;

        public PlantInfo() {
        }

        public PlantInfo(String seed, String block, int meta, int resetMeta) {
            this.seed = seed;
            this.block = block;
            this.meta = meta;
            this.resetMeta = resetMeta;
        }

        public void init() {
            this.seedStack = ItemUtil.parseStringIntoItemStack(this.seed);
            String[] blockinfo = this.block.split(":");
            this.blockInst = GameRegistry.findBlock((String)blockinfo[0], (String)blockinfo[1]);
        }
    }
}

