/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class Bound<T extends Number> {
    public static final Bound<Double> MAX_BOUND = Bound.of(Double.MIN_VALUE, Double.MAX_VALUE);
    public final T min;
    public final T max;

    private Bound(T min, T max) {
        this.min = min;
        this.max = max;
    }

    public static <T extends Number> Bound<T> of(T min, T max) {
        return new Bound<T>(min, max);
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public T clamp(T val) {
        return ((Comparable)val).compareTo(this.min) < 0 ? this.min : (((Comparable)val).compareTo(this.max) > 0 ? this.max : val);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bound)) {
            return false;
        }
        Bound other = (Bound)o;
        T this$min = this.getMin();
        T other$min = other.getMin();
        if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
            return false;
        }
        T this$max = this.getMax();
        T other$max = other.getMax();
        return !(this$max == null ? other$max != null : !this$max.equals(other$max));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : $min.hashCode());
        T $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : $max.hashCode());
        return result;
    }

    public String toString() {
        return "Bound(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    public Bound<T> withMin(T min) {
        return this.min == min ? this : new Bound<T>(min, this.max);
    }

    public Bound<T> withMax(T max) {
        return this.max == max ? this : new Bound<T>(this.min, max);
    }
}

