/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.util.WorldCache;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class PermanentCache<I>
extends WorldCache<I> {
    private static final List<PermanentCache<?>> allCaches = Lists.newArrayList();

    public PermanentCache(String ident) {
        super(ident);
        try {
            this.loadData(this.getSaveFile());
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static void saveCaches() {
        for (PermanentCache<?> c : allCaches) {
            try {
                c.saveData(c.getSaveFile());
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    protected File getSaveFile() {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return new File(this.ident + ".dat");
        }
        return new File("saves", this.ident + ".dat");
    }

    @Override
    protected void blockOldIDs() {
        if (!this.objToName.isEmpty()) {
            super.blockOldIDs();
        }
    }

    @Override
    protected void mergeNewIDs() {
        if (!this.objToName.isEmpty()) {
            super.mergeNewIDs();
        }
    }

    @Override
    public void addObject(I object, String name) {
        super.addObject(object, name);
        this.setID(name);
    }
}

