/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.config.ConfigHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.texture.TextureMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class TextureErrorRemover
extends Logger {
    private static TextureErrorRemover INSTANCE;
    private int removed = 0;

    private TextureErrorRemover(Logger other) {
        super(other.getContext(), other.getName(), other.getMessageFactory());
    }

    public static void beginIntercepting() {
        EnderCore.logger.info("Attempting to initialize texture error message interceptor.");
        try {
            Field f = ReflectionHelper.findField(TextureMap.class, (String[])new String[]{"logger", "field_147635_d", "d"});
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.setAccessible(true);
            INSTANCE = new TextureErrorRemover((Logger)f.get(null));
            f.set(null, (Object)INSTANCE);
        }
        catch (Exception e) {
            EnderCore.logger.error("Failed to initialize texture error interceptor!", (Throwable)e);
        }
    }

    public void log(Marker marker, String fqcn, Level level, Message data, Throwable t) {
        if (ConfigHandler.textureErrorRemover != 0) {
            if (t instanceof FileNotFoundException) {
                if (ConfigHandler.textureErrorRemover == 1) {
                    super.log(marker, fqcn, level, data, null);
                }
                ++this.removed;
            } else {
                super.log(marker, fqcn, level, data, t);
            }
            if (data.getFormat().startsWith("Created:")) {
                EnderCore.logger.info((Message)(ConfigHandler.textureErrorRemover == 1 ? new FormattedMessage("Removed %d missing texture stacktraces. Tada!", (Object)this.removed) : new FormattedMessage("There were %d missing texture errors here. They're gone now.", (Object)this.removed)));
                this.removed = 0;
            }
            return;
        }
        super.log(marker, fqcn, level, data, t);
    }
}

