/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.vecmath.Vector3d;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static String WailaStyle = "\u00a4";
    public static String WailaIcon = "\u00a5";
    public static String TAB = WailaStyle + WailaStyle + "a";
    public static String ALIGNRIGHT = WailaStyle + WailaStyle + "b";
    public static String ALIGNCENTER = WailaStyle + WailaStyle + "c";
    public static String HEART = WailaStyle + WailaIcon + "a";
    public static String HHEART = WailaStyle + WailaIcon + "b";
    public static String EHEART = WailaStyle + WailaIcon + "c";

    public static Block getBlockFromItemId(ItemStack itemId) {
        Item item = itemId.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemPotion) {
            if (stack.field_77994_a == 1) {
                return new ItemStack(Items.field_151069_bo);
            }
            stack.func_77979_a(1);
            return stack;
        }
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static void giveExperience(EntityPlayer thePlayer, float experience) {
        int intExp = (int)experience;
        float fractional = experience - (float)intExp;
        if (fractional > 0.0f && (float)Math.random() < fractional) {
            ++intExp;
        }
        while (intExp > 0) {
            int j = EntityXPOrb.func_70527_a((int)intExp);
            intExp -= j;
            thePlayer.field_70170_p.func_72838_d((Entity)new EntityXPOrb(thePlayer.field_70170_p, thePlayer.field_70165_t, thePlayer.field_70163_u + 0.5, thePlayer.field_70161_v + 0.5, j));
        }
    }

    public static BlockCoord canPlaceItem(ItemStack itemUsed, Block blockIdToBePlaced, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (blockIdToBePlaced == null) {
            return null;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (!(block == Blocks.field_150395_bd || block == Blocks.field_150329_H || block == Blocks.field_150330_I || block != null && block.isReplaceable((IBlockAccess)world, x, y, z))) {
            if (side == 0) {
                --y;
            } else if (side == 1) {
                ++y;
            } else if (side == 2) {
                --z;
            } else if (side == 3) {
                ++z;
            } else if (side == 4) {
                --x;
            } else if (side == 5) {
                ++x;
            }
        }
        if (itemUsed.field_77994_a == 0) {
            return null;
        }
        if (!player.func_82247_a(x, y, z, side, itemUsed)) {
            return null;
        }
        if (y == 255 && blockIdToBePlaced.func_149688_o().func_76220_a()) {
            return null;
        }
        if (world.func_147472_a(blockIdToBePlaced, x, y, z, false, side, (Entity)player, itemUsed)) {
            return new BlockCoord(x, y, z);
        }
        return null;
    }

    public static EntityItem createDrop(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.field_145804_b = 10;
            return entityitem;
        }
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        entityitem.field_145804_b = 0;
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        EntityItem entityitem = Util.createEntityItem(world, stack, x, y, z, doRandomSpread);
        world.func_72838_d((Entity)entityitem);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z) {
        return Util.createEntityItem(world, stack, x, y, z, true);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        EntityItem entityitem;
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.field_145804_b = 10;
        } else {
            entityitem = new EntityItem(world, x, y, z, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.field_145804_b = 0;
        }
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, int x, int y, int z, boolean doRandomSpread) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        } else {
            EntityItem entityitem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.field_145804_b = 0;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void dropItems(World world, ItemStack[] inventory, int x, int y, int z, boolean doRandomSpread) {
        if (inventory == null) {
            return;
        }
        for (ItemStack stack : inventory) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            Util.dropItems(world, stack.func_77946_l(), x, y, z, doRandomSpread);
        }
    }

    public static void dropItems(World world, IInventory inventory, int x, int y, int z, boolean doRandomSpread) {
        for (int l = 0; l < inventory.func_70302_i_(); ++l) {
            ItemStack items = inventory.func_70301_a(l);
            if (items == null || items.field_77994_a <= 0) continue;
            Util.dropItems(world, inventory.func_70301_a(l).func_77946_l(), x, y, z, doRandomSpread);
        }
    }

    public static boolean dumpModObjects(File file) {
        StringBuilder sb = new StringBuilder();
        for (Object key : Block.field_149771_c.func_148742_b()) {
            if (key == null) continue;
            sb.append(key);
            sb.append("\n");
        }
        for (Object key : Item.field_150901_e.func_148742_b()) {
            if (key == null) continue;
            sb.append(key);
            sb.append("\n");
        }
        try {
            Files.write((CharSequence)sb, (File)file, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Log.warn("Error dumping ore dictionary entries: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean dumpOreNames(File file) {
        try {
            Object[] oreNames = OreDictionary.getOreNames();
            Files.write((CharSequence)Joiner.on((String)"\n").join(oreNames), (File)file, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Log.warn("Error dumping ore dictionary entries: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static ItemStack decrStackSize(IInventory inventory, int slot, int size) {
        ItemStack item = inventory.func_70301_a(slot);
        if (item != null) {
            if (item.field_77994_a <= size) {
                ItemStack result = item;
                inventory.func_70299_a(slot, null);
                inventory.func_70296_d();
                return result;
            }
            ItemStack split = item.func_77979_a(size);
            if (item.field_77994_a == 0) {
                inventory.func_70299_a(slot, null);
            }
            inventory.func_70296_d();
            return split;
        }
        return null;
    }

    public static Vec3 getEyePosition(EntityPlayer player) {
        Vec3 v = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        if (player.field_70170_p.field_72995_K) {
            v.field_72448_b += (double)(player.func_70047_e() - player.getDefaultEyeHeight());
        } else {
            v.field_72448_b += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                v.field_72448_b -= 0.08;
            }
        }
        return v;
    }

    public static Vector3d getEyePositionEio(EntityPlayer player) {
        Vector3d res = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (player.field_70170_p.field_72995_K) {
            res.y += (double)(player.func_70047_e() - player.getDefaultEyeHeight());
        } else {
            res.y += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                res.y -= 0.08;
            }
        }
        return res;
    }

    public static Vector3d getLookVecEio(EntityPlayer player) {
        Vec3 lv = player.func_70040_Z();
        return new Vector3d(lv.field_72450_a, lv.field_72448_b, lv.field_72449_c);
    }

    public static boolean isEquipped(EntityPlayer player, Class<? extends Item> class1) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.func_70448_g() == null) {
            return false;
        }
        return class1.isAssignableFrom(player.field_71071_by.func_70448_g().func_77973_b().getClass());
    }

    public static boolean isType(ItemStack stack, Class<?> class1) {
        if (stack == null || class1 == null) {
            return false;
        }
        return class1.isAssignableFrom(stack.func_77973_b().getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<MovingObjectPosition> raytraceAll(World world, Vec3 startVec, Vec3 endVec, boolean includeLiquids) {
        MovingObjectPosition movingobjectposition;
        ArrayList<MovingObjectPosition> result = new ArrayList<MovingObjectPosition>();
        boolean p_147447_4_ = false;
        boolean p_147447_5_ = false;
        if (Double.isNaN(startVec.field_72450_a)) return result;
        if (Double.isNaN(startVec.field_72448_b) || Double.isNaN(startVec.field_72449_c)) return result;
        if (Double.isNaN(endVec.field_72450_a) || Double.isNaN(endVec.field_72448_b) || Double.isNaN(endVec.field_72449_c)) return result;
        int i = MathHelper.func_76128_c((double)endVec.field_72450_a);
        int j = MathHelper.func_76128_c((double)endVec.field_72448_b);
        int k = MathHelper.func_76128_c((double)endVec.field_72449_c);
        int l = MathHelper.func_76128_c((double)startVec.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)startVec.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)startVec.field_72449_c);
        Block block = world.func_147439_a(l, i1, j1);
        int k1 = world.func_72805_g(l, i1, j1);
        if ((!p_147447_4_ || block.func_149668_a(world, l, i1, j1) != null) && block.func_149678_a(k1, includeLiquids) && (movingobjectposition = block.func_149731_a(world, l, i1, j1, startVec, endVec)) != null) {
            result.add(movingobjectposition);
        }
        MovingObjectPosition movingobjectposition2 = null;
        k1 = 200;
        while (k1-- >= 0) {
            int b0;
            if (Double.isNaN(startVec.field_72450_a) || Double.isNaN(startVec.field_72448_b) || Double.isNaN(startVec.field_72449_c)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                if (!p_147447_5_) return result;
                result.add(movingobjectposition2);
            }
            boolean flag6 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d0 = (double)l + 1.0;
            } else if (i < l) {
                d0 = (double)l + 0.0;
            } else {
                flag6 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = endVec.field_72450_a - startVec.field_72450_a;
            double d7 = endVec.field_72448_b - startVec.field_72448_b;
            double d8 = endVec.field_72449_c - startVec.field_72449_c;
            if (flag6) {
                d3 = (d0 - startVec.field_72450_a) / d6;
            }
            if (flag3) {
                d4 = (d1 - startVec.field_72448_b) / d7;
            }
            if (flag4) {
                d5 = (d2 - startVec.field_72449_c) / d8;
            }
            boolean flag5 = false;
            if (d3 < d4 && d3 < d5) {
                b0 = i > l ? 4 : 5;
                startVec.field_72450_a = d0;
                startVec.field_72448_b += d7 * d3;
                startVec.field_72449_c += d8 * d3;
            } else if (d4 < d5) {
                b0 = j > i1 ? 0 : 1;
                startVec.field_72450_a += d6 * d4;
                startVec.field_72448_b = d1;
                startVec.field_72449_c += d8 * d4;
            } else {
                b0 = k > j1 ? 2 : 3;
                startVec.field_72450_a += d6 * d5;
                startVec.field_72448_b += d7 * d5;
                startVec.field_72449_c = d2;
            }
            Vec3 vec32 = Vec3.func_72443_a((double)startVec.field_72450_a, (double)startVec.field_72448_b, (double)startVec.field_72449_c);
            vec32.field_72450_a = MathHelper.func_76128_c((double)startVec.field_72450_a);
            l = (int)vec32.field_72450_a;
            if (b0 == 5) {
                --l;
                vec32.field_72450_a += 1.0;
            }
            vec32.field_72448_b = MathHelper.func_76128_c((double)startVec.field_72448_b);
            i1 = (int)vec32.field_72448_b;
            if (b0 == 1) {
                --i1;
                vec32.field_72448_b += 1.0;
            }
            vec32.field_72449_c = MathHelper.func_76128_c((double)startVec.field_72449_c);
            j1 = (int)vec32.field_72449_c;
            if (b0 == 3) {
                --j1;
                vec32.field_72449_c += 1.0;
            }
            Block block1 = world.func_147439_a(l, i1, j1);
            int l1 = world.func_72805_g(l, i1, j1);
            if (p_147447_4_ && block1.func_149668_a(world, l, i1, j1) == null) continue;
            if (block1.func_149678_a(l1, includeLiquids)) {
                MovingObjectPosition movingobjectposition1 = block1.func_149731_a(world, l, i1, j1, startVec, endVec);
                if (movingobjectposition1 == null) continue;
                result.add(movingobjectposition1);
                continue;
            }
            movingobjectposition2 = new MovingObjectPosition(l, i1, j1, b0, startVec, false);
        }
        if (!p_147447_5_) {
            return result;
        }
        result.add(movingobjectposition2);
        return result;
    }

    public static ForgeDirection getDirFromOffset(int xOff, int yOff, int zOff) {
        if (xOff != 0 && yOff == 0 && zOff == 0) {
            return xOff < 0 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (zOff != 0 && yOff == 0 && xOff == 0) {
            return zOff < 0 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
        }
        if (yOff != 0 && xOff == 0 && zOff == 0) {
            return yOff < 0 ? ForgeDirection.DOWN : ForgeDirection.UP;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static int getProgressScaled(int scale, IProgressTile tile) {
        return (int)(tile.getProgress() * (float)scale);
    }
}

