/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.ArrayUtils;

public class WorldCache<I> {
    public static final int MAX_ID = Short.MAX_VALUE;
    protected String ident;
    protected boolean locked;
    protected BitSet usedIDs = new BitSet(Short.MAX_VALUE);
    protected Set<Integer> blockedIDs = Sets.newHashSet();
    protected BiMap<I, String> objToName = HashBiMap.create();
    protected BiMap<String, Integer> nameToID = HashBiMap.create();

    public WorldCache(String ident) {
        this(ident, true);
    }

    protected WorldCache(String ident, boolean registerToEventBus) {
        this.ident = ident;
        if (registerToEventBus) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            try {
                this.saveData(this.getSaveFile());
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            try {
                this.loadData(this.getSaveFile());
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        this.locked = true;
    }

    protected void loadData(File file) throws IOException {
        if (!file.createNewFile()) {
            NBTTagCompound tag = null;
            try {
                tag = CompressedStreamTools.func_74797_a((File)file);
            }
            catch (Exception e) {
                this.generateIDs();
                return;
            }
            if (tag.func_74764_b("ItemData")) {
                NBTTagList list = tag.func_150295_c("ItemData", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound dataTag = list.func_150305_b(i);
                    int id = dataTag.func_74762_e("V");
                    String name = dataTag.func_74779_i("K");
                    this.nameToID.put((Object)name, (Object)id);
                    if (!this.objToName.containsValue((Object)name)) continue;
                    this.usedIDs.set(id, true);
                }
                for (int id : tag.func_74759_k("BlockedItemIds")) {
                    this.blockedIDs.add(id);
                }
                this.blockOldIDs();
                this.mergeNewIDs();
                return;
            }
        }
        this.generateIDs();
    }

    protected void saveData(File file) throws IOException {
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        for (String key : this.nameToID.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("K", key);
            tag.func_74768_a("V", ((Integer)this.nameToID.get((Object)key)).intValue());
            dataList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("ItemData", (NBTBase)dataList);
        data.func_74783_a("BlockedItemIds", ArrayUtils.toPrimitive((Integer[])this.blockedIDs.toArray(new Integer[0])));
        CompressedStreamTools.func_74795_b((NBTTagCompound)data, (File)file);
    }

    protected void blockOldIDs() {
        for (String s : this.nameToID.keySet()) {
            if (this.objToName.containsValue((Object)s)) continue;
            this.blockedIDs.add((Integer)this.nameToID.get((Object)s));
        }
        Iterator iter = this.nameToID.keySet().iterator();
        while (iter.hasNext()) {
            if (!this.blockedIDs.contains(this.nameToID.get(iter.next()))) continue;
            iter.remove();
        }
    }

    protected void mergeNewIDs() {
        for (String s : this.objToName.values()) {
            Integer id = (Integer)this.nameToID.get((Object)s);
            if (id == null) continue;
            this.setID(s);
        }
    }

    protected void generateIDs() {
        for (Map.Entry e : this.objToName.entrySet()) {
            if (this.nameToID.containsKey(e.getValue())) continue;
            this.setID((String)e.getValue());
        }
    }

    protected int getNextAvailableID(String name) {
        Integer nextID = (Integer)this.nameToID.get((Object)name);
        if (nextID != null) {
            return nextID;
        }
        nextID = this.usedIDs.nextClearBit(0);
        while (this.blockedIDs.contains(nextID) || this.nameToID.containsValue((Object)nextID)) {
            Integer n = nextID;
            Integer n2 = nextID = Integer.valueOf(nextID + 1);
            this.usedIDs.nextClearBit(n);
        }
        return nextID;
    }

    protected void setID(String name) {
        this.setID(name, this.getNextAvailableID(name));
    }

    protected void setID(String name, int id) {
        this.nameToID.put((Object)name, (Object)id);
        this.usedIDs.set(id, true);
    }

    protected File getSaveFile() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), this.ident + ".json");
    }

    public void addObject(I object, String name) {
        if (this.locked) {
            throw new IllegalStateException("Cannot add to world cache after world load!");
        }
        this.objToName.put(object, (Object)name);
    }

    public int getID(I obj) {
        return (Integer)this.nameToID.get((Object)this.getName(obj));
    }

    public String getName(I obj) {
        return (String)this.objToName.get(obj);
    }

    public I getObject(int id) {
        return this.getObject((String)this.nameToID.inverse().get((Object)id));
    }

    public I getObject(String string) {
        return (I)this.objToName.inverse().get((Object)string);
    }

    public Iterator<I> getObjects() {
        return this.objToName.keySet().iterator();
    }

    public TIntObjectMap<I> getEnumeratedObjects() {
        TIntObjectHashMap ret = new TIntObjectHashMap();
        for (int i = 0; i <= Short.MAX_VALUE && this.usedIDs.nextSetBit(i) >= 0; ++i) {
            if (!this.usedIDs.get(i)) continue;
            ret.put(i, this.getObject(i));
        }
        return ret;
    }
}

