/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.blockiterators;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.blockiterators.CubicBlockIterator;
import net.minecraftforge.common.util.ForgeDirection;

public class PlanarBlockIterator
extends CubicBlockIterator {
    private final Orientation orientation;

    public PlanarBlockIterator(BlockCoord base, Orientation orientation, int radius) {
        super(base, radius);
        this.orientation = orientation;
    }

    @Override
    public BlockCoord next() {
        BlockCoord coord = new BlockCoord(this.curX, this.curY, this.curZ);
        switch (this.orientation) {
            case EAST_WEST: {
                this.curY = this.curY == this.maxY ? this.minY : this.curY + 1;
                this.curX = this.curY == this.minY ? this.curX + 1 : this.curX;
            }
            case NORTH_SOUTH: {
                this.curY = this.curY == this.maxY ? this.minY : this.curY + 1;
                this.curZ = this.curY == this.minY ? this.curZ + 1 : this.curZ;
            }
            case HORIZONTAL: {
                this.curX = this.curX == this.maxX ? this.minX : this.curX + 1;
                this.curZ = this.curX == this.minX ? this.curZ + 1 : this.curZ;
            }
        }
        return coord;
    }

    @Override
    public boolean hasNext() {
        return this.curX <= this.maxX && this.curY <= this.maxY && this.curZ <= this.maxZ;
    }

    public static enum Orientation {
        EAST_WEST,
        NORTH_SOUTH,
        HORIZONTAL;


        public static Orientation perpendicular(ForgeDirection dir) {
            switch (dir) {
                case DOWN: 
                case UP: {
                    return HORIZONTAL;
                }
                case NORTH: 
                case SOUTH: {
                    return EAST_WEST;
                }
                case EAST: 
                case WEST: {
                    return NORTH_SOUTH;
                }
            }
            return null;
        }
    }
}

