/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.vecmath;

import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2d;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4d;
import java.awt.Rectangle;

public class Camera {
    private Rectangle viewport;
    private Matrix4d projectionTranspose;
    private Matrix4d projectionMatrix;
    private Matrix4d projectionInverse;
    private Matrix4d viewTranspose;
    private Matrix4d viewMatrix;
    private Matrix4d viewInverse;

    public boolean isValid() {
        return this.viewMatrix != null && this.projectionMatrix != null && this.viewport != null;
    }

    public void setProjectionMatrixAsPerspective(double fovDegrees, double near, double far, int viewportWidth, int viewportHeight) {
        this.setProjectionMatrix(VecmathUtil.createProjectionMatrixAsPerspective(fovDegrees, near, far, viewportWidth, viewportHeight));
    }

    public void setViewMatrixAsLookAt(Vector3d eyePos, Vector3d lookAtPos, Vector3d upVec) {
        this.setViewMatrix(VecmathUtil.createMatrixAsLookAt(eyePos, lookAtPos, upVec));
    }

    public Vector3d getEyePoint() {
        Matrix4d vpm = new Matrix4d();
        Matrix4d ivm = this.getInverseViewMatrix();
        if (ivm == null) {
            return null;
        }
        Matrix4d ipm = this.getInverseProjectionMatrix();
        if (ipm == null) {
            return null;
        }
        vpm.mul(ivm, ipm);
        Vector3d eye = new Vector3d();
        ivm.getTranslation(eye);
        return eye;
    }

    public boolean getRayForPixel(int x, int y, Vector3d eyeOut, Vector3d normalOut) {
        if (this.isValid()) {
            VecmathUtil.computeRayForPixel(this.viewport, this.getInverseProjectionMatrix(), this.getInverseViewMatrix(), x, y, eyeOut, normalOut);
            return true;
        }
        return false;
    }

    public Vector2d getScreenPoint(Vector3d point3d) {
        Vector4d transPoint = new Vector4d(point3d.x, point3d.y, point3d.z, 1.0);
        this.viewMatrix.transform(transPoint);
        this.projectionMatrix.transform(transPoint);
        int halfWidth = this.viewport.width / 2;
        int halfHeight = this.viewport.height / 2;
        Vector2d screenPos = new Vector2d(transPoint.x, transPoint.y);
        screenPos.scale(1.0 / transPoint.w);
        screenPos.x = screenPos.x * (double)halfWidth + (double)halfWidth;
        screenPos.y = -screenPos.y * (double)halfHeight + (double)halfHeight;
        return screenPos;
    }

    public void setViewport(int x, int y, int width, int height) {
        this.viewport = new Rectangle(x, y, width, height);
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public void setViewport(Rectangle viewport) {
        if (viewport != null) {
            this.setViewport(viewport.x, viewport.y, viewport.width, viewport.height);
        }
    }

    public Matrix4d getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public void setProjectionMatrix(Matrix4d matrix) {
        if (this.projectionMatrix == null) {
            this.projectionMatrix = new Matrix4d();
            this.projectionTranspose = new Matrix4d();
        }
        this.projectionMatrix.set(matrix);
        this.projectionTranspose.set(matrix);
        this.projectionTranspose.transpose();
        this.projectionInverse = null;
    }

    public Matrix4d getTransposeProjectionMatrix() {
        return this.projectionTranspose;
    }

    public Matrix4d getInverseProjectionMatrix() {
        if (this.projectionMatrix != null) {
            if (this.projectionInverse == null) {
                this.projectionInverse = new Matrix4d(this.projectionMatrix);
                this.projectionInverse.invert();
            }
            return this.projectionInverse;
        }
        return null;
    }

    public Matrix4d getViewMatrix() {
        return this.viewMatrix;
    }

    public void setViewMatrix(Matrix4d matrix) {
        if (this.viewMatrix == null) {
            this.viewMatrix = new Matrix4d();
            this.viewTranspose = new Matrix4d();
        }
        this.viewMatrix.set(matrix);
        this.viewTranspose.set(matrix);
        this.viewTranspose.transpose();
        this.viewInverse = null;
    }

    public Matrix4d getTransposeViewMatrix() {
        return this.viewTranspose;
    }

    public Matrix4d getInverseViewMatrix() {
        if (this.viewMatrix != null) {
            if (this.viewInverse == null) {
                this.viewInverse = new Matrix4d(this.viewMatrix);
                this.viewInverse.invert();
            }
            return this.viewInverse;
        }
        return null;
    }
}

