/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.enderquarry;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.EventHandlerEntityItemStealer;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsMod;
import com.rwtema.extrautils.crafting.RecipeEnchantCrafting;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.helper.XURandom;
import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.packets.PacketTempChat;
import com.rwtema.extrautils.network.packets.PacketTempChatMultiline;
import com.rwtema.extrautils.tileentity.enderquarry.BlockBreakingRegistry;
import com.rwtema.extrautils.tileentity.enderquarry.TileEntityEnderMarker;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityEnderQuarry
extends TileEntity
implements IEnergyHandler {
    public static final int UPGRADE_BLANK = 0;
    public static final int UPGRADE_VOID = 1;
    public static final int UPGRADE_SILK = 2;
    public static final int UPGRADE_FORTUNE1 = 3;
    public static final int UPGRADE_FORTUNE2 = 4;
    public static final int UPGRADE_FORTUNE3 = 5;
    public static final int UPGRADE_SPEED1 = 6;
    public static final int UPGRADE_SPEED2 = 7;
    public static final int UPGRADE_SPEED3 = 8;
    public static final int UPGRADE_FLUID = 9;
    private static final Random rand = XURandom.getInstance();
    public static boolean disableSelfChunkLoading = false;
    public static int baseDrain = 1800;
    public static float hardnessDrain = 200.0f;
    public static double[] powerMultipliers = new double[]{1.0, 1.0, 2.0, 7.0, 20.0, 80.0, 3.0, 5.5, 8.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public ArrayList<ItemStack> items = new ArrayList();
    public int dx = 1;
    public int dy = 0;
    public int dz = 0;
    public EnergyStorage energy = new EnergyStorage(10000000);
    public int inventoryMask = -1;
    public int fluidMask = -1;
    public long progress = 0L;
    public int neededEnergy = -1;
    public boolean started = false;
    public boolean finished = false;
    public FluidStack fluid = null;
    public boolean[] upgrades;
    int chunk_x = 0;
    int chunk_z = 0;
    int chunk_y = 0;
    byte t = 0;
    boolean searching = false;
    int fence_x = this.field_145851_c;
    int fence_y = this.field_145848_d;
    int fence_z = this.field_145849_e;
    int fence_dir = 2;
    int fence_elev = -1;
    int min_x = this.field_145851_c;
    int max_x = this.field_145851_c;
    int min_z = this.field_145849_e;
    int max_z = this.field_145849_e;
    private ForgeChunkManager.Ticket chunkTicket;
    private EntityPlayer owner;
    private boolean overClock = false;

    public TileEntityEnderQuarry() {
        this.upgrades = new boolean[16];
    }

    public static void addUpgradeRecipes() {
        ItemStack base = new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 0);
        ItemStack burntQuartz = new ItemStack((Block)ExtraUtils.decorative1, 1, 2);
        ItemStack endersidian = new ItemStack((Block)ExtraUtils.decorative1, 1, 1);
        ExtraUtils.addRecipe(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 0), " E ", "EQE", " E ", Character.valueOf('E'), endersidian, Character.valueOf('Q'), burntQuartz);
        ExtraUtils.addRecipe(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 1), " T ", "RBR", Character.valueOf('B'), base, Character.valueOf('T'), ExtraUtils.trashCan, Character.valueOf('R'), Blocks.field_150371_ca);
        ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 2), " P ", "RBR", Character.valueOf('B'), base, Character.valueOf('P'), DigType.SILK.newStack(Items.field_151005_D), Character.valueOf('R'), Items.field_151137_ax));
        ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 3), " P ", "RBR", Character.valueOf('B'), base, Character.valueOf('P'), DigType.FORTUNE.newStack(Items.field_151035_b), Character.valueOf('R'), Items.field_151137_ax));
        ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 4), " P ", "RBR", Character.valueOf('B'), new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 3), Character.valueOf('P'), DigType.FORTUNE2.newStack(Items.field_151005_D), Character.valueOf('R'), Items.field_151137_ax));
        ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 5), "P P", "RBR", Character.valueOf('B'), new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 4), Character.valueOf('P'), DigType.FORTUNE3.newStack(Items.field_151046_w), Character.valueOf('R'), Items.field_151137_ax));
        if (ExtraUtils.nodeUpgrade != null) {
            ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 6), " R ", "TBT", Character.valueOf('B'), base, Character.valueOf('T'), new ItemStack((Item)ExtraUtils.nodeUpgrade, 1, 0), Character.valueOf('R'), DigType.SPEED.newStack(Items.field_151046_w)));
            ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 7), " R ", "TBT", Character.valueOf('B'), new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 6), Character.valueOf('T'), new ItemStack((Item)ExtraUtils.nodeUpgrade, 1, 0), Character.valueOf('R'), DigType.SPEED2.newStack(Items.field_151046_w)));
            ExtraUtils.addRecipe(new RecipeEnchantCrafting(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 8), "R R", "TBT", Character.valueOf('B'), new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 7), Character.valueOf('T'), new ItemStack((Item)ExtraUtils.nodeUpgrade, 1, 3), Character.valueOf('R'), DigType.SPEED3.newStack(Items.field_151046_w)));
        }
        ExtraUtils.addRecipe(new ItemStack((Block)ExtraUtils.enderQuarryUpgrade, 1, 9), " T ", "RBR", Character.valueOf('B'), base, Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('R'), Items.field_151137_ax);
    }

    public static int sign(int d) {
        return d == 0 ? 0 : (d > 0 ? 1 : -1);
    }

    public static boolean isIntEqual(int[] a, int[] b) {
        if (a != b) {
            for (int i = 0; i < 4; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldRefresh(Block oldID, Block newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.energy.readFromNBT(tags);
        int n = tags.func_74762_e("item_no");
        this.items.clear();
        for (int i = 0; i < n; ++i) {
            NBTTagCompound t = tags.func_74775_l("item_" + i);
            this.items.add(ItemStack.func_77949_a((NBTTagCompound)t));
        }
        if (tags.func_74764_b("fluid")) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("fluid"));
        }
        this.finished = tags.func_74767_n("finished");
        if (!this.finished) {
            this.started = tags.func_74767_n("started");
            if (this.started) {
                this.min_x = tags.func_74762_e("min_x");
                this.min_z = tags.func_74762_e("min_z");
                this.max_x = tags.func_74762_e("max_x");
                this.max_z = tags.func_74762_e("max_z");
                this.chunk_x = tags.func_74762_e("chunk_x");
                this.chunk_y = tags.func_74762_e("chunk_y");
                this.chunk_z = tags.func_74762_e("chunk_z");
                this.dx = tags.func_74762_e("dx");
                this.dy = tags.func_74762_e("dy");
                this.dz = tags.func_74762_e("dz");
                this.progress = tags.func_74763_f("progress");
            }
        }
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.energy.writeToNBT(tags);
        for (int i = 0; i < this.items.size(); ++i) {
            while (i < this.items.size() && this.items.get(i) == null) {
                this.items.remove(i);
            }
            if (i >= this.items.size()) continue;
            NBTTagCompound t = new NBTTagCompound();
            this.items.get(i).func_77955_b(t);
            tags.func_74782_a("item_" + i, (NBTBase)t);
        }
        tags.func_74768_a("item_no", this.items.size());
        if (this.fluid != null) {
            NBTTagCompound t = new NBTTagCompound();
            this.fluid.writeToNBT(t);
            tags.func_74782_a("fluid", (NBTBase)t);
        }
        if (this.finished) {
            tags.func_74757_a("finished", true);
        } else if (this.started) {
            tags.func_74757_a("started", true);
            tags.func_74768_a("min_x", this.min_x);
            tags.func_74768_a("max_x", this.max_x);
            tags.func_74768_a("min_z", this.min_z);
            tags.func_74768_a("max_z", this.max_z);
            tags.func_74768_a("chunk_x", this.chunk_x);
            tags.func_74768_a("chunk_y", this.chunk_y);
            tags.func_74768_a("chunk_z", this.chunk_z);
            tags.func_74768_a("dx", this.dx);
            tags.func_74768_a("dy", this.dy);
            tags.func_74768_a("dz", this.dz);
            tags.func_74772_a("progress", this.progress);
        }
    }

    public void startDig() {
        this.started = true;
        this.chunk_y += 5;
        this.chunk_x = this.min_x + 1 >> 4;
        this.chunk_z = this.min_z + 1 >> 4;
        this.dx = Math.max(0, this.min_x + 1 - (this.chunk_x << 4));
        this.dy = this.chunk_y;
        this.dz = Math.max(0, this.min_z + 1 - (this.chunk_z << 4));
        if (!this.stopHere()) {
            this.nextBlock();
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
    }

    public void nextBlock() {
        this.nextSubBlock();
        while (!this.stopHere()) {
            this.nextSubBlock();
        }
    }

    public void nextSubBlock() {
        ++this.progress;
        --this.dy;
        if (this.dy <= 0) {
            ++this.dx;
            if (this.dx >= 16 || (this.chunk_x << 4) + this.dx >= this.max_x) {
                this.dx = Math.max(0, this.min_x + 1 - (this.chunk_x << 4));
                ++this.dz;
                if (this.dz >= 16 || (this.chunk_z << 4) + this.dz >= this.max_z) {
                    this.nextChunk();
                    this.dx = Math.max(0, this.min_x + 1 - (this.chunk_x << 4));
                    this.dz = Math.max(0, this.min_z + 1 - (this.chunk_z << 4));
                }
            }
            this.dy = this.chunk_y;
        }
    }

    public void nextChunk() {
        this.unloadChunk();
        ++this.chunk_x;
        if (this.chunk_x << 4 >= this.max_x) {
            this.chunk_x = this.min_x + 1 >> 4;
            ++this.chunk_z;
            if (this.chunk_z << 4 >= this.max_z) {
                this.finished = true;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                return;
            }
        }
        this.dy = this.chunk_y;
        this.loadChunk();
    }

    public boolean stopHere() {
        return this.finished || this.isValid((this.chunk_x << 4) + this.dx, (this.chunk_z << 4) + this.dz);
    }

    public boolean isValid(int x, int z) {
        return this.min_x < x && x < this.max_x && this.min_z < z && z < this.max_z;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        if (!disableSelfChunkLoading) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
        }
        this.loadChunk();
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.inventoryMask < 0) {
                this.detectInventories();
            }
            this.t = (byte)(this.t + 1);
            if (this.t >= this.getSpeedNo() || this.overClock) {
                this.t = 0;
                if (this.searching) {
                    this.advFencing();
                }
                if (this.started && !this.finished) {
                    if (this.chunkTicket == null) {
                        this.chunkTicket = ForgeChunkManager.requestTicket((Object)ExtraUtilsMod.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                        if (this.chunkTicket == null) {
                            if (this.owner != null) {
                                this.owner.func_146105_b((IChatComponent)new ChatComponentText("Problem registering chunk-preserving method"));
                            }
                            this.finished = true;
                            return;
                        }
                        this.chunkTicket.getModData().func_74778_a("id", "quarry");
                        this.chunkTicket.getModData().func_74768_a("x", this.field_145851_c);
                        this.chunkTicket.getModData().func_74768_a("y", this.field_145848_d);
                        this.chunkTicket.getModData().func_74768_a("z", this.field_145849_e);
                        if (!disableSelfChunkLoading) {
                            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
                        }
                        this.loadChunk();
                    }
                    if (this.neededEnergy > 0 && this.field_145850_b.func_82737_E() % 100L == 0L) {
                        this.neededEnergy = -1;
                    }
                    int n = this.overClock ? 200 : this.getSpeedStack();
                    block0: for (int k = 0; k < n; ++k) {
                        int i;
                        if (this.items.isEmpty() && this.fluid == null) {
                            if (this.overClock || this.energy.getEnergyStored() >= this.neededEnergy && this.energy.extractEnergy(baseDrain, true) == baseDrain) {
                                int x = (this.chunk_x << 4) + this.dx;
                                int z = (this.chunk_z << 4) + this.dz;
                                int y = this.dy;
                                if (y >= 0) {
                                    NetworkHandler.sendParticleEvent(this.field_145850_b, 1, x, y, z);
                                    if (this.mineBlock(x, y, z, !this.upgrades[1])) {
                                        this.neededEnergy = -1;
                                        this.nextBlock();
                                    }
                                } else {
                                    this.nextBlock();
                                }
                            }
                        } else if (!this.overClock) {
                            this.energy.extractEnergy(baseDrain, false);
                        }
                        if (!this.items.isEmpty() && this.inventoryMask > 0) {
                            for (i = 0; i < 6; ++i) {
                                if ((this.inventoryMask & 1 << i) <= 0) continue;
                                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[i], this.field_145849_e + Facing.field_71585_d[i]);
                                if (tile instanceof IInventory) {
                                    IInventory inv = (IInventory)tile;
                                    for (int j = 0; j < this.items.size(); ++j) {
                                        if (XUHelper.invInsert(inv, this.items.get(j), Facing.field_71588_a[i]) != null) continue;
                                        this.items.remove(j);
                                        --j;
                                    }
                                    continue;
                                }
                                this.detectInventories();
                            }
                        }
                        if (this.fluid == null || this.fluidMask <= 0) continue;
                        for (i = 0; this.fluid != null && i < 6; ++i) {
                            if ((this.fluidMask & 1 << i) <= 0) continue;
                            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[i], this.field_145849_e + Facing.field_71585_d[i]);
                            if (tile instanceof IFluidHandler) {
                                IFluidHandler tank = (IFluidHandler)tile;
                                this.fluid.amount -= tank.fill(ForgeDirection.getOrientation((int)i).getOpposite(), this.fluid, true);
                                if (this.fluid.amount != 0) continue;
                                this.fluid = null;
                                continue block0;
                            }
                            this.detectInventories();
                        }
                    }
                }
            }
        }
    }

    private int getSpeedNo() {
        return this.upgrades[6] ? 1 : (this.upgrades[7] ? 1 : (this.upgrades[8] ? 1 : 3));
    }

    private int getSpeedStack() {
        return this.upgrades[6] ? 1 : (this.upgrades[7] ? 3 : (this.upgrades[8] ? 9 : 1));
    }

    public DigType getDigType() {
        return this.upgrades[2] ? DigType.SILK : (this.upgrades[3] ? DigType.FORTUNE : (this.upgrades[4] ? DigType.FORTUNE2 : (this.upgrades[5] ? DigType.FORTUNE3 : DigType.NORMAL)));
    }

    public void func_145843_s() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        super.func_145843_s();
    }

    private void loadChunk() {
        if (this.field_145851_c >> 4 != this.chunk_x || this.field_145849_e >> 4 != this.chunk_z) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunk_x, this.chunk_z));
        }
    }

    private void unloadChunk() {
        if (this.field_145851_c >> 4 != this.chunk_x || this.field_145849_e >> 4 != this.chunk_z) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunk_x, this.chunk_z));
        }
    }

    public boolean mineBlock(int x, int y, int z, boolean replaceWithDirt) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block != Blocks.field_150350_a && !this.field_145850_b.func_147437_c(x, y, z)) {
            if (BlockBreakingRegistry.blackList(block)) {
                if (this.upgrades[9] && XUHelper.isFluidBlock(block)) {
                    this.fluid = XUHelper.drainBlock(this.field_145850_b, x, y, z, true);
                }
                if (!this.overClock) {
                    this.energy.extractEnergy(baseDrain, false);
                }
                return true;
            }
            if (!(replaceWithDirt && (block.isLeaves((IBlockAccess)this.field_145850_b, x, y, z) || block.isFoliage((IBlockAccess)this.field_145850_b, x, y, z) || block.isWood((IBlockAccess)this.field_145850_b, x, y, z) || block instanceof IPlantable || block instanceof IGrowable))) {
                int meta = this.field_145850_b.func_72805_g(x, y, z);
                float hardness = block.func_149712_f(this.field_145850_b, x, y, z);
                if (hardness < 0.0f) {
                    if (!this.overClock) {
                        this.energy.extractEnergy(baseDrain, false);
                    }
                    return true;
                }
                int amount = (int)Math.ceil((double)baseDrain + (double)(hardness * hardnessDrain) * this.getPowerMultiplier());
                if (amount > this.energy.getMaxEnergyStored()) {
                    amount = this.energy.getMaxEnergyStored();
                }
                if (this.overClock) {
                    amount = 0;
                }
                if (this.energy.extractEnergy(amount, true) < amount) {
                    this.neededEnergy = amount;
                    return false;
                }
                this.energy.extractEnergy(amount, false);
                if (replaceWithDirt && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
                    if (this.field_145850_b.func_72937_j(x, y + 1, z)) {
                        this.field_145850_b.func_147465_d(x, y, z, (Block)Blocks.field_150349_c, 0, 3);
                    }
                    if (rand.nextInt(16) == 0 && this.field_145850_b.func_147437_c(x, y + 1, z)) {
                        if (rand.nextInt(5) == 0) {
                            this.field_145850_b.func_72807_a(x, z).plantFlower(this.field_145850_b, rand, x, y + 1, z);
                        } else if (rand.nextInt(2) == 0) {
                            this.field_145850_b.func_147465_d(x, y + 1, z, (Block)Blocks.field_150327_N, rand.nextInt(BlockFlower.field_149858_b.length), 3);
                        } else {
                            this.field_145850_b.func_147465_d(x, y + 1, z, (Block)Blocks.field_150328_O, rand.nextInt(BlockFlower.field_149859_a.length), 3);
                        }
                    }
                    return true;
                }
                return this.harvestBlock(block, x, y, z, meta, replaceWithDirt, this.getDigType());
            }
            if (!this.overClock) {
                this.energy.extractEnergy(baseDrain, false);
            }
            return true;
        }
        if (!this.overClock) {
            this.energy.extractEnergy(baseDrain, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean harvestBlock(Block block, int x, int y, int z, int meta, boolean replaceWithDirt, DigType digType) {
        boolean isOpaque = block.func_149662_c();
        boolean seesSky = replaceWithDirt && isOpaque && this.field_145850_b.func_72937_j(x, y + 1, z);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b));
        fakePlayer.func_70062_b(0, digType.newStack(Items.field_151046_w));
        try {
            boolean var19;
            if (BlockBreakingRegistry.isSpecial(block)) {
                EventHandlerEntityItemStealer.startCapture(true);
                block.func_149681_a(this.field_145850_b, x, y, z, meta, (EntityPlayer)fakePlayer);
                if (!block.removedByPlayer(this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, true)) {
                    boolean var20;
                    this.items.addAll(EventHandlerEntityItemStealer.getCapturedItemStacks());
                    boolean bl = var20 = false;
                    return bl;
                }
                block.func_149636_a(this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, meta);
                block.func_149664_b(this.field_145850_b, x, y, z, meta);
                if (replaceWithDirt && isOpaque) {
                    this.field_145850_b.func_147465_d(x, y, z, (Block)(seesSky ? Blocks.field_150349_c : Blocks.field_150346_d), 0, 3);
                }
                this.items.addAll(EventHandlerEntityItemStealer.getCapturedItemStacks());
            } else {
                EventHandlerEntityItemStealer.startCapture(true);
                boolean flag = this.field_145850_b.func_147465_d(x, y, z, (Block)(replaceWithDirt && isOpaque ? (seesSky ? Blocks.field_150349_c : Blocks.field_150346_d) : Blocks.field_150350_a), 0, 3);
                this.items.addAll(EventHandlerEntityItemStealer.getCapturedItemStacks());
                if (!flag) {
                    boolean var21;
                    boolean bl = var21 = false;
                    return bl;
                }
                ArrayList<ItemStack> i = new ArrayList<ItemStack>();
                if (digType.isSilkTouch() && block.canSilkHarvest(this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, meta)) {
                    int j = 0;
                    Item item = Item.func_150898_a((Block)block);
                    if (item != null) {
                        if (item.func_77614_k()) {
                            j = meta;
                        }
                        ItemStack itemstack = new ItemStack(item, 1, j);
                        i.add(itemstack);
                    }
                } else {
                    i.addAll(block.getDrops(this.field_145850_b, x, y, z, meta, digType.getFortuneModifier()));
                }
                float p = ForgeEventFactory.fireBlockHarvesting(i, (World)this.field_145850_b, (Block)block, (int)x, (int)y, (int)z, (int)meta, (int)digType.getFortuneModifier(), (float)1.0f, (boolean)digType.isSilkTouch(), (EntityPlayer)fakePlayer);
                if (p > 0.0f && !i.isEmpty() && (p == 1.0f || rand.nextFloat() < p)) {
                    this.items.addAll(i);
                }
            }
            NetworkHandler.sendParticleEvent(this.field_145850_b, 0, x, y, z);
            if (seesSky && rand.nextInt(16) == 0 && this.field_145850_b.func_147437_c(x, y + 1, z)) {
                if (rand.nextInt(5) == 0) {
                    this.field_145850_b.func_72807_a(x, z).plantFlower(this.field_145850_b, rand, x, y + 1, z);
                } else if (rand.nextInt(2) == 0) {
                    this.field_145850_b.func_147465_d(x, y + 1, z, (Block)Blocks.field_150327_N, rand.nextInt(BlockFlower.field_149858_b.length), 3);
                } else {
                    this.field_145850_b.func_147465_d(x, y + 1, z, (Block)Blocks.field_150328_O, rand.nextInt(BlockFlower.field_149859_a.length), 3);
                }
            }
            boolean bl = var19 = true;
            return bl;
        }
        finally {
            fakePlayer.func_70062_b(0, (ItemStack)null);
        }
    }

    public void debug() {
        this.overClock = true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    public double getPowerMultiplier() {
        double multiplier = 1.0;
        for (int i = 0; i < 16; ++i) {
            if (!this.upgrades[i]) continue;
            multiplier *= powerMultipliers[i];
        }
        return multiplier;
    }

    public void detectInventories() {
        this.inventoryMask = 0;
        this.fluidMask = 0;
        this.upgrades = new boolean[16];
        for (int i = 0; i < 6; ++i) {
            int x = this.field_145851_c + Facing.field_71586_b[i];
            int y = this.field_145848_d + Facing.field_71587_c[i];
            int z = this.field_145849_e + Facing.field_71585_d[i];
            TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
            if (tile instanceof IInventory) {
                this.inventoryMask |= 1 << i;
            }
            if (tile instanceof IFluidHandler) {
                this.fluidMask |= 1 << i;
            }
            if (this.field_145850_b.func_147439_a(x, y, z) != ExtraUtils.enderQuarryUpgrade) continue;
            this.upgrades[this.field_145850_b.func_72805_g((int)x, (int)y, (int)z)] = true;
        }
    }

    public void startFencing(EntityPlayer player) {
        if (this.finished) {
            PacketTempChat.sendChat(player, (IChatComponent)new ChatComponentText("Quarry has finished"));
        } else if (this.started) {
            PacketTempChatMultiline.addChatComponentMessage((IChatComponent)new ChatComponentText("Mining at: (" + ((this.chunk_x << 4) + this.dx) + "," + this.dy + "," + ((this.chunk_z << 4) + this.dz) + ")"));
            PacketTempChatMultiline.addChatComponentMessage((IChatComponent)new ChatComponentText("" + this.progress + " blocks scanned."));
            PacketTempChatMultiline.sendCached(player);
        } else if (this.searching) {
            PacketTempChat.sendChat(player, (IChatComponent)new ChatComponentText("Searching fence boundary at: (" + this.fence_x + "," + this.fence_y + "," + this.fence_z + ")"));
        } else {
            this.owner = player;
            player.func_146105_b((IChatComponent)new ChatComponentText("Analyzing Fence boundary"));
            if (!this.checkForMarkers(player)) {
                this.fence_x = this.field_145851_c;
                this.fence_y = this.field_145848_d;
                this.fence_z = this.field_145849_e;
                this.fence_elev = -1;
                this.fence_dir = -1;
                int j = 0;
                for (int i = 2; i < 6; ++i) {
                    if (!this.isFence(this.fence_x, this.fence_y, this.fence_z, i)) continue;
                    if (this.fence_dir < 0) {
                        this.fence_dir = i;
                    }
                    if (++j <= 2) continue;
                    this.stopFencing("Quarry is connected to more than fences on more than 2 sides", false);
                    return;
                }
                if (j < 2) {
                    if (j == 0) {
                        this.stopFencing("Unable to detect fence boundary", false);
                    }
                    if (j == 1) {
                        this.stopFencing("Quarry is only connected to fence boundary on one side", false);
                    }
                } else {
                    this.chunk_y = this.field_145848_d;
                    this.fence_x = this.field_145851_c + Facing.field_71586_b[this.fence_dir];
                    this.fence_y = this.field_145848_d + Facing.field_71587_c[this.fence_dir];
                    this.fence_z = this.field_145849_e + Facing.field_71585_d[this.fence_dir];
                    this.min_x = this.field_145851_c;
                    this.max_x = this.field_145851_c;
                    this.min_z = this.field_145849_e;
                    this.max_z = this.field_145849_e;
                    this.searching = true;
                }
            }
        }
    }

    public boolean checkForMarkers(EntityPlayer player) {
        for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH}) {
            int[] test = new int[]{this.func_145831_w().field_73011_w.field_76574_g, this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ};
            int[] test_forward = null;
            int[] test_side = null;
            boolean flag = true;
            for (int[] a : TileEntityEnderMarker.markers) {
                if (!TileEntityEnderQuarry.isIntEqual(a, test)) continue;
                flag = false;
                break;
            }
            if (flag) continue;
            player.func_146105_b((IChatComponent)new ChatComponentText("Found attached ender-marker"));
            for (int[] a : TileEntityEnderMarker.markers) {
                if (a[0] != test[0] || a[2] != test[2] || a[1] == test[1] && a[3] == test[3]) continue;
                if (TileEntityEnderQuarry.sign(a[1] - test[1]) == d.offsetX && TileEntityEnderQuarry.sign(a[3] - test[3]) == d.offsetZ) {
                    if (test_forward == null) {
                        test_forward = a;
                    } else if (!TileEntityEnderQuarry.isIntEqual(a, test_forward)) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Quarry marker square is ambiguous - multiple markers found at (" + a[1] + "," + a[3] + ") and (" + test_forward[1] + "," + test_forward[3] + ")"));
                    }
                }
                if ((d.offsetX != 0 || a[3] != test[3]) && (d.offsetZ != 0 || a[1] != test[1])) continue;
                if (test_side == null) {
                    test_side = a;
                    continue;
                }
                if (TileEntityEnderQuarry.isIntEqual(a, test_side)) continue;
                player.func_146105_b((IChatComponent)new ChatComponentText("Quarry marker square is ambiguous - multiple markers found at (" + a[1] + "," + a[3] + ") and (" + test_side[1] + "," + test_side[3] + ")"));
            }
            if (test_forward == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Quarry marker square is incomplete"));
                return false;
            }
            if (test_side == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Quarry marker square is incomplete"));
                return false;
            }
            int amin_x = Math.min(Math.min(test[1], (int)test_forward[1]), (int)test_side[1]);
            int amax_x = Math.max(Math.max(test[1], (int)test_forward[1]), (int)test_side[1]);
            int amin_z = Math.min(Math.min(test[3], (int)test_forward[3]), (int)test_side[3]);
            int amax_z = Math.max(Math.max(test[3], (int)test_forward[3]), test_side[3]);
            if (amax_x - amin_x > 2 && amax_z - amin_z > 2) {
                this.owner.func_146105_b((IChatComponent)new ChatComponentText("Sucessfully established boundary"));
                if (disableSelfChunkLoading) {
                    this.owner.func_146105_b((IChatComponent)new ChatComponentText("Note: Quarry is configured not to self-chunkload."));
                }
                this.chunk_y = this.field_145848_d;
                this.min_x = amin_x;
                this.max_x = amax_x;
                this.min_z = amin_z;
                this.max_z = amax_z;
                this.searching = false;
                this.startDig();
                return true;
            }
            this.stopFencing("Region created by ender markers is too small", false);
            return false;
        }
        return false;
    }

    public void stopFencing(String reason, boolean sendLocation) {
        this.searching = false;
        if (sendLocation) {
            reason = reason + ": (" + this.fence_x + "," + this.fence_y + "," + this.fence_z + ")";
        }
        if (this.owner != null) {
            this.owner.func_146105_b((IChatComponent)new ChatComponentText(reason));
        }
    }

    private void advFencing() {
        Long t = System.nanoTime();
        while (this.searching && System.nanoTime() - t < 100000L) {
            this.advFence();
        }
    }

    public void advFence() {
        int new_dir = -1;
        for (int i = 0; i < 6; ++i) {
            if ((this.fence_elev >= 0 ? i == Facing.field_71588_a[this.fence_elev] : i == Facing.field_71588_a[this.fence_dir]) || !this.isFence(this.fence_x, this.fence_y, this.fence_z, i)) continue;
            if (new_dir != -1) {
                this.stopFencing("Fence boundary splits at", true);
                return;
            }
            new_dir = i;
        }
        if (new_dir < 0) {
            this.stopFencing("Fence boundary stops at", true);
        } else {
            if (new_dir <= 1) {
                this.fence_elev = new_dir;
                this.fence_y += Facing.field_71587_c[new_dir];
                if (new_dir == 1) {
                    this.chunk_y = Math.max(this.chunk_y, this.fence_y);
                }
            } else {
                if (this.fence_dir != new_dir) {
                    if (this.min_z < this.fence_z && this.fence_z < this.max_z || this.min_x < this.fence_x && this.fence_x < this.max_x) {
                        this.stopFencing("Fence boundary must be square", true);
                        return;
                    }
                    boolean flag = false;
                    if (this.fence_z < this.field_145849_e) {
                        flag = this.fence_z != this.min_z && this.min_z != this.field_145849_e;
                        this.min_z = this.fence_z;
                    }
                    if (this.fence_x < this.field_145851_c && !flag) {
                        flag = this.fence_x != this.min_x && this.min_x != this.field_145851_c;
                        this.min_x = this.fence_x;
                    }
                    if (this.fence_z > this.field_145849_e && !flag) {
                        flag = this.fence_z != this.max_z && this.max_z != this.field_145849_e;
                        this.max_z = this.fence_z;
                    }
                    if (this.fence_x > this.field_145851_c && !flag) {
                        flag = this.fence_x != this.max_x && this.max_x != this.field_145851_c;
                        this.max_x = this.fence_x;
                    }
                    if (flag) {
                        this.stopFencing("Fence boundary must be square", true);
                        return;
                    }
                }
                this.fence_x += Facing.field_71586_b[new_dir];
                this.fence_z += Facing.field_71585_d[new_dir];
                this.fence_dir = new_dir;
                this.fence_elev = -1;
            }
            if (this.fence_x == this.field_145851_c && this.fence_y == this.field_145848_d && this.fence_z == this.field_145849_e) {
                if (this.max_x - this.min_x <= 2 || this.max_z - this.min_z <= 2) {
                    this.stopFencing("Region created by fence is too small", false);
                    return;
                }
                this.owner.func_146105_b((IChatComponent)new ChatComponentText("Sucessfully established boundary"));
                if (disableSelfChunkLoading) {
                    this.owner.func_146105_b((IChatComponent)new ChatComponentText("Note: Quarry is configured not to self-chunkload."));
                }
                this.startDig();
                this.searching = false;
            }
        }
    }

    public boolean isFence(int x, int y, int z, int dir) {
        return this.isFence(x + Facing.field_71586_b[dir], y + Facing.field_71587_c[dir], z + Facing.field_71585_d[dir]);
    }

    public boolean isFence(int x, int y, int z) {
        Block id = this.field_145850_b.func_147439_a(x, y, z);
        return BlockBreakingRegistry.isFence(id) ? true : x == this.field_145851_c && z == this.field_145849_e && y == this.field_145848_d;
    }

    public static enum DigType {
        NORMAL(null, 0),
        SILK(Enchantment.field_77348_q, 1),
        FORTUNE(Enchantment.field_77346_s, 1),
        FORTUNE2(Enchantment.field_77346_s, 2),
        FORTUNE3(Enchantment.field_77346_s, 3),
        SPEED(Enchantment.field_77349_p, 1),
        SPEED2(Enchantment.field_77349_p, 3),
        SPEED3(Enchantment.field_77349_p, 5);

        public Enchantment ench;
        public int level;

        private DigType(Enchantment ench, int level) {
            this.ench = ench;
            this.level = level;
        }

        public int getFortuneModifier() {
            return this.ench == Enchantment.field_77346_s ? this.level : 0;
        }

        public ItemStack newStack(Item pick) {
            ItemStack stack = new ItemStack(pick);
            if (this.ench != null) {
                stack.func_77966_a(this.ench, this.level);
            }
            return stack;
        }

        public boolean isSilkTouch() {
            return this.ench == Enchantment.field_77348_q;
        }
    }
}

