/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.bytebuf;

import com.gtnewhorizon.gtnhlib.bytebuf.CheckIntrinsics;
import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import net.minecraft.launchwrapper.Launch;
import sun.misc.Unsafe;

final class MemoryManage {
    private MemoryManage() {
    }

    static MemoryUtilities.MemoryAllocator getInstance() {
        boolean hasLwjgl3ify = Launch.blackboard.get("lwjgl3ify:rfb-booted") == Boolean.TRUE;
        return hasLwjgl3ify ? CheckIntrinsics.getLwjgl3ifyAllocator() : new StdlibAllocator();
    }

    private static class StdlibAllocator
    implements MemoryUtilities.MemoryAllocator {
        static final Unsafe UNSAFE = MemoryUtilities.getUnsafeInstance();

        private StdlibAllocator() {
        }

        @Override
        public long malloc(long size) {
            return UNSAFE.allocateMemory(size);
        }

        @Override
        public long calloc(long num, long size) {
            long totalSize = Math.multiplyExact(num, size);
            long addr = UNSAFE.allocateMemory(totalSize);
            UNSAFE.setMemory(addr, totalSize, (byte)0);
            return addr;
        }

        @Override
        public long realloc(long ptr, long size) {
            return UNSAFE.reallocateMemory(ptr, size);
        }

        @Override
        public void free(long ptr) {
            UNSAFE.freeMemory(ptr);
        }
    }
}

