/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.capability;

import com.gtnewhorizon.gtnhlib.capability.CapabilityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Capabilities {
    public static <T> T getCapability(@Nullable TileEntity tileEntity, @NotNull Class<T> capability, @NotNull ForgeDirection side) {
        return Capabilities.getCapability((Object)tileEntity, capability, side);
    }

    public static <T> T getCapability(@Nullable TileEntity tileEntity, @NotNull Class<T> capability) {
        return Capabilities.getCapability((Object)tileEntity, capability, ForgeDirection.UNKNOWN);
    }

    public static <T> T getCapability(@Nullable ItemStack itemStack, @NotNull Class<T> capability) {
        if (itemStack == null) {
            return null;
        }
        return Capabilities.getCapability(itemStack.func_77973_b(), capability, ForgeDirection.UNKNOWN);
    }

    public static <T> T getCapability(@Nullable Entity entity, @NotNull Class<T> capability) {
        return Capabilities.getCapability(entity, capability, ForgeDirection.UNKNOWN);
    }

    private static <T> T getCapability(@Nullable Object object, @NotNull Class<T> capability, @NotNull ForgeDirection side) {
        if (object == null) {
            return null;
        }
        if (capability.isAssignableFrom(object.getClass())) {
            return capability.cast(object);
        }
        if (object instanceof CapabilityProvider) {
            CapabilityProvider provider = (CapabilityProvider)object;
            return provider.getCapability(capability, side);
        }
        return null;
    }
}

