/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.NdQuadBuilder;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.Axis;
import com.gtnewhorizon.gtnhlib.client.renderer.util.MathUtil;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class GeometryHelper {
    public static boolean isQuadParallelToFace(ForgeDirection face, NdQuadBuilder quad) {
        int i = Axis.fromDirection(face).ordinal();
        float val = quad.posByIndex(0, i);
        return MathUtil.fuzzy_eq(val, quad.posByIndex(1, i)) && MathUtil.fuzzy_eq(val, quad.posByIndex(2, i)) && MathUtil.fuzzy_eq(val, quad.posByIndex(3, i));
    }

    public static ForgeDirection lightFace(NdQuadBuilder quad) {
        Vector3f normal = quad.faceNormal;
        return GeometryHelper.coerceVector(normal);
    }

    private static ForgeDirection coerceVector(Vector3f v) {
        ForgeDirection forgeDirection;
        switch (GeometryHelper.longestAxis(v)) {
            case X: {
                if (v.x() > 0.0f) {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case Y: {
                if (v.y() > 0.0f) {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case Z: {
                if (v.z() > 0.0f) {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.UP;
            }
        }
        return forgeDirection;
    }

    public static Axis longestAxis(Vector3f vec) {
        return GeometryHelper.longestAxis(vec.x(), vec.y(), vec.z());
    }

    public static Axis longestAxis(float normalX, float normalY, float normalZ) {
        Axis result = Axis.Y;
        float longest = Math.abs(normalY);
        float a = Math.abs(normalX);
        if (a > longest) {
            result = Axis.X;
            longest = a;
        }
        return Math.abs(normalZ) > longest ? Axis.Z : result;
    }

    public static ForgeDirection rotate(ForgeDirection d, Matrix4f rotMat) {
        return GeometryHelper.rotate(d, rotMat, new Vector3f());
    }

    public static ForgeDirection rotate(ForgeDirection d, Matrix4f rotMat, Vector3f v) {
        return GeometryHelper.coerceVector(v.set(d.offsetX, d.offsetY, d.offsetZ).mulPosition(rotMat));
    }
}

