/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.immersivecavegen;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.tclproject.immersivecavegen.WGConfig;
import net.tclproject.immersivecavegen.blocks.BlockInit;
import net.tclproject.immersivecavegen.entities.EntityBrownSpider;
import net.tclproject.immersivecavegen.entities.EntityBrownSpiderLarge;
import net.tclproject.immersivecavegen.entities.EntityBrownSpiderSmall;
import net.tclproject.immersivecavegen.entities.EntityGlowSlime;
import net.tclproject.immersivecavegen.entities.EntityInit;
import net.tclproject.immersivecavegen.entities.ICaveEntity;
import net.tclproject.immersivecavegen.items.ItemInit;
import net.tclproject.immersivecavegen.misc.CraftInit;
import net.tclproject.immersivecavegen.world.CavesDecorator;
import net.tclproject.immersivecavegen.world.GenerateStoneStalactite;
import net.tclproject.mysteriumlib.network.BlockWebDestroy;
import net.tclproject.mysteriumlib.network.ICGMagicNetwork;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@Mod(modid="immersivecavegen", version="1.2g", name="Immersive Cavegen")
public class ImmersiveCavegen {
    public static final String MODID = "immersivecavegen";
    public static final String VERSION = "1.2g";
    public static Random rand = new Random();
    public static int giganticCaveChance;
    public Logger logger;
    @Mod.Instance(value="immersivecavegen")
    public static ImmersiveCavegen instance;
    ResourceLocation rc = new ResourceLocation("immersivecavegen:textures/custom.png");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        WGConfig.init(event.getModConfigurationDirectory().toString(), event);
        if (!WGConfig.serveronly) {
            BlockInit.init();
            ItemInit.init();
            if (WGConfig.enableEntities) {
                EntityInit.init();
                if (event.getSide().isClient()) {
                    EntityInit.clientInit();
                }
            }
        }
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        MinecraftForge.ORE_GEN_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String[] list;
        if (!WGConfig.serveronly) {
            CraftInit.init();
            ICGMagicNetwork.registerPackets();
        }
        String[] arr$ = list = "netherrack,stone,grass,dirt,cobblestone,gravel,gold_ore,iron_ore,coal_ore,lapis_ore,sandstone,diamond_ore,redstone_ore,lit_redstone_ore,ice,snow,clay,monster_egg,emerald_ore".split(",");
        int len = list.length;
        for (int i$ = 0; i$ < len; ++i$) {
            String txt = arr$[i$];
            try {
                Block block = (Block)GameData.getBlockRegistry().func_82594_a(txt.trim());
                if (block == null || block.func_149688_o() == Material.field_151579_a) continue;
                GenerateStoneStalactite.blockWhiteList.add(block);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        giganticCaveChance = WGConfig.giantCaveChance;
        CavesDecorator decor = new CavesDecorator();
        if (!WGConfig.serveronly && WGConfig.caveDecorations) {
            MinecraftForge.EVENT_BUS.register((Object)decor);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent e) {
        if (WGConfig.realisticCobwebs && e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && e.entityPlayer.func_70694_bm() != null && e.world.func_147439_a(e.x, e.y, e.z) == Blocks.field_150321_G && (e.entityPlayer.func_70694_bm().func_77973_b() == Items.field_151033_d || e.entityPlayer.func_70694_bm().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa))) {
            e.world.func_147465_d(e.x, e.y, e.z, Blocks.field_150350_a, 0, 3);
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.sendWebDestroyPacket(e.x, e.y, e.z);
            }
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.1, 0.1, 0.1);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.4f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.4f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.4f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("smoke", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.world.func_72869_a("flame", (double)((float)e.x + 0.5f), (double)((float)e.y + 0.5f), (double)((float)e.z + 0.5f), 0.0, 0.0, 0.0);
            e.entityPlayer.func_71038_i();
            e.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void sendWebDestroyPacket(int x, int y, int z) {
        ICGMagicNetwork.dispatcher.sendToServer((IMessage)new BlockWebDestroy(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderEvent(RenderPlayerEvent.Specials.Pre event) {
        try {
            EntityPlayer player = event.entityPlayer;
            if ("Nlghtwing".equalsIgnoreCase(player.getDisplayName())) {
                this.render(player);
            }
        }
        catch (Throwable var4) {
            var4.printStackTrace();
        }
    }

    private void render(EntityPlayer player) {
        if (!player.func_82150_aj()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.rc);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double d3 = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * 0.0625 - (player.field_70169_q + (player.field_70165_t - player.field_70169_q) * 0.0625);
            double d4 = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * 0.0625 - (player.field_70167_r + (player.field_70163_u - player.field_70167_r) * 0.0625);
            double d0 = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * 0.0625 - (player.field_70166_s + (player.field_70161_v - player.field_70166_s) * 0.0625);
            float f4 = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * 0.0625f;
            double d1 = MathHelper.func_76126_a((float)(f4 * (float)Math.PI / 180.0f));
            double d2 = -MathHelper.func_76134_b((float)(f4 * (float)Math.PI / 180.0f));
            float f5 = (float)d4 * 10.0f;
            if (f5 < -6.0f) {
                f5 = -6.0f;
            }
            if (f5 > 32.0f) {
                f5 = 32.0f;
            }
            float f6 = (float)(d3 * d1 + d0 * d2) * 100.0f;
            float f7 = (float)(d3 * d2 - d0 * d1) * 100.0f;
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            float f8 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * 0.0625f;
            f5 += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * 0.0625f) * 6.0f)) * 32.0f * f8;
            if (player.func_70093_af()) {
                f5 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + f6 / 2.0f + f5), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f7 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f7 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.getCapeModel().cape.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private CapeModel getCapeModel() {
        return new CapeModel();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerBlind(TickEvent.PlayerTickEvent event) {
        if (event.player.func_82114_b().field_71572_b < 35 && WGConfig.jumpscare && rand.nextFloat() > 0.99993f && !event.player.field_70170_p.field_72995_K && event.player.field_70170_p.field_73011_w.field_76577_b != WorldType.field_77138_c && !event.player.func_70644_a(Potion.field_76440_q)) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0, false));
            event.player.func_85030_a("random.fizz", 0.75f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onOreGen(OreGenEvent.GenerateMinable event) {
        if (event.type == OreGenEvent.GenerateMinable.EventType.DIRT && WGConfig.turnOffVanillaUndergroundDirt) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        WGConfig.loadConfiguration();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        WGConfig.loadConfiguration();
    }

    @SubscribeEvent
    public void onMapInit(InitMapGenEvent event) {
        WGConfig.loadConfiguration();
    }

    @SubscribeEvent
    public void onNoiseGenInit(InitNoiseGensEvent event) {
        WGConfig.loadConfiguration();
    }

    @SubscribeEvent
    public void onFMLNetworkJoin(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        WGConfig.loadConfiguration();
    }

    @SubscribeEvent
    public void onFMLNetworkLeave(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        WGConfig.loadConfiguration();
    }

    @SubscribeEvent
    public void entitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (!WGConfig.serveronly && event.world.field_73011_w.field_76577_b != WorldType.field_77138_c && event.y < 34.0f && WGConfig.enableEntities && event.getResult() != Event.Result.DENY && !(event.entity instanceof ICaveEntity) && rand.nextInt(WGConfig.mobSpawnChance) == 0) {
            BiomeGenBase biome = event.world.func_72807_a((int)event.x, (int)event.z);
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
                EntityGlowSlime entityToSpawn = new EntityGlowSlime(event.world);
                entityToSpawn.func_70012_b(event.x, event.y, event.z, rand.nextFloat() * 360.0f, 0.0f);
                event.world.func_72838_d((Entity)entityToSpawn);
            } else if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                float randomValue = rand.nextFloat();
                if ((double)randomValue < 0.5) {
                    EntityBrownSpiderSmall entityToSpawn = new EntityBrownSpiderSmall(event.world);
                    entityToSpawn.func_70012_b(event.x, event.y, event.z, rand.nextFloat() * 360.0f, 0.0f);
                    event.world.func_72838_d((Entity)entityToSpawn);
                } else if ((double)randomValue < 0.83) {
                    EntityBrownSpider entityToSpawn = new EntityBrownSpider(event.world);
                    entityToSpawn.func_70012_b(event.x, event.y, event.z, rand.nextFloat() * 360.0f, 0.0f);
                    event.world.func_72838_d((Entity)entityToSpawn);
                } else {
                    EntityBrownSpiderLarge entityToSpawn = new EntityBrownSpiderLarge(event.world);
                    entityToSpawn.func_70012_b(event.x, event.y, event.z, rand.nextFloat() * 360.0f, 0.0f);
                    event.world.func_72838_d((Entity)entityToSpawn);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CapeModel
    extends ModelBiped {
        public ModelRenderer cape;

        public CapeModel() {
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this.cape = new ModelRenderer((ModelBase)this, 0, 0);
            this.cape.func_78789_a(-5.0f, 0.0f, -1.0f, 10, 16, 1);
            this.cape.func_78793_a(0.0f, 0.0f, 2.0f);
            this.cape.func_78787_b(64, 32);
            this.setRotation(this.cape, 0.0f, 0.0f, 0.0f);
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
            this.cape.func_78785_a(f5);
        }

        private void setRotation(ModelRenderer model, float x, float y, float z) {
            model.field_78795_f = x;
            model.field_78796_g = y;
            model.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, entity);
        }
    }
}

