/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.immersivecavegen.world;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.tclproject.immersivecavegen.WGConfig;
import net.tclproject.immersivecavegen.blocks.BlockHugeGlowingMushroom;
import net.tclproject.immersivecavegen.blocks.BlockHugeGlowingMushroom2;
import net.tclproject.immersivecavegen.blocks.BlockInit;
import net.tclproject.immersivecavegen.world.GenerateStoneStalactite;
import net.tclproject.immersivecavegen.world.biomes.caves.GenerateFireCaves;
import net.tclproject.immersivecavegen.world.biomes.caves.GenerateIceCaves;
import net.tclproject.immersivecavegen.world.biomes.caves.GenerateJungleCaves;
import net.tclproject.immersivecavegen.world.biomes.caves.GenerateLivingCaves;
import net.tclproject.immersivecavegen.world.biomes.caves.GeneratePlainCaves;
import net.tclproject.immersivecavegen.world.biomes.caves.GenerateSandCaves;
import net.tclproject.immersivecavegen.world.biomes.caves.GenerateWaterCaves;
import net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesCave;

public class CavesDecorator {
    public static List freezable = Arrays.asList(Blocks.field_150348_b, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150349_c);
    public static int maxGenHeight = 80;
    public static int maxLength = 8;
    private static int timesPerChunck = 50;
    private static final GenerateJungleCaves jungleGen = new GenerateJungleCaves();
    private static final GenerateWaterCaves waterGen = new GenerateWaterCaves();
    private static final GenerateSandCaves sandGen = new GenerateSandCaves();
    private static final GeneratePlainCaves plainGen = new GeneratePlainCaves();
    private static final GenerateIceCaves iceGen = new GenerateIceCaves();
    private static final GenerateFireCaves fireGen = new GenerateFireCaves();
    private static final GenerateLivingCaves livingGen = new GenerateLivingCaves();

    @SubscribeEvent
    public void decorate(DecorateBiomeEvent.Post decorationEvent) {
        for (String str : WGConfig.dimblacklist) {
            if (decorationEvent.world == null || !String.valueOf(decorationEvent.world.field_73011_w.field_76574_g).equalsIgnoreCase(str)) continue;
            return;
        }
        this.generate(decorationEvent.rand, decorationEvent.chunkX + 8, decorationEvent.chunkZ + 8, decorationEvent.world);
    }

    public void generate(Random random, int blockX, int blockZ, World world) {
        if (MysteriumPatchesFixesCave.oceanAvg == -1) {
            int addedTimes = 1;
            int result = 0;
            int interResult = 0;
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    int Ycoord;
                    int Xcoord = blockX + i;
                    int Zcoord = blockZ + j;
                    if (world.field_73011_w.field_76575_d && !WGConfig.netherCaves) {
                        return;
                    }
                    if (!world.field_73011_w.field_76575_d) {
                        for (Ycoord = Math.min(world.func_72976_f(Xcoord, Zcoord) - 1, random.nextInt(maxGenHeight)); !(Ycoord <= 10 || GenerateStoneStalactite.blockWhiteList.contains(world.func_147439_a(Xcoord, Ycoord + 1, Zcoord)) && world.func_147437_c(Xcoord, Ycoord, Zcoord)); --Ycoord) {
                        }
                    } else {
                        Ycoord = Math.min(world.func_72976_f(Xcoord, Zcoord) - 1, random.nextInt(maxGenHeight));
                    }
                    if (Ycoord <= 10) continue;
                    interResult = CavesDecorator.getNumEmptyBlocks(world, Xcoord, Ycoord, Zcoord) / 2;
                    result += interResult;
                    if (interResult < 3) continue;
                    ++addedTimes;
                }
            }
            int finalResult = result / addedTimes;
            MysteriumPatchesFixesCave.oceanAvg = finalResult = finalResult >= 25 ? 25 - random.nextInt(10) : (finalResult <= 10 ? 10 + random.nextInt(7) : finalResult);
        }
        for (int i = 0; i < timesPerChunck; ++i) {
            int Ycoord;
            int Xcoord = blockX + random.nextInt(16);
            int Zcoord = blockZ + random.nextInt(16);
            if (world.field_73011_w.field_76575_d && !WGConfig.netherCaves) {
                return;
            }
            if (!world.field_73011_w.field_76575_d) {
                for (Ycoord = Math.min(world.func_72976_f(Xcoord, Zcoord) - 1, random.nextInt(maxGenHeight)); !(Ycoord <= 10 || GenerateStoneStalactite.blockWhiteList.contains(world.func_147439_a(Xcoord, Ycoord + 1, Zcoord)) && world.func_147437_c(Xcoord, Ycoord, Zcoord)); --Ycoord) {
                }
            } else {
                Ycoord = Math.min(world.func_72976_f(Xcoord, Zcoord) - 1, random.nextInt(maxGenHeight));
            }
            if (Ycoord <= 10 || !(random.nextFloat() < WGConfig.generationDensity)) continue;
            BiomeGenBase biome = world.func_72807_a(Xcoord, Zcoord);
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) && WGConfig.icaves) {
                iceGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                continue;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && WGConfig.lcaves) {
                livingGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                continue;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE) && WGConfig.fcaves) {
                fireGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                continue;
            }
            if (biome.field_76750_F > 1.5f && biome.field_76751_G < 0.1f && WGConfig.scaves) {
                sandGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                continue;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE) && WGConfig.jcaves) {
                jungleGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                continue;
            }
            if (!biome.func_76736_e() && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || !WGConfig.wcaves) {
                plainGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                continue;
            }
            waterGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
    }

    @Optional.Method(modid="etfuturum")
    public static boolean isBlockDeepslate(World world, int x, int y, int z) {
        return y < ConfigWorld.deepslateMaxY && ConfigWorld.deepslateGenerationMode == 0;
    }

    public static boolean shouldGenerateStone(World world, int origX, int origZ) {
        BiomeGenBase b;
        String str;
        int n;
        Chunk chunk;
        for (int p_72807_1_ = origX - 1; p_72807_1_ <= origX + 1; ++p_72807_1_) {
            if (p_72807_1_ == origX) continue;
            int p_72807_2_ = origZ;
            if (world.func_72899_e(p_72807_1_, 0, p_72807_2_)) {
                chunk = world.func_72938_d(p_72807_1_, p_72807_2_);
                try {
                    BiomeGenBase b2 = chunk.func_76591_a(p_72807_1_ & 0xF, p_72807_2_ & 0xF, world.field_73011_w.field_76578_c);
                    int count2 = 0;
                    String[] stringArray = WGConfig.secondYLevelList;
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        str = stringArray[i];
                        if (b2.field_76791_y.equalsIgnoreCase(str)) continue;
                        ++count2;
                    }
                    if (count2 == WGConfig.secondYLevelList.length) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                continue;
            }
            b = world.field_73011_w.field_76578_c.func_76935_a(p_72807_1_, p_72807_2_);
            int count = 0;
            String[] count2 = WGConfig.secondYLevelList;
            int n2 = count2.length;
            for (n = 0; n < n2; ++n) {
                String str2 = count2[n];
                if (b.field_76791_y.equalsIgnoreCase(str2)) continue;
                ++count;
            }
            if (count != WGConfig.secondYLevelList.length) continue;
            return true;
        }
        for (int p_72807_2_ = origZ - 1; p_72807_2_ <= origZ + 1; ++p_72807_2_) {
            if (p_72807_2_ == origZ) continue;
            int p_72807_1_ = origX;
            if (world.func_72899_e(p_72807_1_, 0, p_72807_2_)) {
                chunk = world.func_72938_d(p_72807_1_, p_72807_2_);
                try {
                    BiomeGenBase b3 = chunk.func_76591_a(p_72807_1_ & 0xF, p_72807_2_ & 0xF, world.field_73011_w.field_76578_c);
                    int count = 0;
                    String[] stringArray = WGConfig.secondYLevelList;
                    n = stringArray.length;
                    for (int str2 = 0; str2 < n; ++str2) {
                        str = stringArray[str2];
                        if (b3.field_76791_y.equalsIgnoreCase(str)) continue;
                        ++count;
                    }
                    if (count == WGConfig.secondYLevelList.length) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                continue;
            }
            b = world.field_73011_w.field_76578_c.func_76935_a(p_72807_1_, p_72807_2_);
            int count = 0;
            for (String str3 : WGConfig.secondYLevelList) {
                if (b.field_76791_y.equalsIgnoreCase(str3)) continue;
                ++count;
            }
            if (count != WGConfig.secondYLevelList.length) continue;
            return true;
        }
        return false;
    }

    public static void generateFloodedCaves(World world, Random random, int x, int y, int z) {
        int vary = CavesDecorator.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (world.func_147439_a(x, y - 1, z).func_149721_r() && WGConfig.waterCaves) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 3);
            return;
        }
    }

    public static void convertToSandType(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(5) + 3;
        int length = random.nextInt(5) + 3;
        int width = random.nextInt(5) + 3;
        int newX = x - length / 2;
        int newY = y + height / 2;
        int newZ = z - width / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < length; ++j) {
                for (int k = 0; k < width; ++k) {
                    if (CavesDecorator.weightedChoice(0.7f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f) != 1) continue;
                    IdentityHashMap<Block, Object> sandEquivalent = new IdentityHashMap<Block, Object>(8);
                    sandEquivalent.put(Blocks.field_150348_b, Blocks.field_150322_A);
                    sandEquivalent.put(Blocks.field_150346_d, Blocks.field_150354_m);
                    sandEquivalent.put(Blocks.field_150351_n, Blocks.field_150354_m);
                    Block aux = (Block)sandEquivalent.get(world.func_147439_a(newX + j, newY - i, newZ + k));
                    if (aux == null) continue;
                    world.func_147465_d(newX + j, newY - i, newZ + k, aux, 0, 2);
                }
            }
        }
    }

    public static boolean generateGlowcaps(World world, Random random, int x, int y, int z) {
        int vary = CavesDecorator.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (world.func_147439_a(x, y - 1, z).func_149662_c()) {
            int glowcapNum = CavesDecorator.randomChoice(0, 1, 2, 3);
            world.func_147465_d(x, y, z, BlockInit.cavePlantBlock, glowcapNum, 3);
            return true;
        }
        return false;
    }

    public static boolean generateSmallMushrooms(World world, Random random, int x, int y, int z) {
        int vary = CavesDecorator.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (world.func_147439_a(x, y - 1, z).func_149662_c()) {
            int glowcapNum = CavesDecorator.randomChoice(0, 1);
            world.func_147465_d(x, y, z, (Block)(glowcapNum == 0 ? Blocks.field_150338_P : Blocks.field_150337_Q), 0, 2);
            return true;
        }
        return false;
    }

    public static boolean generateVegetation(World world, Random random, int x, int y, int z, int vary) {
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (world.func_147439_a(x, y - 1, z).func_149662_c()) {
            BlockFlower flowerblock;
            int selection = CavesDecorator.randomChoice(0, 1, 2, 3);
            switch (selection) {
                case 0: {
                    flowerblock = Blocks.field_150328_O;
                    break;
                }
                case 1: {
                    flowerblock = Blocks.field_150327_N;
                    break;
                }
                case 2: {
                    flowerblock = Blocks.field_150330_I;
                    break;
                }
                case 3: {
                    flowerblock = Blocks.field_150329_H;
                    break;
                }
                default: {
                    flowerblock = Blocks.field_150329_H;
                }
            }
            world.func_147465_d(x, y, z, (Block)flowerblock, 0, 2);
            if (random.nextFloat() > 0.5f || flowerblock != Blocks.field_150330_I) {
                world.func_147465_d(x, y - 1, z, Blocks.field_150346_d, 0, 2);
            }
            if (WGConfig.livingCavesLush) {
                CavesDecorator.convertToLushType(world, random, x, y, z);
            }
            return true;
        }
        return false;
    }

    public static void convertToLushType(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(5) + 3;
        int length = random.nextInt(10) + 3;
        int width = random.nextInt(10) + 3;
        int newX = x - length / 2;
        int newY = y + height / 2;
        int newZ = z - width / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < length; ++j) {
                for (int k = 0; k < width; ++k) {
                    Block aux;
                    if (CavesDecorator.weightedChoice(0.8f, 0.2f, 0.0f, 0.0f, 0.0f, 0.0f) != 1 || (j == length - 1 || j == 0) && (k == width - 1 || k == 0) || !freezable.contains(aux = world.func_147439_a(newX + j, newY - i, newZ + k))) continue;
                    if (world.func_147437_c(newX + j, newY - i + 1, newZ + k)) {
                        BlockFlower flowerblock;
                        world.func_147465_d(newX + j, newY - i, newZ + k, (Block)Blocks.field_150349_c, 0, 2);
                        if (!(random.nextFloat() > 0.66f)) continue;
                        int selection = CavesDecorator.randomChoice(0, 1, 2, 3, 4, 5);
                        switch (selection) {
                            case 0: {
                                flowerblock = Blocks.field_150328_O;
                                break;
                            }
                            case 1: {
                                flowerblock = Blocks.field_150327_N;
                                break;
                            }
                            case 2: {
                                flowerblock = Blocks.field_150329_H;
                                break;
                            }
                            default: {
                                flowerblock = Blocks.field_150329_H;
                            }
                        }
                        world.func_147465_d(newX + j, newY - i + 1, newZ + k, (Block)flowerblock, 1, 2);
                        continue;
                    }
                    world.func_147465_d(newX + j, newY - i, newZ + k, Blocks.field_150346_d, 0, 2);
                }
            }
        }
    }

    public static boolean generateTree(World world, Random random, int x, int y, int z, int vary) {
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (WGConfig.livingCavesLush) {
            CavesDecorator.convertToLushType(world, random, x, y, z);
        }
        if (world.func_147439_a(x, y - 1, z).func_149662_c()) {
            if (random.nextFloat() > WGConfig.treeChance) {
                world.func_147465_d(x, y, z, Blocks.field_150364_r, 0, 2);
                world.func_147465_d(x, y + 1, z, Blocks.field_150364_r, 0, 2);
                if ((double)random.nextFloat() > 0.5) {
                    world.func_147465_d(x, y + 2, z, Blocks.field_150364_r, 0, 2);
                    if ((double)random.nextFloat() > 0.8) {
                        world.func_147465_d(x, y + 3, z, Blocks.field_150364_r, 0, 2);
                        if ((double)random.nextFloat() > 0.95) {
                            world.func_147465_d(x, y + 4, z, Blocks.field_150364_r, 0, 2);
                        }
                    }
                }
            } else {
                CavesDecorator.safeSetblock(world, x, y, z, Blocks.field_150364_r, 0, 2);
                CavesDecorator.safeSetblock(world, x, y + 1, z, Blocks.field_150364_r, 0, 2);
                CavesDecorator.surroundByLeaves(world, x, y + 1, z);
                if ((double)random.nextFloat() > 0.5) {
                    CavesDecorator.safeSetblock(world, x, y + 2, z, Blocks.field_150364_r, 0, 2);
                    CavesDecorator.surroundByLeaves(world, x, y + 2, z);
                    if ((double)random.nextFloat() > 0.7) {
                        CavesDecorator.safeSetblock(world, x, y + 3, z, Blocks.field_150364_r, 0, 2);
                        CavesDecorator.surroundByLeaves(world, x, y + 3, z);
                        if ((double)random.nextFloat() > 0.85) {
                            CavesDecorator.safeSetblock(world, x, y + 4, z, Blocks.field_150364_r, 0, 2);
                            CavesDecorator.surroundByLeaves(world, x, y + 4, z);
                            CavesDecorator.safeSetblock(world, x, y + 5, z, (Block)Blocks.field_150362_t, 0, 2);
                        } else {
                            CavesDecorator.safeSetblock(world, x, y + 4, z, (Block)Blocks.field_150362_t, 0, 2);
                        }
                    } else {
                        CavesDecorator.safeSetblock(world, x, y + 3, z, (Block)Blocks.field_150362_t, 0, 2);
                    }
                } else {
                    CavesDecorator.safeSetblock(world, x, y + 2, z, (Block)Blocks.field_150362_t, 0, 2);
                }
            }
            return true;
        }
        return false;
    }

    public static void surroundByLeaves(World world, int x, int y, int z) {
        CavesDecorator.safeSetblock(world, x + 1, y, z, (Block)Blocks.field_150362_t, 0, 2);
        CavesDecorator.safeSetblock(world, x - 1, y, z, (Block)Blocks.field_150362_t, 0, 2);
        CavesDecorator.safeSetblock(world, x, y, z - 1, (Block)Blocks.field_150362_t, 0, 2);
        CavesDecorator.safeSetblock(world, x, y, z + 1, (Block)Blocks.field_150362_t, 0, 2);
    }

    public static void safeSetblock(World world, int x, int y, int z, Block b, int meta, int flags) {
        if (world.func_147439_a(x, y, z).canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) {
            world.func_147465_d(x, y, z, b, meta, flags);
        }
    }

    public static void generateIceshrooms(World world, Random random, int x, int y, int z) {
        int vary = CavesDecorator.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (!world.func_147437_c(x, y - 1, z)) {
            if (!world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
                world.func_147465_d(x, y - 1, z, Blocks.field_150432_aD, 0, 2);
                world.func_147465_d(x, y, z, BlockInit.cavePlantBlock, CavesDecorator.randomChoice(0, 1, 4, 5), 3);
            }
            CavesDecorator.convertToFrozenType(world, random, x, y, z);
        }
    }

    public static void generateLavashrooms(World world, Random random, int x, int y, int z) {
        int vary = CavesDecorator.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (!world.func_147437_c(x, y - 1, z)) {
            if (!world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
                world.func_147465_d(x, y - 1, z, BlockInit.scorchedStone, 0, 2);
                world.func_147465_d(x, y, z, BlockInit.cavePlantBlock, CavesDecorator.randomChoice(0, 1, 6, 7), 3);
            }
            CavesDecorator.convertToLavaType(world, random, x, y, z);
        }
    }

    public static void generateIcicles(World world, Random random, int x, int y, int z, int distance) {
        world.func_147465_d(x, y + 1, z, Blocks.field_150432_aD, 0, 2);
        world.func_147465_d(x, y, z, BlockInit.iceStalactiteBlock, CavesDecorator.randomChoice(0, 1, 2), 3);
        CavesDecorator.convertToFrozenType(world, random, x, y, z);
        int botY = y - distance + 1;
        if (distance != 0 && !world.func_147439_a(x, botY, z).func_149688_o().func_76224_d()) {
            CavesDecorator.convertToFrozenType(world, random, x, botY, z);
        }
    }

    public static void generateMushrooms(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_, int distance) {
        boolean stone;
        if (p_76484_4_ > 56) {
            return;
        }
        int l = p_76484_2_.nextInt(2);
        boolean bl = stone = p_76484_2_.nextInt(5) > 2;
        if (distance != 0) {
            p_76484_4_ = p_76484_4_ - distance + 1;
        }
        if (!p_76484_1_.func_147437_c(p_76484_3_, p_76484_4_ - 1, p_76484_5_)) {
            int i1 = p_76484_2_.nextInt(3) + 4;
            boolean flag = true;
            if (p_76484_4_ >= 1 && p_76484_4_ + i1 + 1 < 256) {
                int l1;
                int k1;
                for (int j1 = p_76484_4_; j1 <= p_76484_4_ + 1 + i1; ++j1) {
                    int b0 = 3;
                    if (j1 <= p_76484_4_ + 3) {
                        b0 = 0;
                    }
                    for (k1 = p_76484_3_ - b0; k1 <= p_76484_3_ + b0 && flag; ++k1) {
                        for (l1 = p_76484_5_ - b0; l1 <= p_76484_5_ + b0 && flag; ++l1) {
                            if (j1 >= 0 && j1 < 256) {
                                Block block = p_76484_1_.func_147439_a(k1, j1, l1);
                                if (!block.isAir((IBlockAccess)p_76484_1_, k1, j1, l1) && !block.isLeaves((IBlockAccess)p_76484_1_, k1, j1, l1)) {
                                    flag = true;
                                }
                                if (!(block instanceof BlockHugeGlowingMushroom) && !(block instanceof BlockHugeGlowingMushroom2)) continue;
                                flag = false;
                                continue;
                            }
                            flag = true;
                        }
                    }
                }
                if (!flag) {
                    return;
                }
                Block block1 = p_76484_1_.func_147439_a(p_76484_3_, p_76484_4_ - 1, p_76484_5_);
                if (block1 != Blocks.field_150346_d && block1 != Blocks.field_150348_b && block1 != Blocks.field_150391_bh) {
                    return;
                }
                int k2 = p_76484_4_ + i1;
                if (l == 1) {
                    k2 = p_76484_4_ + i1 - 3;
                }
                for (k1 = k2; k1 <= p_76484_4_ + i1; ++k1) {
                    l1 = 1;
                    if (k1 < p_76484_4_ + i1) {
                        ++l1;
                    }
                    if (l == 0) {
                        l1 = 3;
                    }
                    for (int l2 = p_76484_3_ - l1; l2 <= p_76484_3_ + l1; ++l2) {
                        for (int i2 = p_76484_5_ - l1; i2 <= p_76484_5_ + l1; ++i2) {
                            int j2 = 5;
                            if (l2 == p_76484_3_ - l1) {
                                --j2;
                            }
                            if (l2 == p_76484_3_ + l1) {
                                ++j2;
                            }
                            if (i2 == p_76484_5_ - l1) {
                                j2 -= 3;
                            }
                            if (i2 == p_76484_5_ + l1) {
                                j2 += 3;
                            }
                            if (l == 0 || k1 < p_76484_4_ + i1) {
                                if ((l2 == p_76484_3_ - l1 || l2 == p_76484_3_ + l1) && (i2 == p_76484_5_ - l1 || i2 == p_76484_5_ + l1)) continue;
                                if (l2 == p_76484_3_ - (l1 - 1) && i2 == p_76484_5_ - l1) {
                                    j2 = 1;
                                }
                                if (l2 == p_76484_3_ - l1 && i2 == p_76484_5_ - (l1 - 1)) {
                                    j2 = 1;
                                }
                                if (l2 == p_76484_3_ + (l1 - 1) && i2 == p_76484_5_ - l1) {
                                    j2 = 3;
                                }
                                if (l2 == p_76484_3_ + l1 && i2 == p_76484_5_ - (l1 - 1)) {
                                    j2 = 3;
                                }
                                if (l2 == p_76484_3_ - (l1 - 1) && i2 == p_76484_5_ + l1) {
                                    j2 = 7;
                                }
                                if (l2 == p_76484_3_ - l1 && i2 == p_76484_5_ + (l1 - 1)) {
                                    j2 = 7;
                                }
                                if (l2 == p_76484_3_ + (l1 - 1) && i2 == p_76484_5_ + l1) {
                                    j2 = 9;
                                }
                                if (l2 == p_76484_3_ + l1 && i2 == p_76484_5_ + (l1 - 1)) {
                                    j2 = 9;
                                }
                            }
                            if (j2 == 5 && k1 < p_76484_4_ + i1) {
                                j2 = 0;
                            }
                            if (j2 == 0 && p_76484_4_ < p_76484_4_ + i1 - 1 || !p_76484_1_.func_147439_a(l2, k1, i2).canBeReplacedByLeaves((IBlockAccess)p_76484_1_, l2, k1, i2)) continue;
                            p_76484_1_.func_147465_d(l2, k1, i2, stone ? Blocks.field_150348_b : (l == 0 ? BlockInit.mushroomBlockBlue : BlockInit.mushroomBlockGreen), j2, 2);
                        }
                    }
                }
                for (k1 = 0; k1 < i1; ++k1) {
                    Block block2 = p_76484_1_.func_147439_a(p_76484_3_, p_76484_4_ + k1, p_76484_5_);
                    if (!block2.canBeReplacedByLeaves((IBlockAccess)p_76484_1_, p_76484_3_, p_76484_4_ + k1, p_76484_5_)) continue;
                    p_76484_1_.func_147465_d(p_76484_3_, p_76484_4_ + k1, p_76484_5_, stone ? Blocks.field_150348_b : (l == 0 ? BlockInit.mushroomBlockBlue : BlockInit.mushroomBlockGreen), 10, 2);
                }
                return;
            }
            return;
        }
    }

    public static void generateSkulls(World world, Random random, int x, int y, int z, int numEmptyBlocks) {
        int auxY;
        if (numEmptyBlocks > 0 && CavesDecorator.noLiquidUnderneath(world, x, y - numEmptyBlocks + 1, z) && (auxY = y - numEmptyBlocks + 1) > 0 && numEmptyBlocks > 0) {
            world.func_147465_d(x, auxY, z, Blocks.field_150465_bP, 1, 3);
            TileEntity skullTE = world.func_147438_o(x, auxY, z);
            if (skullTE instanceof TileEntitySkull) {
                ((TileEntitySkull)skullTE).func_145903_a(random.nextInt(360));
            }
        }
    }

    public static void generateGlowLily(World world, Random random, int x, int y, int z, int numEmptyBlocks) {
        if (CavesDecorator.isGoodForLily(world, x, y - numEmptyBlocks, z)) {
            world.func_147465_d(x, y - numEmptyBlocks + 1, z, random.nextFloat() > 0.5f ? BlockInit.glowLily : BlockInit.glowLilyBlue, 0, 2);
        }
    }

    public static void generateLily(World world, Random random, int x, int y, int z, int numEmptyBlocks) {
        if (world.func_147439_a(x, y - numEmptyBlocks, z) == Blocks.field_150355_j) {
            world.func_147449_b(x, y - numEmptyBlocks + 1, z, Blocks.field_150392_bi);
        }
    }

    public static boolean isGoodForLily(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h && world.func_72805_g(x, y, z) == 0 && (world.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151586_h && world.func_72805_g(x + 1, y, z) == 0 || world.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151586_h && world.func_72805_g(x - 1, y, z) == 0);
    }

    public static boolean noLiquidUnderneath(World world, int x, int y, int z) {
        return !(world.func_147439_a(x, y - 1, z) instanceof BlockLiquid);
    }

    public static void generateVines(World world, Random random, int x, int y, int z) {
        int distance = CavesDecorator.getNumEmptyBlocks(world, x, y, z);
        int aux = distance > 5 ? random.nextInt(distance - 5) + 5 : distance;
        int side = random.nextInt(4) + 2;
        for (int i = 0; i < aux && !world.func_147439_a(x, y - i, z).func_149688_o().func_76224_d(); ++i) {
            world.func_147465_d(x, y - i, z, Blocks.field_150395_bd, 1 << Direction.field_71579_d[side], 0);
        }
    }

    public static int getNumEmptyBlocks(World world, int x, int y, int z) {
        int dist = 0;
        while (y > 5 && !world.func_147445_c(x, y, z, true) && world.func_147437_c(x, y, z)) {
            --y;
            ++dist;
        }
        return dist;
    }

    public static void convertToFrozenType(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(5) + 3;
        int length = random.nextInt(5) + 3;
        int width = random.nextInt(5) + 3;
        int newX = x - length / 2;
        int newY = y + height / 2;
        int newZ = z - width / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < length; ++j) {
                for (int k = 0; k < width; ++k) {
                    Block aux;
                    if (CavesDecorator.weightedChoice(0.8f, 0.2f, 0.0f, 0.0f, 0.0f, 0.0f) != 1 || !freezable.contains(aux = world.func_147439_a(newX + j, newY - i, newZ + k))) continue;
                    world.func_147465_d(newX + j, newY - i, newZ + k, Blocks.field_150432_aD, 0, 2);
                }
            }
        }
    }

    public static void convertToLavaType(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(5) + 3;
        int length = random.nextInt(5) + 3;
        int width = random.nextInt(5) + 3;
        int newX = x - length / 2;
        int newY = y + height / 2;
        int newZ = z - width / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < length; ++j) {
                for (int k = 0; k < width; ++k) {
                    Block aux;
                    if (CavesDecorator.weightedChoice(0.8f, 0.2f, 0.0f, 0.0f, 0.0f, 0.0f) != 1 || !freezable.contains(aux = world.func_147439_a(newX + j, newY - i, newZ + k)) || world.func_147437_c(newX + j, newY - i + 1, newZ + k)) continue;
                    world.func_147465_d(newX + j, newY - i, newZ + k, BlockInit.scorchedStone, 0, 2);
                }
            }
        }
    }

    public static int randomChoice(int ... val) {
        Random random = new Random();
        return val[random.nextInt(val.length)];
    }

    public static int weightedChoice(String[] values) {
        if (values.length != 6) {
            throw new RuntimeException("Incorrect amount of arguments into weightedChoice! Must be 6!");
        }
        float[] fResult = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            fResult[i] = Float.parseFloat(values[i]);
        }
        return CavesDecorator.weightedChoice(fResult[0], fResult[1], fResult[2], fResult[3], fResult[4], fResult[5]);
    }

    public static int weightedChoice(float par1, float par2, float par3, float par4, float par5, float par6) {
        float total = par1 + par2 + par3 + par4 + par5 + par6;
        float val = new Random().nextFloat();
        par1 /= total;
        par2 /= total;
        par3 /= total;
        par4 /= total;
        par5 /= total;
        if (val < par1) {
            return 1;
        }
        if (val < par2 + par1) {
            return 2;
        }
        float previous = par1 + par2;
        if (val < par3 + previous) {
            return 3;
        }
        if (val < par4 + (previous += par3)) {
            return 4;
        }
        return val < par5 + (previous += par4) ? 5 : 6;
    }

    public static void generateScorchedLavaStone(World world, Random random, int x, int y, int z, int distance) {
        if (world.func_147439_a(x, y - 1, z).func_149721_r()) {
            world.func_147449_b(x, y - 1, z, BlockInit.scorchedLavaStone);
        } else if (world.func_147439_a(x, y - distance, z).func_149721_r()) {
            world.func_147449_b(x, y - distance, z, BlockInit.scorchedLavaStone);
        }
    }
}

