/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.lang.reflect.Field;
import java.util.Map;
import net.tclproject.mysteriumlib.asm.common.CustomClassTransformer;
import net.tclproject.mysteriumlib.asm.common.FirstClassTransformer;
import net.tclproject.mysteriumlib.asm.common.MinecraftMetaReader;
import net.tclproject.mysteriumlib.asm.core.ASMFix;
import net.tclproject.mysteriumlib.asm.core.MetaReader;
import net.tclproject.mysteriumlib.asm.core.TargetClassTransformer;
import org.apache.logging.log4j.Level;

@IFMLLoadingPlugin.TransformerExclusions(value={"net.tclproject"})
public class CustomLoadingPlugin
implements IFMLLoadingPlugin {
    private static DeobfuscationTransformer deobfuscationTransformer;
    private static boolean checkedObfuscation;
    private static boolean obfuscated;
    private static MetaReader mcMetaReader;

    public static TargetClassTransformer getTransformer() {
        return FirstClassTransformer.instance.registeredBuiltinFixes ? CustomClassTransformer.instance : FirstClassTransformer.instance;
    }

    public static void registerFix(ASMFix fix) {
        CustomLoadingPlugin.getTransformer().registerFix(fix);
    }

    public static void registerClassWithFixes(String className) {
        CustomLoadingPlugin.getTransformer().registerClassWithFixes(className);
    }

    public static MetaReader getMetaReader() {
        return mcMetaReader;
    }

    static DeobfuscationTransformer getDeobfuscationTransformer() {
        if (CustomLoadingPlugin.isObfuscated() && deobfuscationTransformer == null) {
            deobfuscationTransformer = new DeobfuscationTransformer();
        }
        return deobfuscationTransformer;
    }

    public static boolean isObfuscated() {
        if (!checkedObfuscation) {
            try {
                Field deobfuscatedField = CoreModManager.class.getDeclaredField("deobfuscatedEnvironment");
                deobfuscatedField.setAccessible(true);
                obfuscated = !deobfuscatedField.getBoolean(null);
            }
            catch (Exception e) {
                FMLLog.log((String)"Mysterium Patches", (Level)Level.ERROR, (String)"Error occured when checking obfuscation.", (Object[])new Object[0]);
                FMLLog.log((String)"Mysterium Patches", (Level)Level.ERROR, (String)"THIS IS MOST LIKELY HAPPENING BECAUSE OF MOD CONFLICTS. PLEASE CONTACT ME TO LET ME KNOW.", (Object[])new Object[0]);
                FMLLog.log((String)"Mysterium Patches", (Level)Level.ERROR, (String)e.getMessage(), (Object[])new Object[0]);
            }
            checkedObfuscation = true;
        }
        return obfuscated;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        this.registerFixes();
    }

    public void registerFixes() {
    }

    static {
        mcMetaReader = new MinecraftMetaReader();
    }
}

