/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.fixes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import net.tclproject.mysteriumlib.asm.common.CustomLoadingPlugin;
import net.tclproject.mysteriumlib.asm.common.FirstClassTransformer;

public class MysteriumPatchesFixLoaderB
extends CustomLoadingPlugin {
    @Override
    public String[] getASMTransformerClass() {
        return new String[]{FirstClassTransformer.class.getName()};
    }

    @Override
    public void registerFixes() {
        ArrayList<String> lines2 = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(new File("."), "config/immersivecavegen.cfg")));
            String line = br.readLine();
            while (line != null) {
                lines2.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception br) {
            // empty catch block
        }
        boolean oldGen = false;
        boolean mineshafts = true;
        boolean sand = true;
        boolean caverns = true;
        boolean popChanges = true;
        for (String str : lines2) {
            if (str.contains("\"Old Cave Gen\"=true")) {
                oldGen = true;
            }
            if (str.contains("\"Enable Better Mineshafts\"=false")) {
                mineshafts = false;
            }
            if (str.contains("\"Enable Better Sand Generation\"=false")) {
                sand = false;
            }
            if (str.contains("\"Enable Caverns Replacer\"=false")) {
                caverns = false;
            }
            if (!str.contains("\"Enable World Population Changes\"=false")) continue;
            popChanges = false;
        }
        if (!oldGen) {
            if (mineshafts) {
                MysteriumPatchesFixLoaderB.registerClassWithFixes("net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesB");
            }
            if (sand) {
                MysteriumPatchesFixLoaderB.registerClassWithFixes("net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesSand");
            }
            if (caverns) {
                MysteriumPatchesFixLoaderB.registerClassWithFixes("net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesRavine");
            }
            if (popChanges) {
                MysteriumPatchesFixLoaderB.registerClassWithFixes("net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesPop");
            }
            MysteriumPatchesFixLoaderB.registerClassWithFixes("net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesCave");
        } else if (oldGen) {
            MysteriumPatchesFixLoaderB.registerClassWithFixes("net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesOld");
        }
    }
}

