/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.fixes;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.tclproject.mysteriumlib.asm.annotations.EnumReturnSetting;
import net.tclproject.mysteriumlib.asm.annotations.Fix;

public class MysteriumPatchesFixesB {
    private static final Random caveRNG = new Random();
    private static final Random largeCaveRNG = new Random();
    private static final Random spawnRNG = new Random();
    private static long seedMultiplier;
    private static long regionalCaveSeedMultiplier;
    private static long colossalCaveSeedMultiplier;
    private static int caveOffsetX;
    private static int caveOffsetZ;
    private static int mineshaftOffsetX;
    private static Random rand;
    private static World worldObj;
    private static int mineshaftOffsetZ;
    private static double field_82673_e;
    private static final int caveLimit = 18;
    private static boolean isInitialized;

    private static void initialize() {
        int x;
        int z;
        int i;
        isInitialized = true;
        rand.setSeed(worldObj.func_72905_C());
        seedMultiplier = rand.nextLong() / 2L * 2L + 1L;
        caveOffsetX = rand.nextInt(128) + 2000000;
        caveOffsetZ = rand.nextInt(128) + 2000000;
        mineshaftOffsetX = rand.nextInt(7) + 2000000;
        mineshaftOffsetZ = rand.nextInt(7) + 2000000;
        int range = 66;
        block0: for (i = 0; i < 100; i += 2) {
            colossalCaveSeedMultiplier = seedMultiplier + (long)i;
            for (z = -range; z <= range; ++z) {
                for (x = -range; x <= range; ++x) {
                    if (MysteriumPatchesFixesB.validColossalCaveLocation(x, z, x * x + z * z)) break block0;
                }
            }
        }
        for (i = 0; i < 100; i += 2) {
            regionalCaveSeedMultiplier = seedMultiplier + (long)i;
            for (z = -range; z <= range; z += 12) {
                for (x = -range; x <= range; x += 12) {
                    if (!MysteriumPatchesFixesB.validRegionalCaveLocation(x, z, x * x + z * z) || !MysteriumPatchesFixesB.isGiantCaveRegion(x, z)) continue;
                    return;
                }
            }
        }
    }

    @Fix(returnSetting=EnumReturnSetting.ALWAYS)
    public static boolean canSpawnStructureAtCoords(MapGenMineshaft m, int chunkX, int chunkZ) {
        rand = m.field_75038_b;
        worldObj = m.field_75039_c;
        if (!isInitialized) {
            MysteriumPatchesFixesB.initialize();
        }
        if (chunkX == 0 && chunkZ == 0) {
            return false;
        }
        int chunkOffX = chunkX + mineshaftOffsetX;
        int chunkOffZ = chunkZ + mineshaftOffsetZ;
        if ((chunkOffX / 7 & 1) == (chunkOffZ / 7 & 1)) {
            return false;
        }
        int chunkModX = chunkOffX % 7;
        int chunkModZ = chunkOffZ % 7;
        if (chunkModX <= 2 && chunkModZ <= 2) {
            spawnRNG.setSeed(((long)(chunkOffX / 7) * 341873128712L + (long)(chunkOffZ / 7) * 132897987541L) * seedMultiplier);
            if (chunkModX == spawnRNG.nextInt(3) && chunkModZ == spawnRNG.nextInt(3)) {
                rand.setSeed(((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L) * seedMultiplier);
                int distance = Math.abs(chunkX) < 64 && Math.abs(chunkZ) < 64 ? chunkX * chunkX + chunkZ * chunkZ : 4096;
                return MysteriumPatchesFixesB.caveCheck(m, chunkX, chunkZ, distance);
            }
        }
        return false;
    }

    private static boolean caveCheck(MapGenMineshaft m, int chunkX, int chunkZ, int distance) {
        int radius = 6;
        boolean colossalCaveR2 = true;
        int caveR2 = 17;
        int centerR2 = 4;
        int caveCount1 = 0;
        int caveCount2 = 0;
        int caveCount3 = 0;
        int caveCount4 = 0;
        int caveCount5 = 0;
        float totalWidth = 0.0f;
        boolean flag = distance < 4096;
        for (int z = -radius; z <= radius; ++z) {
            int cz = chunkZ + z;
            for (int x = -radius; x <= radius; ++x) {
                float widthMultiplier;
                int circularRoomChance;
                int var39;
                int largeCaveChance;
                int x2z2 = x * x + z * z;
                if (x2z2 > 37) continue;
                int cx = chunkX + x;
                if (flag) {
                    distance = cx * cx + cz * cz;
                }
                if (MysteriumPatchesFixesB.validColossalCaveLocation(cx, cz, distance)) {
                    return false;
                }
                int chunkOffX = cx + caveOffsetX + 4;
                int chunkOffZ = cz + caveOffsetZ + 4;
                if (distance >= 1024) {
                    spawnRNG.setSeed(((long)cx * 341873128712L + (long)cz * 132897987541L) * seedMultiplier);
                    if (spawnRNG.nextInt(20) == 15) {
                        int caveSize = 0;
                        if ((chunkOffX & 7) == 0 && (chunkOffZ & 7) == 0 && (chunkOffX & 8) != (chunkOffZ & 8)) {
                            caveSize = 2;
                        } else if (spawnRNG.nextInt(25) < 19 && chunkOffX % 3 == 0 && chunkOffZ % 3 == 0 && (chunkOffX / 3 & 1) == (chunkOffZ / 3 & 1)) {
                            caveSize = 1;
                        }
                        if (caveSize > 0) {
                            spawnRNG.nextInt(spawnRNG.nextInt(50) + 8);
                            spawnRNG.nextFloat();
                            spawnRNG.nextFloat();
                            float applyCaveVariation = spawnRNG.nextFloat() * 4.0f + spawnRNG.nextFloat() * 2.0f;
                            if (spawnRNG.nextInt(4) == 0) {
                                applyCaveVariation += spawnRNG.nextFloat() * (caveSize != 1 && applyCaveVariation < 2.0f ? 0.0f : 2.0f);
                            }
                            largeCaveChance = 112 - spawnRNG.nextInt(15) * 2;
                            if (spawnRNG.nextInt(3) == 0) {
                                spawnRNG.nextInt(3);
                            }
                            largeCaveChance += spawnRNG.nextInt(64) * 2;
                            if (applyCaveVariation < 2.0f && (applyCaveVariation += 1.0f) < 2.0f) {
                                applyCaveVariation += 1.0f;
                            }
                            applyCaveVariation *= spawnRNG.nextFloat() * spawnRNG.nextFloat() * 1.5f + 1.0f;
                            if (caveSize == 2) {
                                applyCaveVariation += spawnRNG.nextFloat() * (float)((largeCaveChance += 80 + spawnRNG.nextInt(40) * 2) / 56) + 3.0f;
                            }
                            if (largeCaveChance > 160 || x2z2 <= caveR2) {
                                totalWidth += applyCaveVariation;
                                if (applyCaveVariation > 10.0f || totalWidth > 30.0f) {
                                    return false;
                                }
                            }
                        }
                    }
                    if ((chunkOffX & 7) == 0 && (chunkOffZ & 7) == 0 && (chunkOffX & 8) == (chunkOffZ & 8)) {
                        spawnRNG.setSeed(((long)cx * 341873128712L + (long)cz * 132897987541L) * seedMultiplier);
                        if (spawnRNG.nextInt(15) == 0 && spawnRNG.nextInt(spawnRNG.nextInt(spawnRNG.nextInt(40) + 1) + 1) > 0) {
                            largeCaveRNG.setSeed(spawnRNG.nextLong());
                            float var38 = MysteriumPatchesFixesB.getLargeCaveWidth(cx, cz, 0);
                            totalWidth += var38;
                            if (var38 > 18.0f || totalWidth > 30.0f) {
                                return false;
                            }
                        }
                    }
                }
                if (x2z2 > caveR2) continue;
                if (MysteriumPatchesFixesB.validStrongholdLocation(cx, cz, distance)) {
                    return false;
                }
                if (MysteriumPatchesFixesB.validSpecialCaveLocation(cx, cz, distance) > 0) {
                    return false;
                }
                if (MysteriumPatchesFixesB.isGiantCaveRegion(cx, cz) && MysteriumPatchesFixesB.validRegionalCaveLocation(cx, cz, distance)) {
                    return false;
                }
                spawnRNG.setSeed(((long)cx * 341873128712L + (long)cz * 132897987541L) * seedMultiplier);
                if (spawnRNG.nextInt(15) != 0 || (var39 = spawnRNG.nextInt(spawnRNG.nextInt(spawnRNG.nextInt(40) + 1) + 1)) <= 0) continue;
                boolean var40 = false;
                largeCaveChance = -1;
                long regionSeed = 0L;
                if (distance >= 1024) {
                    caveRNG.setSeed(((long)(chunkOffX / 16) * 341873128712L + (long)(chunkOffZ / 16) * 132897987541L) * seedMultiplier);
                    largeCaveRNG.setSeed(spawnRNG.nextLong());
                    if (caveRNG.nextInt(4) != 0) {
                        largeCaveChance = (1 << caveRNG.nextInt(3)) - 1;
                        var40 = true;
                        regionSeed = caveRNG.nextLong();
                    }
                    if ((chunkOffX & 7) == 0 && (chunkOffZ & 7) == 0 && (chunkOffX & 8) == (chunkOffZ & 8)) {
                        return false;
                    }
                    if (var39 <= 3 && largeCaveRNG.nextInt(4) <= largeCaveChance && MysteriumPatchesFixesB.validLargeCaveLocation(cx, cz, var39) > 0) {
                        int largerCircularRooms = 1;
                        if (largeCaveRNG.nextInt(10) == 0) {
                            largerCircularRooms += 1 + largeCaveRNG.nextInt(3);
                        }
                        for (circularRoomChance = 0; circularRoomChance < largerCircularRooms; ++circularRoomChance) {
                            widthMultiplier = MysteriumPatchesFixesB.getLargeCaveWidth(cx, cz, 1);
                            totalWidth += widthMultiplier;
                            if (!(widthMultiplier > 10.0f) && !(totalWidth > 30.0f)) continue;
                            return false;
                        }
                    }
                }
                boolean var41 = false;
                circularRoomChance = 4;
                largeCaveChance = 10;
                widthMultiplier = 1.0f;
                int multiplier = 1;
                if (var40) {
                    caveRNG.setSeed(regionSeed);
                    if (var39 < 20) {
                        var41 = caveRNG.nextBoolean();
                        circularRoomChance = 2 << caveRNG.nextInt(2) + caveRNG.nextInt(2);
                        caveRNG.nextBoolean();
                        largeCaveChance = 5 << caveRNG.nextInt(2) + caveRNG.nextInt(2);
                    }
                    if (caveRNG.nextBoolean()) {
                        widthMultiplier += caveRNG.nextFloat();
                        if (caveRNG.nextBoolean()) {
                            widthMultiplier /= 2.0f;
                        }
                    }
                    if (caveRNG.nextBoolean()) {
                        caveRNG.nextBoolean();
                        if (spawnRNG.nextBoolean()) {
                            spawnRNG.nextFloat();
                        }
                    }
                    if (var39 >= 20) {
                        float caves = var39 / 10;
                        widthMultiplier = (widthMultiplier + caves - 1.0f) / caves;
                    }
                    if (var39 >= 10) {
                        if (widthMultiplier > 1.5f) {
                            var39 = var39 / 2 + 1;
                            multiplier = 3;
                        } else if (widthMultiplier > 1.25f) {
                            var39 = var39 * 3 / 4 + 1;
                            multiplier = 2;
                        }
                    }
                }
                int var42 = 0;
                for (int i = 0; i < var39; ++i) {
                    int j;
                    spawnRNG.nextInt(16);
                    int y = spawnRNG.nextInt(spawnRNG.nextInt(120) + 8);
                    spawnRNG.nextInt(16);
                    int caves2 = 1;
                    if (spawnRNG.nextInt(circularRoomChance) == 0) {
                        j = spawnRNG.nextInt(4);
                        caves2 += j;
                        float width = spawnRNG.nextFloat() * 6.0f + 1.0f;
                        if (var41 && spawnRNG.nextInt(16 / circularRoomChance) == 0 && (width = width * (spawnRNG.nextFloat() * spawnRNG.nextFloat() + 1.0f) + 3.0f) > 8.5f) {
                            caves2 += 2;
                        }
                        if (widthMultiplier >= 1.0f) {
                            width *= widthMultiplier;
                            if (j == 0 && width > 10.0f && width < 17.0f) {
                                float f = (width - 10.0f) / 7.0f;
                                width *= spawnRNG.nextFloat() * (1.0f - f) + 1.0f + f;
                            }
                        }
                        if (width > 15.5f) {
                            totalWidth += width / 2.0f;
                            if (width > 23.5f || totalWidth > 30.0f) {
                                return false;
                            }
                        }
                        spawnRNG.nextLong();
                    }
                    spawnRNG.nextFloat();
                    if (y > 10 && y < 60) {
                        var42 += caves2 * multiplier;
                    }
                    for (j = 0; j < caves2; ++j) {
                        spawnRNG.nextFloat();
                        spawnRNG.nextFloat();
                        if (spawnRNG.nextInt(largeCaveChance) == 0) {
                            spawnRNG.nextFloat();
                            spawnRNG.nextFloat();
                        }
                        if (j > 0) {
                            spawnRNG.nextFloat();
                        }
                        spawnRNG.nextLong();
                        spawnRNG.nextFloat();
                    }
                }
                if (x < 0) {
                    m.getClass();
                    if ((caveCount1 += var42) > 18) {
                        return false;
                    }
                } else if (x > 0) {
                    m.getClass();
                    if ((caveCount2 += var42) > 18) {
                        return false;
                    }
                }
                if (z < 0) {
                    m.getClass();
                    if ((caveCount3 += var42) > 18) {
                        return false;
                    }
                } else if (z > 0) {
                    m.getClass();
                    if ((caveCount4 += var42) > 18) {
                        return false;
                    }
                }
                if (x2z2 > centerR2) continue;
                m.getClass();
                if ((caveCount5 += var42) <= 12) continue;
                return false;
            }
        }
        return true;
    }

    private static float getLargeCaveWidth(int chunkX, int chunkZ, int type) {
        if (type == 0) {
            int length = 224 + largeCaveRNG.nextInt(113);
            float width = largeCaveRNG.nextFloat() * 8.0f + largeCaveRNG.nextFloat() * 6.0f + 10.0f;
            if (largeCaveRNG.nextBoolean()) {
                width *= (float)length / 224.0f;
            }
            return width * ((float)length / 336.0f);
        }
        int length = Math.min(112 + largeCaveRNG.nextInt(largeCaveRNG.nextInt(336) + 1), 336);
        caveRNG.setSeed(((long)((chunkX + caveOffsetX + 12) / 16) * 341873128712L + (long)((chunkZ + caveOffsetZ + 12) / 16) * 132897987541L) * seedMultiplier);
        float width = largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat();
        width = caveRNG.nextBoolean() ? width * 8.0f + 2.0f : width * 2.66667f + 2.66667f;
        if (largeCaveRNG.nextBoolean()) {
            float multiplier = largeCaveRNG.nextFloat() * (float)length / 96.0f + (float)(672 - length) / 672.0f;
            if (multiplier > 1.0f) {
                width *= multiplier;
            }
        } else {
            float multiplier = largeCaveRNG.nextFloat();
            width *= multiplier * multiplier * 3.0f + 1.0f;
        }
        largeCaveRNG.nextInt(16);
        largeCaveRNG.nextInt(length / 4);
        largeCaveRNG.nextFloat();
        largeCaveRNG.nextLong();
        largeCaveRNG.nextFloat();
        return width;
    }

    private static boolean validStrongholdLocation(int chunkX, int chunkZ, int distance) {
        if (((chunkX += caveOffsetX) & 0x40) != ((chunkZ += caveOffsetZ) & 0x40)) {
            return false;
        }
        caveRNG.setSeed(((long)(chunkX / 64) * 341873128712L + (long)(chunkZ / 64) * 132897987541L) * seedMultiplier);
        return (chunkX & 0x3F) == caveRNG.nextInt(32) && (chunkZ & 0x3F) == caveRNG.nextInt(32) && distance >= 1600;
    }

    private static boolean validColossalCaveLocation(int chunkX, int chunkZ, int distance) {
        if (((chunkX += caveOffsetX) & 0x40) == ((chunkZ += caveOffsetZ) & 0x40)) {
            return false;
        }
        caveRNG.setSeed(((long)(chunkX / 64) * 341873128712L + (long)(chunkZ / 64) * 132897987541L) * colossalCaveSeedMultiplier);
        return (chunkX & 0x3F) == caveRNG.nextInt(32) && (chunkZ & 0x3F) == caveRNG.nextInt(32) && distance >= 1600;
    }

    private static int validSpecialCaveLocation(int chunkX, int chunkZ, int distance) {
        if (distance >= 1024) {
            int offsetX = chunkX + caveOffsetX + 1;
            int offsetZ = chunkZ + caveOffsetZ + 1;
            if ((offsetX & 7) <= 2 && (offsetZ & 7) <= 2) {
                int d = MysteriumPatchesFixesB.validSpecialCaveLocation2(offsetX, offsetZ);
                if (d != 0) {
                    return d;
                }
                caveRNG.setSeed(((long)((offsetX -= 16) / 32) * 341873128712L + (long)((offsetZ -= 16) / 32) * 132897987541L) * seedMultiplier);
                if ((offsetX & 0x1F) == caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3) && (offsetZ & 0x1F) == caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3)) {
                    boolean flag = distance < 5041;
                    for (int z = -7; z <= 7; ++z) {
                        int cz = chunkZ + z;
                        for (int x = -7; x <= 7; ++x) {
                            int x2z2 = x * x + z * z;
                            if (x2z2 > 50) continue;
                            int cx = chunkX + x;
                            if (flag) {
                                distance = cx * cx + cz * cz;
                            }
                            if (MysteriumPatchesFixesB.validColossalCaveLocation(cx, cz, distance)) {
                                return 0;
                            }
                            if (x2z2 > 37) continue;
                            if (MysteriumPatchesFixesB.validStrongholdLocation(cx, cz, distance)) {
                                return 0;
                            }
                            if (x2z2 > 24) continue;
                            if (MysteriumPatchesFixesB.validRegionalCaveLocation(cx, cz, distance)) {
                                return 0;
                            }
                            if (x2z2 <= 0 || x2z2 > 17 || MysteriumPatchesFixesB.validSpecialCaveLocation2(cx + caveOffsetX + 1, cz + caveOffsetZ + 1) == 0) continue;
                            return 0;
                        }
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    private static int validSpecialCaveLocation2(int offsetX, int offsetZ) {
        int z;
        int x;
        caveRNG.setSeed(((long)(offsetX / 64) * 341873128712L + (long)(offsetZ / 64) * 132897987541L) * regionalCaveSeedMultiplier);
        if (caveRNG.nextBoolean()) {
            x = caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3);
            z = caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40;
        } else {
            x = caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40;
            z = caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3);
        }
        return (offsetX & 0x3F) == x && (offsetZ & 0x3F) == z ? 4 : ((offsetX & 0x3F) == caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40 && (offsetZ & 0x3F) == caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40 ? 5 : 0);
    }

    private static boolean validRegionalCaveLocation(int chunkX, int chunkZ, int distance) {
        int offsetZ;
        int offsetX;
        int x1 = chunkX;
        int z1 = chunkZ;
        caveRNG.setSeed(((long)((chunkX += caveOffsetX) / 64) * 341873128712L + (long)((chunkZ += caveOffsetZ) / 64) * 132897987541L) * regionalCaveSeedMultiplier);
        chunkX &= 0x3F;
        chunkZ &= 0x3F;
        if (caveRNG.nextBoolean()) {
            offsetX = caveRNG.nextInt(9) + 38;
            offsetZ = caveRNG.nextInt(21);
        } else {
            offsetX = caveRNG.nextInt(21);
            offsetZ = caveRNG.nextInt(9) + 38;
        }
        if (chunkX >= offsetX && chunkX <= offsetX + 11 && chunkZ >= offsetZ && chunkZ <= offsetZ + 11) {
            if (distance < 4096) {
                int x2 = (x1 -= chunkX - offsetX) + 11;
                int z2 = (z1 -= chunkZ - offsetZ) + 11;
                x1 *= x1;
                z1 *= z1;
                x2 *= x2;
                z2 *= z2;
                if (x1 + z1 < 1024 || x2 + z1 < 1024 || x1 + z2 < 1024 || x2 + z2 < 1024) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isGiantCaveRegion(int chunkX, int chunkZ) {
        chunkX = (chunkX + caveOffsetX) / 64;
        chunkZ = (chunkZ + caveOffsetZ) / 64;
        caveRNG.setSeed(((long)(chunkX / 2) * 341873128712L + (long)(chunkZ / 2) * 132897987541L) * regionalCaveSeedMultiplier);
        return (chunkX & 1) == caveRNG.nextInt(2) && (chunkZ & 1) == caveRNG.nextInt(2);
    }

    private static int validLargeCaveLocation(int chunkX, int chunkZ, int caves) {
        int flag = 3;
        int caves2 = caves;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                int x2z2 = x * x + z * z;
                if (x2z2 <= 0 || x2z2 > 10) continue;
                caveRNG.setSeed(((long)(chunkX + x) * 341873128712L + (long)(chunkZ + z) * 132897987541L) * seedMultiplier);
                if (caveRNG.nextInt(15) != 0) continue;
                int c = caveRNG.nextInt(caveRNG.nextInt(caveRNG.nextInt(40) + 1) + 1);
                if (x2z2 <= 5 && (caves += c) > 12) {
                    return 0;
                }
                if ((caves2 += c) <= 6) continue;
                flag = caves2 > 12 ? 1 : 2;
            }
        }
        return flag;
    }

    static {
        field_82673_e = 0.004;
    }
}

