/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.fixes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.tclproject.immersivecavegen.WGConfig;
import net.tclproject.immersivecavegen.world.CavesDecorator;
import net.tclproject.mysteriumlib.asm.annotations.EnumReturnSetting;
import net.tclproject.mysteriumlib.asm.annotations.Fix;

public class MysteriumPatchesFixesCave {
    private static final Random rand;
    private static final Random noiseGen;
    private static final Random caveRNG;
    public static final Random newRand;
    private static final Random largeCaveRNG;
    private static long seedMultiplier;
    private static long regionalCaveSeedMultiplier;
    private static long colossalCaveSeedMultiplier;
    private static int caveOffsetX;
    private static World worldObj;
    private static int caveOffsetZ;
    private static int mineshaftOffsetX;
    private static int mineshaftOffsetZ;
    private static int chunkX_16;
    private static int chunkZ_16;
    private static double chunkCenterX;
    private static double chunkCenterZ;
    private static Block[] chunkData;
    private static final byte[] caveDataArray;
    private static final float[] ravineData;
    private static final float[] ravineHeightLookup;
    private static final byte[] biomeList;
    private static final float[] SINE_TABLE;
    private static boolean isInitialized;
    public static MapGenStronghold strongholdGenerator;
    public static MapGenVillage villageGenerator;
    public static MapGenMineshaft mineshaftGenerator;
    public static MapGenScatteredFeature scatteredFeatureGenerator;
    public static int oceanAvg;

    @Fix(returnSetting=EnumReturnSetting.ALWAYS)
    public static void func_151542_a(MapGenCaves c, long p_151542_1_, int p_151542_3_, int p_151542_4_, Block[] p_151542_5_, double p_151542_6_, double p_151542_8_, double p_151542_10_) {
    }

    @Fix(returnSetting=EnumReturnSetting.ALWAYS)
    public static void func_151541_a(MapGenCaves c, long p_151541_1_, int p_151541_3_, int p_151541_4_, Block[] p_151541_5_, double p_151541_6_, double p_151541_8_, double p_151541_10_, float p_151541_12_, float p_151541_13_, float p_151541_14_, int p_151541_15_, int p_151541_16_, double p_151541_17_) {
    }

    @Fix(returnSetting=EnumReturnSetting.ALWAYS)
    public static void func_151538_a(MapGenCaves c, World p_151538_1_, int p_151538_2_, int p_151538_3_, int p_151538_4_, int p_151538_5_, Block[] p_151538_6_) {
    }

    @Fix(returnSetting=EnumReturnSetting.ON_TRUE)
    public static boolean func_151539_a(MapGenBase instance, IChunkProvider p_151539_1_, World world, int chunkX, int chunkZ, Block[] data) {
        for (String str : WGConfig.dimblacklist) {
            if (world == null || !String.valueOf(world.field_73011_w.field_76574_g).equalsIgnoreCase(str)) continue;
            return false;
        }
        if (instance instanceof MapGenCaves) {
            if (!isInitialized) {
                MysteriumPatchesFixesCave.initialize(world);
            }
            MysteriumPatchesFixesCave.generate(chunkX, chunkZ, data);
            return true;
        }
        return false;
    }

    private static void initialize(World world) {
        int x;
        int z;
        int i;
        isInitialized = true;
        worldObj = world;
        rand.setSeed(worldObj.func_72905_C());
        newRand.setSeed(worldObj.func_72905_C());
        seedMultiplier = rand.nextLong() / 2L * 2L + 1L;
        caveOffsetX = rand.nextInt(128) + 2000000;
        caveOffsetZ = rand.nextInt(128) + 2000000;
        mineshaftOffsetX = rand.nextInt(7) + 2000000;
        mineshaftOffsetZ = rand.nextInt(7) + 2000000;
        int range = 66;
        block0: for (i = 0; i < 100; i += 2) {
            colossalCaveSeedMultiplier = seedMultiplier + (long)i;
            for (z = -range; z <= range; ++z) {
                for (x = -range; x <= range; ++x) {
                    if (MysteriumPatchesFixesCave.validColossalCaveLocation(x, z, x * x + z * z)) break block0;
                }
            }
        }
        for (i = 0; i < 100; i += 2) {
            regionalCaveSeedMultiplier = seedMultiplier + (long)i;
            for (z = -range; z <= range; z += 12) {
                for (x = -range; x <= range; x += 12) {
                    if (!MysteriumPatchesFixesCave.validRegionalCaveLocation(x, z, x * x + z * z) || !MysteriumPatchesFixesCave.isGiantCaveRegion(x, z)) continue;
                    return;
                }
            }
        }
    }

    public static void generate(int chunkX, int chunkZ, Block[] data) {
        int y;
        int index1;
        int z;
        int index;
        chunkData = data;
        chunkX_16 = chunkX * 16;
        chunkZ_16 = chunkZ * 16;
        chunkCenterX = chunkX_16 + 8;
        chunkCenterZ = chunkZ_16 + 8;
        noiseGen.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        MysteriumPatchesFixesCave.initializeCaveData(chunkX, chunkZ);
        for (index = -12; index <= 12; ++index) {
            for (z = -12; z <= 12; ++z) {
                int i;
                index1 = index * index + z * z;
                if (index1 > 145) continue;
                y = chunkX + index;
                int cz = chunkZ + z;
                if (y == 0 && cz == 0) continue;
                long chunkSeed = ((long)y * 341873128712L + (long)cz * 132897987541L) * seedMultiplier;
                int genCaves = MysteriumPatchesFixesCave.validCaveLocation(index, z);
                if (genCaves != 2 && genCaves < 6) {
                    if (genCaves > 0) {
                        if (genCaves == 3) {
                            rand.setSeed(chunkSeed);
                            for (i = 0; i < WGConfig.cavesSpawnMultiplier; ++i) {
                                MysteriumPatchesFixesCave.generateRegionalCaves(y, cz);
                            }
                        }
                        rand.setSeed(chunkSeed);
                        for (i = 0; i < WGConfig.cavesSpawnMultiplier; ++i) {
                            MysteriumPatchesFixesCave.generateCaves(y, cz, index1, genCaves);
                        }
                        rand.setSeed(chunkSeed);
                        for (i = 0; i < WGConfig.cavernsSpawnMultiplier; ++i) {
                            MysteriumPatchesFixesCave.generateRavines(y, cz, index1 <= 20, genCaves);
                        }
                        continue;
                    }
                    if (genCaves >= 0 || Math.abs(index) > 9 || Math.abs(z) > 9) continue;
                    rand.setSeed(chunkSeed);
                    for (i = 0; i < WGConfig.cavesSpawnMultiplier; ++i) {
                        MysteriumPatchesFixesCave.generateColossalCaveSystem(y, cz);
                    }
                    continue;
                }
                if (index1 > 65) continue;
                rand.setSeed(chunkSeed);
                for (i = 0; i < WGConfig.cavesSpawnMultiplier; ++i) {
                    MysteriumPatchesFixesCave.generateSpecialCaveSystems(y, cz, genCaves);
                }
            }
        }
        for (index = 0; index < 16; ++index) {
            for (z = 0; z < 16; ++z) {
                index1 = index << 12 | z << 8;
                for (y = 1; y <= 4; ++y) {
                    if (chunkData[index1 | y] != Blocks.field_150357_h) continue;
                    MysteriumPatchesFixesCave.chunkData[index1 | y] = Blocks.field_150348_b;
                }
            }
        }
        if ((chunkX & 1) == (chunkZ & 1) && (biomeList[MysteriumPatchesFixesCave.worldObj.getBiomeGenForCoordsBody((int)(MysteriumPatchesFixesCave.chunkX_16 + 8), (int)(MysteriumPatchesFixesCave.chunkZ_16 + 8)).field_76756_M] & 0x10) != 0 && chunkData[index = rand.nextInt(16) << 12 | rand.nextInt(16) << 8 | rand.nextInt(3) + 1] == Blocks.field_150348_b) {
            MysteriumPatchesFixesCave.chunkData[index] = Blocks.field_150412_bA;
        }
    }

    private static void generateCaves(int chunkX, int chunkZ, int flag, int genCaves) {
        int y;
        int i;
        int range;
        int type;
        int blockZ;
        if (rand.nextInt(100) + 1 <= WGConfig.caveNormalReductionPercentage) {
            return;
        }
        int chance = rand.nextInt(15);
        int caveSize = 0;
        if (genCaves == 1 || genCaves == 0) {
            Random r = new Random();
            r.setSeed(worldObj.func_72905_C());
            if (r.nextInt(100) < WGConfig.giantCaveChance) {
                genCaves = 3;
                chance = 0;
            }
        }
        if (chance == 0) {
            caveSize = rand.nextInt(rand.nextInt(rand.nextInt(40) + 1) + 1);
            boolean blockX = true;
            if (caveSize > 0) {
                float var30;
                int length;
                int var38;
                int x;
                blockZ = chunkX * 16;
                type = chunkZ * 16;
                range = chunkX + caveOffsetX + 4;
                i = chunkZ + caveOffsetZ + 4;
                y = -1;
                boolean genNormalCaves = genCaves != 3 && genCaves != 4;
                boolean applyCaveVariation = false;
                long regionSeed = 0L;
                if (blockX && genCaves < 5) {
                    caveRNG.setSeed(((long)(range / 16) * 341873128712L + (long)(i / 16) * 132897987541L) * seedMultiplier);
                    largeCaveRNG.setSeed(rand.nextLong());
                    if (!genNormalCaves || caveRNG.nextInt(4) != 0) {
                        y = (1 << caveRNG.nextInt(3)) - 1;
                        applyCaveVariation = true;
                        regionSeed = caveRNG.nextLong();
                    }
                    if (genCaves != 3 || !MysteriumPatchesFixesCave.isGiantCaveRegion(chunkX, chunkZ)) {
                        int direction;
                        if ((range & 7) == 0 && (i & 7) == 0 && (range & 8) == (i & 8)) {
                            MysteriumPatchesFixesCave.generateLargeCave(chunkX, chunkZ, 0);
                        } else if (caveSize <= 3 && largeCaveRNG.nextInt(4) <= y && (direction = MysteriumPatchesFixesCave.validLargeCaveLocation(chunkX, chunkZ, caveSize)) > 0) {
                            x = 1;
                            int largerLargeCaves = 30;
                            int y1 = 15;
                            if (largeCaveRNG.nextInt(10) == 0) {
                                x += 1 + largeCaveRNG.nextInt(3);
                            }
                            for (int curviness = 0; curviness < x; ++curviness) {
                                int z = MysteriumPatchesFixesCave.generateLargeCave(chunkX, chunkZ, x);
                                largerLargeCaves = Math.min(largerLargeCaves, z);
                                y1 = Math.max(y1, z);
                            }
                            if (x > 1) {
                                if (largerLargeCaves < y1) {
                                    MysteriumPatchesFixesCave.generateVerticalCave(largeCaveRNG.nextLong(), blockZ + 8, largerLargeCaves, y1, type + 8, -1.0f, blockZ + 8, type + 8, 1);
                                }
                            } else {
                                MysteriumPatchesFixesCave.generateHorizontalCave(largeCaveRNG.nextLong(), chunkX * 16 + 8, y1 & 0xFF, chunkZ * 16 + 8, largeCaveRNG.nextFloat() * 0.5f + 0.25f, (float)(y1 / 256) / 1024.0f + (float)Math.PI, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, 0, largeCaveRNG.nextInt(direction * 4 + 4) + direction * 20 + 20, 0);
                            }
                        }
                    }
                }
                if (flag <= 40) {
                    boolean var29 = false;
                    x = 4;
                    boolean var32 = false;
                    y = 10;
                    float var33 = 1.0f;
                    float var35 = 0.1f;
                    boolean var36 = false;
                    boolean seaLevelCaves = false;
                    if (applyCaveVariation) {
                        caveRNG.setSeed(regionSeed);
                        if (caveSize < 20 && genCaves < 5) {
                            var29 = caveRNG.nextBoolean();
                            x = 2 << caveRNG.nextInt(2) + caveRNG.nextInt(2);
                            var32 = caveRNG.nextBoolean();
                            y = 5 << caveRNG.nextInt(2) + caveRNG.nextInt(2);
                        }
                        if (caveRNG.nextBoolean()) {
                            var33 += caveRNG.nextFloat();
                            if (caveRNG.nextBoolean()) {
                                var33 /= 2.0f;
                            }
                        }
                        if (caveRNG.nextBoolean()) {
                            if (caveRNG.nextBoolean()) {
                                var35 /= 2.0f;
                            }
                            var35 = rand.nextBoolean() ? (var35 += rand.nextFloat() * var35) : (var35 += caveRNG.nextFloat() * var35);
                        }
                        if (caveSize >= 20) {
                            float branchPoint = caveSize / 10;
                            var33 = (var33 + branchPoint - 1.0f) / branchPoint;
                            var35 = (var35 + (branchPoint - 1.0f) / 10.0f) / branchPoint;
                        }
                        var36 = caveRNG.nextBoolean();
                        seaLevelCaves = caveRNG.nextBoolean();
                    }
                    if (genNormalCaves) {
                        var38 = caveSize;
                        if (caveSize >= 10) {
                            if (var33 > 1.5f) {
                                var38 = caveSize / 2 + 1;
                            } else if (var33 > 1.25f) {
                                var38 = caveSize * 3 / 4 + 1;
                            }
                        }
                        if (genCaves == 5 && var38 > 2) {
                            var38 = var38 / 4 + 2;
                        }
                        Random r = new Random();
                        r.setSeed(worldObj.func_72905_C());
                        if (r.nextInt(100) < WGConfig.giantCaveChance) {
                            var32 = true;
                            y = 1;
                        }
                        MysteriumPatchesFixesCave.generateCaveSystem(var38, blockZ, type, var33, var35, var32, y, var29, x);
                    }
                    if ((caveSize /= 5) > 0) {
                        if (caveSize < 4) {
                            if (var36) {
                                var38 = rand.nextInt(rand.nextInt(caveSize + 3) + 1);
                                if (var38 > 2) {
                                    var38 = 2;
                                }
                                for (length = 0; length < var38; ++length) {
                                    int width = Math.max(1, 1 + WGConfig.widthAdditionNormal);
                                    if (WGConfig.hardLimitsEnabled) {
                                        width = Math.min(width, WGConfig.widthMaxNormal);
                                        width = Math.max(width, WGConfig.widthMinNormal);
                                    }
                                    if (rand.nextInt(4) == 0) {
                                        width += rand.nextInt(4);
                                    }
                                    for (int LL = 0; LL < width; ++LL) {
                                        MysteriumPatchesFixesCave.generateSingleCave(blockZ, 3, type, var35);
                                    }
                                }
                            }
                            if (seaLevelCaves) {
                                var38 = rand.nextInt(caveSize * 2 + 1);
                                if (var38 > caveSize) {
                                    var38 = caveSize;
                                }
                                length = 23 - var38 * 5;
                                if (WGConfig.hardLimitsEnabled) {
                                    var38 = Math.min(var38, WGConfig.widthMaxNormal);
                                    var38 = Math.max(var38, WGConfig.widthMinNormal);
                                }
                                for (int width = 0; width < var38; ++width) {
                                    MysteriumPatchesFixesCave.generateSingleCave(blockZ, rand.nextInt(length) + width * 5 + 40, type, var35);
                                }
                            }
                        } else {
                            caveSize /= 2;
                        }
                    } else {
                        caveSize = rand.nextInt(2);
                    }
                }
                if (!blockX && flag <= 65 && (var30 = MysteriumPatchesFixesCave.getDirection(chunkX, chunkZ)) > -5.0f) {
                    double var31 = chunkX * 16 + 8;
                    double var34 = largeCaveRNG.nextInt(20) + 15;
                    double var37 = chunkZ * 16 + 8;
                    var38 = 96 + largeCaveRNG.nextInt(32);
                    length = var38 + 24 + largeCaveRNG.nextInt(16);
                    float var39 = Math.max(1.0f, largeCaveRNG.nextFloat() + 1.0f + (float)WGConfig.widthAdditionNormal);
                    if (WGConfig.hardLimitsEnabled) {
                        var39 = Math.min(var39, (float)WGConfig.widthMaxNormal);
                        var39 = Math.max(var39, (float)WGConfig.widthMinNormal);
                    }
                    MysteriumPatchesFixesCave.generateHorizontalCave(largeCaveRNG.nextLong(), var31, var34, var37, var39, var30, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, var38, length, 1);
                    MysteriumPatchesFixesCave.generateHorizontalCave(largeCaveRNG.nextLong(), var31, var34, var37, Math.min(var39 * 0.75f, largeCaveRNG.nextFloat() * var39 * 0.75f + var39 * 0.25f), var30 - 1.5707964f, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, 0, length - var38, -1);
                    MysteriumPatchesFixesCave.generateHorizontalCave(largeCaveRNG.nextLong(), var31, var34, var37, Math.min(var39 * 0.75f, largeCaveRNG.nextFloat() * var39 * 0.75f + var39 * 0.25f), var30 + 1.5707964f, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, 0, length - var38, -1);
                }
            } else if (flag <= 65 && blockX && (genCaves == 1 || genCaves == 3 && !MysteriumPatchesFixesCave.isGiantCaveRegion(chunkX, chunkZ)) && (blockZ = MysteriumPatchesFixesCave.validCaveClusterLocation(chunkX, chunkZ, true, true)) > 0) {
                MysteriumPatchesFixesCave.generateCaveCluster(chunkX, chunkZ, genCaves == 3 ? 1 : blockZ);
            }
        }
        if (chance <= 1 && flag <= 40) {
            if (chance == 1 && (caveSize = rand.nextInt(rand.nextInt(rand.nextInt(40) + 1) + 1) / 5) > 3) {
                caveSize /= 2;
            }
            if (caveSize > 0) {
                int var28 = chunkX * 16;
                blockZ = chunkZ * 16;
                type = biomeList[MysteriumPatchesFixesCave.worldObj.getBiomeGenForCoordsBody((int)(var28 + 8), (int)(blockZ + 8)).field_76756_M] & 3;
                switch (type) {
                    case 1: {
                        caveSize += rand.nextInt(caveSize * (rand.nextInt(2) + 1) + 2);
                        break;
                    }
                    case 2: {
                        caveSize += rand.nextInt(caveSize + rand.nextInt(2) + 1);
                    }
                }
                if (caveSize > 0) {
                    if (caveSize > 9) {
                        caveSize = 9;
                    }
                    range = 50 - caveSize * 5;
                    chance = 50 + chance * 10;
                    for (i = 0; i < caveSize; ++i) {
                        y = rand.nextInt(range) + chance + i * 5;
                        if (y >= 80 && type >= 4) continue;
                        MysteriumPatchesFixesCave.generateSingleCave(var28, y, blockZ, 0.1f);
                    }
                }
            }
        }
    }

    public static int validLargeCaveLocation(int chunkX, int chunkZ, int caves) {
        int flag = 3;
        int caves2 = caves;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                int x2z2 = x * x + z * z;
                if (x2z2 <= 0 || x2z2 > 10) continue;
                caveRNG.setSeed(((long)(chunkX + x) * 341873128712L + (long)(chunkZ + z) * 132897987541L) * seedMultiplier);
                if (caveRNG.nextInt(15) != 0) continue;
                int c = caveRNG.nextInt(caveRNG.nextInt(caveRNG.nextInt(40) + 1) + 1);
                if (x2z2 <= 5 && (caves += c) > 12) {
                    return 0;
                }
                if ((caves2 += c) <= 6) continue;
                flag = caves2 > 12 ? 1 : 2;
            }
        }
        return flag;
    }

    private static float getDirection(int chunkX, int chunkZ) {
        int direction;
        int caveCountEast = 0;
        int caveCountWest = 0;
        int caveCountSouth = 0;
        int caveCountNorth = 0;
        int caveCountCenter = 0;
        for (direction = -4; direction <= 4; ++direction) {
            for (int x = -4; x <= 4; ++x) {
                int x2z2 = x * x + direction * direction;
                if (x2z2 > 17) continue;
                largeCaveRNG.setSeed(((long)(chunkX + x) * 341873128712L + (long)(chunkZ + direction) * 132897987541L) * seedMultiplier);
                if (largeCaveRNG.nextInt(15) != 0) continue;
                int caves = largeCaveRNG.nextInt(largeCaveRNG.nextInt(largeCaveRNG.nextInt(40) + 1) + 1);
                if (x > 0) {
                    caveCountEast += caves;
                } else if (x < 0) {
                    caveCountWest += caves;
                }
                if (direction > 0) {
                    caveCountSouth += caves;
                } else if (direction < 0) {
                    caveCountNorth += caves;
                }
                if (x2z2 > 4 || (caveCountCenter += caves) <= 8) continue;
                return -10.0f;
            }
        }
        if (caveCountCenter < 3) {
            return -10.0f;
        }
        direction = 0;
        if (caveCountEast > 0) {
            ++direction;
        }
        if (caveCountSouth > 0) {
            direction += 2;
        }
        if (caveCountWest > 0) {
            direction += 4;
        }
        if (caveCountNorth > 0) {
            direction += 8;
        }
        switch (direction) {
            case 0: {
                return largeCaveRNG.nextFloat() * ((float)Math.PI * 2);
            }
            case 1: {
                return (float)Math.PI + (largeCaveRNG.nextFloat() - 0.5f) * 1.5707964f;
            }
            case 2: {
                return 4.712389f + (largeCaveRNG.nextFloat() - 0.5f) * 1.5707964f;
            }
            case 3: {
                return 3.926991f + (largeCaveRNG.nextFloat() - 0.5f) * 0.7853982f;
            }
            case 4: {
                return (largeCaveRNG.nextFloat() - 0.5f) * 1.5707964f;
            }
            case 5: {
                return 1.5707964f + (float)largeCaveRNG.nextInt(2) * (float)Math.PI;
            }
            case 6: {
                return 5.497787f + (largeCaveRNG.nextFloat() - 0.5f) * 0.7853982f;
            }
            case 7: {
                return 4.712389f;
            }
            case 8: {
                return 1.5707964f + (largeCaveRNG.nextFloat() - 0.5f) * 1.5707964f;
            }
            case 9: {
                return 2.356194f + (largeCaveRNG.nextFloat() - 0.5f) * 0.7853982f;
            }
            case 10: {
                return (float)largeCaveRNG.nextInt(2) * (float)Math.PI;
            }
            case 11: {
                return (float)Math.PI;
            }
            case 12: {
                return 0.7853982f + (largeCaveRNG.nextFloat() - 0.5f) * 0.7853982f;
            }
            case 13: {
                return 1.5707964f;
            }
            case 14: {
                return 0.0f;
            }
        }
        return -10.0f;
    }

    private static void generateCaveCluster(int centerX, int centerZ, int clusterType) {
        int caveType;
        int var34;
        centerX = centerX * 16 + 8;
        centerZ = centerZ * 16 + 8;
        boolean comboCave = clusterType == 3;
        boolean linkCave = clusterType == 1 || clusterType == 2;
        int quadrant = rand.nextInt(4);
        double y = 3.0;
        boolean size = true;
        double yInc = 53.0;
        int mazeIndex1 = -1;
        int mazeIndex2 = -1;
        int mazeType = 0;
        int centerOffset = 4;
        int caveCount = Math.max(1, 1 + WGConfig.additionalCavesInClusterAmount);
        if (WGConfig.hardLimitsEnabled) {
            caveCount = Math.min(caveCount, WGConfig.maxCavesInClusterAmount);
            caveCount = Math.max(caveCount, WGConfig.minCavesInClusterAmount);
        }
        if (comboCave) {
            var34 = rand.nextInt(6) + 24;
            caveType = rand.nextInt(3);
            mazeIndex1 = rand.nextInt(var34);
            mazeIndex2 = (mazeIndex1 + var34 / 4 + rand.nextInt(var34 / 2)) % var34;
            mazeType = rand.nextInt(2);
            yInc /= (double)(var34 - 1);
            centerOffset = 8;
        } else {
            var34 = 1;
            caveType = rand.nextInt(4);
        }
        for (int caveIndex = 0; caveIndex < var34; ++caveIndex) {
            int i;
            int z;
            int y2;
            int x;
            switch (caveType) {
                case 0: {
                    double var38;
                    double var36;
                    double var35;
                    x = 0;
                    if (!comboCave) {
                        x = rand.nextInt(35);
                        y = x;
                        caveCount = rand.nextInt(4) + 3 + WGConfig.additionalCavesInClusterAmount;
                        if (WGConfig.hardLimitsEnabled) {
                            caveCount = Math.min(caveCount, WGConfig.maxCavesInClusterAmount);
                            caveCount = Math.max(caveCount, WGConfig.minCavesInClusterAmount);
                        }
                    }
                    for (y2 = caveCount; y2 > 0; --y2) {
                        var35 = centerX + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantX(y2 + quadrant);
                        var36 = comboCave ? y + (double)(rand.nextFloat() * 2.0f - 1.0f) : y;
                        var38 = centerZ + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantZ(y2 + quadrant);
                        MysteriumPatchesFixesCave.generateCircularRoom(var35, var36, var38, rand.nextFloat() * rand.nextFloat() * (comboCave ? 9.0f : 6.0f) + 3.0f);
                        MysteriumPatchesFixesCave.generateDirectionalCave((int)(var35 + 0.5), (int)(var36 + 0.5), (int)(var38 + 0.5), centerX, centerZ, 0);
                        if (!comboCave) {
                            y += (double)(rand.nextInt(4) + 2);
                            if (y2 == 1) {
                                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), centerX + rand.nextInt(5) - 2, x, (int)(var36 + 0.5), centerZ + rand.nextInt(5) - 2, 0.0f, centerX, centerZ, 8);
                            }
                        }
                        if (!linkCave || y2 != caveCount / 2) continue;
                        MysteriumPatchesFixesCave.generateHorizontalLinkCave((int)var35, (int)var36, (int)var38, centerX, centerZ, 2 - clusterType);
                    }
                    break;
                }
                case 1: {
                    double var38;
                    double var36;
                    double var35;
                    if (!comboCave) {
                        y = rand.nextInt(35);
                        caveCount = rand.nextInt(4) + 3 + WGConfig.additionalCavesInClusterAmount;
                        if (WGConfig.hardLimitsEnabled) {
                            caveCount = Math.min(caveCount, WGConfig.maxCavesInClusterAmount);
                            caveCount = Math.max(caveCount, WGConfig.minCavesInClusterAmount);
                        }
                    }
                    for (y2 = caveCount; y2 > 0; --y2) {
                        var35 = centerX + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantX(y2 + quadrant);
                        var36 = comboCave ? y + (double)(rand.nextFloat() * 2.0f - 1.0f) : y;
                        var38 = centerZ + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantZ(y2 + quadrant);
                        MysteriumPatchesFixesCave.generateRavineCave(var35, var36, var38, comboCave ? 2.0f : 1.0f);
                        if (!comboCave) {
                            y += (double)(rand.nextInt(3) + 3);
                        }
                        if (!linkCave || y2 != caveCount / 2) continue;
                        MysteriumPatchesFixesCave.generateHorizontalLinkCave((int)var35, (int)var36, (int)var38, centerX, centerZ, 4 - clusterType);
                    }
                    break;
                }
                case 2: {
                    int dirSwitch;
                    int length;
                    int z1;
                    double var35;
                    if (!comboCave) {
                        y = rand.nextInt(8);
                        caveCount = rand.nextInt(4) + 3 + WGConfig.additionalCavesInClusterAmount;
                        if (WGConfig.hardLimitsEnabled) {
                            caveCount = Math.min(caveCount, WGConfig.maxCavesInClusterAmount);
                            caveCount = Math.max(caveCount, WGConfig.minCavesInClusterAmount);
                        }
                    }
                    for (y2 = caveCount; y2 > 0; --y2) {
                        var35 = centerX + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantX(y2 + quadrant);
                        z1 = Math.round(comboCave ? ((float)y + rand.nextFloat() * 2.0f - 1.0f) / 1.5f : (float)y);
                        double var37 = centerZ + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantZ(y2 + quadrant);
                        length = Math.max(0, z1 - rand.nextInt(5) + WGConfig.additionalCavesInClusterLength);
                        if (WGConfig.hardLimitsEnabled) {
                            length = Math.min(length, WGConfig.maxCavesInClusterLength);
                            length = Math.max(length, WGConfig.minCavesInClusterLength);
                        }
                        dirSwitch = z1 + Math.min(40 + rand.nextInt(16), 24 + rand.nextInt(36 - z1 / 2));
                        float var39 = rand.nextFloat() * rand.nextFloat() * 2.0f;
                        if (rand.nextInt(10) == 0) {
                            var39 = Math.min(8.0f, var39 * (rand.nextFloat() * 3.0f + 1.0f) + 2.0f);
                        }
                        if ((y2 + caveIndex & 1) == 0) {
                            MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), var35, length, dirSwitch, var37, var39, centerX, centerZ, comboCave ? 24 : 16);
                        } else {
                            MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), var35, dirSwitch - length, 0, var37, var39, centerX, centerZ, comboCave ? 24 : 16);
                        }
                        if (!comboCave) {
                            y += (double)(rand.nextInt(4) + 3);
                        }
                        if (!linkCave || y2 != caveCount / 2) continue;
                        MysteriumPatchesFixesCave.generateHorizontalLinkCave(centerX, rand.nextInt(10) + 10, centerZ, centerX, centerZ, 4 - clusterType);
                    }
                    break;
                }
                case 3: {
                    int dirSwitch;
                    int length;
                    y2 = comboCave ? rand.nextInt(4) * 2 + mazeType : rand.nextInt(8);
                    z = centerX + (4 + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantX(quadrant);
                    i = comboCave ? Math.max(3, Math.round((float)y)) : rand.nextInt(50) + 3;
                    int z1 = centerZ + (4 + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantZ(quadrant);
                    float height = i == 3 ? 2.625f : 1.625f;
                    for (int d = 0; d < 4; ++d) {
                        y2 += 2;
                        length = Math.max(0, rand.nextInt(8) + WGConfig.additionalCavesInClusterLength);
                        if (WGConfig.hardLimitsEnabled) {
                            length = Math.min(length, WGConfig.maxCavesInClusterLength);
                            length = Math.max(length, WGConfig.minCavesInClusterLength);
                        }
                        length = (y2 & 1) == 0 ? (length += 24) : (length += 17);
                        MysteriumPatchesFixesCave.generateMazeCaveSegment(z, i, z1, y2, length, height);
                        dirSwitch = rand.nextInt(2) * 4 + 2;
                        int maxOffset = length * 3 / 4;
                        for (int offset = length / 5 + rand.nextInt(length / 4); offset < maxOffset; offset += length / 6 + rand.nextInt(length / 4) + 1) {
                            int x2 = MysteriumPatchesFixesCave.getOffsetX(z, y2, offset);
                            int z2 = MysteriumPatchesFixesCave.getOffsetZ(z1, y2, offset);
                            int direction2 = y2 + (dirSwitch += 4);
                            int length2 = length / 3 + rand.nextInt(length / 3);
                            if ((direction2 & 1) == 1) {
                                length2 -= offset / 4;
                            }
                            MysteriumPatchesFixesCave.generateMazeCaveSegment(x2, i, z2, direction2, length2, height);
                            if (linkCave && d == 0) {
                                linkCave = false;
                                x2 = MysteriumPatchesFixesCave.getOffsetX(x2, direction2, length2);
                                z2 = MysteriumPatchesFixesCave.getOffsetZ(z2, direction2, length2);
                                MysteriumPatchesFixesCave.generateHorizontalLinkCave(x2, i, z2, centerX, centerZ, 2 - clusterType);
                            }
                            if (offset <= length / 2) continue;
                            x2 = MysteriumPatchesFixesCave.getOffsetX(z, y2, offset += rand.nextInt(length / 6) + 2);
                            z2 = MysteriumPatchesFixesCave.getOffsetZ(z1, y2, offset);
                            length2 = length / 3 + rand.nextInt(length / 3);
                            if (((direction2 += 4) & 1) == 1) {
                                length2 -= offset / 4;
                            }
                            MysteriumPatchesFixesCave.generateMazeCaveSegment(x2, i, z2, direction2, length2, height);
                        }
                    }
                    ++mazeType;
                }
            }
            ++quadrant;
            y += yInc;
            if (caveIndex == mazeIndex1) {
                caveType = 3;
                x = centerX + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantX(quadrant);
                y2 = rand.nextInt(16) + 16;
                z = centerZ + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantZ(quadrant);
                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, y2, 100, z, rand.nextFloat(), centerX, centerZ, 24);
                MysteriumPatchesFixesCave.generateHorizontalLinkCave(x, y2, z, centerX, centerZ, 0);
                MysteriumPatchesFixesCave.generateCircularRoom(x, y2, z, rand.nextFloat() * rand.nextFloat() * 4.0f + 4.0f);
                x = centerX + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantX(++quadrant);
                y2 = rand.nextInt(16) + 32;
                z = centerZ + (centerOffset + rand.nextInt(5)) * MysteriumPatchesFixesCave.getQuadrantZ(quadrant);
                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, y2, 100, z, rand.nextFloat(), centerX, centerZ, 24);
                ++quadrant;
                if (mazeIndex1 <= 0 || mazeIndex2 <= 0) continue;
                for (i = rand.nextInt(3) + 4; i > 0; --i) {
                    x = centerX + (centerOffset + 8 + rand.nextInt(16)) * MysteriumPatchesFixesCave.getQuadrantX(quadrant);
                    z = centerZ + (centerOffset + 8 + rand.nextInt(16)) * MysteriumPatchesFixesCave.getQuadrantZ(quadrant);
                    MysteriumPatchesFixesCave.generateDirectionalCave(x, 3, z, centerX, centerZ, 0);
                    ++quadrant;
                }
                continue;
            }
            caveType = caveIndex == mazeIndex2 ? 3 : (caveType + 1) % 3;
        }
    }

    private static int validCaveClusterLocation(int chunkX, int chunkZ, boolean includeCaves, boolean firstCheck) {
        int x2z2;
        int z;
        int x;
        int radius2;
        int type = 3;
        int count = 0;
        for (radius2 = -3; radius2 <= 3; ++radius2) {
            for (x = -3; x <= 3; ++x) {
                int chunkModZ;
                int chunkModX;
                z = radius2 * radius2 + x * x;
                if (z > 13) continue;
                x2z2 = chunkX + radius2;
                int chunkOffZ = chunkZ + x;
                if (includeCaves && z != 0) {
                    caveRNG.setSeed(((long)x2z2 * 341873128712L + (long)chunkOffZ * 132897987541L) * seedMultiplier);
                    if (caveRNG.nextInt(15) == 0 && (chunkModX = caveRNG.nextInt(caveRNG.nextInt(caveRNG.nextInt(40) + 1) + 1)) > 0) {
                        if (!firstCheck || z <= 5) {
                            return 0;
                        }
                        count += chunkModX;
                        if (type == 3) {
                            type = 2;
                        }
                        if (type == 2 && count > 10) {
                            type = 1;
                        }
                    }
                }
                caveRNG.setSeed(((long)x2z2 * 341873128712L + (long)chunkOffZ * 132897987541L) * seedMultiplier);
                if (caveRNG.nextInt(20) == 15) {
                    chunkModX = x2z2 + caveOffsetX + 4;
                    chunkModZ = chunkOffZ + caveOffsetZ + 4;
                    boolean ravine = false;
                    if ((chunkModX & 7) == 0 && (chunkModZ & 7) == 0 && (chunkModX & 8) != (chunkModZ & 8)) {
                        ravine = true;
                    } else if (caveRNG.nextInt(25) < 19 && chunkModX % 3 == 0 && chunkModZ % 3 == 0 && (chunkModX / 3 & 1) == (chunkModZ / 3 & 1)) {
                        ravine = true;
                    }
                    if (ravine || caveRNG.nextInt(30) < 11) {
                        if (!firstCheck || z <= 5) {
                            return 0;
                        }
                        count += 6;
                        if (type == 3) {
                            type = 2;
                        }
                        if (type == 2 && count > 10) {
                            type = 1;
                        }
                    }
                }
                if (((x2z2 += mineshaftOffsetX) / 7 & 1) == ((chunkOffZ += mineshaftOffsetZ) / 7 & 1)) continue;
                chunkModX = x2z2 % 7;
                chunkModZ = chunkOffZ % 7;
                if (chunkModX > 2 || chunkModZ > 2) continue;
                caveRNG.setSeed(((long)(x2z2 / 7) * 341873128712L + (long)(chunkOffZ / 7) * 132897987541L) * seedMultiplier);
                if (chunkModX != caveRNG.nextInt(3) || chunkModZ != caveRNG.nextInt(3)) continue;
                if (!firstCheck || z <= 5) {
                    return 0;
                }
                count += 6;
                if (type == 3) {
                    type = 2;
                }
                if (type != 2 || count <= 10) continue;
                type = 1;
            }
        }
        if (!includeCaves) {
            return 1;
        }
        if (type > 1 && firstCheck) {
            radius2 = type * type + 1;
            for (x = -type; x <= type; ++x) {
                for (z = -type; z <= type; ++z) {
                    x2z2 = x * x + z * z;
                    if (x2z2 <= 0 || x2z2 > radius2) continue;
                    caveRNG.setSeed(((long)(chunkX + x) * 341873128712L + (long)(chunkZ + z) * 132897987541L) * seedMultiplier);
                    if (caveRNG.nextInt(15) != 0 || caveRNG.nextInt(caveRNG.nextInt(caveRNG.nextInt(40) + 1) + 1) != 0 || MysteriumPatchesFixesCave.validCaveClusterLocation(chunkX + x, chunkZ + z, true, false) != 3) continue;
                    return type == 2 ? 4 : 1;
                }
            }
        }
        return type;
    }

    private static void generateCaveSystem(int size, int centerX, int centerZ, float widthMultiplier, float curviness, boolean largerLargeCaves, int largeCaveChance, boolean largerCircularRooms, int circularRoomChance) {
        int spread = 16;
        if (curviness >= 0.15f) {
            spread = 32;
            centerX -= 8;
            centerZ -= 8;
        }
        for (int i = 0; i < size; ++i) {
            float width;
            double x = centerX + rand.nextInt(spread);
            double y = rand.nextInt(rand.nextInt(120) + 8) - 7;
            double z = centerZ + rand.nextInt(spread);
            int caves = 1;
            if (rand.nextInt(circularRoomChance) == 0) {
                int startDirection = rand.nextInt(4);
                caves += startDirection;
                float j = rand.nextFloat() * 6.0f + 1.0f;
                if (largerCircularRooms && rand.nextInt(16 / circularRoomChance) == 0 && (j = j * (rand.nextFloat() * rand.nextFloat() + 1.0f) + 3.0f) > 8.5f) {
                    caves += 2;
                    if (y < 4.5) {
                        y += 12.0;
                    } else if (y > 62.5 && (y -= 47.0) > 62.5) {
                        y -= 20.0;
                    }
                }
                if (widthMultiplier < 1.0f) {
                    if (j > 8.5f) {
                        j *= widthMultiplier;
                    }
                } else {
                    j *= widthMultiplier;
                    if (startDirection == 0 && j > 10.0f && j < 17.0f) {
                        width = (j - 10.0f) / 7.0f + (float)WGConfig.widthAdditionNormal;
                        width = Math.max((j - 10.0f) / 10.0f, width);
                        if (WGConfig.hardLimitsEnabled) {
                            width = Math.min(width, (float)WGConfig.widthMaxNormal);
                            width = Math.max(width, (float)WGConfig.widthMinNormal);
                        }
                        j *= rand.nextFloat() * (1.0f - width) + 1.0f + width;
                    }
                    if (j > 15.5f) {
                        if (y < 4.5) {
                            y += 12.0;
                        } else if (y > 62.5 && (y -= 47.0) > 62.5) {
                            y -= 20.0;
                        }
                        if (y < 9.5) {
                            y += (double)(j / 8.0f + 0.5f);
                        } else if (y > 52.5) {
                            y -= (double)(j / 4.0f + 0.5f);
                        }
                    }
                }
                MysteriumPatchesFixesCave.generateCircularRoom(x, y, z, j);
            }
            float var23 = rand.nextFloat() * ((float)Math.PI * 2);
            for (int var24 = 0; var24 < caves; ++var24) {
                width = rand.nextFloat() * 2.0f + rand.nextFloat() + (float)WGConfig.widthAdditionNormal;
                width = Math.max(rand.nextFloat() * 1.5f, width);
                if (WGConfig.hardLimitsEnabled) {
                    width = Math.min(width, (float)WGConfig.widthMaxNormal);
                    width = Math.max(width, (float)WGConfig.widthMinNormal);
                }
                if (rand.nextInt(largeCaveChance) == 0) {
                    width *= rand.nextFloat() * rand.nextFloat() * 4.0f + 1.0f;
                    if (largerLargeCaves) {
                        if (widthMultiplier < 1.0f) {
                            if (width > 7.5f) {
                                width *= widthMultiplier;
                            }
                        } else if (width < 7.5f) {
                            width *= widthMultiplier;
                        }
                    } else if (width > 8.5f) {
                        width = 8.5f;
                    }
                } else {
                    width *= widthMultiplier;
                }
                float direction = var23;
                if (var24 > 0) {
                    direction = var23 + (float)Math.PI * 2 * (float)var24 / (float)caves + (rand.nextFloat() - 0.5f) * ((float)Math.PI * 2) / (float)caves;
                }
                MysteriumPatchesFixesCave.generateCave(rand.nextLong(), x, y, z, width, direction, (rand.nextFloat() - 0.5f) / 4.0f, 0, 0, curviness);
            }
        }
    }

    private static void generateColossalCaveSystem(int centerX, int centerZ) {
        int offset;
        int x2z2;
        int x;
        int z;
        if (rand.nextInt(100) + 1 <= WGConfig.caveColossalReductionPercentage) {
            return;
        }
        centerX *= 16;
        centerZ *= 16;
        int caveType = rand.nextInt(5);
        int caveCounter = rand.nextInt(200);
        if (caveType < 4) {
            z = rand.nextInt(2);
            for (x = 0; x < 8; ++x) {
                x2z2 = centerX;
                offset = centerZ;
                switch (caveType) {
                    case 0: {
                        offset = centerZ + (x * 16 - 56);
                        break;
                    }
                    case 1: {
                        x2z2 = centerX + (x * 16 - 56);
                        break;
                    }
                    case 2: {
                        x2z2 = centerX + (x * 11 - 38);
                        offset = centerZ + (x * 12 - 42);
                        break;
                    }
                    case 3: {
                        x2z2 = centerX + (38 - x * 11);
                        offset = centerZ + (x * 12 - 42);
                    }
                }
                int size = (x + z & 1) + 12;
                if (caveType == 1) {
                    caveCounter = MysteriumPatchesFixesCave.generateCCCaveSystem(size, x2z2, offset - 8, caveCounter);
                    caveCounter = MysteriumPatchesFixesCave.generateCCCaveSystem(25 - size, x2z2, offset + 8, caveCounter);
                    continue;
                }
                caveCounter = MysteriumPatchesFixesCave.generateCCCaveSystem(size, x2z2 - 8, offset, caveCounter);
                caveCounter = MysteriumPatchesFixesCave.generateCCCaveSystem(25 - size, x2z2 + 8, offset, caveCounter);
            }
        } else {
            for (z = -2; z <= 2; ++z) {
                for (x = -2; x <= 2; ++x) {
                    x2z2 = x * x + z * z;
                    if (x2z2 <= 0 || x2z2 > 5) continue;
                    offset = x != 0 && z != 0 ? 16 : 20;
                    caveCounter = MysteriumPatchesFixesCave.generateCCCaveSystem(10, centerX + x * offset, centerZ + z * offset, caveCounter);
                }
            }
        }
        centerX += 8;
        centerZ += 8;
        for (z = -32; z <= 32; z += 64) {
            for (x = -32; x <= 32; x += 64) {
                MysteriumPatchesFixesCave.generateHorizontalLinkCave(centerX + x, rand.nextInt(15) + 15, centerZ + z, centerX, centerZ, 4);
            }
        }
    }

    private static int generateCCCaveSystem(int size, int centerX, int centerZ, int caveCounter) {
        for (int i = 0; i < size; ++i) {
            double x = centerX + rand.nextInt(16);
            double z = centerZ + rand.nextInt(16);
            int index12 = caveCounter % 12;
            double y = -7.0;
            if (index12 < 9) {
                int width = Math.max(caveCounter % 3, caveCounter % 3 + WGConfig.widthAdditionColossal);
                if (WGConfig.hardLimitsEnabled) {
                    width = Math.min(width, WGConfig.widthMaxColossal);
                    width = Math.max(width, WGConfig.widthMinColossal);
                }
                y = width < 2 ? (y += (double)(width * 10 + rand.nextInt(10))) : (y += (double)(index12 * 3 + 14 + rand.nextInt(9)));
            } else {
                y = index12 == 9 ? (y += (double)(47 + rand.nextInt(11))) : (index12 == 10 ? (y += (double)(58 + rand.nextInt(13))) : (y += (double)(71 + rand.nextInt(20))));
            }
            if (caveCounter % 7 == 0) {
                MysteriumPatchesFixesCave.generateCircularRoom(x, y, z, rand.nextFloat() * 5.0f + 2.0f);
            }
            float var14 = rand.nextFloat() * 2.0f + rand.nextFloat();
            if (caveCounter % 19 == 0) {
                if (var14 < 1.5f) {
                    var14 += (var14 + 3.0f) / 3.0f;
                }
                var14 += 1.0f;
            }
            MysteriumPatchesFixesCave.generateCCCave(rand.nextLong(), x, y, z, var14, rand.nextFloat() * ((float)Math.PI * 2), (rand.nextFloat() - 0.5f) / 4.0f, 0, caveCounter % 5 == 0, centerX + 8, centerZ + 8);
            ++caveCounter;
        }
        return caveCounter;
    }

    private static void generateCCCave(long seed, double x, double y, double z, float width, float directionXZ, float directionY, int pos, boolean isVerticalCave, double centerX, double centerZ) {
        int branchPoint;
        caveRNG.setSeed(seed);
        float var23 = 0.0f;
        float var24 = 0.0f;
        int n = branchPoint = pos == 0 ? 49 : -999;
        while (pos < 98) {
            if (pos == branchPoint) {
                seed = caveRNG.nextLong();
                width = caveRNG.nextFloat() * 0.5f + 0.5f;
                isVerticalCave = caveRNG.nextInt(6) == 0;
                MysteriumPatchesFixesCave.generateCCCave(caveRNG.nextLong(), x, y, z, caveRNG.nextFloat() * 0.5f + 0.5f, directionXZ - 1.5707964f, directionY /= 3.0f, pos, caveRNG.nextInt(6) == 0, centerX, centerZ);
                MysteriumPatchesFixesCave.generateCCCave(seed, x, y, z, width, directionXZ + 1.5707964f, directionY, pos, isVerticalCave, centerX, centerZ);
                return;
            }
            double var35 = x - chunkCenterX;
            double var37 = z - chunkCenterZ;
            double radiusW = 1.5f + MysteriumPatchesFixesCave.sine((float)pos * 0.0320571f) * width;
            double var39 = (double)(116 - pos) + radiusW;
            if (var35 * var35 + var37 * var37 > var39 * var39) {
                return;
            }
            if (caveRNG.nextInt(4) == 0) {
                radiusW = radiusW / 5.0 + 0.75;
            }
            float var33 = MysteriumPatchesFixesCave.cosine(directionY);
            y += (double)MysteriumPatchesFixesCave.sine(directionY);
            directionY = isVerticalCave ? (directionY *= 0.92f) : (directionY *= 0.7f);
            float devX = (float)((x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * var33)) - centerX);
            float devZ = (float)((z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * var33)) - centerZ);
            if (devX * devX + devZ * devZ > 576.0f) {
                directionXZ = devZ >= 0.0f ? (devX >= 0.0f ? (directionXZ * 31.0f - 2.35619f) / 32.0f : (directionXZ * 31.0f - 0.7853982f) / 32.0f) : (devX >= 0.0f ? (directionXZ * 31.0f + 2.35619f) / 32.0f : (directionXZ * 31.0f + 0.7853982f) / 32.0f);
            }
            directionY += var24 * 0.1f;
            directionXZ += var23 * 0.1f;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            var23 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double radiusW_2 = radiusW + 9.0;
            if (x >= chunkCenterX - radiusW_2 && x <= chunkCenterX + radiusW_2 && z >= chunkCenterZ - radiusW_2 && z <= chunkCenterZ + radiusW_2) {
                double noiseMultiplier = 0.275 / Math.max(radiusW - 1.0, 0.916666);
                MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, radiusW, radiusW, noiseMultiplier, 1);
            }
            ++pos;
        }
    }

    private static void generateSpecialCaveSystems(int chunkX, int chunkZ, int type) {
        int centerX = chunkX * 16 + 8;
        int centerZ = chunkZ * 16 + 8;
        if (type == 2) {
            if ((chunkX + caveOffsetX - 15 & 0x20) == (chunkZ + caveOffsetZ - 15 & 0x20)) {
                if (rand.nextInt(100) + 1 <= WGConfig.caveCircularRoomReductionPercentage) {
                    return;
                }
                MysteriumPatchesFixesCave.generateCircularRoomCaveSystem(centerX, centerZ);
            } else {
                if (rand.nextInt(100) + 1 <= WGConfig.caveRavineCaveReductionPercentage) {
                    return;
                }
                MysteriumPatchesFixesCave.generateRavineCaveSystem(centerX, centerZ);
            }
        } else if (type == 6) {
            if (rand.nextInt(100) + 1 <= WGConfig.caveVerticalReductionPercentage) {
                return;
            }
            MysteriumPatchesFixesCave.generateVerticalCaveSystem(centerX, centerZ);
        } else {
            if (rand.nextInt(100) + 1 <= WGConfig.caveMazeReductionPercentage) {
                return;
            }
            MysteriumPatchesFixesCave.generateMazeCaveSystem(centerX, centerZ);
        }
    }

    private static void generateCircularRoomCaveSystem(int centerX, int centerZ) {
        int caveSize = rand.nextInt(15) + 35;
        double yInc = 39.0 / (double)caveSize;
        double y = 0.0;
        int offset = rand.nextInt(4);
        int centerCave = rand.nextInt(2);
        for (int i = 0; i < caveSize; ++i) {
            int z;
            int x;
            int x2z2;
            while ((x2z2 = (x = rand.nextInt(33)) * x + (z = rand.nextInt(33)) * z) < 101 || x2z2 > 1025) {
            }
            x *= MysteriumPatchesFixesCave.getQuadrantX(i + offset);
            z *= MysteriumPatchesFixesCave.getQuadrantZ(i + offset);
            MysteriumPatchesFixesCave.generateCircularRoom(x += centerX, y += ((double)i / (double)(caveSize - 1) + 1.0) * yInc, z += centerZ, rand.nextFloat() * rand.nextFloat() * 9.0f + 3.0f);
            MysteriumPatchesFixesCave.generateDirectionalCave(x, (int)(y + 0.5), z, centerX, centerZ, 16);
            if (i < 2) {
                x = centerX + (rand.nextInt(9) + 8) * (rand.nextInt(2) * 2 - 1);
                int y2 = rand.nextInt(8) + i * 16 + 16;
                z = centerZ + (rand.nextInt(9) + 8) * (rand.nextInt(2) * 2 - 1);
                MysteriumPatchesFixesCave.generateVerticalCave(x, y2, 100, z);
                MysteriumPatchesFixesCave.generateCircularRoom(x, y2, z, rand.nextFloat() * rand.nextFloat() * 9.0f + 3.0f);
                MysteriumPatchesFixesCave.generateDirectionalCave(x, y2, z, centerX, centerZ, 999);
                MysteriumPatchesFixesCave.generateHorizontalLinkCave(x, y2, z, centerX, centerZ, 0);
            }
            if ((i & 7) != centerCave) continue;
            x = centerX + (rand.nextInt(6) + 3) * (rand.nextInt(2) * 2 - 1);
            double var16 = y + (double)(rand.nextInt(9) - 4);
            if (var16 < 0.0) {
                var16 += 4.0;
            }
            z = centerZ + (rand.nextInt(6) + 3) * (rand.nextInt(2) * 2 - 1);
            MysteriumPatchesFixesCave.generateCircularRoom(x, y, z, rand.nextFloat() * rand.nextFloat() * 9.0f + 3.0f);
            if (i != centerCave) continue;
            MysteriumPatchesFixesCave.generateVerticalCave(x, 3, 32, z);
        }
    }

    private static void generateRavineCaveSystem(int centerX, int centerZ) {
        int caveSize = rand.nextInt(10) + 30;
        double yInc = 39.0 / (double)caveSize;
        double y = 0.0;
        int offset = rand.nextInt(4);
        int vertCave1 = caveSize / 4 + rand.nextInt(3);
        int vertCave2 = caveSize / 3 + rand.nextInt(3);
        int centerCave = rand.nextInt(3);
        for (int i = 0; i < caveSize; ++i) {
            int z;
            int x;
            int x2z2;
            while ((x2z2 = (x = rand.nextInt(33)) * x + (z = rand.nextInt(33)) * z) < 145 || x2z2 > 1025) {
            }
            x *= MysteriumPatchesFixesCave.getQuadrantX(i + offset);
            z *= MysteriumPatchesFixesCave.getQuadrantZ(i + offset);
            MysteriumPatchesFixesCave.generateRavineCave(x += centerX, y += ((double)i / (double)(caveSize - 1) + 1.0) * yInc, z += centerZ, 2.0f);
            if (i == vertCave1 || i == vertCave2) {
                MysteriumPatchesFixesCave.generateVerticalCave(x, (int)(y + 0.5), 100, z);
                MysteriumPatchesFixesCave.generateHorizontalLinkCave(x, (int)(y + 0.5), z, centerX, centerZ, 0);
            }
            if (i % 7 != centerCave) continue;
            x = centerX + (rand.nextInt(6) + 3) * (rand.nextInt(2) * 2 - 1);
            double y2 = y + (double)(rand.nextInt(5) - 2);
            if (y2 < 0.0) {
                y2 += 4.0;
            }
            z = centerZ + (rand.nextInt(6) + 3) * (rand.nextInt(2) * 2 - 1);
            int length = rand.nextInt(17) + 26;
            int segmentLength = length + rand.nextInt(2) * 8;
            float width = rand.nextFloat() * rand.nextFloat() + 1.0f;
            float height = rand.nextFloat() * 2.0f + 2.0f;
            float direction = rand.nextFloat() * 0.7853982f + (float)i * 0.112199f;
            float directionY = (rand.nextFloat() - 0.5f) / 4.0f;
            float slope = (rand.nextFloat() * 0.75f + 0.25f) * 0.25f * (float)(rand.nextInt(2) * 2 - 1);
            MysteriumPatchesFixesCave.generateRavineCaveSegment(rand.nextLong(), x, y, z, width, direction, directionY, slope, segmentLength, height);
            segmentLength = length + rand.nextInt(2) * 8;
            MysteriumPatchesFixesCave.generateRavineCaveSegment(rand.nextLong(), x, y, z, width, direction + (float)Math.PI, -directionY, -slope, segmentLength, height);
        }
    }

    private static void generateVerticalCaveSystem(int centerX, int centerZ) {
        int caveSize = rand.nextInt(15) + 45;
        double yInc = 39.0 / (double)caveSize;
        double y = 0.0;
        int offset = rand.nextInt(4);
        int horizCave = rand.nextInt(3);
        int deepHorizCave = 6 + rand.nextInt(3);
        int vertCave1 = caveSize / 3 + (rand.nextInt(5) - 2) * 2;
        int vertCave2 = caveSize / 3 + (rand.nextInt(5) - 2) * 2 + rand.nextInt(2) * 2 - 1;
        int largeCaveChance = (caveSize - 29) / 5;
        largeCaveChance += rand.nextInt(8 - largeCaveChance) + 5;
        int largeCaveOffset = rand.nextInt(largeCaveChance);
        for (int i = 0; i < caveSize; ++i) {
            int z;
            int x;
            int x2z2;
            while ((x2z2 = (x = rand.nextInt(33)) * x + (z = rand.nextInt(33)) * z) < 101 || x2z2 > 1025) {
            }
            x *= MysteriumPatchesFixesCave.getQuadrantX(i + offset);
            z *= MysteriumPatchesFixesCave.getQuadrantZ(i + offset);
            int y2 = (int)(y += ((double)i / (double)(caveSize - 1) + 1.0) * yInc);
            if (i < deepHorizCave) {
                MysteriumPatchesFixesCave.generateDirectionalCave(centerX - x - (x >= 0 ? 8 : -8), 3, centerZ - z - (z >= 0 ? 8 : -8), centerX, centerZ, 0);
            }
            if (i % 3 == horizCave) {
                MysteriumPatchesFixesCave.generateDirectionalCave(centerX + x + (x >= 0 ? 8 : -8), y2, centerZ + z + (z >= 0 ? 8 : -8), centerX, centerZ, 0);
            }
            if (i == vertCave1 || i == vertCave2) {
                MysteriumPatchesFixesCave.generateHorizontalLinkCave(centerX - x, y2, centerZ - z, centerX, centerZ, 2);
            }
            int minY = (y2 /= 3) - rand.nextInt(5);
            int maxY = y2 + 32 + rand.nextInt(33 - y2);
            float width = Math.max(0.5f, rand.nextFloat() * rand.nextFloat() * 2.0f + (float)WGConfig.caveVerticalReductionPercentage);
            if (i % largeCaveChance == largeCaveOffset) {
                width = Math.min(8.0f, Math.max(width * 3.0f, width * (rand.nextFloat() * 3.0f + 1.0f) + 2.0f) + (float)WGConfig.caveVerticalReductionPercentage);
            }
            x += centerX;
            z += centerZ;
            if ((i + offset & 4) == 0) {
                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, minY, maxY, z, width, centerX, centerZ, 40);
            } else {
                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, maxY - minY, 0, z, width, centerX, centerZ, 40);
            }
            if (i != vertCave1 && i != vertCave2) continue;
            x = centerX + (rand.nextInt(6) + 3) * (rand.nextInt(2) * 2 - 1);
            z = centerZ + (rand.nextInt(6) + 3) * (rand.nextInt(2) * 2 - 1);
            if (i == vertCave1) {
                MysteriumPatchesFixesCave.generateVerticalCave(x, minY, 100, z);
                continue;
            }
            MysteriumPatchesFixesCave.generateVerticalCave(x, 100, 0, z);
        }
    }

    private static void generateMazeCaveSystem(int centerX, int centerZ) {
        int vertCave2;
        int horizCave2;
        int quadrant;
        boolean direction = false;
        int oldDirection = 0;
        boolean change = false;
        int yInc = 7 + rand.nextInt(2);
        int minY = 3;
        int maxY = 59;
        int oldQuadrant = quadrant = rand.nextInt(4);
        float height = 2.625f;
        int horizCave1 = rand.nextInt(4);
        while (horizCave1 == (horizCave2 = rand.nextInt(4))) {
        }
        horizCave1 = minY + (horizCave1 + 1) * yInc + rand.nextInt(4);
        horizCave2 = minY + (horizCave2 + 1) * yInc + rand.nextInt(4);
        int vertCave1 = maxY + rand.nextInt(4);
        while (vertCave1 == (vertCave2 = maxY + rand.nextInt(4))) {
        }
        int caveCount = rand.nextInt(2);
        for (int caveY = minY; caveY <= maxY; caveY += yInc) {
            int length;
            int caveX = centerX + (rand.nextInt(7) + 4) * MysteriumPatchesFixesCave.getQuadrantX(quadrant);
            int caveZ = centerZ + (rand.nextInt(7) + 4) * MysteriumPatchesFixesCave.getQuadrantZ(quadrant);
            int var31 = rand.nextInt(2);
            if (change && var31 == oldDirection) {
                var31 = 1 - var31;
            }
            change = var31 == oldDirection;
            oldDirection = var31;
            var31 += rand.nextInt(4) * 2;
            for (int d = 0; d < 4; ++d) {
                length = ((var31 += 2) & 1) == 0 ? 28 + rand.nextInt(20) : 20 + rand.nextInt(20);
                MysteriumPatchesFixesCave.generateMazeCaveSegment(caveX, caveY, caveZ, var31, length, height);
                int dirSwitch = rand.nextInt(2) * 4 + 2;
                int maxOffset = length * 3 / 4;
                for (int offset = length / 5 + rand.nextInt(length / 4); offset < maxOffset; offset += length / 6 + rand.nextInt(length / 4) + 1) {
                    int x = MysteriumPatchesFixesCave.getOffsetX(caveX, var31, offset);
                    int z = MysteriumPatchesFixesCave.getOffsetZ(caveZ, var31, offset);
                    int direction2 = var31 + (dirSwitch += 4);
                    int length2 = length / 3 + rand.nextInt(length / 3);
                    if ((direction2 & 1) == 1) {
                        length2 -= offset / 4;
                    }
                    MysteriumPatchesFixesCave.generateMazeCaveSegment(x, caveY, z, direction2, length2, height);
                    int index = caveY + (direction2 / 2 & 3);
                    if (index != horizCave1 && index != horizCave2) {
                        if (index == vertCave1 || index == vertCave2) {
                            int offset2 = length2 / 4 + rand.nextInt(length2 / 2 + 1) + 1;
                            x = MysteriumPatchesFixesCave.getOffsetX(x, direction2, offset2);
                            z = MysteriumPatchesFixesCave.getOffsetZ(z, direction2, offset2);
                            if (index == vertCave1) {
                                vertCave1 = -999;
                                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, caveY, minY + yInc * 2, z, 0.0f, centerX, centerZ, 32);
                            } else {
                                vertCave2 = -999;
                                MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, caveY, 100, z, 0.0f, 0.0, 0.0, 0);
                            }
                        }
                    } else {
                        if (index == horizCave1) {
                            horizCave1 = -999;
                        } else {
                            horizCave2 = -999;
                        }
                        x = MysteriumPatchesFixesCave.getOffsetX(x, direction2, length2);
                        z = MysteriumPatchesFixesCave.getOffsetZ(z, direction2, length2);
                        MysteriumPatchesFixesCave.generateHorizontalLinkCave(x, caveY, z, centerX, centerZ, 0);
                    }
                    if (offset <= length / 2) continue;
                    x = MysteriumPatchesFixesCave.getOffsetX(caveX, var31, offset += rand.nextInt(length / 6) + 2);
                    z = MysteriumPatchesFixesCave.getOffsetZ(caveZ, var31, offset);
                    length2 = length / 3 + rand.nextInt(length / 3);
                    if (((direction2 += 4) & 1) == 1) {
                        length2 -= offset / 4;
                    }
                    MysteriumPatchesFixesCave.generateMazeCaveSegment(x, caveY, z, direction2, length2, height);
                }
            }
            length = caveY == maxY ? 100 : (caveY == minY ? maxY - yInc * 2 + 1 : Math.min(maxY, caveY + yInc) + 1);
            MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), caveX, caveY, length, caveZ, 0.0f, caveX, caveZ, 8);
            while ((quadrant = rand.nextInt(4)) == oldQuadrant) {
            }
            oldQuadrant = quadrant;
            height = 1.625f;
            ++caveCount;
        }
    }

    private static void generateRegionalCaves(int chunkX, int chunkZ) {
        if (rand.nextInt(100) + 1 <= WGConfig.caveRegionalReductionPercentage) {
            return;
        }
        Random r = new Random();
        r.setSeed(worldObj.func_72905_C());
        if (MysteriumPatchesFixesCave.isGiantCaveRegion(chunkX, chunkZ) || r.nextInt(100) < WGConfig.giantCaveChance) {
            int chunkOffX = MysteriumPatchesFixesCave.isEdgeOfGiantCaveRegion(chunkX, chunkZ);
            if (chunkOffX > 0 || (chunkX & 1) == (chunkZ & 1)) {
                int x;
                int chunkOffZ = chunkX;
                int div1 = chunkZ;
                while (MysteriumPatchesFixesCave.validRegionalCaveLocation(chunkOffZ - 1, div1, 4096)) {
                    --chunkOffZ;
                }
                while (MysteriumPatchesFixesCave.validRegionalCaveLocation(chunkOffZ, div1 - 1, 4096)) {
                    --div1;
                }
                int div2 = 0;
                float startY = 0.0f;
                int verticalCave = 0;
                for (x = div1; x < div1 + 12; ++x) {
                    for (int direction = chunkOffZ; direction < chunkOffZ + 12; ++direction) {
                        if ((direction & 1) != (x & 1) && MysteriumPatchesFixesCave.isEdgeOfGiantCaveRegion(direction, x) <= 0) continue;
                        caveRNG.setSeed(((long)direction * 341873128712L + (long)x * 132897987541L) * seedMultiplier);
                        div2 += caveRNG.nextInt(65);
                        startY += caveRNG.nextFloat() * caveRNG.nextFloat();
                        ++verticalCave;
                    }
                }
                div2 = Math.round(32.0f - (float)div2 / (float)verticalCave) + rand.nextInt(65) + 112;
                startY = 0.25f / (startY / (float)verticalCave) * rand.nextFloat() * rand.nextFloat() * (chunkOffX > 0 ? 12.0f : 11.3333f) + (chunkOffX > 0 ? 3.0f : 3.66667f);
                x = rand.nextInt(div2 / 4) + div2 / 2;
                float var25 = chunkOffX > 0 ? (float)(chunkOffX - 1) * 0.7853982f : rand.nextFloat() * ((float)Math.PI * 2);
                chunkOffZ = chunkX * 16 + 8;
                div1 = chunkZ * 16 + 8;
                int y = rand.nextInt(11) + 25 * (chunkOffX > 0 ? chunkX + chunkZ & 1 : chunkZ & 1) + 10;
                MysteriumPatchesFixesCave.generateLargeCave2(rand.nextLong(), chunkOffZ, y, div1, startY, var25, (rand.nextFloat() - 0.5f) / 4.0f, 0, div2, x, 0.1f, true, false);
                if (chunkOffX > 0 && (chunkOffX & 1) == 0) {
                    div2 = 64 + rand.nextInt(16);
                    MysteriumPatchesFixesCave.generateHorizontalCave(rand.nextLong(), chunkOffZ, y, div1, rand.nextFloat() + 1.0f, var25 + (float)Math.PI, (rand.nextFloat() - 0.5f) / 4.0f, div2, div2 + 32 + rand.nextInt(8), 1);
                }
                if (rand.nextInt(chunkOffX > 0 ? 12 : 6) == 0) {
                    MysteriumPatchesFixesCave.generateVerticalCave(chunkOffZ, y, 100, div1);
                }
            }
        } else {
            int chunkOffX = chunkX + caveOffsetX;
            int chunkOffZ = chunkZ + caveOffsetZ;
            int var20 = 2;
            int var21 = 3;
            if ((chunkOffX & 0x40) == (chunkOffZ & 0x40)) {
                var20 = 3;
                var21 = 2;
            }
            caveRNG.setSeed(((long)(chunkOffX / var20) * 341873128712L + (long)(chunkOffZ / var21) * 132897987541L) * seedMultiplier);
            if (chunkOffX % var20 == caveRNG.nextInt(var20) && chunkOffZ % var21 == caveRNG.nextInt(var21)) {
                int var22 = 10 + (chunkOffX / var21 + chunkOffZ / var20) % 3 * 20;
                boolean var23 = rand.nextBoolean();
                double var24 = chunkX * 16 + rand.nextInt(16);
                double var26 = var22;
                double z = chunkZ * 16 + rand.nextInt(16);
                float direction1 = rand.nextFloat() * ((float)Math.PI * 2);
                int segments = rand.nextInt(3) + 2;
                float width = Math.max(1.0f, !var23 && segments == 2 ? 1.0f : (float)(rand.nextInt(2) + 1) + (float)WGConfig.widthAdditionRegional);
                width = rand.nextFloat() * rand.nextFloat() * width + 0.5f;
                if (WGConfig.hardLimitsEnabled) {
                    width = Math.min(width, (float)WGConfig.widthMaxRegional);
                    width = Math.max(width, (float)WGConfig.widthMinRegional);
                }
                for (int i = 0; i < segments; ++i) {
                    float segmentDirection = direction1;
                    direction1 += (float)Math.PI * 2 / (float)segments;
                    if (segments > 2) {
                        segmentDirection += (rand.nextFloat() - 0.5f) * 2.094395f / (float)segments;
                    }
                    if (i > 0 && (var23 || segments > 2)) {
                        width = Math.max(0.6f, rand.nextFloat() * rand.nextFloat() * (float)(rand.nextInt(2) + 1) + 0.5f + (float)WGConfig.widthAdditionRegional);
                        if (WGConfig.hardLimitsEnabled) {
                            width = Math.min(width, (float)WGConfig.widthMaxRegional);
                            width = Math.max(width, (float)WGConfig.widthMinRegional);
                        }
                    }
                    MysteriumPatchesFixesCave.generateHorizontalCave(rand.nextLong(), var24, var26, z, width, segmentDirection, (rand.nextFloat() - 0.5f) / 4.0f, 0, 112 + rand.nextInt(65), 2);
                }
                if (var23) {
                    MysteriumPatchesFixesCave.generateVerticalCave(var24, var22, 100, z);
                    ++segments;
                }
                if (segments > 2) {
                    MysteriumPatchesFixesCave.generateCircularRoom(var24, var26, z, (rand.nextFloat() + 0.5f) * (float)segments + 1.0f);
                }
                if (!var23 && MysteriumPatchesFixesCave.validCaveClusterLocation(chunkX, chunkZ, false, true) > 0) {
                    MysteriumPatchesFixesCave.generateCaveCluster(chunkX, chunkZ, 1);
                }
            }
        }
    }

    private static void generateCave(long seed, double x, double y, double z, float width, float directionXZ, float directionY, int pos, int length, float curviness) {
        boolean isVerticalCave;
        caveRNG.setSeed(seed);
        float var23 = 0.0f;
        float var24 = 0.0f;
        int branchPoint = -999;
        if (pos <= 0) {
            length = 112 - caveRNG.nextInt(28);
            if (width >= 1.0f) {
                branchPoint = caveRNG.nextInt(length / 2) + length / 4;
            }
        }
        boolean bl = isVerticalCave = caveRNG.nextInt(6) == 0;
        while (pos < length) {
            if (pos == branchPoint) {
                seed = caveRNG.nextLong();
                width = caveRNG.nextFloat() * 0.5f + 0.5f + (float)WGConfig.widthAdditionBranchPoint;
                if (WGConfig.hardLimitsEnabled) {
                    width = Math.min(width, (float)WGConfig.widthMaxBranchPoint);
                    width = Math.max(width, (float)WGConfig.widthMinBranchPoint);
                }
                MysteriumPatchesFixesCave.generateCave(caveRNG.nextLong(), x, y, z, caveRNG.nextFloat() * 0.5f + 0.5f, directionXZ - 1.5707964f, directionY /= 3.0f, pos, length, curviness);
                MysteriumPatchesFixesCave.generateCave(seed, x, y, z, width, directionXZ + 1.5707964f, directionY, pos, length, curviness);
                return;
            }
            double var35 = x - chunkCenterX;
            double var37 = z - chunkCenterZ;
            double radiusW = 1.5f + MysteriumPatchesFixesCave.sine((float)pos * (float)Math.PI / (float)length) * width;
            double var39 = (double)(length - pos + 18) + radiusW;
            if (var35 * var35 + var37 * var37 > var39 * var39) {
                return;
            }
            if (caveRNG.nextInt(4) == 0) {
                radiusW = radiusW / 5.0 + 0.75;
            }
            float var33 = MysteriumPatchesFixesCave.cosine(directionY);
            x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * var33);
            y += (double)MysteriumPatchesFixesCave.sine(directionY);
            z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * var33);
            directionY = isVerticalCave ? (directionY *= 0.92f) : (directionY *= 0.7f);
            directionY += var24 * 0.1f;
            directionXZ += var23 * curviness;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            var23 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double radiusW_2 = radiusW + 9.0;
            if (x >= chunkCenterX - radiusW_2 && x <= chunkCenterX + radiusW_2 && z >= chunkCenterZ - radiusW_2 && z <= chunkCenterZ + radiusW_2) {
                double noiseMultiplier = 0.275 / Math.max(radiusW - 1.0, 0.916666);
                MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, radiusW, radiusW, noiseMultiplier, 1);
            }
            ++pos;
        }
    }

    private static void generateCircularRoom(double x, double y, double z, float width) {
        double var39;
        double var37;
        double var35;
        long seed = rand.nextLong();
        width += 1.0f;
        width = Math.max(1.0f, width + (float)WGConfig.widthAdditionCircular);
        if (WGConfig.hardLimitsEnabled) {
            width = Math.min(width, (float)WGConfig.widthMaxCircular);
            width = Math.max(width, (float)WGConfig.widthMinCircular);
        }
        if ((var35 = x - chunkCenterX) * var35 + (var37 = z - chunkCenterZ) * var37 <= (var39 = (double)(width + 18.0f)) * var39) {
            caveRNG.setSeed(seed);
            x += (double)(caveRNG.nextFloat() - 0.5f);
            y += (double)(caveRNG.nextFloat() - 0.5f);
            z += (double)(caveRNG.nextFloat() - 0.5f);
            double radiusW_2 = (double)width + 9.0;
            if (x >= chunkCenterX - radiusW_2 && x <= chunkCenterX + radiusW_2 && z >= chunkCenterZ - radiusW_2 && z <= chunkCenterZ + radiusW_2) {
                double noiseMultiplier = 0.33 / Math.max((double)(width - 1.0f), 1.1);
                MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, width, width / 2.0f, noiseMultiplier, 1);
            }
        }
    }

    private static void generateSingleCave(int x, int y, int z, float curviness) {
        float width = rand.nextFloat() * rand.nextFloat() * rand.nextFloat() * 5.0f + 0.5f;
        MysteriumPatchesFixesCave.generateCave(rand.nextLong(), x += rand.nextInt(16), y, z += rand.nextInt(16), width, rand.nextFloat() * ((float)Math.PI * 2), (rand.nextFloat() - 0.5f) / 4.0f, 0, 0, curviness);
    }

    private static int generateLargeCave(int chunkX, int chunkZ, int type) {
        int ret;
        float width;
        int length;
        if (type == 0) {
            length = 224 + largeCaveRNG.nextInt(113);
            width = largeCaveRNG.nextFloat() * 8.0f + largeCaveRNG.nextFloat() * 6.0f + 10.0f + (float)WGConfig.widthAdditionColossal;
            if (WGConfig.hardLimitsEnabled) {
                width = Math.min(width, (float)WGConfig.widthMaxColossal);
                width = Math.max(width, (float)WGConfig.widthMinColossal);
            }
            if (largeCaveRNG.nextBoolean()) {
                width *= (float)length / 224.0f;
            }
        } else {
            float x;
            length = Math.min(112 + largeCaveRNG.nextInt(largeCaveRNG.nextInt(336) + 1), 336);
            caveRNG.setSeed(((long)((chunkX + caveOffsetX + 12) / 16) * 341873128712L + (long)((chunkZ + caveOffsetZ + 12) / 16) * 132897987541L) * seedMultiplier);
            width = Math.max(largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat(), largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat() * largeCaveRNG.nextFloat() + (float)WGConfig.widthAdditionColossal);
            width = caveRNG.nextBoolean() ? width * 8.0f + 2.0f : width * 2.66667f + 2.66667f;
            if (largeCaveRNG.nextBoolean()) {
                x = largeCaveRNG.nextFloat() * (float)length / 96.0f + (float)(672 - length) / 672.0f;
                if (x > 1.0f) {
                    width *= x;
                }
            } else {
                x = largeCaveRNG.nextFloat();
                width *= x * x * 3.0f + 1.0f;
            }
        }
        double x1 = chunkX * 16 + 8;
        double y = largeCaveRNG.nextInt(16) + 15;
        double z = chunkZ * 16 + 8;
        if (y < 20.5) {
            y += (double)((width + 0.5f) / 4.0f);
        }
        int branchPoint = largeCaveRNG.nextInt(length / 4) + length / 2;
        float direction = largeCaveRNG.nextFloat() * ((float)Math.PI * 2);
        float curviness = (float)length / 3360.0f + 0.05f;
        if (type == 0) {
            ret = length - branchPoint;
            if (WGConfig.hardLimitsEnabled) {
                width = Math.min(width, (float)WGConfig.widthMaxColossal);
                width = Math.max(width, (float)WGConfig.widthMinColossal);
            }
            MysteriumPatchesFixesCave.generateLargeCave2(largeCaveRNG.nextLong(), x1, y, z, width, direction, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, ret, length, 0, curviness, false, true);
            length += ret;
            ret = length / 2;
            branchPoint = ret * 3 / 2 + largeCaveRNG.nextInt(ret / 4);
            MysteriumPatchesFixesCave.generateLargeCave2(largeCaveRNG.nextLong(), x1, y, z, (largeCaveRNG.nextFloat() * width + width * 2.0f) / 4.0f, direction + 1.5707964f, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, ret, length, branchPoint, curviness, true, true);
            MysteriumPatchesFixesCave.generateLargeCave2(largeCaveRNG.nextLong(), x1, y, z, (largeCaveRNG.nextFloat() * width + width * 2.0f) / 4.0f, direction - 1.5707964f, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, ret, length, branchPoint, curviness, true, true);
        } else {
            MysteriumPatchesFixesCave.generateLargeCave2(largeCaveRNG.nextLong(), x1, y, z, width, direction, (largeCaveRNG.nextFloat() - 0.5f) / 4.0f, 0, length, branchPoint, curviness, false, true);
        }
        ret = (int)(y + 0.5);
        if (type == 1) {
            ret += (int)(direction * 1024.0f) * 256;
        }
        return ret;
    }

    private static void generateLargeCave2(long seed, double x, double y, double z, float width, float directionXZ, float directionY, int pos, int length, int branchPoint, float curviness, boolean giantCaveBranch, boolean vertVar) {
        boolean isVerticalCave;
        caveRNG.setSeed(seed);
        float var23 = 0.0f;
        float var24 = 0.0f;
        float minRadius = 1.75f + width / 53.3333f;
        boolean bl = isVerticalCave = vertVar && caveRNG.nextInt(6) == 0 && width < 20.0f;
        while (pos < length) {
            if (pos == branchPoint) {
                seed = caveRNG.nextLong();
                if (giantCaveBranch) {
                    width *= 1.5f;
                }
                width = (caveRNG.nextFloat() * width + width) / 3.0f;
                MysteriumPatchesFixesCave.generateLargeCave2(caveRNG.nextLong(), x, y, z, (caveRNG.nextFloat() * width + width) / 3.0f, directionXZ - 1.5707964f, directionY /= 3.0f, pos, length, 0, curviness, false, true);
                MysteriumPatchesFixesCave.generateLargeCave2(seed, x, y, z, width, directionXZ + 1.5707964f, directionY, pos, length, 0, curviness, false, true);
                return;
            }
            double var35 = x - chunkCenterX;
            double var37 = z - chunkCenterZ;
            double radiusW = MysteriumPatchesFixesCave.sine((float)pos * (float)Math.PI / (float)length) * width;
            double var39 = (double)(length - pos + 18) + radiusW;
            if (var35 * var35 + var37 * var37 > var39 * var39) {
                return;
            }
            double ratio = 1.0f - (float)radiusW / 100.0f;
            double radiusH = (radiusW += (double)minRadius) * ratio;
            if (caveRNG.nextInt(4) == 0) {
                radiusW = radiusW / 5.0 + 0.75;
                radiusH = radiusH / 5.0 + 0.75;
            }
            float var33 = MysteriumPatchesFixesCave.cosine(directionY);
            x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * var33);
            y += (double)MysteriumPatchesFixesCave.sine(directionY);
            z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * var33);
            directionY = isVerticalCave ? (directionY *= 0.92f) : (directionY *= 0.7f);
            if (!vertVar) {
                if (y > 45.0) {
                    var24 = -0.5f;
                } else if (y < 4.0) {
                    var24 = 0.5f;
                }
            }
            directionY += var24 * 0.1f;
            directionXZ += var23 * curviness;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            var23 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double radiusW_2 = radiusW + 9.0;
            if (x >= chunkCenterX - radiusW_2 && x <= chunkCenterX + radiusW_2 && z >= chunkCenterZ - radiusW_2 && z <= chunkCenterZ + radiusW_2) {
                double noiseMultiplier = 0.275 / Math.max(radiusW - 1.0, 0.916666) + 0.0033735;
                MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, radiusW, radiusH, noiseMultiplier, 1);
            }
            ++pos;
        }
    }

    private static void generateHorizontalCave(long seed, double x, double y, double z, float width, float directionXZ, float directionY, int pos, int length, int caveType) {
        boolean isVerticalCave;
        float curviness;
        boolean flag;
        caveRNG.setSeed(seed);
        float var23 = 0.0f;
        float var24 = 0.0f;
        int branchPoint = -999;
        float startDir = directionXZ;
        double startY = y;
        int branchFlag = -1;
        boolean bl = flag = caveType < 1 || caveType == 2;
        if (caveType < 2) {
            curviness = 0.1f;
        } else {
            float f = curviness = caveType != 3 && caveRNG.nextInt(4) != 0 ? 0.025f : 0.05f;
        }
        if (caveType == 1) {
            if (pos == 0) {
                branchPoint = Math.min(length * 2 / 3 + caveRNG.nextInt(length / 11), 120);
            } else {
                branchPoint = pos;
                pos = 0;
                branchFlag = 0;
            }
        }
        boolean bl2 = isVerticalCave = flag && caveRNG.nextInt(6) == 0;
        while (pos < length) {
            float radiusW_2;
            if (pos == branchPoint) {
                seed = caveRNG.nextLong();
                float var38 = Math.min(width * 0.75f, caveRNG.nextFloat() * width * 0.75f + width * 0.25f);
                width = Math.min(width * 0.75f, caveRNG.nextFloat() * width * 0.75f + width * 0.25f);
                MysteriumPatchesFixesCave.generateHorizontalCave(caveRNG.nextLong(), x, y, z, width, directionXZ - 1.5707964f, directionY /= 3.0f, pos, length, branchFlag);
                MysteriumPatchesFixesCave.generateHorizontalCave(seed, x, y, z, var38, directionXZ + 1.5707964f, directionY, pos, length, branchFlag);
                return;
            }
            double var35 = x - chunkCenterX;
            double var37 = z - chunkCenterZ;
            double var39 = (double)(length - pos + 18) + (double)width;
            if (var35 * var35 + var37 * var37 > var39 * var39) {
                return;
            }
            double radiusW = 1.25;
            float var33 = MysteriumPatchesFixesCave.cosine(directionY);
            x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * var33);
            y += (double)MysteriumPatchesFixesCave.sine(directionY);
            z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * var33);
            directionY = isVerticalCave ? (directionY *= 0.92f) : (directionY *= 0.7f);
            if (caveType < 2) {
                radiusW += (double)(MysteriumPatchesFixesCave.sine((float)pos * (float)Math.PI / (float)length) * width);
                if (caveType >= 0) {
                    radiusW_2 = directionXZ - startDir;
                    if (radiusW_2 > 0.7853982f) {
                        var23 = -0.5f;
                    } else if (radiusW_2 < -0.7853982f) {
                        var23 = 0.5f;
                    }
                    radiusW_2 = (float)(y - startY);
                    if (radiusW_2 > 5.0f) {
                        var24 = -0.5f;
                    } else if (radiusW_2 < -5.0f) {
                        var24 = 0.5f;
                    }
                }
            } else {
                if (pos < length - 3) {
                    radiusW += 0.25;
                }
                if (pos < length - 6) {
                    radiusW += (double)(width * caveRNG.nextFloat());
                }
                if (caveType == 2) {
                    radiusW_2 = (float)(y - startY);
                    if (radiusW_2 > 5.0f) {
                        var24 = -0.5f;
                    } else if (radiusW_2 < -5.0f) {
                        var24 = 0.5f;
                    }
                } else if (caveType == 3) {
                    radiusW_2 = directionXZ - startDir;
                    if (radiusW_2 > 0.7853982f) {
                        var23 = -0.5f;
                    } else if (radiusW_2 < -0.7853982f) {
                        var23 = 0.5f;
                    }
                }
            }
            directionY += var24 * 0.1f;
            var24 *= 0.9f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            if (caveRNG.nextInt(4) == 0) {
                radiusW = 1.25;
            }
            directionXZ += var23 * curviness;
            var23 *= 0.75f;
            var23 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double var391 = radiusW + 9.0;
            if (x >= chunkCenterX - var391 && x <= chunkCenterX + var391 && z >= chunkCenterZ - var391 && z <= chunkCenterZ + var391) {
                double noiseMultiplier = radiusW < 1.916666 ? 0.15 : 0.275 / (radiusW - 1.0);
                MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, radiusW, radiusW, noiseMultiplier, 1);
            }
            ++pos;
        }
    }

    private static void generateDirectionalCave(int x, int y, int z, int cx, int cz, int offset) {
        float direction = (rand.nextFloat() - 0.5f) * 0.7853982f;
        boolean length = false;
        cx = x - cx;
        cz = z - cz;
        if (cx > offset) {
            direction = cz > offset ? (direction -= 2.35619f) : (cz < -offset ? (direction += 2.35619f) : (direction += (float)Math.PI));
        } else if (cx < -offset) {
            if (cz > offset) {
                direction -= 0.7853982f;
            } else if (cz < -offset) {
                direction += 0.7853982f;
            }
        } else if (cz > offset) {
            direction -= 1.0f;
        } else if (cz < -offset) {
            direction += 1.0f;
        } else {
            direction *= 8.0f;
            length = true;
        }
        int var9 = !length ? rand.nextInt(16) + 8 + Math.round((float)Math.sqrt(cx * cx + cz * cz)) : rand.nextInt(8) + 24;
        float width = Math.max(0.01f, rand.nextFloat() * 0.5f + (float)WGConfig.widthAdditionDirectional / 10.0f);
        if (WGConfig.hardLimitsEnabled) {
            width = Math.min(width, (float)WGConfig.widthMaxDirectional);
            width = Math.max(width, (float)WGConfig.widthMinDirectional);
        }
        MysteriumPatchesFixesCave.generateHorizontalCave(rand.nextLong(), x, y, z, width, direction, (rand.nextFloat() - 0.5f) / 4.0f, 0, var9, 0);
    }

    private static void generateHorizontalLinkCave(int x, int y, int z, int cx, int cz, int type) {
        int length;
        int caveType;
        float direction = (rand.nextFloat() - 0.5f) * 0.7853982f;
        cx = x - cx;
        cz = z - cz;
        direction = cx == 0 && cz == 0 ? (direction *= 8.0f) : (cx >= 0 ? (cz >= 0 ? (direction += 0.7853982f) : (direction -= 0.7853982f)) : (cz >= 0 ? (direction += 2.35619f) : (direction -= 2.35619f)));
        float width = rand.nextFloat() * 0.75f + 0.25f;
        width += (float)WGConfig.widthAdditionNormal;
        width = Math.max(0.275f, width);
        if (WGConfig.hardLimitsEnabled) {
            width = Math.min(width, (float)WGConfig.widthMaxNormal);
            width = Math.max(width, (float)WGConfig.widthMinNormal);
        }
        if ((type & 1) == 0) {
            caveType = 1;
            length = (type == 4 ? 144 : 128) + rand.nextInt(32);
        } else {
            caveType = 0;
            length = 80 + rand.nextInt(16);
        }
        MysteriumPatchesFixesCave.generateHorizontalCave(rand.nextLong(), x, y, z, width, direction, (rand.nextFloat() - 0.5f) / 4.0f, 0, length, caveType);
        if (type >= 2) {
            length = 20 + rand.nextInt(6);
            MysteriumPatchesFixesCave.generateHorizontalCave(rand.nextLong(), x, y, z, Math.min(width * 0.75f, rand.nextFloat() * width * 0.75f + width * 0.25f), direction - 2.0944f, (rand.nextFloat() - 0.5f) / 4.0f, 0, length, -1);
            MysteriumPatchesFixesCave.generateHorizontalCave(rand.nextLong(), x, y, z, Math.min(width * 0.75f, rand.nextFloat() * width * 0.75f + width * 0.25f), direction + 2.0944f, (rand.nextFloat() - 0.5f) / 4.0f, 0, length, -1);
        }
    }

    private static void generateVerticalCave(double x, int y1, int y2, double z) {
        MysteriumPatchesFixesCave.generateVerticalCave(rand.nextLong(), x, y1, y2, z, -1.0f, 0.0, 0.0, 0);
    }

    private static void generateVerticalCave(long seed, double x, int y1, int y2, double z, float width, double centerX, double centerZ, int maxDeviation) {
        int length;
        caveRNG.setSeed(seed);
        float var23 = 0.0f;
        width += Math.max(0.0f, (float)WGConfig.widthAdditionVertical);
        if (WGConfig.hardLimitsEnabled) {
            width = Math.min(width, (float)WGConfig.widthMaxVertical);
            width = Math.max(width, (float)WGConfig.widthMinVertical);
        }
        float directionXZ = caveRNG.nextFloat() * ((float)Math.PI * 2);
        boolean descending = false;
        maxDeviation *= maxDeviation;
        float horizVar = 1.0f;
        if (width != 0.0f) {
            horizVar = caveRNG.nextFloat();
            horizVar = 1.0f - horizVar * horizVar * 0.333333f;
        }
        if (y1 > y2) {
            length = y1;
            y1 = y2;
            y2 = length;
            descending = true;
        }
        length = y2 - y1;
        for (int i = 0; i < length; ++i) {
            float devZ;
            float radiusW_2;
            double var35 = x - chunkCenterX;
            double var37 = z - chunkCenterZ;
            double var39 = (double)(length - i + 18) + (double)width;
            if (var35 * var35 + var37 * var37 > var39 * var39) {
                return;
            }
            double radiusW = width >= 0.0f ? (double)(1.5f + MysteriumPatchesFixesCave.sine((float)i * 1.5707964f / (float)length) * width) : (double)(1.5f + (caveRNG.nextFloat() + caveRNG.nextFloat()) * 0.5f);
            x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * horizVar);
            z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * horizVar);
            if (maxDeviation == 1) {
                radiusW_2 = (float)(x - centerX);
                devZ = (float)(z - centerZ);
                if (radiusW_2 > 1.0f) {
                    x -= 1.0;
                }
                if (radiusW_2 < -1.0f) {
                    x += 1.0;
                }
                if (devZ > 1.0f) {
                    z -= 1.0;
                }
                if (devZ < -1.0f) {
                    z += 1.0;
                }
            } else if (maxDeviation > 0 && (radiusW_2 = (float)(x - centerX)) * radiusW_2 + (devZ = (float)(z - centerZ)) * devZ > (float)maxDeviation) {
                directionXZ = devZ >= 0.0f ? (radiusW_2 >= 0.0f ? (directionXZ * 3.0f - 2.35619f) / 4.0f : (directionXZ * 3.0f - 0.7853982f) / 4.0f) : (radiusW_2 >= 0.0f ? (directionXZ * 3.0f + 2.35619f) / 4.0f : (directionXZ * 3.0f + 0.7853982f) / 4.0f);
            }
            directionXZ += var23 * 0.15f;
            var23 *= 0.75f;
            var23 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double var371 = radiusW + 9.0;
            if (!(x >= chunkCenterX - var371) || !(x <= chunkCenterX + var371) || !(z >= chunkCenterZ - var371) || !(z <= chunkCenterZ + var371)) continue;
            double noiseMultiplier = radiusW < 1.916666 ? 0.15 : 0.275 / (radiusW - 1.0);
            double radiusH = 1.5;
            double y = descending ? (double)(y2 - i - 1) : (double)(y1 + i);
            if (i == length - 1 && width >= 0.5f) {
                radiusH = width + 1.0f;
            }
            MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, radiusW, radiusH, noiseMultiplier, 1);
        }
    }

    private static void generateRavineCave(double x, double y, double z, float heightVariation) {
        int length = rand.nextInt(5) + 16;
        int segmentLength = length + rand.nextInt(4) * 2;
        float width = rand.nextFloat() * rand.nextFloat() + 1.0f + Math.max(-1.0f, (float)WGConfig.widthAdditionRavineCave);
        if (WGConfig.hardLimitsEnabled) {
            width = Math.min(width, (float)WGConfig.widthMaxRavineCave);
            width = Math.max(width, (float)WGConfig.widthMinRavineCave);
        }
        float height = rand.nextFloat() * heightVariation + 2.0f;
        float direction = rand.nextFloat() * (float)Math.PI;
        float directionY = (rand.nextFloat() - 0.5f) / 4.0f;
        float slope = (rand.nextFloat() * 0.75f + 0.25f) * 0.25f * (float)(rand.nextInt(2) * 2 - 1);
        MysteriumPatchesFixesCave.generateRavineCaveSegment(rand.nextLong(), x, y, z, width, direction, directionY, slope, segmentLength, height);
        segmentLength = length + rand.nextInt(4) * 2;
        MysteriumPatchesFixesCave.generateRavineCaveSegment(rand.nextLong(), x, y, z, width, direction + (float)Math.PI, -directionY, -slope, segmentLength, height);
        if (rand.nextBoolean()) {
            length = rand.nextInt(5) + 16;
            segmentLength = length + rand.nextInt(4) * 2;
            width = rand.nextFloat() * rand.nextFloat() + 1.0f;
            height = rand.nextFloat() * heightVariation + 2.0f;
            directionY = (rand.nextFloat() - 0.5f) / 4.0f;
            slope = (rand.nextFloat() * 0.75f + 0.25f) * 0.25f * (float)(rand.nextInt(2) * 2 - 1) * ((float)rand.nextInt(2) * 0.75f + 0.25f);
            MysteriumPatchesFixesCave.generateRavineCaveSegment(rand.nextLong(), x, y, z, width, direction += (rand.nextFloat() * 0.7853982f + 0.393699f) * (float)(rand.nextInt(2) * 2 - 1), directionY, slope, segmentLength, height);
            if (rand.nextBoolean()) {
                segmentLength = length + rand.nextInt(4) * 2;
                MysteriumPatchesFixesCave.generateRavineCaveSegment(rand.nextLong(), x, y, z, width, direction + (float)Math.PI, -directionY, -slope, segmentLength, height);
            }
        }
    }

    private static void generateRavineCaveSegment(long seed, double x, double y, double z, float width, float directionXZ, float directionY, float slope, int length, float heightRatio) {
        caveRNG.setSeed(seed);
        float var24 = 0.0f;
        float var25 = 0.0f;
        float startDir = directionXZ;
        int end = width >= 1.666f ? 3 : (width >= 1.333f ? 2 : 1);
        width /= 2.0f;
        for (int pos = 0; pos < length; ++pos) {
            double var34 = x - chunkCenterX;
            double var36 = z - chunkCenterZ;
            double var38 = length - pos + 18;
            if (var34 * var34 + var36 * var36 > var38 * var38) {
                return;
            }
            double radiusW = width;
            if (pos < length - end) {
                radiusW += (double)(caveRNG.nextFloat() * 0.5f);
            }
            if (pos < length - end * 2) {
                radiusW += (double)width;
            }
            double radiusH = radiusW * (double)heightRatio;
            radiusW *= (double)(caveRNG.nextFloat() * 0.25f + 0.75f);
            radiusH *= (double)(caveRNG.nextFloat() * 0.25f + 0.75f);
            float var32 = MysteriumPatchesFixesCave.cosine(directionY);
            x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * var32);
            y += (double)(MysteriumPatchesFixesCave.sine(directionY) + slope);
            z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * var32);
            float dev = directionXZ - startDir;
            if (dev > 0.392699f) {
                var24 = -0.5f;
            } else if (dev < -0.392699f) {
                var24 = 0.5f;
            }
            directionY *= 0.7f;
            directionY += var25 * 0.1f;
            directionXZ += var24 * 0.1f;
            var25 *= 0.5f;
            var24 *= 0.75f;
            var25 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double radiusW_2 = radiusW + 9.0;
            if (!(x >= chunkCenterX - radiusW_2) || !(x <= chunkCenterX + radiusW_2) || !(z >= chunkCenterZ - radiusW_2) || !(z <= chunkCenterZ + radiusW_2)) continue;
            int var56 = MathHelper.func_76128_c((double)(x - radiusW)) - chunkX_16 - 1;
            int var35 = MathHelper.func_76128_c((double)(x + radiusW)) - chunkX_16 + 1;
            int var55 = (int)(y - radiusH) - 1;
            int var37 = (int)(y + radiusH) + 1;
            int var57 = MathHelper.func_76128_c((double)(z - radiusW)) - chunkZ_16 - 1;
            int var39 = MathHelper.func_76128_c((double)(z + radiusW)) - chunkZ_16 + 1;
            if (var56 < 0) {
                var56 = 0;
            }
            if (var35 > 16) {
                var35 = 16;
            }
            if (var55 < 0) {
                var55 = 0;
            }
            if (var37 > 200) {
                var37 = 200;
            }
            if (var57 < 0) {
                var57 = 0;
            }
            if (var39 > 16) {
                var39 = 16;
            }
            for (int var41 = var56; var41 < var35; ++var41) {
                double var59 = ((double)(var41 + chunkX_16) + 0.5 - x) / radiusW;
                var59 *= var59;
                for (int var44 = var57; var44 < var39; ++var44) {
                    double var45 = ((double)(var44 + chunkZ_16) + 0.5 - z) / radiusW;
                    if (!((var45 = var45 * var45 + var59) < 1.0)) continue;
                    int var47 = var41 << 12 | var44 << 8 | var37;
                    int biome = MysteriumPatchesFixesCave.worldObj.getBiomeGenForCoordsBody((int)(var41 + MysteriumPatchesFixesCave.chunkX_16), (int)(var44 + MysteriumPatchesFixesCave.chunkZ_16)).field_76756_M;
                    for (int var49 = var37 - 1; var49 >= var55; --var49) {
                        double var50 = ((double)var49 + 0.5 - y) / radiusH;
                        if (var50 > -0.7 && var45 + var50 * var50 / 6.0 + (double)(noiseGen.nextInt(3) - 1) * 0.3 < 1.0) {
                            MysteriumPatchesFixesCave.replaceBlock(var47, var41, var44, biome);
                        }
                        --var47;
                    }
                }
            }
        }
    }

    private static void generateMazeCaveSegment(int x, int y, int z, int direction, int length, float height) {
        float width = Math.max(1.45f, (direction & 1) == 1 ? 1.55f : 1.45f + (float)WGConfig.widthAdditionMaze);
        if (WGConfig.hardLimitsEnabled) {
            width = Math.min(width, (float)WGConfig.widthMaxMaze);
            width = Math.max(width, (float)WGConfig.widthMinMaze);
        }
        for (int pos = 0; pos < length; ++pos) {
            double var34 = (double)x - chunkCenterX;
            double var36 = (double)z - chunkCenterZ;
            double var38 = length - pos + 18;
            if (var34 * var34 + var36 * var36 > var38 * var38) {
                return;
            }
            x = MysteriumPatchesFixesCave.getOffsetX(x, direction, 1);
            z = MysteriumPatchesFixesCave.getOffsetZ(z, direction, 1);
            double radiusW = (double)width + 10.0;
            if (!((double)x >= chunkCenterX - radiusW) || !((double)x <= chunkCenterX + radiusW) || !((double)z >= chunkCenterZ - radiusW) || !((double)z <= chunkCenterZ + radiusW)) continue;
            radiusW = noiseGen.nextFloat() * 0.5f + width;
            double radiusH = noiseGen.nextFloat() * 0.5f + height;
            double var10000 = noiseGen.nextFloat() - 0.5f + (float)x;
            var10000 = noiseGen.nextFloat() - 0.5f + (float)y;
            var10000 = noiseGen.nextFloat() - 0.5f + (float)z;
            MysteriumPatchesFixesCave.generateCaveSegment(x, y, z, radiusW, radiusH, width / 7.25f, 0);
        }
    }

    private static void generateRavines(int chunkX, int chunkZ, boolean flag, int genCaves) {
        if (rand.nextInt(20) == 15) {
            if (genCaves == 3 && MysteriumPatchesFixesCave.isGiantCaveRegion(chunkX, chunkZ)) {
                return;
            }
            int bigRavine = -1;
            boolean notNearOrigin = true;
            if (notNearOrigin) {
                int x = chunkX + caveOffsetX + 4;
                int offsetZ = chunkZ + caveOffsetZ + 4;
                if ((x & 7) == 0 && (offsetZ & 7) == 0 && (x & 8) != (offsetZ & 8)) {
                    bigRavine = 2;
                } else if (rand.nextInt(25) < 19 && x % 3 == 0 && offsetZ % 3 == 0 && (x / 3 & 1) == (offsetZ / 3 & 1)) {
                    bigRavine = 1;
                }
            }
            if (bigRavine > 0 && genCaves == 5) {
                bigRavine = 0;
            }
            if (bigRavine >= 0 || flag && (rand.nextInt(30) < 11 || !notNearOrigin && rand.nextInt(20) == 0)) {
                double var24 = chunkX * 16 + 8;
                double y = rand.nextInt(rand.nextInt(50) + 8) + 13;
                double z = chunkZ * 16 + 8;
                float directionXZ = rand.nextFloat() * (float)Math.PI;
                float directionY = (rand.nextFloat() - 0.5f) / 4.0f;
                float width = Math.max(rand.nextFloat() * 3.0f, rand.nextFloat() * 4.0f + rand.nextFloat() * 2.0f + (float)WGConfig.widthAdditionRavineCave);
                if (WGConfig.hardLimitsEnabled) {
                    width = Math.min(width, (float)WGConfig.widthMaxRavineCave);
                    width = Math.max(width, (float)WGConfig.widthMinRavineCave);
                }
                if (rand.nextInt(4) == 0) {
                    width += rand.nextFloat() * (bigRavine != 1 && width < 2.0f ? 0.0f : 2.0f);
                }
                double heightRatio = 3.0;
                int length = 112 - rand.nextInt(15) * 2;
                float curviness = 0.05f;
                if (rand.nextInt(3) == 0) {
                    curviness = rand.nextInt(3) == 0 ? 0.1f : 0.075f;
                }
                if (bigRavine <= 0) {
                    int data = biomeList[MysteriumPatchesFixesCave.worldObj.getBiomeGenForCoordsBody((int)(chunkX * 16 + 8), (int)(chunkZ * 16 + 8)).field_76756_M] >> 2 & 3;
                    if (rand.nextBoolean() && data == 1 || data == 2) {
                        data = rand.nextInt(2) + 1;
                        if (y < 31.5) {
                            y += (double)(data * 8);
                        }
                        heightRatio += (double)data;
                        if (width > (float)(6 - data)) {
                            width /= 2.0f;
                        }
                    }
                } else {
                    length += rand.nextInt(64) * 2;
                    if (width < 2.0f && (width += 1.0f) < 2.0f) {
                        width += 1.0f;
                    }
                    width *= rand.nextFloat() * rand.nextFloat() * 1.5f + 1.0f;
                    if (bigRavine == 2) {
                        width += rand.nextFloat() * (float)((length += 80 + rand.nextInt(40) * 2) / 56) + 3.0f;
                    }
                    if (length > 336) {
                        length = 336;
                    }
                    if (width > 18.0f) {
                        width = 18.0f;
                    }
                    if (y < 23.5) {
                        y += (double)(width / 1.5f);
                    } else if (y > 52.5) {
                        y -= (double)(width * 1.5f);
                    } else if (y > 42.5) {
                        y -= (double)(width / 1.5f);
                    }
                    curviness = (curviness + (float)length / 8960.0f + 0.0125f) / 1.5f;
                }
                float var25 = 1.0f;
                float ravineDataMultiplier = 1.1f - (width - 2.0f) * 0.07f;
                if (ravineDataMultiplier < 0.6f) {
                    ravineDataMultiplier = 0.6f - (0.6f - ravineDataMultiplier) * 0.290322f;
                }
                int skipCount = 999;
                for (int i = 0; i < 128; ++i) {
                    if (++skipCount >= 2 && (skipCount >= 5 || rand.nextInt(3) == 0)) {
                        skipCount = 0;
                        var25 = (1.0f + rand.nextFloat() * rand.nextFloat() * ravineDataMultiplier) * (0.95f + (float)rand.nextInt(2) * 0.1f);
                        var25 *= var25;
                    }
                    MysteriumPatchesFixesCave.ravineData[i] = var25;
                }
                MysteriumPatchesFixesCave.generateRavineHalf(rand.nextLong(), var24, y, z, width, directionXZ, directionY, heightRatio, length /= 2, curviness, bigRavine > 0);
                MysteriumPatchesFixesCave.generateRavineHalf(rand.nextLong(), var24, y, z, width, directionXZ + (float)Math.PI, -directionY, heightRatio, length, curviness, bigRavine > 0);
            }
        }
    }

    private static void generateRavineHalf(long seed, double x, double y, double z, float width, float directionXZ, float directionY, double heightRatio, int length, float curviness, boolean bigRavine) {
        caveRNG.setSeed(seed);
        float var24 = 0.0f;
        float var25 = 0.0f;
        float startDir = directionXZ;
        for (int pos = 0; pos < length; ++pos) {
            double var34 = x - chunkCenterX;
            double var36 = z - chunkCenterZ;
            double radiusW = 1.5f + MysteriumPatchesFixesCave.cosine((float)pos * 1.5707964f / (float)length) * width;
            double var38 = (double)(length - pos + 18) + radiusW;
            if (var34 * var34 + var36 * var36 > var38 * var38) {
                return;
            }
            double radiusH = radiusW * heightRatio;
            if (bigRavine) {
                radiusH = width > 5.5f ? (radiusH *= (double)ravineHeightLookup[(int)(radiusW * 10.025642) - 15]) : (radiusH *= (double)((ravineHeightLookup[(int)(radiusW * 10.025642) - 15] + Math.max(1.875f - (float)radiusW / 4.0f, 1.0f) + 0.25f) / 2.25f));
            } else if (width > 2.0f) {
                radiusH *= (double)Math.max(1.875f - (float)radiusW / 4.0f, 1.0f);
            }
            radiusW *= (double)(caveRNG.nextFloat() * 0.25f + 0.75f);
            radiusH *= (double)(caveRNG.nextFloat() * 0.25f + 0.75f);
            if (caveRNG.nextInt(4) == 0) {
                radiusW = radiusW / 5.0 + 0.5;
                radiusH = radiusH / 4.0 + 1.5;
            }
            float var32 = MysteriumPatchesFixesCave.cosine(directionY);
            x += (double)(MysteriumPatchesFixesCave.cosine(directionXZ) * var32);
            y += (double)MysteriumPatchesFixesCave.sine(directionY);
            z += (double)(MysteriumPatchesFixesCave.sine(directionXZ) * var32);
            float dev = directionXZ - startDir;
            if (dev > 0.7853982f) {
                var24 = -0.5f;
            } else if (dev < -0.7853982f) {
                var24 = 0.5f;
            }
            directionY *= 0.7f;
            directionY += var25 * 0.05f;
            directionXZ += var24 * curviness;
            var25 *= 0.8f;
            var24 *= 0.5f;
            var25 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            double radiusW_2 = radiusW + 9.0;
            if (!(x >= chunkCenterX - radiusW_2) || !(x <= chunkCenterX + radiusW_2) || !(z >= chunkCenterZ - radiusW_2) || !(z <= chunkCenterZ + radiusW_2)) continue;
            int var56 = MathHelper.func_76128_c((double)(x - radiusW)) - chunkX_16 - 1;
            int var35 = MathHelper.func_76128_c((double)(x + radiusW)) - chunkX_16 + 1;
            int var55 = (int)(y - radiusH) - 1;
            int var37 = (int)(y + radiusH) + 1;
            int var57 = MathHelper.func_76128_c((double)(z - radiusW)) - chunkZ_16 - 1;
            int var39 = MathHelper.func_76128_c((double)(z + radiusW)) - chunkZ_16 + 1;
            if (var56 < 0) {
                var56 = 0;
            }
            if (var35 > 16) {
                var35 = 16;
            }
            if (var55 < 0) {
                var55 = 0;
            }
            if (var37 > 120) {
                var37 = 120;
            }
            if (var57 < 0) {
                var57 = 0;
            }
            if (var39 > 16) {
                var39 = 16;
            }
            double noiseMultiplier = 0.33333333 / Math.max(radiusW - 0.5, 2.5);
            for (int var41 = var56; var41 < var35; ++var41) {
                double var59 = ((double)(var41 + chunkX_16) + 0.5 - x) / radiusW;
                var59 *= var59;
                for (int var44 = var57; var44 < var39; ++var44) {
                    double var45 = ((double)(var44 + chunkZ_16) + 0.5 - z) / radiusW;
                    if (!((var45 = var45 * var45 + var59) < 1.0)) continue;
                    int var47 = var41 << 12 | var44 << 8 | var37;
                    int biome = MysteriumPatchesFixesCave.worldObj.getBiomeGenForCoordsBody((int)(var41 + MysteriumPatchesFixesCave.chunkX_16), (int)(var44 + MysteriumPatchesFixesCave.chunkZ_16)).field_76756_M;
                    for (int var49 = var37 - 1; var49 >= var55; --var49) {
                        double var50 = ((double)var49 + 0.5 - y) / radiusH;
                        if (var45 * (double)ravineData[var49] + var50 * var50 / 6.0 + (double)(noiseGen.nextInt(3) - 1) * noiseMultiplier < 1.0) {
                            MysteriumPatchesFixesCave.replaceBlock(var47, var41, var44, biome);
                        }
                        --var47;
                    }
                }
            }
        }
    }

    private static void generateCaveSegment(double x, double y, double z, double radiusW, double radiusH, double noiseMultiplier, int noiseOffset) {
        int var55 = MathHelper.func_76128_c((double)(x - radiusW)) - chunkX_16 - 1;
        int var36 = MathHelper.func_76128_c((double)(x + radiusW)) - chunkX_16 + 1;
        int var57 = (int)(y - radiusH) - 1;
        int var38 = (int)(y + radiusH) + 1;
        int var56 = MathHelper.func_76128_c((double)(z - radiusW)) - chunkZ_16 - 1;
        int var40 = MathHelper.func_76128_c((double)(z + radiusW)) - chunkZ_16 + 1;
        if (var55 < 0) {
            var55 = 0;
        }
        if (var36 > 16) {
            var36 = 16;
        }
        if (var57 < 0) {
            var57 = 0;
        }
        if (var38 > 200) {
            var38 = 200;
        }
        if (var56 < 0) {
            var56 = 0;
        }
        if (var40 > 16) {
            var40 = 16;
        }
        for (int var42 = var55; var42 < var36; ++var42) {
            double var59 = ((double)(var42 + chunkX_16) + 0.5 - x) / radiusW;
            var59 *= var59;
            for (int var45 = var56; var45 < var40; ++var45) {
                double var46 = ((double)(var45 + chunkZ_16) + 0.5 - z) / radiusW;
                if (!((var46 = var46 * var46 + var59) < 1.0)) continue;
                int var48 = var42 << 12 | var45 << 8 | var38;
                int biome = MysteriumPatchesFixesCave.worldObj.getBiomeGenForCoordsBody((int)(var42 + MysteriumPatchesFixesCave.chunkX_16), (int)(var45 + MysteriumPatchesFixesCave.chunkZ_16)).field_76756_M;
                for (int var50 = var38 - 1; var50 >= var57; --var50) {
                    double var51 = ((double)var50 + 0.5 - y) / radiusH;
                    if (var51 > -0.7 && var51 * var51 + var46 + (double)(noiseGen.nextInt(3) - noiseOffset) * noiseMultiplier < 1.0) {
                        MysteriumPatchesFixesCave.replaceBlock(var48, var42, var45, biome);
                    }
                    --var48;
                }
            }
        }
    }

    private static void replaceBlock(int index, int x, int z, int biome) {
        Block data = chunkData[index];
        if (data != null || data != Blocks.field_150350_a) {
            int y = index & 0xFF;
            if (y >= 25 && y <= 62) {
                int z2;
                int x2;
                int minX = Math.max(x - 1, 0);
                int maxX = Math.min(x + 1, 15);
                int minZ = Math.max(z - 1, 0);
                int maxZ = Math.min(z + 1, 15);
                for (x2 = minX; x2 <= maxX; ++x2) {
                    for (z2 = minZ; z2 <= maxZ; ++z2) {
                        int xyz = x2 << 12 | z2 << 8 | y;
                        if (chunkData[xyz] == Blocks.field_150355_j) {
                            return;
                        }
                        if (chunkData[xyz + 1] != Blocks.field_150355_j) continue;
                        return;
                    }
                }
                for (x2 = minX; x2 <= maxX; ++x2) {
                    z2 = z - 2;
                    if (z2 >= 0 && chunkData[x2 << 12 | z2 << 8 | y] == Blocks.field_150355_j) {
                        return;
                    }
                    z2 = z + 2;
                    if (z2 > 15 || chunkData[x2 << 12 | z2 << 8 | y] != Blocks.field_150355_j) continue;
                    return;
                }
                for (z2 = minZ; z2 <= maxZ; ++z2) {
                    x2 = x - 2;
                    if (x2 >= 0 && chunkData[x2 << 12 | z2 << 8 | y] == Blocks.field_150355_j) {
                        return;
                    }
                    x2 = x + 2;
                    if (x2 > 15 || chunkData[x2 << 12 | z2 << 8 | y] != Blocks.field_150355_j) continue;
                    return;
                }
                if (chunkData[x << 12 | z << 8 | y + 2] == Blocks.field_150355_j) {
                    return;
                }
            }
            if (y >= 60 && y <= 64 && (biomeList[biome] & 0x20) != 0) {
                return;
            }
            BiomeGenBase bm = null;
            try {
                bm = worldObj.getBiomeGenForCoordsBody(x + chunkX_16, z + chunkZ_16);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean flag1 = false;
            for (String str : WGConfig.secondYLevelList) {
                if (!bm.field_76791_y.equalsIgnoreCase(str)) continue;
                flag1 = true;
                break;
            }
            if (bm != null && y < oceanAvg && WGConfig.secondYLevel && flag1) {
                MysteriumPatchesFixesCave.chunkData[index] = Blocks.field_150355_j;
                if (CavesDecorator.shouldGenerateStone(worldObj, x + chunkX_16, z + chunkZ_16)) {
                    MysteriumPatchesFixesCave.chunkData[index] = newRand.nextFloat() > 0.5f ? Blocks.field_150348_b : Blocks.field_150347_e;
                }
            } else if (y < WGConfig.floodLevel) {
                MysteriumPatchesFixesCave.chunkData[index] = WGConfig.floodMech == 1 ? Blocks.field_150353_l : Blocks.field_150355_j;
            } else {
                if (y > 56 && (data == Blocks.field_150349_c || data == Blocks.field_150391_bh) && chunkData[index - 1] == Blocks.field_150346_d) {
                    MysteriumPatchesFixesCave.chunkData[index - 1] = data;
                }
                MysteriumPatchesFixesCave.chunkData[index] = null;
                if (y > 25) {
                    data = chunkData[index + 1];
                    if (data == Blocks.field_150354_m) {
                        MysteriumPatchesFixesCave.chunkData[index + 1] = !(biome >= 37 && biome <= 39 || biome >= 165 && biome <= 167) ? Blocks.field_150322_A : Blocks.field_150406_ce;
                    } else if (data == Blocks.field_150351_n) {
                        MysteriumPatchesFixesCave.chunkData[index + 1] = Blocks.field_150348_b;
                    }
                }
            }
        }
    }

    private static void initializeCaveData(int chunkX, int chunkZ) {
        boolean flag = Math.abs(chunkX) < 82 && Math.abs(chunkZ) < 82;
        int distance = 6724;
        for (int z = -18; z <= 18; ++z) {
            int zIndex = (z + 18) * 37 + 18;
            int cz = chunkZ + z;
            int z2 = z * z;
            for (int x = -18; x <= 18; ++x) {
                int x2z2 = x * x + z2;
                if (x2z2 > 329) continue;
                int cx = chunkX + x;
                if (flag) {
                    distance = cx * cx + cz * cz;
                }
                int data = 0;
                if (MysteriumPatchesFixesCave.validColossalCaveLocation(cx, cz, distance)) {
                    data = -1;
                } else if (MysteriumPatchesFixesCave.validStrongholdLocation(cx, cz, distance)) {
                    data = 3;
                } else if (x2z2 <= 287) {
                    int d;
                    if (MysteriumPatchesFixesCave.validRegionalCaveLocation(cx, cz, distance)) {
                        data = 2;
                    } else if (x2z2 <= 262 && (d = MysteriumPatchesFixesCave.validSpecialCaveLocation(cx, cz, distance)) > 0) {
                        data = (byte)d;
                    }
                }
                MysteriumPatchesFixesCave.caveDataArray[zIndex + x] = data;
            }
        }
    }

    private static int validCaveLocation(int cx, int cz) {
        int flag = 1;
        for (int z = -6; z <= 6; ++z) {
            int zIndex = (cz + z + 18) * 37 + cx + 18;
            int z2 = z * z;
            for (int x = -6; x <= 6; ++x) {
                byte data;
                int x2z2 = x * x + z2;
                if (x2z2 > 37 || (data = caveDataArray[zIndex + x]) == 0) continue;
                if (data == -1) {
                    if (x2z2 == 0) {
                        return -1;
                    }
                    return 0;
                }
                if (data == 1 && x2z2 <= 17) {
                    if (x2z2 == 0) {
                        return 2;
                    }
                    if (x2z2 <= 5) {
                        return 0;
                    }
                    flag = 5;
                }
                if (data == 4 && x2z2 <= 17) {
                    if (x2z2 == 0) {
                        return 6;
                    }
                    if (x2z2 <= 5) {
                        return 0;
                    }
                    flag = 5;
                }
                if (data == 5 && x2z2 <= 17) {
                    if (x2z2 == 0) {
                        return 7;
                    }
                    if (x2z2 <= 5) {
                        return 0;
                    }
                    flag = 5;
                }
                if (data == 2 && x2z2 <= 24) {
                    if (x2z2 == 0) {
                        return 3;
                    }
                    if (flag == 1) {
                        flag = 4;
                    }
                }
                if (data != 3) continue;
                flag = 5;
            }
        }
        return flag;
    }

    public static boolean validColossalCaveLocation(int chunkX, int chunkZ, int distance) {
        if (((chunkX += caveOffsetX) & 0x40) == ((chunkZ += caveOffsetZ) & 0x40)) {
            return false;
        }
        caveRNG.setSeed(((long)(chunkX / 64) * 341873128712L + (long)(chunkZ / 64) * 132897987541L) * colossalCaveSeedMultiplier);
        return (chunkX & 0x3F) == caveRNG.nextInt(32) && (chunkZ & 0x3F) == caveRNG.nextInt(32);
    }

    public static int validSpecialCaveLocation(int chunkX, int chunkZ, int distance) {
        int offsetX = chunkX + caveOffsetX + 1;
        int offsetZ = chunkZ + caveOffsetZ + 1;
        if ((offsetX & 7) <= 2 && (offsetZ & 7) <= 2) {
            int d = MysteriumPatchesFixesCave.validSpecialCaveLocation2(offsetX, offsetZ);
            if (d != 0) {
                return d;
            }
            caveRNG.setSeed(((long)((offsetX -= 16) / 32) * 341873128712L + (long)((offsetZ -= 16) / 32) * 132897987541L) * seedMultiplier);
            if ((offsetX & 0x1F) == caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3) && (offsetZ & 0x1F) == caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3)) {
                boolean flag = distance < 5041;
                for (int z = -7; z <= 7; ++z) {
                    int cz = chunkZ + z;
                    for (int x = -7; x <= 7; ++x) {
                        int x2z2 = x * x + z * z;
                        if (x2z2 > 50) continue;
                        int cx = chunkX + x;
                        if (flag) {
                            distance = cx * cx + cz * cz;
                        }
                        if (MysteriumPatchesFixesCave.validColossalCaveLocation(cx, cz, distance)) {
                            return 0;
                        }
                        if (x2z2 > 37) continue;
                        if (MysteriumPatchesFixesCave.validStrongholdLocation(cx, cz, distance)) {
                            return 0;
                        }
                        if (x2z2 > 24) continue;
                        if (MysteriumPatchesFixesCave.validRegionalCaveLocation(cx, cz, distance)) {
                            return 0;
                        }
                        if (x2z2 <= 0 || x2z2 > 17 || MysteriumPatchesFixesCave.validSpecialCaveLocation2(cx + caveOffsetX + 1, cz + caveOffsetZ + 1) == 0) continue;
                        return 0;
                    }
                }
                return 1;
            }
        }
        return 0;
    }

    private static int validSpecialCaveLocation2(int offsetX, int offsetZ) {
        int z;
        int x;
        caveRNG.setSeed(((long)(offsetX / 64) * 341873128712L + (long)(offsetZ / 64) * 132897987541L) * regionalCaveSeedMultiplier);
        if (caveRNG.nextBoolean()) {
            x = caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3);
            z = caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40;
        } else {
            x = caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40;
            z = caveRNG.nextInt(4) * 8 + caveRNG.nextInt(3);
        }
        return (offsetX & 0x3F) == x && (offsetZ & 0x3F) == z ? 4 : ((offsetX & 0x3F) == caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40 && (offsetZ & 0x3F) == caveRNG.nextInt(3) * 8 + caveRNG.nextInt(3) + 40 ? 5 : 0);
    }

    public static boolean validRegionalCaveLocation(int chunkX, int chunkZ, int distance) {
        int offsetZ;
        int offsetX;
        caveRNG.setSeed(((long)((chunkX += caveOffsetX) / 64) * 341873128712L + (long)((chunkZ += caveOffsetZ) / 64) * 132897987541L) * regionalCaveSeedMultiplier);
        chunkX &= 0x3F;
        chunkZ &= 0x3F;
        if (caveRNG.nextBoolean()) {
            offsetX = caveRNG.nextInt(9) + 38;
            offsetZ = caveRNG.nextInt(21);
        } else {
            offsetX = caveRNG.nextInt(21);
            offsetZ = caveRNG.nextInt(9) + 38;
        }
        return chunkX >= offsetX && chunkX <= offsetX + 11 && chunkZ >= offsetZ && chunkZ <= offsetZ + 11;
    }

    public static boolean isGiantCaveRegion(int chunkX, int chunkZ) {
        chunkX = (chunkX + caveOffsetX) / 64;
        chunkZ = (chunkZ + caveOffsetZ) / 64;
        caveRNG.setSeed(((long)(chunkX / 2) * 341873128712L + (long)(chunkZ / 2) * 132897987541L) * regionalCaveSeedMultiplier);
        return (chunkX & 1) == caveRNG.nextInt(2) && (chunkZ & 1) == caveRNG.nextInt(2);
    }

    private static int isEdgeOfGiantCaveRegion(int chunkX, int chunkZ) {
        int offsetZ;
        int offsetX;
        caveRNG.setSeed(((long)((chunkX += caveOffsetX) / 64) * 341873128712L + (long)((chunkZ += caveOffsetZ) / 64) * 132897987541L) * regionalCaveSeedMultiplier);
        chunkX &= 0x3F;
        chunkZ &= 0x3F;
        if (caveRNG.nextBoolean()) {
            offsetX = caveRNG.nextInt(9) + 38;
            offsetZ = caveRNG.nextInt(21);
        } else {
            offsetX = caveRNG.nextInt(21);
            offsetZ = caveRNG.nextInt(9) + 38;
        }
        return chunkX == offsetX ? (chunkZ == offsetZ ? 6 : (chunkZ == offsetZ + 11 ? 4 : 5)) : (chunkX == offsetX + 11 ? (chunkZ == offsetZ ? 8 : (chunkZ == offsetZ + 11 ? 2 : 1)) : (chunkZ == offsetZ ? 7 : (chunkZ == offsetZ + 11 ? 3 : 0)));
    }

    private static int getQuadrantX(int i) {
        return (i + 1 & 3) < 2 ? -1 : 1;
    }

    private static int getQuadrantZ(int i) {
        return (i & 3) < 2 ? -1 : 1;
    }

    private static int getOffsetX(int x, int direction, int offset) {
        switch (direction & 7) {
            case 0: 
            case 1: 
            case 7: {
                return x + offset;
            }
            default: {
                return x;
            }
            case 3: 
            case 4: 
            case 5: 
        }
        return x - offset;
    }

    private static int getOffsetZ(int z, int direction, int offset) {
        switch (direction & 7) {
            case 1: 
            case 2: 
            case 3: {
                return z + offset;
            }
            default: {
                return z;
            }
            case 5: 
            case 6: 
            case 7: 
        }
        return z - offset;
    }

    private static float sine(float f) {
        return SINE_TABLE[(int)(f * 162.97466f) & 0x3FF];
    }

    private static float cosine(float f) {
        return SINE_TABLE[(int)(f * 162.97466f) + 256 & 0x3FF];
    }

    private static boolean validStrongholdLocation(int chunkX, int chunkZ, int distance) {
        if (((chunkX += caveOffsetX) & 0x40) != ((chunkZ += caveOffsetZ) & 0x40)) {
            return false;
        }
        rand.setSeed(((long)(chunkX / 64) * 341873128712L + (long)(chunkZ / 64) * 132897987541L) * seedMultiplier);
        return (chunkX & 0x3F) == rand.nextInt(32) && (chunkZ & 0x3F) == rand.nextInt(32) && distance >= 1600;
    }

    static {
        int i;
        rand = new Random();
        noiseGen = new Random();
        caveRNG = new Random();
        newRand = new Random();
        largeCaveRNG = new Random();
        caveDataArray = new byte[1369];
        ravineData = new float[128];
        ravineHeightLookup = new float[181];
        biomeList = new byte[256];
        SINE_TABLE = new float[1024];
        strongholdGenerator = new MapGenStronghold();
        villageGenerator = new MapGenVillage();
        mineshaftGenerator = new MapGenMineshaft();
        scatteredFeatureGenerator = new MapGenScatteredFeature();
        oceanAvg = -1;
        for (i = 0; i < 1024; ++i) {
            MysteriumPatchesFixesCave.SINE_TABLE[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 1024.0);
        }
        MysteriumPatchesFixesCave.biomeList[3] = 1;
        MysteriumPatchesFixesCave.biomeList[20] = 1;
        MysteriumPatchesFixesCave.biomeList[34] = 1;
        MysteriumPatchesFixesCave.biomeList[131] = 1;
        MysteriumPatchesFixesCave.biomeList[162] = 1;
        MysteriumPatchesFixesCave.biomeList[163] = 1;
        MysteriumPatchesFixesCave.biomeList[164] = 1;
        MysteriumPatchesFixesCave.biomeList[36] = 2;
        MysteriumPatchesFixesCave.biomeList[37] = 2;
        MysteriumPatchesFixesCave.biomeList[38] = 2;
        MysteriumPatchesFixesCave.biomeList[39] = 2;
        MysteriumPatchesFixesCave.biomeList[165] = 2;
        MysteriumPatchesFixesCave.biomeList[166] = 2;
        MysteriumPatchesFixesCave.biomeList[167] = 2;
        MysteriumPatchesFixesCave.biomeList[37] = (byte)(biomeList[37] + 4);
        MysteriumPatchesFixesCave.biomeList[38] = (byte)(biomeList[38] + 4);
        MysteriumPatchesFixesCave.biomeList[39] = (byte)(biomeList[39] + 4);
        MysteriumPatchesFixesCave.biomeList[165] = (byte)(biomeList[165] + 4);
        MysteriumPatchesFixesCave.biomeList[166] = (byte)(biomeList[166] + 4);
        MysteriumPatchesFixesCave.biomeList[167] = (byte)(biomeList[167] + 4);
        MysteriumPatchesFixesCave.biomeList[36] = (byte)(biomeList[36] + 4);
        MysteriumPatchesFixesCave.biomeList[163] = (byte)(biomeList[163] + 8);
        MysteriumPatchesFixesCave.biomeList[164] = (byte)(biomeList[164] + 8);
        MysteriumPatchesFixesCave.biomeList[3] = (byte)(biomeList[3] + 16);
        MysteriumPatchesFixesCave.biomeList[20] = (byte)(biomeList[20] + 16);
        MysteriumPatchesFixesCave.biomeList[34] = (byte)(biomeList[34] + 16);
        MysteriumPatchesFixesCave.biomeList[131] = (byte)(biomeList[131] + 16);
        MysteriumPatchesFixesCave.biomeList[162] = (byte)(biomeList[162] + 16);
        MysteriumPatchesFixesCave.biomeList[0] = (byte)(biomeList[0] + 32);
        MysteriumPatchesFixesCave.biomeList[7] = (byte)(biomeList[7] + 32);
        MysteriumPatchesFixesCave.biomeList[10] = (byte)(biomeList[10] + 32);
        MysteriumPatchesFixesCave.biomeList[11] = (byte)(biomeList[11] + 32);
        MysteriumPatchesFixesCave.biomeList[16] = (byte)(biomeList[16] + 32);
        MysteriumPatchesFixesCave.biomeList[26] = (byte)(biomeList[26] + 32);
        for (i = 15; i <= 195; ++i) {
            float radiusW = (float)i / 10.0f;
            float heightMultiplier = i < 35 ? 2.42858f - radiusW / 3.5f : (i < 70 ? 1.85716f - radiusW / 8.1665f : (i < 110 ? 1.2f - radiusW / 25.0f : 0.96706f - radiusW / 53.125f));
            MysteriumPatchesFixesCave.ravineHeightLookup[i - 15] = heightMultiplier;
        }
    }
}

