/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.fixes;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.tclproject.immersivecavegen.ImmersiveCavegen;
import net.tclproject.immersivecavegen.WGConfig;
import net.tclproject.mysteriumlib.asm.annotations.EnumReturnSetting;
import net.tclproject.mysteriumlib.asm.annotations.Fix;

public class MysteriumPatchesFixesOld {
    protected static Random noiseGen = new Random();
    protected static Random b = new Random();
    protected static float[] ravineData = new float[128];
    protected static World world;
    protected static long seedX;
    protected static long seedZ;
    protected static long worldSeed;
    protected static long chunkSeed;
    protected static int colossalCaveChance;
    protected static boolean genCaves;
    protected static boolean genFillerCaves;
    private static Random newRand;
    public static MapGenStronghold strongholdGenerator;
    public static MapGenVillage villageGenerator;
    public static MapGenMineshaft mineshaftGenerator;
    public static MapGenScatteredFeature scatteredFeatureGenerator;

    @Fix(returnSetting=EnumReturnSetting.ON_TRUE)
    public static boolean func_151539_a(MapGenBase instance, IChunkProvider p_151539_1_, World par2World, int chunkX, int chunkZ, Block[] par5ArrayOfBlock) {
        for (String str : WGConfig.dimblacklist) {
            if (world == null || !String.valueOf(MysteriumPatchesFixesOld.world.field_73011_w.field_76574_g).equalsIgnoreCase(str)) continue;
            return false;
        }
        if (instance instanceof MapGenCaves) {
            world = par2World;
            worldSeed = world.func_72905_C();
            b.setSeed(worldSeed);
            noiseGen.setSeed(worldSeed);
            seedX = b.nextLong();
            seedZ = b.nextLong();
            for (int varChunkX = chunkX - 12; varChunkX <= chunkX + 12; ++varChunkX) {
                for (int varChunkZ = chunkZ - 12; varChunkZ <= chunkZ + 12; ++varChunkZ) {
                    int hj;
                    chunkSeed = (long)varChunkX * seedX ^ (long)varChunkZ * seedZ ^ worldSeed;
                    boolean genRavines = MysteriumPatchesFixesOld.validCaveLocation(varChunkX, varChunkZ);
                    MysteriumPatchesFixesOld.generateCaves(varChunkX, varChunkZ, chunkX, chunkZ, par5ArrayOfBlock);
                    for (hj = 1; hj < WGConfig.cavesSpawnMultiplier; ++hj) {
                        MysteriumPatchesFixesOld.generateCaves(varChunkX, varChunkZ, chunkX, chunkZ, par5ArrayOfBlock);
                    }
                    if (genRavines) {
                        MysteriumPatchesFixesOld.generateRavines(varChunkX, varChunkZ, chunkX, chunkZ, par5ArrayOfBlock);
                        for (hj = 1; hj < WGConfig.cavernsSpawnMultiplier; ++hj) {
                            MysteriumPatchesFixesOld.generateRavines(varChunkX, varChunkZ, chunkX, chunkZ, par5ArrayOfBlock);
                        }
                    }
                    MysteriumPatchesFixesOld.generateColossalCaves(varChunkX, varChunkZ, chunkX, chunkZ, par5ArrayOfBlock);
                    for (hj = 1; hj < WGConfig.oldBigCavesSpawnMultiplier; ++hj) {
                        MysteriumPatchesFixesOld.generateColossalCaves(varChunkX, varChunkZ, chunkX, chunkZ, par5ArrayOfBlock);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static void generateLargeCaveNode(long par1, int par3, int par4, Block[] par5ArrayOfBlock, double par6, double par8, double par10) {
        MysteriumPatchesFixesOld.generateCaveNode(par1, par3, par4, par5ArrayOfBlock, par6, par8, par10, 1.0f + b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5, 0);
    }

    protected static void generateCaveNode(long par1, int par3, int par4, Block[] par5ArrayOfBlock, double par6, double par8, double par10, float par12, float par13, float par14, int par15, int par16, double par17, int bigCave) {
        boolean var28;
        Random r;
        if (bigCave == 0 && (r = new Random()).nextInt(100) < WGConfig.giantCaveChance) {
            bigCave = 3;
        }
        double var19 = par3 * 16 + 8;
        double var21 = par4 * 16 + 8;
        float var23 = 0.0f;
        float var24 = 0.0f;
        Random var25 = new Random(par1);
        float curviness1 = 0.1f;
        float curviness2 = 0.1f;
        if (par16 <= 0) {
            par16 = 112 - var25.nextInt(28);
        }
        int var27 = var25.nextInt(par16 / 2) + par16 / 4;
        double minWidth = 1.5;
        if (bigCave != 1 && bigCave != 2) {
            if (bigCave == 3) {
                par17 = 1.0f - par12 / 100.0f;
                minWidth = 2.0;
            }
        } else {
            if (bigCave == 1) {
                par16 = 112 + var25.nextInt(var25.nextInt(337) + 1);
                if (par16 > 336) {
                    par16 = 336;
                }
                if (var25.nextBoolean()) {
                    float multiplier = var25.nextFloat() * (float)par16 / 96.0f + (float)(672 - par16) / 672.0f;
                    if (multiplier > 1.0f) {
                        par12 *= multiplier;
                    }
                } else {
                    par12 *= var25.nextFloat() + 1.0f;
                }
            } else {
                par16 = 224 + var25.nextInt(113);
            }
            var27 = var25.nextInt(par16 / 4) + par16 / 2;
            curviness1 = (float)par16 / 3360.0f + 0.05f;
            if (curviness1 < 0.1f) {
                curviness2 = curviness1;
            }
            par17 = 1.0f - par12 / 100.0f;
            minWidth = 2.5;
        }
        boolean var54 = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            var54 = true;
        }
        int skipCount = 999;
        boolean bl = var28 = var25.nextInt(6) == 0;
        while (par15 < par16) {
            double var29 = minWidth + (double)(MathHelper.func_76126_a((float)((float)par15 * 3.141593f / (float)par16)) * par12);
            double var31 = var29 * par17;
            float var33 = MathHelper.func_76134_b((float)par14);
            float var34 = MathHelper.func_76126_a((float)par14);
            par6 += (double)(MathHelper.func_76134_b((float)par13) * var33);
            par8 += (double)var34;
            par10 += (double)(MathHelper.func_76126_a((float)par13) * var33);
            par14 = var28 ? (par14 *= 0.92f) : (par14 *= 0.7f);
            par14 += var24 * curviness2;
            par13 += var23 * curviness1;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (var25.nextFloat() - var25.nextFloat()) * var25.nextFloat() * 2.0f;
            var23 += (var25.nextFloat() - var25.nextFloat()) * var25.nextFloat() * 4.0f;
            if (!var54 && bigCave < 3 && par15 == var27 && par12 > 1.0f && par16 > 0) {
                if (bigCave == 0) {
                    MysteriumPatchesFixesOld.generateCaveNode(var25.nextLong(), par3, par4, par5ArrayOfBlock, par6, par8, par10, var25.nextFloat() * 0.5f + 0.5f, par13 - 1.5707964f, par14 / 3.0f, par15, par16, 1.0, 0);
                    MysteriumPatchesFixesOld.generateCaveNode(var25.nextLong(), par3, par4, par5ArrayOfBlock, par6, par8, par10, var25.nextFloat() * 0.5f + 0.5f, par13 + 1.5707964f, par14 / 3.0f, par15, par16, 1.0, 0);
                    return;
                }
                MysteriumPatchesFixesOld.generateCaveNode(var25.nextLong(), par3, par4, par5ArrayOfBlock, par6, par8, par10, var25.nextFloat() * par12 / 3.0f + par12 / 3.0f, par13 - 1.5707964f, par14 / 3.0f, par15, par16, 1.0, 3);
                MysteriumPatchesFixesOld.generateCaveNode(var25.nextLong(), par3, par4, par5ArrayOfBlock, par6, par8, par10, var25.nextFloat() * par12 / 3.0f + par12 / 3.0f, par13 + 1.5707964f, par14 / 3.0f, par15, par16, 1.0, 3);
                return;
            }
            if (!var54 && var25.nextInt(4) != 0 && skipCount <= (int)var29 / 2) {
                ++skipCount;
            } else {
                double var35 = par6 - var19;
                double var37 = par10 - var21;
                double var39 = (double)(par16 - par15) + (double)(par12 + 18.0f);
                if (var35 * var35 + var37 * var37 > var39 * var39) {
                    return;
                }
                skipCount = 0;
                double var29_2 = var29 * 2.0;
                if (par6 >= var19 - 16.0 - var29_2 && par10 >= var21 - 16.0 - var29_2 && par6 <= var19 + 16.0 + var29_2 && par10 <= var21 + 16.0 + var29_2) {
                    double noiseMultiplier;
                    int var55 = MathHelper.func_76128_c((double)(par6 - var29)) - par3 * 16 - 1;
                    int var36 = MathHelper.func_76128_c((double)(par6 + var29)) - par3 * 16 + 1;
                    int var57 = MathHelper.func_76128_c((double)(par8 - var31)) - 1;
                    int var38 = MathHelper.func_76128_c((double)(par8 + var31)) + 1;
                    int var56 = MathHelper.func_76128_c((double)(par10 - var29)) - par4 * 16 - 1;
                    int var40 = MathHelper.func_76128_c((double)(par10 + var29)) - par4 * 16 + 1;
                    if (var55 < 0) {
                        var55 = 0;
                    }
                    if (var36 > 16) {
                        var36 = 16;
                    }
                    if (var57 < 0) {
                        var57 = 0;
                    }
                    if (var38 > 126) {
                        var38 = 126;
                    }
                    if (var56 < 0) {
                        var56 = 0;
                    }
                    if (var40 > 16) {
                        var40 = 16;
                    }
                    if ((noiseMultiplier = 0.55 / (var29_2 - 2.0)) > 0.3) {
                        noiseMultiplier = 0.3;
                    }
                    for (int var42 = var55; var42 < var36; ++var42) {
                        double var59 = ((double)(var42 + par3 * 16) + 0.5 - par6) / var29;
                        var59 *= var59;
                        for (int var45 = var56; var45 < var40; ++var45) {
                            double var46 = ((double)(var45 + par4 * 16) + 0.5 - par10) / var29;
                            var46 = var46 * var46 + var59;
                            int var48 = var42 << 12 | var45 << 8 | var38;
                            int yIndex = var38;
                            int grassMycelium = 0;
                            if (!(var46 < 1.0)) continue;
                            for (int var50 = var38 - 1; var50 >= var57; --var50) {
                                Block var53;
                                double var51 = ((double)var50 + 0.5 - par8) / var31;
                                if (var51 > -0.7 && var51 * var51 + var46 + (double)(noiseGen.nextInt(3) - 1) * noiseMultiplier < 1.0 && MysteriumPatchesFixesOld.waterCheck(var42, yIndex, var45, par5ArrayOfBlock) && (var53 = par5ArrayOfBlock[var48]) != null && var53 != Blocks.field_150357_h) {
                                    int biome = MysteriumPatchesFixesOld.world.getBiomeGenForCoordsBody((int)(var42 + par3 * 16), (int)(var45 + par4 * 16)).field_76756_M;
                                    if (var50 < 60 || biome != 16) {
                                        if (var53 == Blocks.field_150349_c) {
                                            grassMycelium = 1;
                                        }
                                        if (var53 == Blocks.field_150391_bh) {
                                            grassMycelium = 2;
                                        }
                                        if (var50 < 10) {
                                            par5ArrayOfBlock[var48] = Blocks.field_150353_l;
                                        } else {
                                            Block fallingBlock;
                                            par5ArrayOfBlock[var48] = null;
                                            if (grassMycelium > 0 && par5ArrayOfBlock[var48 - 1] == Blocks.field_150346_d) {
                                                if (grassMycelium == 1) {
                                                    par5ArrayOfBlock[var48 - 1] = Blocks.field_150349_c;
                                                }
                                                if (grassMycelium == 2) {
                                                    par5ArrayOfBlock[var48 - 1] = Blocks.field_150391_bh;
                                                }
                                            }
                                            if ((fallingBlock = par5ArrayOfBlock[var48 + 1]) != Blocks.field_150354_m) {
                                                if (fallingBlock == Blocks.field_150351_n) {
                                                    par5ArrayOfBlock[var48 + 1] = Blocks.field_150348_b;
                                                }
                                            } else {
                                                par5ArrayOfBlock[var48 + 1] = !(biome >= 36 && biome <= 39 || biome >= 164 && biome <= 167) ? Blocks.field_150322_A : Blocks.field_150406_ce;
                                            }
                                        }
                                    }
                                }
                                --var48;
                                --yIndex;
                            }
                        }
                    }
                    if (var54) break;
                }
            }
            ++par15;
        }
    }

    protected static boolean validGiantCaveLocation(int varChunkX, int varChunkZ) {
        int chunkModX = varChunkX & 0xF;
        int chunkModZ = varChunkZ & 0xF;
        if (!(chunkModX == 0 && chunkModZ == 0 || chunkModX == 8 && chunkModZ == 8)) {
            return false;
        }
        if (varChunkX * varChunkX + varChunkZ * varChunkZ <= 128) {
            return false;
        }
        b.setSeed((long)varChunkX * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) <= colossalCaveChance / 2) {
            return false;
        }
        b.setSeed((long)(varChunkX - 16) * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 16) * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)varChunkX * seedX ^ (long)(varChunkZ - 16) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)varChunkX * seedX ^ (long)(varChunkZ + 16) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 24) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 16) * seedX ^ (long)(varChunkZ - 16) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ - 24) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 24) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 16) * seedX ^ (long)(varChunkZ - 16) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ - 24) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 24) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 16) * seedX ^ (long)(varChunkZ + 16) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ + 24) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 24) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 16) * seedX ^ (long)(varChunkZ + 16) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ + 24) * seedZ ^ worldSeed);
        if (b.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        b.setSeed((long)varChunkX * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        int tmp = b.nextInt(2) + b.nextInt(2) + b.nextInt(2);
        return true;
    }

    protected static boolean validCaveLocation(int chunkX, int chunkZ) {
        int caveCount = 0;
        genCaves = true;
        genFillerCaves = true;
        for (int cx = -6; cx <= 6; ++cx) {
            for (int cz = -6; cz <= 6; ++cz) {
                if (cx * cx + cz * cz > 36 || !genCaves) continue;
                if (MysteriumPatchesFixesOld.validGiantCaveLocation(chunkX + cx, chunkZ + cz)) {
                    genCaves = false;
                    genFillerCaves = false;
                    return false;
                }
                if (!genFillerCaves) continue;
                b.setSeed((long)(chunkX + cx) * seedX ^ (long)(chunkZ + cz) * seedZ ^ worldSeed);
                int size = b.nextInt(b.nextInt(b.nextInt(40) + 1) + 1);
                if (b.nextInt(15) == 0) {
                    caveCount += size;
                }
                if (caveCount <= 1) continue;
                genFillerCaves = false;
            }
        }
        return true;
    }

    protected static void generateRavine(long par1, int par3, int par4, Block[] par5ArrayOfBlock, double par6, double par8, double par10, float par12, float par13, float par14, double height, int bigRavine) {
        int par15;
        int skipCount;
        Random var19 = new Random(par1);
        noiseGen.setSeed(par1);
        double var20 = par3 * 16 + 8;
        double var22 = par4 * 16 + 8;
        float var24 = 0.0f;
        float var25 = 0.0f;
        float curviness = 0.05f;
        int par16 = 112 - var19.nextInt(28);
        if (bigRavine > 0) {
            par16 = 112 + noiseGen.nextInt(noiseGen.nextInt(225) + 1);
            par12 *= noiseGen.nextFloat() * noiseGen.nextFloat() * 1.5f + 1.0f;
            if (bigRavine == 2) {
                if ((par16 += 100 + noiseGen.nextInt(61)) > 336) {
                    par16 = 336;
                }
                if ((par12 += 3.0f + noiseGen.nextFloat() * 2.0f) > 15.0f) {
                    par12 = 15.0f;
                }
            }
            curviness = (float)par16 / 2240.0f;
        }
        float var27 = 1.0f;
        for (skipCount = 0; skipCount < 128; ++skipCount) {
            if (skipCount != 0 && var19.nextInt(3) != 0) continue;
            var27 += var19.nextFloat() * var19.nextFloat();
        }
        skipCount = 5;
        float ravineDataMultiplier = 1.1f - (par12 - 2.0f) * 0.07f;
        if (ravineDataMultiplier < 0.6f) {
            ravineDataMultiplier = 0.6f;
        }
        for (par15 = 0; par15 < 128; ++par15) {
            if (++skipCount > 1 && (skipCount > 3 || noiseGen.nextInt(3) == 0)) {
                skipCount = 0;
                var27 = (1.0f + noiseGen.nextFloat() * noiseGen.nextFloat() * ravineDataMultiplier) * (0.95f + (float)noiseGen.nextInt(2) * 0.1f);
            }
            MysteriumPatchesFixesOld.ravineData[par15] = var27 * var27;
        }
        skipCount = 999;
        for (par15 = 0; par15 < par16; ++par15) {
            double var53 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * 3.141593f / (float)par16)) * par12);
            if (bigRavine > 0 && (height = 3.416667 - var53 / 18.0) > 3.0) {
                height = 3.0;
            }
            double var30 = var53 * height;
            var53 *= (double)var19.nextFloat() * 0.25 + 0.75;
            var30 *= (double)var19.nextFloat() * 0.25 + 0.75;
            float var32 = MathHelper.func_76134_b((float)par14);
            float var33 = MathHelper.func_76126_a((float)par14);
            par6 += (double)(MathHelper.func_76134_b((float)par13) * var32);
            par8 += (double)var33;
            par10 += (double)(MathHelper.func_76126_a((float)par13) * var32);
            par14 *= 0.7f;
            par14 += var25 * curviness;
            par13 += var24 * curviness;
            var25 *= 0.8f;
            var24 *= 0.5f;
            var25 += (var19.nextFloat() - var19.nextFloat()) * var19.nextFloat() * 2.0f;
            var24 += (var19.nextFloat() - var19.nextFloat()) * var19.nextFloat() * 4.0f;
            if (var19.nextInt(4) != 0 && skipCount < (int)var53 / 2) {
                ++skipCount;
                continue;
            }
            double var34 = par6 - var20;
            double var36 = par10 - var22;
            double var38 = (double)(par16 - par15) + (double)(par12 + 18.0f);
            if (var34 * var34 + var36 * var36 > var38 * var38) {
                return;
            }
            skipCount = 0;
            double noiseMultiplier = 0.3333333 / (var53 - 0.5);
            double var53_2 = var53 * 2.0;
            if (!(par6 >= var20 - 16.0 - var53_2) || !(par10 >= var22 - 16.0 - var53_2) || !(par6 <= var20 + 16.0 + var53_2) || !(par10 <= var22 + 16.0 + var53_2)) continue;
            int var56 = MathHelper.func_76128_c((double)(par6 - var53)) - par3 * 16 - 1;
            int var35 = MathHelper.func_76128_c((double)(par6 + var53)) - par3 * 16 + 1;
            int var55 = MathHelper.func_76128_c((double)(par8 - var30)) - 1;
            int var37 = MathHelper.func_76128_c((double)(par8 + var30)) + 1;
            int var57 = MathHelper.func_76128_c((double)(par10 - var53)) - par4 * 16 - 1;
            int var39 = MathHelper.func_76128_c((double)(par10 + var53)) - par4 * 16 + 1;
            if (var56 < 0) {
                var56 = 0;
            }
            if (var35 > 16) {
                var35 = 16;
            }
            if (var55 < 0) {
                var55 = 0;
            }
            if (var37 > 120) {
                var37 = 120;
            }
            if (var57 < 0) {
                var57 = 0;
            }
            if (var39 > 16) {
                var39 = 16;
            }
            for (int var41 = var56; var41 < var35; ++var41) {
                double var59 = ((double)(var41 + par3 * 16) + 0.5 - par6) / var53;
                var59 *= var59;
                for (int var44 = var57; var44 < var39; ++var44) {
                    double var45 = ((double)(var44 + par4 * 16) + 0.5 - par10) / var53;
                    var45 = var45 * var45 + var59;
                    int var47 = var41 << 12 | var44 << 8 | var37;
                    int yIndex = var37;
                    int grassMycelium = 0;
                    if (!(var45 < 1.0)) continue;
                    for (int var49 = var37 - 1; var49 >= var55; --var49) {
                        Block var52;
                        double var50 = ((double)var49 + 0.5 - par8) / var30;
                        if (var45 * (double)ravineData[var49] + var50 * var50 / 6.0 + (double)(noiseGen.nextInt(3) - 1) * noiseMultiplier < 1.0 && MysteriumPatchesFixesOld.waterCheck(var41, yIndex, var44, par5ArrayOfBlock) && (var52 = par5ArrayOfBlock[var47]) != null && var52 != Blocks.field_150357_h) {
                            int biome = MysteriumPatchesFixesOld.world.getBiomeGenForCoordsBody((int)(var41 + par3 * 16), (int)(var44 + par4 * 16)).field_76756_M;
                            if (var50 < 60.0 || biome != 16) {
                                if (var52 == Blocks.field_150349_c) {
                                    grassMycelium = 1;
                                }
                                if (var52 == Blocks.field_150391_bh) {
                                    grassMycelium = 2;
                                }
                                if (var49 < 10) {
                                    par5ArrayOfBlock[var47] = Blocks.field_150353_l;
                                } else {
                                    Block fallingBlock;
                                    par5ArrayOfBlock[var47] = null;
                                    if (grassMycelium > 0 && par5ArrayOfBlock[var47 - 1] == Blocks.field_150346_d) {
                                        if (grassMycelium == 1) {
                                            par5ArrayOfBlock[var47 - 1] = Blocks.field_150349_c;
                                        }
                                        if (grassMycelium == 2) {
                                            par5ArrayOfBlock[var47 - 1] = Blocks.field_150391_bh;
                                        }
                                    }
                                    if ((fallingBlock = par5ArrayOfBlock[var47 + 1]) != Blocks.field_150354_m) {
                                        if (fallingBlock == Blocks.field_150351_n) {
                                            par5ArrayOfBlock[var47 + 1] = Blocks.field_150346_d;
                                        }
                                    } else {
                                        par5ArrayOfBlock[var47 + 1] = !(biome >= 36 && biome <= 39 || biome >= 164 && biome <= 167) ? Blocks.field_150322_A : Blocks.field_150406_ce;
                                    }
                                }
                            }
                        }
                        --var47;
                        --yIndex;
                    }
                }
            }
        }
    }

    @Fix(returnSetting=EnumReturnSetting.ON_TRUE, booleanAlwaysReturned=false)
    public static boolean generate(WorldGenLiquids l, World world, Random random, int x, int y, int z) {
        boolean type;
        boolean bl = type = l.field_150521_a.func_149688_o() == Material.field_151586_h;
        if (WGConfig.disableSourceWater && type && (!WGConfig.disableSourceUnderground || y < 64)) {
            return true;
        }
        return WGConfig.disableSourceLava && !type && (!WGConfig.disableSourceUnderground || y < 64);
    }

    @Fix(returnSetting=EnumReturnSetting.ALWAYS)
    public static void populate(ChunkProviderGenerate g, IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        int i2;
        int l1;
        int k1;
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        boolean flag = false;
        WorldServer world = DimensionManager.getWorld((int)0);
        BlockFalling.field_149832_M = true;
        BiomeGenBase biomegenbase = world.getBiomeGenForCoordsBody(k + 16, l + 16);
        newRand.setSeed(world.func_72905_C());
        long i1 = newRand.nextLong() / 2L * 2L + 1L;
        long j1 = newRand.nextLong() / 2L * 2L + 1L;
        newRand.setSeed((long)p_73153_2_ * i1 + (long)p_73153_3_ * j1 ^ world.func_72905_C());
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(p_73153_1_, (World)world, newRand, p_73153_2_, p_73153_3_, flag));
        if (world.func_72912_H().func_76089_r()) {
            if (WGConfig.enableMineshaftSpawn) {
                mineshaftGenerator.func_75051_a((World)world, newRand, p_73153_2_, p_73153_3_);
            }
            boolean bl = flag = WGConfig.enableVillageSpawn ? villageGenerator.func_75051_a((World)world, newRand, p_73153_2_, p_73153_3_) : false;
            if (WGConfig.enableStrongholdSpawn) {
                strongholdGenerator.func_75051_a((World)world, newRand, p_73153_2_, p_73153_3_);
            }
            if (!WGConfig.enableDesolateSpawn) {
                scatteredFeatureGenerator.func_75051_a((World)world, newRand, p_73153_2_, p_73153_3_);
            }
        }
        if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && !flag && newRand.nextInt(WGConfig.waterLakesChance) == 0 && TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)newRand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = k + newRand.nextInt(16) + 8;
            l1 = newRand.nextInt(256);
            i2 = l + newRand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, newRand, k1, l1, i2);
            if (newRand.nextInt(WGConfig.waterLakesChance) == 0) {
                k1 = k + newRand.nextInt(16) + 8;
                l1 = newRand.nextInt(256);
                i2 = l + newRand.nextInt(16) + 8;
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, newRand, k1, l1, i2);
            }
            if (newRand.nextInt(WGConfig.waterLakesChance) == 0) {
                k1 = k + newRand.nextInt(16) + 8;
                l1 = newRand.nextInt(256);
                i2 = l + newRand.nextInt(16) + 8;
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, newRand, k1, l1, i2);
            }
        }
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)newRand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag) {
            k1 = k + newRand.nextInt(16) + 8;
            l1 = newRand.nextInt(newRand.nextInt(248) + 8);
            i2 = l + newRand.nextInt(16) + 8;
            if (l1 < 63 || newRand.nextInt(WGConfig.lavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, newRand, k1, l1, i2);
            } else if (newRand.nextInt(WGConfig.undergLavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, newRand, k1, l1, i2);
            }
            k1 = k + newRand.nextInt(16) + 8;
            l1 = newRand.nextInt(newRand.nextInt(248) + 8);
            i2 = l + newRand.nextInt(16) + 8;
            if (l1 < 63 || newRand.nextInt(WGConfig.lavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, newRand, k1, l1, i2);
            } else if (newRand.nextInt(WGConfig.undergLavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, newRand, k1, l1, i2);
            }
            k1 = k + newRand.nextInt(16) + 8;
            l1 = newRand.nextInt(newRand.nextInt(248) + 8);
            i2 = l + newRand.nextInt(16) + 8;
            if (l1 < 63 || newRand.nextInt(WGConfig.lavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, newRand, k1, l1, i2);
            } else if (newRand.nextInt(WGConfig.undergLavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, newRand, k1, l1, i2);
            }
        }
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)newRand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && newRand.nextInt(WGConfig.undergWaterLakesChance) == 0) {
            k1 = k + newRand.nextInt(16) + 8;
            l1 = newRand.nextInt(newRand.nextInt(248) + 8);
            i2 = l + newRand.nextInt(16) + 8;
            if (l1 < 63) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, newRand, k1, l1, i2);
            }
            if (newRand.nextInt(WGConfig.undergWaterLakesChance) == 0) {
                k1 = k + newRand.nextInt(16) + 8;
                l1 = newRand.nextInt(newRand.nextInt(248) + 8);
                i2 = l + newRand.nextInt(16) + 8;
                if (l1 < 63) {
                    new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, newRand, k1, l1, i2);
                }
            }
            if (newRand.nextInt(WGConfig.undergWaterLakesChance) == 0) {
                k1 = k + newRand.nextInt(16) + 8;
                l1 = newRand.nextInt(newRand.nextInt(248) + 8);
                i2 = l + newRand.nextInt(16) + 8;
                if (l1 < 63) {
                    new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, newRand, k1, l1, i2);
                }
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)newRand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (k1 = 0; doGen && k1 < 8; ++k1) {
            l1 = k + newRand.nextInt(16) + 8;
            i2 = newRand.nextInt(256);
            int j2 = l + newRand.nextInt(16) + 8;
            if (!WGConfig.enableDungeonSpawn) continue;
            new WorldGenDungeons().func_76484_a((World)world, newRand, l1, i2, j2);
        }
        biomegenbase.func_76728_a((World)world, newRand, k, l);
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)newRand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)world, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)newRand);
        }
        k += 8;
        l += 8;
        doGen = TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)newRand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = world.func_72874_g(k + k1, l + l1);
                if (world.func_72884_u(k1 + k, i2 - 1, l1 + l)) {
                    world.func_147465_d(k1 + k, i2 - 1, l1 + l, Blocks.field_150432_aD, 0, 2);
                }
                if (!world.func_147478_e(k1 + k, i2, l1 + l, true)) continue;
                world.func_147465_d(k1 + k, i2, l1 + l, Blocks.field_150431_aC, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(p_73153_1_, (World)world, newRand, p_73153_2_, p_73153_3_, flag));
        BlockFalling.field_149832_M = false;
    }

    protected static void generateColossalCaves(int varChunkX, int varChunkZ, int chunkX, int chunkZ, Block[] par6ArrayOfBlock) {
        if (MysteriumPatchesFixesOld.validGiantCaveLocation(varChunkX, varChunkZ)) {
            int centerX = varChunkX * 16 + 8;
            int centerZ = varChunkZ * 16 + 8;
            int subCenterX = 0;
            int subCenterZ = 0;
            int caveType = b.nextInt(4);
            for (int caveSystemCount = 0; caveSystemCount < 8; ++caveSystemCount) {
                switch (caveType) {
                    case 0: {
                        subCenterX = centerX + b.nextInt(33) - 40;
                        subCenterZ = centerZ + caveSystemCount * 15 + b.nextInt(17) - 84;
                        break;
                    }
                    case 1: {
                        subCenterX = centerX + caveSystemCount * 15 + b.nextInt(17) - 84;
                        subCenterZ = centerZ + b.nextInt(33) - 40;
                        break;
                    }
                    case 2: {
                        subCenterX = centerX - caveSystemCount * 15 + b.nextInt(17) + 20;
                        subCenterZ = centerZ + caveSystemCount * 15 + b.nextInt(17) - 84;
                        break;
                    }
                    case 3: {
                        subCenterX = centerX + caveSystemCount * 15 + b.nextInt(17) - 84;
                        subCenterZ = centerZ + caveSystemCount * 15 + b.nextInt(17) - 84;
                    }
                }
                MysteriumPatchesFixesOld.generateCaveSystem(20, subCenterX, subCenterZ, chunkX, chunkZ, par6ArrayOfBlock, 48);
                for (int i = 0; i < 5; ++i) {
                    MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), chunkX, chunkZ, par6ArrayOfBlock, subCenterX + b.nextInt(48), b.nextInt(6) + 10, subCenterZ + b.nextInt(48), b.nextFloat() * b.nextFloat() * b.nextFloat() * 6.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 0);
                }
            }
        }
    }

    protected static void generateCaves(int par2, int par3, int par4, int par5, Block[] par6ArrayOfBlock) {
        int cz;
        int cx;
        int caveCount;
        block24: {
            int genCave;
            int caveSize;
            block22: {
                block23: {
                    b.setSeed(chunkSeed);
                    caveSize = b.nextInt(b.nextInt(b.nextInt(40) + 1) + 1);
                    genCave = b.nextInt(15);
                    if (genCave != 0 || !genCaves) break block22;
                    MysteriumPatchesFixesOld.generateCaveSystem(caveSize, par2 * 16, par3 * 16, par4, par5, par6ArrayOfBlock, 16);
                    if (caveSize > 4 && caveSize < 20) {
                        caveCount = b.nextInt(b.nextInt(b.nextInt(caveSize / 5 * 2 + 2) + 1) + 1);
                        for (cx = 0; cx < caveCount; ++cx) {
                            cz = 1;
                            if (b.nextInt(4) == 0) {
                                cz += b.nextInt(4);
                            }
                            for (int LL = 0; LL < cz; ++LL) {
                                MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, par2 * 16 + b.nextInt(16), b.nextInt(6) + 10, par3 * 16 + b.nextInt(16), b.nextFloat() * b.nextFloat() * b.nextFloat() * 6.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 0);
                            }
                        }
                    }
                    if ((par2 % 18 != 0 || par3 % 18 != 0) && (par2 % 18 != 9 || par3 % 18 != 9) || par2 * par2 + par3 * par3 < 1024) break block23;
                    MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, par2 * 16 + 8, b.nextInt(11) + 20, par3 * 16 + 8, b.nextFloat() * 12.0f + b.nextFloat() * 6.0f + 3.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 2);
                    break block24;
                }
                if (caveSize <= 4 || caveSize >= 15 || !b.nextBoolean()) break block24;
                MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, par2 * 16 + 8, b.nextInt(11) + 20, par3 * 16 + 8, b.nextFloat() * b.nextFloat() * b.nextFloat() * 8.0f + 2.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 1);
                break block24;
            }
            if (genCave == 5 || genCave == 10) {
                caveCount = MysteriumPatchesFixesOld.world.getBiomeGenForCoordsBody((int)(par2 * 16 + 8), (int)(par3 * 16 + 8)).field_76756_M;
                caveSize = 0;
                if (caveCount != 3 && caveCount != 34 && caveCount != 131 && caveCount != 162) {
                    if (!(caveCount >= 36 && caveCount <= 39 || caveCount >= 164 && caveCount <= 167)) {
                        if (caveCount == 17) {
                            caveSize = 5;
                        }
                    } else {
                        caveSize = 10;
                    }
                } else {
                    caveSize = 15;
                }
                if (!genCaves) {
                    caveSize /= 2;
                }
                if (caveSize > 0) {
                    cx = b.nextInt(b.nextInt(caveSize) + 1);
                    for (cz = 0; cz < cx; ++cz) {
                        MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, par2 * 16 + b.nextInt(16), b.nextInt(50) + 40, par3 * 16 + b.nextInt(16), b.nextFloat() * b.nextFloat() * b.nextFloat() * 6.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 0);
                    }
                }
            }
        }
        if (genFillerCaves) {
            caveCount = 0;
            for (cx = -1; cx <= 1; ++cx) {
                for (cz = -1; cz <= 1; ++cz) {
                    if (cx == 0 || cz == 0) continue;
                    MysteriumPatchesFixesOld.validCaveLocation(par2 + cx, par3 + cz);
                    if (!genFillerCaves) continue;
                    ++caveCount;
                }
            }
            if (caveCount == 0) {
                caveCount = 1;
            } else if (caveCount > 2) {
                caveCount = 8;
            }
            b.setSeed(chunkSeed);
            if (b.nextInt(caveCount) == 0) {
                MysteriumPatchesFixesOld.generateCaveSystem(b.nextInt(b.nextInt(9) + 1) + 3, par2 * 16, par3 * 16, par4, par5, par6ArrayOfBlock, 16);
                if (b.nextBoolean()) {
                    MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, par2 * 16 + b.nextInt(16), b.nextInt(6) + 10, par3 * 16 + b.nextInt(16), b.nextFloat() * b.nextFloat() * b.nextFloat() * 6.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 0);
                }
                if (b.nextInt(4) == 0) {
                    MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, par2 * 16 + 8, b.nextInt(11) + 20, par3 * 16 + 8, b.nextFloat() * b.nextFloat() * b.nextFloat() * 8.0f + 2.0f, b.nextFloat() * 6.283185f, (b.nextFloat() - 0.5f) / 4.0f, 0, 0, 1.0, 1);
                }
            }
        }
    }

    protected static void generateCaveSystem(int numberOfCaves, int par2, int par3, int par4, int par5, Block[] par6ArrayOfBlock, int spread) {
        for (int var8 = 0; var8 < numberOfCaves; ++var8) {
            double var9 = par2 + b.nextInt(spread);
            double var11 = b.nextInt(b.nextInt(120) + 8);
            double var13 = par3 + b.nextInt(spread);
            int var15 = 1;
            if (b.nextInt(4) == 0) {
                MysteriumPatchesFixesOld.generateLargeCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, var9, var11, var13);
                var15 += b.nextInt(4);
            }
            for (int var16 = 0; var16 < var15; ++var16) {
                float var17 = b.nextFloat() * (float)Math.PI * 2.0f;
                float var18 = (b.nextFloat() - 0.5f) / 4.0f;
                float var19 = b.nextFloat() * 2.0f + b.nextFloat();
                if (b.nextInt(10) == 0) {
                    var19 *= b.nextFloat() * b.nextFloat() * 4.0f + 1.0f;
                }
                MysteriumPatchesFixesOld.generateCaveNode(b.nextLong(), par4, par5, par6ArrayOfBlock, var9, var11, var13, var19, var17, var18, 0, 0, 1.0, 0);
            }
        }
    }

    protected static void generateRavines(int par2, int par3, int par4, int par5, Block[] par6ArrayOfBlock) {
        ImmersiveCavegen.rand.setSeed(chunkSeed);
        if (ImmersiveCavegen.rand.nextInt(50) == 0) {
            double var7 = par2 * 16 + ImmersiveCavegen.rand.nextInt(16);
            double var9 = ImmersiveCavegen.rand.nextInt(ImmersiveCavegen.rand.nextInt(40) + 8) + 20;
            double var11 = par3 * 16 + ImmersiveCavegen.rand.nextInt(16);
            float var15 = ImmersiveCavegen.rand.nextFloat() * (float)Math.PI * 2.0f;
            float var16 = (ImmersiveCavegen.rand.nextFloat() - 0.5f) / 4.0f;
            float var17 = (ImmersiveCavegen.rand.nextFloat() * 2.0f + ImmersiveCavegen.rand.nextFloat()) * 2.0f;
            long ravineSeed = ImmersiveCavegen.rand.nextLong();
            int bigRavine = 0;
            double height = 3.0;
            if (ravineSeed % 50L == 0L && par2 * par2 + par3 * par3 >= 1024) {
                bigRavine = 2;
            } else if (ravineSeed % 8L == 0L) {
                bigRavine = 1;
            } else {
                int biome = MysteriumPatchesFixesOld.world.getBiomeGenForCoordsBody((int)(par2 * 16 + 8), (int)(par3 * 16 + 8)).field_76756_M;
                if (biome >= 36 && biome <= 39 || biome >= 164 && biome <= 167) {
                    if (var9 < 40.0) {
                        var9 += (double)ImmersiveCavegen.rand.nextInt(16);
                    }
                    height += (double)(ImmersiveCavegen.rand.nextInt(2) + 1);
                }
            }
            MysteriumPatchesFixesOld.generateRavine(ravineSeed, par4, par5, par6ArrayOfBlock, var7, var9, var11, var17, var15, var16, height, bigRavine);
        }
    }

    public static boolean waterCheck(int blockX, int blockY, int blockZ, Block[] blockData) {
        if (blockY >= 25 && blockY <= 62) {
            int xyz;
            int x;
            for (x = blockX - 1; x <= blockX + 1; ++x) {
                if (x < 0 || x > 15) continue;
                for (int z = blockZ - 1; z <= blockZ + 1; ++z) {
                    if (z < 0 || z > 15) continue;
                    xyz = x << 12 | z << 8;
                    for (int y = blockY - 1; y <= blockY + 1; ++y) {
                        if (blockData[xyz + y] != Blocks.field_150355_j) continue;
                        return false;
                    }
                }
            }
            for (x = blockZ - 1; x <= blockZ + 1; ++x) {
                if (x < 0 || x > 15) continue;
                xyz = blockX - 2;
                if (xyz >= 0 && blockData[xyz << 12 | x << 8 | blockY] == Blocks.field_150355_j) {
                    return false;
                }
                xyz = blockX + 2;
                if (xyz > 15 || blockData[xyz << 12 | x << 8 | blockY] != Blocks.field_150355_j) continue;
                return false;
            }
            for (x = blockX - 1; x <= blockX + 1; ++x) {
                if (x < 0 || x > 15) continue;
                xyz = blockZ - 2;
                if (xyz >= 0 && blockData[x << 12 | xyz << 8 | blockY] == Blocks.field_150355_j) {
                    return false;
                }
                xyz = blockZ + 2;
                if (xyz > 15 || blockData[x << 12 | xyz << 8 | blockY] != Blocks.field_150355_j) continue;
                return false;
            }
            if (blockData[blockX << 12 | blockZ << 8 | blockY - 2] == Blocks.field_150355_j) {
                return false;
            }
            if (blockData[blockX << 12 | blockZ << 8 | blockY + 2] == Blocks.field_150355_j) {
                return false;
            }
        }
        return true;
    }

    public static boolean validGiantCaveLocation(int varChunkX, int varChunkZ, long seedX, long seedZ, long worldSeed) {
        int chunkModX = varChunkX & 0xF;
        int chunkModZ = varChunkZ & 0xF;
        if (!(chunkModX == 0 && chunkModZ == 0 || chunkModX == 8 && chunkModZ == 8)) {
            return false;
        }
        if (varChunkX * varChunkX + varChunkZ * varChunkZ <= 512) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)varChunkX * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) != 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 16) * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 16) * seedX ^ (long)varChunkZ * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)varChunkX * seedX ^ (long)(varChunkZ - 16) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)varChunkX * seedX ^ (long)(varChunkZ + 16) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 24) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 16) * seedX ^ (long)(varChunkZ - 16) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ - 24) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 24) * seedX ^ (long)(varChunkZ - 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 16) * seedX ^ (long)(varChunkZ - 16) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ - 24) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 24) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 16) * seedX ^ (long)(varChunkZ + 16) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX - 8) * seedX ^ (long)(varChunkZ + 24) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 24) * seedX ^ (long)(varChunkZ + 8) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 16) * seedX ^ (long)(varChunkZ + 16) * seedZ ^ worldSeed);
        if (ImmersiveCavegen.rand.nextInt(colossalCaveChance) == 0) {
            return false;
        }
        ImmersiveCavegen.rand.setSeed((long)(varChunkX + 8) * seedX ^ (long)(varChunkZ + 24) * seedZ ^ worldSeed);
        return ImmersiveCavegen.rand.nextInt(colossalCaveChance) != 0;
    }

    public static boolean didSpawn(MapGenMineshaft instance, int chunkX, int chunkZ) {
        if (!((chunkX + 2000000) % 14 == 0 && (chunkZ + 2000000) % 14 == 0 || (chunkX + 2000000) % 14 == 7 && (chunkZ + 2000000) % 14 == 7)) {
            return false;
        }
        long worldSeed = instance.field_75039_c.func_72905_C();
        ImmersiveCavegen.rand.setSeed(worldSeed);
        long seedX = ImmersiveCavegen.rand.nextLong();
        long seedZ = ImmersiveCavegen.rand.nextLong();
        int caveCount = 0;
        for (int cx = -6; cx <= 6; ++cx) {
            for (int cz = -6; cz <= 6; ++cz) {
                if (cx * cx + cz * cz > 36) continue;
                ImmersiveCavegen.rand.setSeed((long)(chunkX + cx) * seedX ^ (long)(chunkZ + cz) * seedZ ^ worldSeed);
                int size = ImmersiveCavegen.rand.nextInt(ImmersiveCavegen.rand.nextInt(ImmersiveCavegen.rand.nextInt(40) + 1) + 1);
                if (ImmersiveCavegen.rand.nextInt(15) == 0) {
                    caveCount += size;
                }
                if (caveCount <= 33 && !MysteriumPatchesFixesOld.validGiantCaveLocation(chunkX + cx, chunkZ + cz, seedX, seedZ, worldSeed)) continue;
                return false;
            }
        }
        if (caveCount >= 10) {
            return true;
        }
        if (caveCount >= 5 && instance.field_75038_b.nextBoolean()) {
            return true;
        }
        return instance.field_75038_b.nextInt(4) == 0;
    }

    @Fix(returnSetting=EnumReturnSetting.ON_TRUE, anotherMethodReturned="didSpawn")
    public static boolean canSpawnStructureAtCoords(MapGenMineshaft instance, int chunkX, int chunkZ) {
        return WGConfig.enableBetterMineshafts;
    }

    @Fix(returnSetting=EnumReturnSetting.ALWAYS)
    public static boolean generate(WorldGenSand instance, World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        if (WGConfig.enableBetterSand) {
            if (p_76484_1_.func_147439_a(p_76484_3_, p_76484_4_, p_76484_5_).func_149688_o() != Material.field_151586_h) {
                return false;
            }
            int var6 = p_76484_2_.nextInt(instance.field_76539_b - 2) + 2;
            int var7 = 2;
            for (int var8 = p_76484_3_ - var6; var8 <= p_76484_3_ + var6; ++var8) {
                for (int var9 = p_76484_5_ - var6; var9 <= p_76484_5_ + var6; ++var9) {
                    int var10 = var8 - p_76484_3_;
                    int var11 = var9 - p_76484_5_;
                    if (var10 * var10 + var11 * var11 > var6 * var6) continue;
                    for (int var12 = p_76484_4_ - var7; var12 <= p_76484_4_ + var7; ++var12) {
                        Block var13 = p_76484_1_.func_147439_a(var8, var12, var9);
                        if (var13 != Blocks.field_150346_d && var13 != Blocks.field_150349_c) continue;
                        if (p_76484_1_.func_147439_a(var8, var12 - 1, var9) != Blocks.field_150350_a) {
                            p_76484_1_.func_147465_d(var8, var12, var9, instance.field_150517_a, 0, 2);
                            continue;
                        }
                        if (instance.field_150517_a == Blocks.field_150354_m) {
                            p_76484_1_.func_147465_d(var8, var12, var9, Blocks.field_150322_A, 0, 2);
                            continue;
                        }
                        if (instance.field_150517_a == Blocks.field_150351_n) {
                            p_76484_1_.func_147465_d(var8, var12, var9, Blocks.field_150348_b, 0, 2);
                            continue;
                        }
                        p_76484_1_.func_147465_d(var8, var12, var9, instance.field_150517_a, 0, 2);
                    }
                }
            }
            return true;
        }
        if (p_76484_1_.func_147439_a(p_76484_3_, p_76484_4_, p_76484_5_).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        int l = p_76484_2_.nextInt(instance.field_76539_b - 2) + 2;
        int b0 = 2;
        for (int i1 = p_76484_3_ - l; i1 <= p_76484_3_ + l; ++i1) {
            for (int j1 = p_76484_5_ - l; j1 <= p_76484_5_ + l; ++j1) {
                int k1 = i1 - p_76484_3_;
                int l1 = j1 - p_76484_5_;
                if (k1 * k1 + l1 * l1 > l * l) continue;
                for (int i2 = p_76484_4_ - b0; i2 <= p_76484_4_ + b0; ++i2) {
                    Block block = p_76484_1_.func_147439_a(i1, i2, j1);
                    if (block != Blocks.field_150346_d && block != Blocks.field_150349_c) continue;
                    p_76484_1_.func_147465_d(i1, i2, j1, instance.field_150517_a, 0, 2);
                }
            }
        }
        return true;
    }

    static {
        colossalCaveChance = 26 - WGConfig.giantCaveChance / 4;
        genCaves = false;
        genFillerCaves = false;
        newRand = new Random();
        strongholdGenerator = new MapGenStronghold();
        villageGenerator = new MapGenVillage();
        mineshaftGenerator = new MapGenMineshaft();
        scatteredFeatureGenerator = new MapGenScatteredFeature();
    }
}

