/*
 * Decompiled with CFR 0.152.
 */
package net.tclproject.mysteriumlib.asm.fixes;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureMineshaftPieces;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.tclproject.immersivecavegen.WGConfig;
import net.tclproject.immersivecavegen.world.WorldGenLakesUnderground;
import net.tclproject.mysteriumlib.asm.annotations.EnumReturnSetting;
import net.tclproject.mysteriumlib.asm.annotations.Fix;
import net.tclproject.mysteriumlib.asm.fixes.MysteriumPatchesFixesSnow;

public class MysteriumPatchesFixesPop {
    public static Random lakeRand = new Random();

    @Fix(returnSetting=EnumReturnSetting.ON_TRUE, booleanAlwaysReturned=false)
    public static boolean generate(WorldGenLiquids l, World world, Random random, int x, int y, int z) {
        boolean type;
        for (String str : WGConfig.dimblacklist) {
            if (!String.valueOf(world.field_73011_w.field_76574_g).equalsIgnoreCase(str)) continue;
            return false;
        }
        boolean bl = type = l.field_150521_a.func_149688_o() == Material.field_151586_h;
        if (WGConfig.disableSourceWater && type && (!WGConfig.disableSourceUnderground || y < 64)) {
            return true;
        }
        return WGConfig.disableSourceLava && !type && (!WGConfig.disableSourceUnderground || y < 64);
    }

    @Fix(returnSetting=EnumReturnSetting.ON_TRUE)
    public static boolean populate(ChunkProviderGenerate g, IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        int i2;
        int l1;
        int k1;
        BiomeGenBase biomegenbase;
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        boolean flag = false;
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            return true;
        }
        for (String str : WGConfig.dimblacklist) {
            if (!String.valueOf(world.field_73011_w.field_76574_g).equalsIgnoreCase(str)) continue;
            return false;
        }
        BlockFalling.field_149832_M = true;
        try {
            biomegenbase = world.getBiomeGenForCoordsBody(k + 16, l + 16);
        }
        catch (Exception e) {
            biomegenbase = null;
        }
        g.field_73220_k.setSeed(world.func_72905_C());
        long i1 = g.field_73220_k.nextLong() / 2L * 2L + 1L;
        long j1 = g.field_73220_k.nextLong() / 2L * 2L + 1L;
        g.field_73220_k.setSeed((long)p_73153_2_ * i1 + (long)p_73153_3_ * j1 ^ world.func_72905_C());
        lakeRand.setSeed((long)p_73153_2_ * i1 + (long)p_73153_3_ * j1 ^ world.func_72905_C());
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(p_73153_1_, (World)world, g.field_73220_k, p_73153_2_, p_73153_3_, flag));
        if (world.func_72912_H().func_76089_r()) {
            try {
                if (WGConfig.enableMineshaftSpawn) {
                    g.field_73223_w.func_75051_a((World)world, g.field_73220_k, p_73153_2_, p_73153_3_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                flag = WGConfig.enableVillageSpawn ? g.field_73224_v.func_75051_a((World)world, g.field_73220_k, p_73153_2_, p_73153_3_) : false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (WGConfig.enableStrongholdSpawn) {
                    g.field_73225_u.func_75051_a((World)world, g.field_73220_k, p_73153_2_, p_73153_3_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (!WGConfig.enableDesolateSpawn) {
                    g.field_73233_x.func_75051_a((World)world, g.field_73220_k, p_73153_2_, p_73153_3_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && !flag && g.field_73220_k.nextInt(WGConfig.waterLakesChance) == 0 && TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)g.field_73220_k, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = k + g.field_73220_k.nextInt(16) + 8;
            l1 = g.field_73220_k.nextInt(256);
            i2 = l + g.field_73220_k.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            if (lakeRand.nextInt(WGConfig.waterLakesChance) == 0) {
                k1 = k + lakeRand.nextInt(16) + 8;
                l1 = lakeRand.nextInt(256);
                i2 = l + lakeRand.nextInt(16) + 8;
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, lakeRand, k1, l1, i2);
            }
            if (lakeRand.nextInt(WGConfig.waterLakesChance) == 0) {
                k1 = k + lakeRand.nextInt(16) + 8;
                l1 = lakeRand.nextInt(256);
                i2 = l + lakeRand.nextInt(16) + 8;
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a((World)world, lakeRand, k1, l1, i2);
            }
        }
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)g.field_73220_k, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag) {
            k1 = k + g.field_73220_k.nextInt(16) + 8;
            l1 = g.field_73220_k.nextInt(g.field_73220_k.nextInt(248) + 8);
            i2 = l + g.field_73220_k.nextInt(16) + 8;
            if (l1 < 63 || g.field_73220_k.nextInt(WGConfig.lavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            } else if (lakeRand.nextInt(WGConfig.undergLavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, lakeRand, k1, l1, i2);
            }
            k1 = k + lakeRand.nextInt(16) + 8;
            l1 = lakeRand.nextInt(g.field_73220_k.nextInt(248) + 8);
            i2 = l + lakeRand.nextInt(16) + 8;
            if (l1 < 63 || lakeRand.nextInt(WGConfig.lavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, lakeRand, k1, l1, i2);
            } else if (lakeRand.nextInt(WGConfig.undergLavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, lakeRand, k1, l1, i2);
            }
            k1 = k + lakeRand.nextInt(16) + 8;
            l1 = lakeRand.nextInt(g.field_73220_k.nextInt(248) + 8);
            i2 = l + lakeRand.nextInt(16) + 8;
            if (l1 < 63 || lakeRand.nextInt(WGConfig.lavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, lakeRand, k1, l1, i2);
            } else if (lakeRand.nextInt(WGConfig.undergLavaLakesChance) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a((World)world, lakeRand, k1, l1, i2);
            }
        }
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)g.field_73220_k, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            k1 = k + g.field_73220_k.nextInt(16) + 8;
            l1 = g.field_73220_k.nextInt(g.field_73220_k.nextInt(248) + 8);
            i2 = l + g.field_73220_k.nextInt(16) + 8;
            if (l1 < 63 || g.field_73220_k.nextInt(WGConfig.waterLakesChance) == 0) {
                new WorldGenLakesUnderground(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            } else if (g.field_73220_k.nextInt(WGConfig.undergWaterLakesChance) == 0) {
                new WorldGenLakesUnderground(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            }
            k1 = k + g.field_73220_k.nextInt(16) + 8;
            l1 = g.field_73220_k.nextInt(g.field_73220_k.nextInt(248) + 8);
            i2 = l + g.field_73220_k.nextInt(16) + 8;
            if (l1 < 63 || g.field_73220_k.nextInt(WGConfig.waterLakesChance) == 0) {
                new WorldGenLakesUnderground(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            } else if (g.field_73220_k.nextInt(WGConfig.undergWaterLakesChance) == 0) {
                new WorldGenLakesUnderground(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            }
            k1 = k + g.field_73220_k.nextInt(16) + 8;
            l1 = g.field_73220_k.nextInt(g.field_73220_k.nextInt(248) + 8);
            i2 = l + g.field_73220_k.nextInt(16) + 8;
            if (l1 < 63 || g.field_73220_k.nextInt(WGConfig.waterLakesChance) == 0) {
                new WorldGenLakesUnderground(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            } else if (g.field_73220_k.nextInt(WGConfig.undergWaterLakesChance) == 0) {
                new WorldGenLakesUnderground(Blocks.field_150353_l).func_76484_a((World)world, g.field_73220_k, k1, l1, i2);
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)g.field_73220_k, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (k1 = 0; doGen && k1 < 8; ++k1) {
            l1 = k + g.field_73220_k.nextInt(16) + 8;
            i2 = g.field_73220_k.nextInt(256);
            int j2 = l + g.field_73220_k.nextInt(16) + 8;
            if (!WGConfig.enableDungeonSpawn) continue;
            new WorldGenDungeons().func_76484_a((World)world, g.field_73220_k, l1, i2, j2);
        }
        if (biomegenbase != null) {
            biomegenbase.func_76728_a((World)world, g.field_73220_k, k, l);
            if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)g.field_73220_k, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
                SpawnerAnimals.func_77191_a((World)world, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)g.field_73220_k);
            }
        }
        k += 8;
        l += 8;
        doGen = TerrainGen.populate((IChunkProvider)p_73153_1_, (World)world, (Random)g.field_73220_k, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = world.func_72874_g(k + k1, l + l1);
                if (world.func_72884_u(k1 + k, i2 - 1, l1 + l)) {
                    world.func_147465_d(k1 + k, i2 - 1, l1 + l, Blocks.field_150432_aD, 0, 2);
                }
                if (!world.func_147478_e(k1 + k, i2, l1 + l, true)) continue;
                world.func_147465_d(k1 + k, i2, l1 + l, Blocks.field_150431_aC, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(p_73153_1_, (World)world, g.field_73220_k, p_73153_2_, p_73153_3_, flag));
        BlockFalling.field_149832_M = false;
        if (Loader.isModLoaded((String)"immersivesnow")) {
            MysteriumPatchesFixesPop.loadImmersiveSnowCompat(g, p_73153_1_, p_73153_2_, p_73153_3_);
        }
        return true;
    }

    @Fix(targetMethod="<init>", insertOnExit=true)
    public static void Corridor(StructureMineshaftPieces.Corridor r, int p_i2035_1_, Random p_i2035_2_, StructureBoundingBox p_i2035_3_, int p_i2035_4_) {
        if (!WGConfig.enableCaveSpiderSpawnerSpawn) {
            r.field_74956_b = false;
        } else if (WGConfig.enableCaveSpiderSpawnerSpawnAlways) {
            r.field_74956_b = true;
        }
    }

    @Fix(targetMethod="<init>", insertOnExit=true)
    public static void ChunkProviderGenerate(ChunkProviderGenerate gen, World p_i2006_1_, long p_i2006_2_, boolean p_i2006_4_) {
        gen.field_73226_t = TerrainGen.getModdedMapGen((MapGenBase)gen.field_73226_t, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        gen.field_73225_u = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)gen.field_73225_u, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        gen.field_73224_v = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)gen.field_73224_v, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        gen.field_73223_w = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)gen.field_73223_w, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        gen.field_73233_x = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)gen.field_73233_x, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        gen.field_73232_y = TerrainGen.getModdedMapGen((MapGenBase)gen.field_73232_y, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
    }

    @Optional.Method(modid="immersivesnow")
    public static void loadImmersiveSnowCompat(ChunkProviderGenerate t, IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        boolean population = MysteriumPatchesFixesSnow.populate((ChunkProviderGenerate)t, (IChunkProvider)p_73153_1_, (int)p_73153_2_, (int)p_73153_3_);
    }
}

