/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.base;

import com.denfop.IUCore;
import com.denfop.api.utils.textures.TextureAtlasSheet;
import com.denfop.item.base.ItemElectricBlock;
import com.denfop.item.modules.AdditionModule;
import com.denfop.proxy.ClientProxy;
import com.denfop.tiles.base.TileEntityElectricBlock;
import com.denfop.tiles.wiring.storage.TileEntityElectricAdvMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricBarMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricBatBox;
import com.denfop.tiles.wiring.storage.TileEntityElectricCESU;
import com.denfop.tiles.wiring.storage.TileEntityElectricGraMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricHadrMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricMFE;
import com.denfop.tiles.wiring.storage.TileEntityElectricMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricPerMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricQuarkMFSU;
import com.denfop.tiles.wiring.storage.TileEntityElectricUltMFSU;
import com.denfop.utils.NBTData;
import com.denfop.utils.SomeUtils;
import com.denfop.utils.WrenchChecker;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IC2Items;
import ic2.api.tile.IWrenchable;
import ic2.core.block.TileEntityBlock;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockElectric
extends BlockContainer {
    private final String[] name = new String[]{"ADVMFSU", "ULTMFSU", "BatBox", "MFE", "MFSU", "CESU", "PERMFSU", "BARMFSU", "ADRMFSU", "GRAMFSU", "KRVMFSU"};
    private IIcon[][] iconBuffer;

    public BlockElectric() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IUCore.TAB_BLOCKS);
        this.func_149722_s();
        GameRegistry.registerBlock((Block)this, ItemElectricBlock.class, (String)"electricblock");
    }

    public static TileEntity getBlockEntity(int i) {
        TileEntityElectricBlock tileEntityElectricBlock;
        switch (i) {
            case 0: {
                tileEntityElectricBlock = new TileEntityElectricAdvMFSU();
                break;
            }
            case 1: {
                tileEntityElectricBlock = new TileEntityElectricUltMFSU();
                break;
            }
            case 2: {
                tileEntityElectricBlock = new TileEntityElectricBatBox();
                break;
            }
            case 3: {
                tileEntityElectricBlock = new TileEntityElectricMFE();
                break;
            }
            case 4: {
                tileEntityElectricBlock = new TileEntityElectricMFSU();
                break;
            }
            case 5: {
                tileEntityElectricBlock = new TileEntityElectricCESU();
                break;
            }
            case 6: {
                tileEntityElectricBlock = new TileEntityElectricPerMFSU();
                break;
            }
            case 7: {
                tileEntityElectricBlock = new TileEntityElectricBarMFSU();
                break;
            }
            case 8: {
                tileEntityElectricBlock = new TileEntityElectricHadrMFSU();
                break;
            }
            case 9: {
                tileEntityElectricBlock = new TileEntityElectricGraMFSU();
                break;
            }
            case 10: {
                tileEntityElectricBlock = new TileEntityElectricQuarkMFSU();
                break;
            }
            default: {
                tileEntityElectricBlock = null;
            }
        }
        return tileEntityElectricBlock;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[this.name.length + 1][6];
        for (int i = 0; i < this.name.length; ++i) {
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(par1IconRegister, "industrialupgrade:block" + this.name[i], 6, 1);
            System.arraycopy(icons, 0, this.iconBuffer[i], 0, icons.length);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        int blockMeta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        short facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    public IIcon func_149691_a(int blockSide, int blockMeta) {
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][3]];
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList dropList = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory iinv = (IInventory)te;
            for (int index = 0; index < iinv.func_70302_i_(); ++index) {
                ItemStack itemstack = iinv.func_70301_a(index);
                if (itemstack == null) continue;
                dropList.add(itemstack);
                iinv.func_70299_a(index, null);
            }
        }
        return dropList;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int blockMeta) {
        super.func_149749_a(world, x, y, z, blockID, blockMeta);
        boolean var5 = true;
        for (ItemStack var7 : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (!var5) {
                if (var7 == null) {
                    return;
                }
                double var8 = 0.7;
                double var10 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var12 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var14 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                EntityItem var16 = new EntityItem(world, (double)x + var10, (double)y + var12, (double)z + var14, var7);
                var16.field_145804_b = 10;
                world.func_72838_d((Entity)var16);
                return;
            }
            var5 = false;
        }
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return IC2Items.getItem((String)"advancedMachine").func_77973_b();
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return BlockElectric.getBlockEntity(var2);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityElectricBlock te = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
        NBTTagCompound nbttagcompound1 = NBTData.getOrCreateNbtData(stack);
        double energy1 = nbttagcompound1.func_74769_h("energy");
        double energy2 = nbttagcompound1.func_74769_h("energy2");
        te.energy = energy1;
        te.energy2 = energy2;
        if (player instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            te.UUID = entityplayer.getDisplayName();
        }
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        TileEntityElectricBlock tile;
        if (world.field_72995_K) {
            return true;
        }
        if (entityPlayer.func_70093_af() && (tile = (TileEntityElectricBlock)world.func_147438_o(x, y, z)) != null) {
            if (WrenchChecker.isWrenchInHand(entityPlayer)) {
                return false;
            }
            TileEntityElectricBlock.instantlyCharge(entityPlayer, tile);
        }
        if (!entityPlayer.func_70093_af()) {
            TileEntity tileentity = world.func_147438_o(x, y, z);
            if (tileentity != null) {
                if (WrenchChecker.isWrenchInHand(entityPlayer)) {
                    return false;
                }
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (tileEntity instanceof TileEntityElectricBlock) {
                    TileEntityElectricBlock tile2 = (TileEntityElectricBlock)tileEntity;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(tile2.UUID);
                    for (int h = 0; h < 2; ++h) {
                        if (tile2.inputslotC.get(h) == null || !(tile2.inputslotC.get(h).func_77973_b() instanceof AdditionModule) || tile2.inputslotC.get(h).func_77960_j() != 0) continue;
                        for (int m = 0; m < 9; ++m) {
                            String name;
                            NBTTagCompound nbt = SomeUtils.getNBT(tile2.inputslotC.get(h));
                            if (nbt.func_74779_i(name = "player_" + m).isEmpty()) continue;
                            list.add(nbt.func_74779_i(name));
                        }
                        break;
                    }
                    if (list.contains(entityPlayer.getDisplayName()) || entityPlayer.field_71075_bZ.field_75098_d) {
                        entityPlayer.openGui((Object)IUCore.instance, 1, world, x, y, z);
                    } else if (!tile2.personality) {
                        entityPlayer.openGui((Object)IUCore.instance, 1, world, x, y, z);
                    } else if (!list.contains(entityPlayer.getDisplayName()) && tile2.func_145831_w().field_73011_w.getWorldTime() % 5L == 0L) {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"iu.error"), new Object[0]));
                    }
                    return true;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 0 || stack.func_77960_j() == 1 ? EnumRarity.uncommon : EnumRarity.common;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityBlock)) {
            return 0;
        }
        TileEntityElectricBlock teb = (TileEntityElectricBlock)te;
        return (int)Math.round(Util.map((double)teb.energy, (double)teb.maxStorage, (double)15.0));
    }
}

