/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.mechanism;

import com.denfop.IUCore;
import com.denfop.api.utils.textures.TextureAtlasSheet;
import com.denfop.item.mechanism.ItemBaseMachine;
import com.denfop.proxy.ClientProxy;
import com.denfop.tiles.base.TileEntityAdvQuantumQuarry;
import com.denfop.tiles.base.TileEntityImpQuantumQuarry;
import com.denfop.tiles.base.TileEntityPerQuantumQuarry;
import com.denfop.tiles.base.TileEntityQuantumQuarry;
import com.denfop.tiles.mechanism.TileEntityAdvancedMatter;
import com.denfop.tiles.mechanism.TileEntityAlloySmelter;
import com.denfop.tiles.mechanism.TileEntityGenerationMicrochip;
import com.denfop.tiles.mechanism.TileEntityGenerationStone;
import com.denfop.tiles.mechanism.TileEntityGeneratorAdv;
import com.denfop.tiles.mechanism.TileEntityGeneratorImp;
import com.denfop.tiles.mechanism.TileEntityGeneratorPer;
import com.denfop.tiles.mechanism.TileEntityImprovedMatter;
import com.denfop.tiles.mechanism.TileEntityModuleMachine;
import com.denfop.tiles.mechanism.TileEntityUltimateMatter;
import com.denfop.tiles.neutroniumgenerator.TileNeutronGenerator;
import com.denfop.utils.WrenchChecker;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IC2Items;
import ic2.api.tile.IWrenchable;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityBlock;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBaseMachine
extends BlockContainer {
    public static final String[] names = new String[]{"GenMatter", "GenMatter2", "GenMatter3", "Alloy", "NeutronGen", "Circuit", "GenCobble", "Quarry", "ModuleMachine", "advgenerator", "impgenerator", "pergenerator", "Quarry1", "Quarry2", "Quarry3"};
    private IIcon[][] iconBuffer;

    public BlockBaseMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IUCore.TAB_BLOCKS);
        GameRegistry.registerBlock((Block)this, ItemBaseMachine.class, (String)"machines");
    }

    public TileEntity createTileEntity(World world, int meta) {
        IHasGui iHasGui;
        switch (meta) {
            case 1: {
                iHasGui = new TileEntityAdvancedMatter();
                break;
            }
            case 2: {
                iHasGui = new TileEntityImprovedMatter();
                break;
            }
            case 3: {
                iHasGui = new TileEntityUltimateMatter();
                break;
            }
            case 4: {
                iHasGui = new TileEntityAlloySmelter();
                break;
            }
            case 5: {
                iHasGui = new TileNeutronGenerator();
                break;
            }
            case 6: {
                iHasGui = new TileEntityGenerationMicrochip();
                break;
            }
            case 7: {
                iHasGui = new TileEntityGenerationStone();
                break;
            }
            case 8: {
                iHasGui = new TileEntityQuantumQuarry();
                break;
            }
            case 9: {
                iHasGui = new TileEntityModuleMachine();
                break;
            }
            case 10: {
                iHasGui = new TileEntityGeneratorAdv();
                break;
            }
            case 11: {
                iHasGui = new TileEntityGeneratorImp();
                break;
            }
            case 12: {
                iHasGui = new TileEntityGeneratorPer();
                break;
            }
            case 13: {
                iHasGui = new TileEntityAdvQuantumQuarry();
                break;
            }
            case 14: {
                iHasGui = new TileEntityImpQuantumQuarry();
                break;
            }
            case 15: {
                iHasGui = new TileEntityPerQuantumQuarry();
                break;
            }
            default: {
                iHasGui = null;
            }
        }
        return iHasGui;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[names.length + 1][12];
        for (int i = 1; i < names.length + 1; ++i) {
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(par1IconRegister, "industrialupgrade:block" + names[i - 1], 12, 1);
            System.arraycopy(icons, 0, this.iconBuffer[i], 0, icons.length);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        short facing;
        int blockMeta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        short s = facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
        if (this.isActive(world, x, y, z)) {
            return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing] + 6];
        }
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    public IIcon func_149691_a(int blockSide, int blockMeta) {
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][3]];
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList dropList = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory iinv = (IInventory)te;
            for (int index = 0; index < iinv.func_70302_i_(); ++index) {
                ItemStack itemstack = iinv.func_70301_a(index);
                if (itemstack == null) continue;
                dropList.add(itemstack);
                iinv.func_70299_a(index, null);
            }
        }
        return dropList;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int blockMeta) {
        super.func_149749_a(world, x, y, z, blockID, blockMeta);
        boolean var5 = true;
        for (ItemStack dropIter : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (!var5) {
                if (dropIter == null) {
                    return;
                }
                double var8 = 0.7;
                double var10 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var12 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var14 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                EntityItem entityItem = new EntityItem(world, (double)x + var10, (double)y + var12, (double)z + var14, dropIter);
                entityItem.field_145804_b = 10;
                world.func_72838_d((Entity)entityItem);
                return;
            }
            var5 = false;
        }
    }

    public Item func_149650_a(int meta, Random p_149650_2_, int p_149650_3_) {
        if (meta == 8 || meta == 13 || meta == 14 || meta == 15) {
            ItemStack quarry = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_149692_a(meta));
            return quarry.func_77973_b();
        }
        return IC2Items.getItem((String)"advancedMachine").func_77973_b();
    }

    public int func_149692_a(int meta) {
        if (meta == 8 || meta == 13 || meta == 14 || meta == 15) {
            return meta;
        }
        return 0;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(x, y, z);
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        if (WrenchChecker.isWrenchInHand(entityPlayer)) {
            return false;
        }
        if (!entityPlayer.func_70093_af()) {
            entityPlayer.openGui((Object)IUCore.instance, 0, world, x, y, z);
            return true;
        }
        return false;
    }

    private boolean isActive(IBlockAccess iba, int x, int y, int z) {
        return ((TileEntityBlock)iba.func_147438_o(x, y, z)).getActive();
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }
}

