/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.mechanism;

import com.denfop.IUCore;
import com.denfop.api.utils.textures.TextureAtlasSheet;
import com.denfop.item.mechanism.ItemBaseMachine4;
import com.denfop.proxy.ClientProxy;
import com.denfop.tiles.base.TileEntityAutoSpawner;
import com.denfop.tiles.base.TileEntityRadiationPurifier;
import com.denfop.tiles.mechanism.TileEntityElectricHeat;
import com.denfop.tiles.mechanism.TileEntityElectricLather;
import com.denfop.tiles.mechanism.TileEntityFluidHeat;
import com.denfop.tiles.mechanism.TileEntityPrivatizer;
import com.denfop.tiles.mechanism.TileEntityTunerWireless;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.WrenchChecker;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IC2Items;
import ic2.api.tile.IWrenchable;
import ic2.core.block.TileEntityBlock;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBaseMachine4
extends BlockContainer {
    public static final String[] names = new String[]{"Lathe", "RadPur", "Privatizer", "Tuner", "Spawner", "Electricheat", "Fluidheat"};
    private IIcon[][] iconBuffer;

    public BlockBaseMachine4() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IUCore.TAB_BLOCKS);
        GameRegistry.registerBlock((Block)this, ItemBaseMachine4.class, (String)"BlockBaseMachine4");
    }

    public TileEntity createTileEntity(World world, int meta) {
        Object object;
        switch (meta) {
            case 0: {
                object = new TileEntityElectricLather();
                break;
            }
            case 1: {
                object = new TileEntityRadiationPurifier();
                break;
            }
            case 2: {
                object = new TileEntityPrivatizer();
                break;
            }
            case 3: {
                object = new TileEntityTunerWireless();
                break;
            }
            case 4: {
                object = new TileEntityAutoSpawner();
                break;
            }
            case 5: {
                object = new TileEntityElectricHeat();
                break;
            }
            case 6: {
                object = new TileEntityFluidHeat();
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[names.length][12];
        for (int i = 0; i < names.length; ++i) {
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(par1IconRegister, "industrialupgrade:block" + names[i], 12, 1);
            System.arraycopy(icons, 0, this.iconBuffer[i], 0, icons.length);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te;
        short facing;
        int blockMeta = world.func_72805_g(x, y, z);
        if (blockMeta > 6) {
            blockMeta = 0;
        }
        short s = facing = (te = world.func_147438_o(x, y, z)) instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
        if (this.isActive(world, x, y, z)) {
            return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing] + 6];
        }
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    public IIcon func_149691_a(int blockSide, int blockMeta) {
        if (blockMeta > 6) {
            blockMeta = 0;
        }
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][3]];
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList dropList = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory iinv = (IInventory)te;
            for (int index = 0; index < iinv.func_70302_i_(); ++index) {
                ItemStack itemstack = iinv.func_70301_a(index);
                if (itemstack == null) continue;
                dropList.add(itemstack);
                iinv.func_70299_a(index, null);
            }
        }
        return dropList;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int blockMeta) {
        super.func_149749_a(world, x, y, z, blockID, blockMeta);
        boolean var5 = true;
        for (ItemStack var7 : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (!var5) {
                if (var7 == null) {
                    return;
                }
                double var8 = 0.7;
                double var10 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var12 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var14 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                EntityItem var16 = new EntityItem(world, (double)x + var10, (double)y + var12, (double)z + var14, var7);
                var16.field_145804_b = 10;
                world.func_72838_d((Entity)var16);
                return;
            }
            var5 = false;
        }
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return IC2Items.getItem((String)"advancedMachine").func_77973_b();
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        int heading = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(x, y, z);
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        if (WrenchChecker.isWrenchInHand(player)) {
            return false;
        }
        if (!player.func_70093_af()) {
            player.openGui((Object)IUCore.instance, 0, world, x, y, z);
            return true;
        }
        if (WrenchChecker.isWrenchInHand(player)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityAutoSpawner) {
            TileEntityAutoSpawner tileEntityAutoSpawner = (TileEntityAutoSpawner)tile;
            ExperienceUtils.addPlayerXP(player, tileEntityAutoSpawner.expstorage);
            tileEntityAutoSpawner.expstorage = 0;
        }
        return false;
    }

    private boolean isActive(IBlockAccess iba, int x, int y, int z) {
        return ((TileEntityBlock)iba.func_147438_o(x, y, z)).getActive();
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }
}

