/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.utils.textures.TextureAtlasSheet;
import com.denfop.item.mechanism.ItemImpChamber;
import com.denfop.proxy.ClientProxy;
import com.denfop.tiles.reactors.TileEntityImpNuclearReactor;
import com.denfop.tiles.reactors.TileEntityImpReactorChamberElectric;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.Direction;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityBlock;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockImpReactorChamber
extends BlockContainer {
    public static final String[] names = new String[]{"ImpReaCha"};
    TileEntityImpNuclearReactor reactor;
    private IIcon[][] iconBuffer;

    public BlockImpReactorChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IUCore.TAB_BLOCKS);
        GameRegistry.registerBlock((Block)this, ItemImpChamber.class, (String)"ImpChamber");
    }

    public TileEntity createTileEntity(World world, int meta) {
        if (meta == 0) {
            return new TileEntityImpReactorChamberElectric();
        }
        return null;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[names.length][12];
        for (int i = 0; i < names.length; ++i) {
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(par1IconRegister, "industrialupgrade:block" + names[i], 12, 1);
            System.arraycopy(icons, 0, this.iconBuffer[i], 0, icons.length);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        int blockMeta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        short facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    public IIcon func_149691_a(int blockSide, int blockMeta) {
        return this.iconBuffer[blockMeta][ClientProxy.sideAndFacingToSpriteOffset[blockSide][3]];
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (world.func_72904_c(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1) && !this.func_149742_c(world, x, y, z)) {
            world.func_147468_f(x, y, z);
            this.func_149642_a(world, x, y, z, new ItemStack(IUItem.impchamberblock));
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Direction[] var6;
        int count = 0;
        for (Direction dir : var6 = Direction.directions) {
            if (!(dir.applyTo(world, x, y, z) instanceof TileEntityImpNuclearReactor)) continue;
            ++count;
        }
        return count == 1;
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        this.reactor = this.getReactorEntity(world, i, j, k);
        if (this.reactor == null) {
            this.func_149695_a(world, i, j, k, (Block)this);
        } else {
            int puffs = this.reactor.heat / 1000;
            if (puffs > 0) {
                int n;
                puffs = world.field_73012_v.nextInt(puffs);
                for (n = 0; n < puffs; ++n) {
                    world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
                }
                puffs -= world.field_73012_v.nextInt(4) + 3;
                for (n = 0; n < puffs; ++n) {
                    world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public TileEntityImpNuclearReactor getReactorEntity(World world, int x, int y, int z) {
        Direction[] var5;
        for (Direction dir : var5 = Direction.directions) {
            TileEntity te = dir.applyTo(world, x, y, z);
            if (!(te instanceof TileEntityImpNuclearReactor)) continue;
            return (TileEntityImpNuclearReactor)te;
        }
        this.func_149695_a(world, x, y, z, world.func_147439_a(x, y, z));
        return null;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (world.field_72995_K) {
            return true;
        }
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityImpNuclearReactor reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, (Block)this);
            return false;
        }
        return !IC2.platform.isSimulating() || IC2.platform.launchGui(entityplayer, (IHasGui)reactor);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList dropList = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory iinv = (IInventory)te;
            for (int index = 0; index < iinv.func_70302_i_(); ++index) {
                ItemStack itemstack = iinv.func_70301_a(index);
                if (itemstack == null) continue;
                dropList.add(itemstack);
                iinv.func_70299_a(index, null);
            }
        }
        return dropList;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int blockMeta) {
        super.func_149749_a(world, x, y, z, blockID, blockMeta);
        boolean var5 = true;
        for (ItemStack var7 : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (!var5) {
                if (var7 == null) {
                    return;
                }
                double var8 = 0.7;
                double var10 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var12 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var14 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                EntityItem var16 = new EntityItem(world, (double)x + var10, (double)y + var12, (double)z + var14, var7);
                var16.field_145804_b = 10;
                world.func_72838_d((Entity)var16);
                return;
            }
            var5 = false;
        }
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }
}

