/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.utils.textures.TextureAtlasSheet;
import com.denfop.item.mechanism.ItemMoreMachine;
import com.denfop.item.modules.AdditionModule;
import com.denfop.item.modules.ModuleTypePanel;
import com.denfop.tiles.base.TileEntityMultiMachine;
import com.denfop.tiles.mechanism.TileEntityDoubleCompressor;
import com.denfop.tiles.mechanism.TileEntityDoubleElectricFurnace;
import com.denfop.tiles.mechanism.TileEntityDoubleExtractor;
import com.denfop.tiles.mechanism.TileEntityDoubleMacerator;
import com.denfop.tiles.mechanism.TileEntityDoubleMetalFormer;
import com.denfop.tiles.mechanism.TileEntityQuadCompressor;
import com.denfop.tiles.mechanism.TileEntityQuadElectricFurnace;
import com.denfop.tiles.mechanism.TileEntityQuadExtractor;
import com.denfop.tiles.mechanism.TileEntityQuadMacerator;
import com.denfop.tiles.mechanism.TileEntityQuadMetalFormer;
import com.denfop.tiles.mechanism.TileEntityTripleCompressor;
import com.denfop.tiles.mechanism.TileEntityTripleElectricFurnace;
import com.denfop.tiles.mechanism.TileEntityTripleExtractor;
import com.denfop.tiles.mechanism.TileEntityTripleMacerator;
import com.denfop.tiles.mechanism.TileEntityTripleMetalFormer;
import com.denfop.tiles.overtimepanel.EnumSolarPanels;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.SomeUtils;
import com.denfop.utils.WrenchChecker;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IC2Items;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMoreMachine
extends BlockContainer {
    public static final String[] names = new String[]{"Macerator", "Macerator2", "Macerator3", "Compressor", "Compressor2", "Compressor3", "ElecFurnace", "ElecFurnace2", "ElecFurnace3", "Extractor", "Extractor2", "Extractor3", "MetalFormer", "MetalFormer2", "MetalFormer3"};
    private static final int[][] sideAndFacingToSpriteOffset = new int[][]{{3, 2, 0, 0, 0, 0}, {2, 3, 1, 1, 1, 1}, {1, 1, 3, 5, 2, 4}, {0, 0, 5, 3, 4, 2}, {4, 5, 4, 2, 3, 5}, {5, 4, 2, 4, 5, 3}};
    private IIcon[][] iconBuffer;

    public BlockMoreMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IUCore.TAB_BLOCKS);
        GameRegistry.registerBlock((Block)this, ItemMoreMachine.class, (String)"machines_base");
    }

    public TileEntity createTileEntity(World world, int meta) {
        TileEntityMultiMachine tileEntityMultiMachine;
        switch (meta) {
            case 0: {
                tileEntityMultiMachine = new TileEntityDoubleMacerator();
                break;
            }
            case 1: {
                tileEntityMultiMachine = new TileEntityTripleMacerator();
                break;
            }
            case 2: {
                tileEntityMultiMachine = new TileEntityQuadMacerator();
                break;
            }
            case 3: {
                tileEntityMultiMachine = new TileEntityDoubleCompressor();
                break;
            }
            case 4: {
                tileEntityMultiMachine = new TileEntityTripleCompressor();
                break;
            }
            case 5: {
                tileEntityMultiMachine = new TileEntityQuadCompressor();
                break;
            }
            case 6: {
                tileEntityMultiMachine = new TileEntityDoubleElectricFurnace();
                break;
            }
            case 7: {
                tileEntityMultiMachine = new TileEntityTripleElectricFurnace();
                break;
            }
            case 8: {
                tileEntityMultiMachine = new TileEntityQuadElectricFurnace();
                break;
            }
            case 9: {
                tileEntityMultiMachine = new TileEntityDoubleExtractor();
                break;
            }
            case 10: {
                tileEntityMultiMachine = new TileEntityTripleExtractor();
                break;
            }
            case 11: {
                tileEntityMultiMachine = new TileEntityQuadExtractor();
                break;
            }
            case 12: {
                tileEntityMultiMachine = new TileEntityDoubleMetalFormer();
                break;
            }
            case 13: {
                tileEntityMultiMachine = new TileEntityTripleMetalFormer();
                break;
            }
            case 14: {
                tileEntityMultiMachine = new TileEntityQuadMetalFormer();
                break;
            }
            default: {
                tileEntityMultiMachine = null;
            }
        }
        return tileEntityMultiMachine;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[15][12];
        for (int i = 0; i < names.length; ++i) {
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(par1IconRegister, "industrialupgrade:block" + names[i], 12, 1);
            System.arraycopy(icons, 0, this.iconBuffer[i], 0, icons.length);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        short facing;
        int blockMeta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        short s = facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
        if (this.isActive(world, x, y, z)) {
            return this.iconBuffer[blockMeta][sideAndFacingToSpriteOffset[blockSide][facing] + 6];
        }
        return this.iconBuffer[blockMeta][sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    public IIcon func_149691_a(int blockSide, int blockMeta) {
        return this.iconBuffer[blockMeta][sideAndFacingToSpriteOffset[blockSide][3]];
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList dropList = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory iinv = (IInventory)te;
            for (int index = 0; index < iinv.func_70302_i_(); ++index) {
                ItemStack itemstack = iinv.func_70301_a(index);
                if (itemstack == null) continue;
                dropList.add(itemstack);
                iinv.func_70299_a(index, null);
            }
        }
        return dropList;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int blockMeta) {
        super.func_149749_a(world, x, y, z, blockID, blockMeta);
        boolean var5 = true;
        for (ItemStack drop : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (!var5) {
                if (drop == null) {
                    return;
                }
                double var8 = 0.7;
                double var10 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var12 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                double var14 = (double)world.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
                EntityItem var16 = new EntityItem(world, (double)x + var10, (double)y + var12, (double)z + var14, drop);
                var16.field_145804_b = 10;
                world.func_72838_d((Entity)var16);
                return;
            }
            var5 = false;
        }
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return IC2Items.getItem((String)"advancedMachine").func_77973_b();
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        NBTTagCompound nbttagcompound = SomeUtils.getNBT(stack);
        boolean rf = nbttagcompound.func_74767_n("rf");
        TileEntityMultiMachine te1 = (TileEntityMultiMachine)world.func_147438_o(x, y, z);
        te1.rf = rf;
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(x, y, z);
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        if (!entityPlayer.func_70093_af()) {
            if (WrenchChecker.isWrenchInHand(entityPlayer)) {
                return false;
            }
            TileEntityMultiMachine tile = (TileEntityMultiMachine)world.func_147438_o(x, y, z);
            if (entityPlayer.func_70694_bm() != null) {
                if (entityPlayer.func_70694_bm().func_77973_b() instanceof ModuleTypePanel) {
                    if (tile.solartype != null) {
                        EnumSolarPanels type = tile.solartype;
                        int meta = type.meta;
                        ItemStack stack = new ItemStack(IUItem.module6, 1, meta);
                        if (!entityPlayer.field_71071_by.func_70441_a(stack)) {
                            EntityItem item = new EntityItem(entityPlayer.func_130014_f_());
                            item.func_92058_a(stack);
                            item.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u - 1.0, entityPlayer.field_70161_v);
                            item.field_145804_b = 10;
                            world.func_147479_m((int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u - 1, (int)entityPlayer.field_70161_v);
                        }
                    }
                    tile.solartype = ModuleTypePanel.getSolarType(entityPlayer.func_70694_bm().func_77960_j());
                    --entityPlayer.func_70694_bm().field_77994_a;
                    return true;
                }
                if (entityPlayer.func_70694_bm().func_77973_b() instanceof AdditionModule && entityPlayer.func_70694_bm().func_77960_j() == 4 && !tile.rf && tile.module == 0) {
                    tile.rf = true;
                    tile.module = 1;
                    --entityPlayer.func_70694_bm().field_77994_a;
                    return true;
                }
                if (entityPlayer.func_70694_bm().func_77973_b().equals(IUItem.moduleQuickly) && !tile.quickly && tile.module == 0) {
                    tile.quickly = true;
                    tile.module = 1;
                    --entityPlayer.func_70694_bm().field_77994_a;
                    return true;
                }
                if (entityPlayer.func_70694_bm().func_77973_b().equals(IUItem.moduleStack) && !tile.modulesize && tile.module == 0) {
                    tile.modulesize = true;
                    tile.module = 1;
                    --entityPlayer.func_70694_bm().field_77994_a;
                    return true;
                }
            }
            entityPlayer.openGui((Object)IUCore.instance, 0, world, x, y, z);
            return true;
        }
        TileEntityMultiMachine tile = (TileEntityMultiMachine)world.func_147438_o(x, y, z);
        if (WrenchChecker.isWrenchInHand(entityPlayer)) {
            return false;
        }
        ExperienceUtils.addPlayerXP(entityPlayer, tile.expstorage);
        tile.expstorage = 0;
        return false;
    }

    private boolean isActive(IBlockAccess iba, int x, int y, int z) {
        return ((TileEntityBlock)iba.func_147438_o(x, y, z)).getActive();
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (!IC2.platform.isRendering()) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if (meta > 6 && meta <= 8 && this.isActive((IBlockAccess)world, i, j, k)) {
            TileEntity te = world.func_147438_o(i, j, k);
            short facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
            float f = (float)i + 0.5f;
            float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (facing) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
            }
        }
        if (meta >= 0 && meta <= 2 && this.isActive((IBlockAccess)world, i, j, k)) {
            float f = (float)i + 1.0f;
            float f1 = (float)j + 1.0f;
            float f2 = (float)k + 1.0f;
            for (int z = 0; z < 4; ++z) {
                float fmod = -0.2f - random.nextFloat() * 0.6f;
                float f1mod = -0.1f + random.nextFloat() * 0.2f;
                float f2mod = -0.2f - random.nextFloat() * 0.6f;
                world.func_72869_a("smoke", (double)(f + fmod), (double)(f1 + f1mod), (double)(f2 + f2mod), 0.0, 0.0, 0.0);
            }
        }
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return 0;
    }

    public boolean func_149740_M() {
        return true;
    }
}

