/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.IDoubleMachineRecipeManager;
import com.denfop.api.Recipes;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mods.ic2.IC2RecipeInput;
import modtweaker2.helpers.InputHelper;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.Enrich")
public class CTEnrich {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient container, IIngredient fill) {
        MineTweakerAPI.apply((IUndoableAction)new AddEnrichIngredientAction(container, fill, output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        LinkedHashMap<IDoubleMachineRecipeManager.Input, RecipeOutput> recipes = new LinkedHashMap<IDoubleMachineRecipeManager.Input, RecipeOutput>();
        for (Map.Entry<IDoubleMachineRecipeManager.Input, RecipeOutput> iRecipeInputRecipeOutputEntry : Recipes.enrichment.getRecipes().entrySet()) {
            for (ItemStack stack : iRecipeInputRecipeOutputEntry.getValue().items) {
                if (!stack.func_77969_a(InputHelper.toStack((IItemStack)output))) continue;
                recipes.put(iRecipeInputRecipeOutputEntry.getKey(), iRecipeInputRecipeOutputEntry.getValue());
            }
        }
        MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
    }

    private static class AddEnrichIngredientAction
    extends OneWayAction {
        private final IIngredient container;
        private final IIngredient fill;
        private final IItemStack output;

        public AddEnrichIngredientAction(IIngredient container, IIngredient fill, IItemStack output) {
            this.container = container;
            this.fill = fill;
            this.output = output;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                MineTweakerAPI.logError((String)("Not a valid item stack: " + item));
                return null;
            }
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            Recipes.enrichment.addRecipe((IRecipeInput)new IC2RecipeInput(this.container), (IRecipeInput)new IC2RecipeInput(this.fill), null, AddEnrichIngredientAction.getItemStack(this.output));
        }

        public String describe() {
            return "Adding enrich bottle recipe " + this.container + " + " + this.fill + " => " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.container != null ? this.container.hashCode() : 0);
            hash = 67 * hash + (this.fill != null ? this.fill.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddEnrichIngredientAction other = (AddEnrichIngredientAction)((Object)obj);
            if (!Objects.equals(this.container, other.container)) {
                return false;
            }
            if (!Objects.equals(this.fill, other.fill)) {
                return false;
            }
            return Objects.equals(this.output, other.output);
        }
    }

    private static class Remove
    extends BaseMapRemoval<IDoubleMachineRecipeManager.Input, RecipeOutput> {
        protected Remove(Map<IDoubleMachineRecipeManager.Input, RecipeOutput> recipes) {
            super("enrichment", Recipes.enrichment.getRecipes(), recipes);
        }

        protected String getRecipeInfo(Map.Entry<IDoubleMachineRecipeManager.Input, RecipeOutput> recipe) {
            return recipe.toString();
        }
    }
}

