/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.ISunnariumRecipeManager;
import com.denfop.api.Recipes;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mods.ic2.IC2RecipeInput;
import modtweaker2.helpers.InputHelper;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.SunnariumMaker")
public class CTSunnariumMaker {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient container, IIngredient container1, IIngredient container2, IIngredient container3) {
        MineTweakerAPI.apply((IUndoableAction)new Add(container, container1, container2, container3, output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        LinkedHashMap<ISunnariumRecipeManager.Input, RecipeOutput> recipes = new LinkedHashMap<ISunnariumRecipeManager.Input, RecipeOutput>();
        for (Map.Entry<ISunnariumRecipeManager.Input, RecipeOutput> iRecipeInputRecipeOutputEntry : Recipes.sunnariumMaker.getRecipes().entrySet()) {
            for (ItemStack stack : iRecipeInputRecipeOutputEntry.getValue().items) {
                if (!stack.func_77969_a(InputHelper.toStack((IItemStack)output))) continue;
                recipes.put(iRecipeInputRecipeOutputEntry.getKey(), iRecipeInputRecipeOutputEntry.getValue());
            }
        }
        MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
    }

    private static class Add
    extends OneWayAction {
        private final IIngredient container;
        private final IIngredient container1;
        private final IIngredient container2;
        private final IIngredient container3;
        private final IItemStack output;

        public Add(IIngredient container, IIngredient container1, IIngredient container2, IIngredient container3, IItemStack output) {
            this.container = container;
            this.container1 = container1;
            this.container2 = container2;
            this.container3 = container3;
            this.output = output;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (internal instanceof ItemStack) {
                return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
            }
            MineTweakerAPI.logError((String)("Not a valid item stack: " + item));
            return null;
        }

        public void apply() {
            Recipes.sunnariumMaker.addRecipe((IRecipeInput)new IC2RecipeInput(this.container), (IRecipeInput)new IC2RecipeInput(this.container1), (IRecipeInput)new IC2RecipeInput(this.container2), (IRecipeInput)new IC2RecipeInput(this.container3), Add.getItemStack(this.output));
        }

        public String describe() {
            return "Adding sunnuriumMaker recipe " + this.container + " + " + this.container + this.container1 + this.container2 + this.container3 + " => " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.container != null ? this.container.hashCode() : 0);
            hash = 67 * hash + (this.container1 != null ? this.container1.hashCode() : 0);
            hash = 67 * hash + (this.container2 != null ? this.container2.hashCode() : 0);
            hash = 67 * hash + (this.container3 != null ? this.container3.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Add other = (Add)((Object)obj);
            if (!Objects.equals(this.container, other.container)) {
                return false;
            }
            if (!Objects.equals(this.container1, other.container1)) {
                return false;
            }
            if (!Objects.equals(this.container2, other.container2)) {
                return false;
            }
            if (!Objects.equals(this.container3, other.container3)) {
                return false;
            }
            return Objects.equals(this.output, other.output);
        }
    }

    private static class Remove
    extends BaseMapRemoval<ISunnariumRecipeManager.Input, RecipeOutput> {
        protected Remove(Map<ISunnariumRecipeManager.Input, RecipeOutput> recipes) {
            super("sunnurium", Recipes.sunnariumMaker.getRecipes(), recipes);
        }

        protected String getRecipeInfo(Map.Entry<ISunnariumRecipeManager.Input, RecipeOutput> recipe) {
            return recipe.toString();
        }
    }
}

